/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.businessinteligence;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.ServiceBuildBusinessIntelligenceImpl;
import com.touchcomp.basementorservice.service.impl.buildbusinessintelligence.model.DataOutputBI;
import com.touchcomp.basementorservice.service.impl.versaorepositoriobi.ServiceVersaoRepositorioBIImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.touchvomodel.temp.DTOSuiteVersaoQueryTest;
import com.touchcomp.touchvomodel.vo.importacaobi.repositorio.DTOVersaoBICompleto;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.utilities.CoreUtilityFactory;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class AuxValidarBI {
    List validarBIs(JTextArea txtLog, Empresa emp, Usuario user, Grupo grupoUsuarios) {
        List<Map> data = this.getRepositorios();
        txtLog.append("Testando BI's: " + data.size() + "\n\n");
        LinkedList<DTOSuiteVersaoQueryTest> errors = new LinkedList<DTOSuiteVersaoQueryTest>();
        int i = 1;
        int erros = 1;
        for (Map map : data) {
            Long idImportacao = (Long)map.get("ID_IMPORTACAO");
            String serial = (String)map.get("SERIAL_BI");
            String descBI = (String)map.get("DESC_BI");
            Long nrVersaoRep = (Long)map.get("NUMERO_VERSAO_REP");
            Long nrVersao = (Long)map.get("NUMERO_VERSAO_VER");
            txtLog.append(i + "/" + data.size() + " Id. Importacao: " + idImportacao);
            if (!this.testarBI(txtLog, errors, descBI, serial, nrVersaoRep, nrVersao, emp, user, grupoUsuarios)) {
                ++erros;
            }
            ++i;
        }
        txtLog.append("\n\n" + erros + " BI's com problemas.");
        return errors;
    }

    public List<Map> getRepositorios() {
        String hql = " select distinct  i.identificador as ID_IMPORTACAO, i.serialLocalBI as SERIAL_BI, r.numeroVersao as NUMERO_VERSAO_REP, v.numeroVersao as NUMERO_VERSAO_VER, i.descricao as DESC_BI from RepositorioBi r  inner join r.importacaoBi i  inner join r.versaosRepositorioBI v  where v.publicado = :sim and r.inativo =:nao  and v.inativo =:nao and i.inativo = :nao and v.numeroVersao = ( select max(v1.numeroVersao) from RepositorioBi r1  inner join r1.importacaoBi i1  inner join r1.versaosRepositorioBI v1  where i.serialLocalBI = i1.serialLocalBI and r.numeroVersao = r1.numeroVersao)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).setShort("sim", (short)1).setShort("nao", (short)0).list();
    }

    private DTOVersaoBICompleto getContentFromBI(String serialBI, Long numeroVersaoRep, Long numeroVersao) throws ExceptionService {
        ServiceVersaoRepositorioBIImpl service = (ServiceVersaoRepositorioBIImpl)Context.get(ServiceVersaoRepositorioBIImpl.class);
        return service.getVersaoBI(serialBI, numeroVersaoRep, numeroVersao);
    }

    private boolean testarBI(JTextArea txtLog, List<DTOSuiteVersaoQueryTest> errors, String desc, String serial, Long nrVersaoRep, Long nrVersao, Empresa emp, Usuario user, Grupo grupoUsuarios) {
        try {
            DTOVersaoBICompleto content = this.getContentFromBI(serial, nrVersaoRep, nrVersao);
            BusinessIntelligence toSave = CoreUtilityFactory.getUtilityImportExportBI().importBI(content, emp);
            this.testCode(toSave);
            ThreadTest t = new ThreadTest(this, txtLog, toSave, user, grupoUsuarios);
            long time = 0L;
            long limite = 30000L;
            t.start();
            do {
                Thread.sleep(500L);
            } while (t.isRunning && (time += 500L) < limite && !t.isOnError);
            if (t.isOnError) {
                Logger.getLogger(AuxValidarBI.class.getName()).log(Level.SEVERE, null, t.ex);
                txtLog.append("Erro ao gerar BI " + desc + ", serial: " + serial + " versao repositorio: " + nrVersaoRep + " versao: " + nrVersao);
                txtLog.append("\nErro: " + t.ex.getMessage());
                txtLog.append("\n-----------------------------------------------------------\n\n");
                DTOSuiteVersaoQueryTest er = new DTOSuiteVersaoQueryTest();
                errors.add(er);
                return false;
            }
            if (time >= limite) {
                txtLog.append("Tempo esgotado ao gerar BI " + desc + ", serial: " + serial + " versao repositorio: " + nrVersaoRep + " versao: " + nrVersao);
                txtLog.append("\n-----------------------------------------------------------\n\n");
                DTOSuiteVersaoQueryTest er = new DTOSuiteVersaoQueryTest();
                errors.add(er);
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            Logger.getLogger(AuxValidarBI.class.getName()).log(Level.SEVERE, null, ex);
            txtLog.append("Erro ao gerar BI " + desc + ", serial: " + serial + " versao repositorio: " + nrVersaoRep + " versao: " + nrVersao);
            txtLog.append("\nErro: " + ex.getMessage());
            txtLog.append("\n-----------------------------------------------------------\n\n");
            DTOSuiteVersaoQueryTest er = new DTOSuiteVersaoQueryTest();
            errors.add(er);
            return false;
        }
    }

    private void testCode(BusinessIntelligence toSave) throws ExceptionBuildBI {
        if (toSave.getBusinessJavaClassCode() == null) {
            return;
        }
        String code = new String(toSave.getBusinessJavaClassCode().getClassContent());
        if (code.indexOf(" mentor.") > 0) {
            throw new ExceptionBuildBI("BI contem vinculos com os projetos Desktop", new Object[0]);
        }
        if (code.indexOf(" mentorcore.") > 0) {
            throw new ExceptionBuildBI("BI contem vinculos com os projetos Desktop", new Object[0]);
        }
    }

    public class ThreadTest
    extends Thread {
        JTextArea txtLog;
        BusinessIntelligence bi;
        Empresa emp;
        Usuario user;
        boolean isRunning;
        boolean isOnError = false;
        Exception ex;
        Grupo grupoUsuarios;

        public ThreadTest(AuxValidarBI this$0, JTextArea txtLog, BusinessIntelligence bi, Usuario user, Grupo grupoUsuarios) {
            this.txtLog = txtLog;
            this.bi = bi;
            this.user = user;
            this.grupoUsuarios = grupoUsuarios;
        }

        @Override
        public void run() {
            this.isRunning = true;
            try {
                this.doProcess(this.txtLog, this.bi, this.emp, this.user, this.grupoUsuarios);
            }
            catch (Exception ex) {
                Logger.getLogger(AuxValidarBI.class.getName()).log(Level.SEVERE, null, ex);
                this.ex = ex;
                this.isOnError = true;
            }
            this.isRunning = false;
        }

        public void doProcess(JTextArea txtLog, BusinessIntelligence bi, Empresa empresa, Usuario usuario, Grupo grupoUsuarios) throws ExceptionService {
            try {
                DataOutputBI out = ((ServiceBuildBusinessIntelligenceImpl)ConfApplicationContext.getBean(ServiceBuildBusinessIntelligenceImpl.class)).gerarBITestesInternos(bi, ConstEnumFormImprBI.VISUALIZAR, CompBIDefaultParams.getDefParamsMap((Empresa)empresa, (Usuario)usuario, (Grupo)grupoUsuarios, (Object[])new Object[0]), null, null);
                txtLog.append("BI gerado com sucesso " + bi.getDescricao() + "\n");
            }
            catch (Exception ex) {
                Logger.getLogger(AuxValidarBI.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionService(ex);
            }
        }
    }
}

