/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.calculocomplemetosalario;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CadastroConvencaoColetiva;
import com.touchcomp.basementor.model.vo.CalculoComplementoSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Sindicato;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.calculocomplemetosalario.UtilProcessamentoComplementoSalario;

public class ServiceComplementoSalario
extends CoreService {
    public static final String FIND_TIPO_CALCULO_INCIDE_INSS = "findTipoCalculoIncideInss";
    public static final String FIND_TODOS_COLABORADORES = "findTodosColaboradores";
    public static final String CRIAR_LANCAMENTOS_DE_COMPLEMENTO_SALARIO = "lancamentosComplementoSalario";
    public static final String FIND_EVENTO_COMPLEMENTO_POR_PERIODO = "findEventoComplementoPorPeriodo";
    public static final String INTEGRAR_LANCAMENTOS_COMPLEMENTO_DEC = "integrarComplementoSalarioDec";
    public static final String INTEGRAR_LANCAMENTOS_COMPLEMENTO_SALARIO = "integrarComplementoSalario";
    public static final String FIND_EVENTOS_INCIDENCIA_DEC = "findEventosIncidenciaDec";
    public static final String EXCLUIR_CALCULO_COMPLEMENTO_SALARIO = "excluirCalculoComplementoSalario";

    public List findTipoCalculoIncideInss(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().findTipoCalculoIncideInss(dataInicial, dataFinal);
    }

    public List findTodosColaboradores(CoreRequestContext request) {
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Date periodoFinal = (Date)request.getAttribute("periodoFinal");
        Short filtrarSindicato = (Short)request.getAttribute("filtrarSindicato");
        Sindicato sindicato = (Sindicato)request.getAttribute("sindicato");
        return CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().findColaboradoresComFolhaNoPeriodo(idEmpresa, periodoFinal, filtrarSindicato, sindicato);
    }

    public CalculoComplementoSalario lancamentosComplementoSalario(CoreRequestContext request) throws ExceptionService {
        CalculoComplementoSalario vo = (CalculoComplementoSalario)request.getAttribute("complementoSalario");
        Date periodoInicial = (Date)request.getAttribute("periodoInicial");
        Date periodoFinal = (Date)request.getAttribute("periodoFinal");
        EmpresaRh empresaRh = (EmpresaRh)request.getAttribute("empresaRh");
        if (vo.getTipoCalculoFolha().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_COMPLEMENTAR.getValue())) {
            if (vo.getPagamentosComplementares().isEmpty()) {
                UtilProcessamentoComplementoSalario.processamentoComplementoSalario(vo, periodoInicial, periodoFinal);
            }
            return (CalculoComplementoSalario)ServiceComplementoSalario.simpleSave(CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario(), vo);
        }
        new UtilProcessamentoComplementoSalario().processamentoComplementoDecimoTerceiro(vo, periodoInicial, periodoFinal, empresaRh);
        return (CalculoComplementoSalario)ServiceComplementoSalario.simpleSave(CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario(), vo);
    }

    public List findEventoComplementoPorPeriodo(CoreRequestContext request) {
        CalculoComplementoSalario complementoSalario = (CalculoComplementoSalario)request.getAttribute("complementoSalario");
        Short filtrarCentroCusto = (Short)request.getAttribute("filtrarCentroCusto");
        String codCentroCustoInicial = (String)request.getAttribute("codCentroCustoInicial");
        String codCentroCustoFinal = (String)request.getAttribute("codCentroCustoFinal");
        return CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().findEventoComplementosSalarioPorPeriodo(complementoSalario, filtrarCentroCusto, codCentroCustoInicial, codCentroCustoFinal);
    }

    public List integrarComplementoSalarioDec(CoreRequestContext request) {
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        return CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getItensComplementoDecimoTerceiro(dataPagamento, colaborador);
    }

    public List integrarComplementoSalario(CoreRequestContext request) {
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        return CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getItensComplementoSalario(dataPagamento, colaborador);
    }

    public List findEventosIncidenciaDec(CoreRequestContext request) {
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().findEventosInicidentes13(dataInicial, dataFinal);
    }

    public void excluirCalculoComplementoSalario(CoreRequestContext r) throws ExceptionDatabase {
        CalculoComplementoSalario calculoComplemento = (CalculoComplementoSalario)r.getAttribute("calculoComplementoSalario");
        if (calculoComplemento.getConvencao() != null) {
            CadastroConvencaoColetiva convencao = calculoComplemento.getConvencao();
            convencao.setComplementoSalario(null);
            CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().delete(calculoComplemento);
            CoreDAOFactory.getInstance().getDAOCadastroConvencaoColetiva().saveOrUpdate(convencao);
        } else {
            CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().delete(calculoComplemento);
        }
    }
}

