/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.calculocomplemetosalario;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.CalculoComplementoSalario;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemCompSalarioEventoPeriodo;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioColaboradores;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioEvento;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.ContatoFormatUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilProcessamentoComplementoSalario {
    UtilProcessamentoComplementoSalario() {
    }

    static void processamentoComplementoSalario(CalculoComplementoSalario complementoSalario, Date periodoInicio, Date periodoFinal) {
        for (ItemComplementoSalarioEvento itemEvento : complementoSalario.getItensEvento()) {
            Date data;
            Object valor;
            Long idColaborador;
            ItemCompSalarioEventoPeriodo itemCompPeriodo;
            HashMap hash;
            System.err.print(itemEvento.getTipoCalculo().toString());
            boolean achou = false;
            ArrayList<ItemCompSalarioEventoPeriodo> itens = new ArrayList<ItemCompSalarioEventoPeriodo>();
            List ret = CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getEventosCompoemComplementoSalario(itemEvento.getTipoCalculo(), periodoInicio, periodoFinal);
            for (Object obj : ret) {
                hash = (HashMap)obj;
                itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                idColaborador = (Long)hash.get("idColaborador");
                for (ItemComplementoSalarioColaboradores oo : complementoSalario.getItensColaboradores()) {
                    if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                    itemCompPeriodo.setColaborador(oo.getColaborador());
                    itemCompPeriodo.setPercAumento(oo.getPercAumento());
                    achou = true;
                    break;
                }
                if (achou) {
                    valor = (Double)hash.get("valor");
                    itemCompPeriodo.setValorEvento((Double)valor);
                    data = (Date)hash.get("periodo");
                    itemCompPeriodo.setPeriodo(data);
                    itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() * (itemCompPeriodo.getPercAumento() / 100.0), 2));
                    itemCompPeriodo.setItemEvento(itemEvento);
                    itens.add(itemCompPeriodo);
                }
                achou = false;
            }
            if (complementoSalario.getIncluirFolhaDec().equals((short)1)) {
                ret = CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getEventosCompoemComplementoDecimoTerceiro(itemEvento.getTipoCalculo(), complementoSalario.getAno(), periodoInicio, periodoFinal);
                for (Object obj : ret) {
                    hash = (HashMap)obj;
                    itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                    idColaborador = (Long)hash.get("idColaborador");
                    for (ItemComplementoSalarioColaboradores oo : complementoSalario.getItensColaboradores()) {
                        if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                        itemCompPeriodo.setColaborador(oo.getColaborador());
                        itemCompPeriodo.setPercAumento(oo.getPercAumento());
                        achou = true;
                        break;
                    }
                    if (achou) {
                        valor = (Double)hash.get("valor");
                        itemCompPeriodo.setValorEvento((Double)valor);
                        data = (Date)hash.get("periodo");
                        itemCompPeriodo.setPeriodo(data);
                        itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() * (itemCompPeriodo.getPercAumento() / 100.0), 2));
                        itemCompPeriodo.setItemEvento(itemEvento);
                        itens.add(itemCompPeriodo);
                    }
                    achou = false;
                }
            }
            itemEvento.setEventosPeriodo(itens);
        }
        if (complementoSalario.getTpValorAdicional() != null) {
            for (ItemComplementoSalarioColaboradores colaborador : complementoSalario.getItensColaboradores()) {
                if (!(colaborador.getValorAdicional() > 0.0)) continue;
                ItemComplementoSalarioEvento itemEvento = new ItemComplementoSalarioEvento();
                itemEvento.setTipoCalculo(complementoSalario.getTpValorAdicional());
                itemEvento.setComplementoSalario(complementoSalario);
                ItemCompSalarioEventoPeriodo itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                itemCompPeriodo.setColaborador(colaborador.getColaborador());
                itemCompPeriodo.setItemEvento(itemEvento);
                itemCompPeriodo.setPercAumento(Double.valueOf(0.0));
                itemCompPeriodo.setValorComplemento(colaborador.getValorAdicional());
                itemCompPeriodo.setPeriodo(complementoSalario.getPeriodoFinal());
                itemEvento.getEventosPeriodo().add(itemCompPeriodo);
                complementoSalario.getItensEvento().add(itemEvento);
            }
        }
    }

    void processamentoComplementoDecimoTerceiro(CalculoComplementoSalario complementoSalario, Date dataInicial, Date dataFinal, EmpresaRh empresaRh) throws ExceptionService {
        for (ItemComplementoSalarioEvento itemEvento : complementoSalario.getItensEvento()) {
            List retorno;
            boolean achou = false;
            ArrayList<ItemCompSalarioEventoPeriodo> itens = new ArrayList<ItemCompSalarioEventoPeriodo>();
            List ret = CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getEventosCompoemComplementoDecimoTerceiro(itemEvento.getTipoCalculo(), dataInicial, dataFinal);
            for (Object obj : ret) {
                Double valorPago = 0.0;
                HashMap hash = (HashMap)obj;
                ItemCompSalarioEventoPeriodo itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                Long idColaborador = (Long)hash.get("idColaborador");
                for (ItemComplementoSalarioColaboradores oo : complementoSalario.getItensColaboradores()) {
                    if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                    itemCompPeriodo.setColaborador(oo.getColaborador());
                    this.getAvos(itemCompPeriodo, complementoSalario.getAno());
                    achou = true;
                    break;
                }
                if (achou) {
                    Double valor = (Double)hash.get("valor");
                    itemCompPeriodo.setValorEvento(valor);
                    Date data = (Date)hash.get("periodo");
                    itemCompPeriodo.setPeriodo(data);
                    itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() / 12.0, 2));
                    itemCompPeriodo.setItemEvento(itemEvento);
                    itens.add(itemCompPeriodo);
                }
                achou = false;
            }
            if (complementoSalario.getCalcularDecTerceiroDissidio().equals((short)1) && (retorno = this.getColaboradoresComDissidio(dataInicial, dataFinal, complementoSalario.getEmpresa())) != null && !retorno.isEmpty()) {
                this.calcularDissidioDecimoTerceiro(complementoSalario, retorno, empresaRh);
            }
            if (complementoSalario.getIncluirFolhaDec().equals((short)1)) {
                ret = CoreDAOFactory.getInstance().getDAOCalculoComplementoSalario().getEventosCompoemComplementoDecimoTerceiro(itemEvento.getTipoCalculo(), complementoSalario.getAno(), dataInicial, dataFinal);
                for (Object obj : ret) {
                    HashMap hash = (HashMap)obj;
                    ItemCompSalarioEventoPeriodo itemCompPeriodo = new ItemCompSalarioEventoPeriodo();
                    Long idColaborador = (Long)hash.get("idColaborador");
                    for (ItemComplementoSalarioColaboradores oo : complementoSalario.getItensColaboradores()) {
                        if (!oo.getColaborador().getIdentificador().equals(idColaborador)) continue;
                        itemCompPeriodo.setColaborador(oo.getColaborador());
                        itemCompPeriodo.setPercAumento(oo.getPercAumento());
                        achou = true;
                        break;
                    }
                    if (achou) {
                        Double valor = (Double)hash.get("valor");
                        itemCompPeriodo.setValorEvento(valor);
                        Date data = (Date)hash.get("periodo");
                        itemCompPeriodo.setPeriodo(data);
                        itemCompPeriodo.setAvos(itemCompPeriodo.getPercAumento());
                        itemCompPeriodo.setValorComplemento(ContatoFormatUtil.arrredondarNumero(itemCompPeriodo.getValorEvento() * (itemCompPeriodo.getPercAumento() / 100.0), 2));
                        itemCompPeriodo.setItemEvento(itemEvento);
                        itens.add(itemCompPeriodo);
                    }
                    achou = false;
                }
            }
            itemEvento.setEventosPeriodo(itens);
        }
    }

    private void getAvos(ItemCompSalarioEventoPeriodo item, Integer ano) throws ExceptionService {
        item.setAvos(Double.valueOf(1.0));
    }

    public List getColaboradoresComDissidio(Date dataInicial, Date dataFinal, Empresa empresa) throws ExceptionService {
        String hqlDissidioDezembro = " from ColaboradorSalario cs  where  cs.colaborador.empresa = :empresa  and  cs.periodo between :dataInicial and :dataFinal  and  cs.colaborador.ativo = :sim  and  (cs.colaborador.dataDemissao is null or cs.colaborador.dataDemissao > :dataFinal) and  cs.colaborador.dataAdmissao < :dataInicial  and   cs.periodo = (select max(cc.periodo)                from ColaboradorSalario cc               where (cc.periodo <= :dataFinal) and cc.colaborador = cs.colaborador)";
        List newColaboradores = CoreBdUtil.getInstance().getSession().createQuery(hqlDissidioDezembro).setParameter("empresa", (Object)empresa).setParameter("sim", (Object)1).setParameter("dataInicial", (Object)dataInicial).setParameter("dataFinal", (Object)dataFinal).list();
        if (newColaboradores == null || newColaboradores.isEmpty()) {
            return new ArrayList();
        }
        ArrayList hashs = new ArrayList();
        for (Object ob : newColaboradores) {
            ColaboradorSalario cs = (ColaboradorSalario)ob;
            Date periodo = ToolDate.nextDays((Date)dataInicial, (int)-1);
            ColaboradorSalario csAnterior = this.getColaboradorSalarioAnterior(cs.getColaborador(), periodo);
            if (csAnterior == null) continue;
            HashMap<String, Object> h = new HashMap<String, Object>();
            h.put("COLABORADOR", cs.getColaborador());
            h.put("PERCENTUAL", this.getPercentual(cs.getValorSalario(), csAnterior.getValorSalario()));
            hashs.add(h);
        }
        return hashs;
    }

    private ColaboradorSalario getColaboradorSalarioAnterior(Colaborador colaborador, Date periodo) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select c  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", colaborador.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        List listaSalario = q.list();
        if (listaSalario != null && listaSalario.size() > 1) {
            throw new ExceptionService("Verifique a informa\u00e7\u00e3o de Salario do Colaborador: " + colaborador.toString());
        }
        ColaboradorSalario csAnt = (ColaboradorSalario)listaSalario.get(0);
        return csAnt;
    }

    private Double getPercentual(Double valorSalario, Double valorSalarioAnterior) {
        return ContatoFormatUtil.arrredondarNumero((valorSalario - valorSalarioAnterior) / valorSalarioAnterior * 100.0, 4);
    }

    private void calcularDissidioDecimoTerceiro(CalculoComplementoSalario complementoSalario, List<HashMap> retorno, EmpresaRh empresaRh) {
        for (HashMap h : retorno) {
            Colaborador colaborador = (Colaborador)h.get("COLABORADOR");
            Double percentual = (Double)h.get("PERCENTUAL");
            for (ItemComplementoSalarioColaboradores i : complementoSalario.getItensColaboradores()) {
                if (!i.getColaborador().equals((Object)colaborador)) continue;
                this.calcularComplementoDecimoTerceiro(colaborador, complementoSalario, empresaRh, percentual);
            }
        }
    }

    private void calcularComplementoDecimoTerceiro(Colaborador colaborador, CalculoComplementoSalario complementoSalario, EmpresaRh empresaRh, Double percentual) {
        String hql = " select  item.valor as VALOR ,  item.eventoColaborador.colaborador.identificador as idColaborador,  item.movimentoFolha.aberturaPeriodo.dataInicio as periodo  from ItemMovimentoFolha item  where  item.eventoColaborador.tipoCalculoEvento.incidenciaInss = :sim  and  extract(year from item.movimentoFolha.aberturaPeriodo.dataInicio) = :ano  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaDec  and  item.movimentoFolha.colaborador = :colaborador ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("folhaDec", EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue().shortValue()).setShort("sim", (short)1).setEntity("colaborador", (Object)colaborador).setInteger("ano", complementoSalario.getAno().intValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        Double valorTotal = 0.0;
        for (Object object : ret) {
            HashMap h = (HashMap)object;
            Double valor = (Double)h.get("VALOR");
            valorTotal = valorTotal + valor;
        }
        if (valorTotal > 0.0) {
            ItemComplementoSalarioEvento item = new ItemComplementoSalarioEvento();
            item.setComplementoSalario(complementoSalario);
            item.setTipoCalculo(empresaRh.getTpEventoPagDecimoTerceiro());
            item.setComplementoSalario(complementoSalario);
            item.setEventosPeriodo(this.getEventosSalarioPeriodo(valorTotal, percentual, colaborador, item, complementoSalario.getAno()));
            complementoSalario.getItensEvento().add(item);
        }
    }

    private List<ItemCompSalarioEventoPeriodo> getEventosSalarioPeriodo(Double valorTotal, Double percentual, Colaborador colaborador, ItemComplementoSalarioEvento item, Integer ano) {
        ArrayList<ItemCompSalarioEventoPeriodo> itens = new ArrayList<ItemCompSalarioEventoPeriodo>();
        ItemCompSalarioEventoPeriodo i = new ItemCompSalarioEventoPeriodo();
        i.setAvos(percentual);
        i.setColaborador(colaborador);
        i.setItemEvento(item);
        i.setPercAumento(percentual);
        i.setPeriodo(ToolDate.intToDate((Integer)ano, (Integer)12, (Integer)31));
        i.setValorEvento(valorTotal);
        i.setValorComplemento(ContatoFormatUtil.arrredondarNumero(valorTotal * percentual / 100.0, 2));
        itens.add(i);
        return itens;
    }

    private Double getValorPago(Integer ano, Colaborador colaborador) {
        String hql = " select coalesce(sum(i.valor),0) as VALOR   from ItemMovimentoFolha i    where    extract(year from i.movimentoFolha.aberturaPeriodo.dataFinal) =:ano   and    i.movimentoFolha.colaborador.identificador = :idcolaborador   and    i.eventoColaborador.tipoCalculoEvento.identificador != 26    and   i.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = 2   and   i.eventoColaborador.tipoCalculoEvento.evento.tipoEvento = 0 ";
        return (Double)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("ano", (Object)ano).setParameter("idcolaborador", (Object)colaborador.getIdentificador()).uniqueResult();
    }
}

