/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.calculocomplemetosalario;

import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.BaseInssEscalonada;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodo;
import com.touchcomp.basementor.model.vo.FolhaComplementarPeriodoItem;
import com.touchcomp.basementor.model.vo.ItemComplementoSalarioEvento;
import com.touchcomp.basementor.model.vo.ItemTabelaINSS;
import com.touchcomp.basementor.model.vo.ItemTabelaIRRF;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PagamentoFolhaCompColaborador;
import com.touchcomp.basementor.model.vo.TabelaINSS;
import com.touchcomp.basementor.model.vo.TabelaIRRF;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import contatocore.util.ContatoFormatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityCalculoComplementoSalarioESocial {
    public List calcularComplementoSalarioEsocial(List<PagamentoFolhaCompColaborador> pagamentos, List<ItemComplementoSalarioEvento> eventos, Date periodoInicial, Date periodoFinal, Short chcFolhaDec) throws ExceptionService {
        ArrayList<HashMap> lista = new ArrayList<HashMap>();
        for (PagamentoFolhaCompColaborador pagamento : pagamentos) {
            for (ItemComplementoSalarioEvento evento : eventos) {
                TipoCalculoEvento tp;
                Long idEvento;
                HashMap h;
                TipoCalculoEvento tipoC = evento.getTipoCalculo();
                String hql = null;
                String hql2 = null;
                if (!(tipoC.getEvento().getCodigo().equals(1013L) || tipoC.getEvento().getCodigo().equals(1015L) || tipoC.getEvento().getCodigo().equals(1014L) || tipoC.getEvento().getCodigo().equals(1016L))) {
                    hql = " select item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO,  item.movimentoFolha.aberturaPeriodo.periodoApuracao as PERIODO,  item.movimentoFolha.nrDepIrrf as NR_DEP_IRRF,  item.valor as VALOR  from ItemMovimentoFolha item  where  item.movimentoFolha.aberturaPeriodo.periodoApuracao between :periodoInicial and :periodoFinal  and  item.movimentoFolha.colaborador = :colaborador  and  item.eventoColaborador.tipoCalculoEvento = :tp  and  (item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento   or  (:chcFolhaDec = 1 and item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decTerceiro  ))";
                } else {
                    hql = " select item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO,  item.movimentoFolha.aberturaPeriodo.periodoApuracao as PERIODO,  item.movimentoFolha.nrDepIrrf as NR_DEP_IRRF,  item.valor as VALOR  from ItemMovimentoFolha item  left join  item.itemFeriasFolha iferias  left join  iferias.itemFerias itemferias  left join itemferias.ferias f  where  item.movimentoFolha.aberturaPeriodo.periodoApuracao between :periodoInicial and :periodoFinal  and  item.movimentoFolha.colaborador = :colaborador  and  item.eventoColaborador.tipoCalculoEvento = :tp  and  (item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento or (:chcFolhaDec = 1 and item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :decTerceiro ))  and  (iferias is null  or (f.dataGozoInicial < :periodoFinal and f.dataGozoFinal < :periodoFinal ) ) ";
                    hql2 = " select item.eventoColaborador.tipoCalculoEvento.identificador as ID_EVENTO,  item.movimentoFolha.aberturaPeriodo.periodoApuracao as PERIODO,  item.movimentoFolha.nrDepIrrf as NR_DEP_IRRF,  itemferias.valor as VALOR  from ItemMovimentoFolha item  left join  item.itemFeriasFolha iferias  left join  iferias.itemFerias itemferias  left join itemferias.ferias f  where  item.movimentoFolha.aberturaPeriodo.periodoApuracao between :periodoInicial and :periodoFinal  and  item.movimentoFolha.colaborador = :colaborador  and  item.eventoColaborador.tipoCalculoEvento = :tp  and  item.movimentoFolha.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  (iferias is not null  and  (f.dataGozoInicial < :periodoFinal and f.dataGozoFinal > :periodoFinal ) ) ";
                }
                List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)pagamento.getColaborador()).setDate("periodoInicial", periodoInicial).setEntity("tp", (Object)tipoC).setShort("chcFolhaDec", chcFolhaDec.shortValue()).setParameter("decTerceiro", (Object)EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()).setDate("periodoFinal", periodoFinal).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
                for (Object object : retorno) {
                    h = (HashMap)object;
                    idEvento = (Long)h.get("ID_EVENTO");
                    tp = (TipoCalculoEvento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoCalculoEvento(), "identificador", idEvento, 0);
                    h.put("TP_EVENTO", tp);
                    h.put("PAGAMENTO", pagamento);
                    lista.add(h);
                }
                if (hql2 == null) continue;
                retorno = CoreBdUtil.getInstance().getSession().createQuery(hql2).setEntity("colaborador", (Object)pagamento.getColaborador()).setDate("periodoInicial", periodoInicial).setEntity("tp", (Object)tipoC).setDate("periodoFinal", periodoFinal).setShort("folhaPagamento", EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue().shortValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
                for (Object object : retorno) {
                    h = (HashMap)object;
                    idEvento = (Long)h.get("ID_EVENTO");
                    tp = (TipoCalculoEvento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoCalculoEvento(), "identificador", idEvento, 0);
                    h.put("TP_EVENTO", tp);
                    h.put("PAGAMENTO", pagamento);
                    lista.add(h);
                }
            }
        }
        return lista;
    }

    public List calcularImpostoFolhaComplementarEsocial(List lista, Date dataPagamento) throws ExceptionService {
        TabelaINSS tabelaInss = this.getTabelaInss(dataPagamento);
        if (tabelaInss == null) {
            throw new ExceptionService("Tabela de Inss n\u00e3o encontrada.");
        }
        TabelaIRRF tabelaIrrf = this.getTabelaIrrf(dataPagamento);
        if (tabelaIrrf == null) {
            throw new ExceptionService("Tabela de Irrf n\u00e3o encontrada.");
        }
        for (Object object : lista) {
            PagamentoFolhaCompColaborador pag = (PagamentoFolhaCompColaborador)object;
            for (FolhaComplementarPeriodo folhaComp : pag.getFolhaComplementares()) {
                this.getBaseInss(folhaComp);
                this.calcularValorInss(folhaComp, tabelaInss);
                this.getBaseIrrf(folhaComp);
                this.calcularValorIrrf(folhaComp, tabelaIrrf);
                this.getBaseFgts(folhaComp);
                this.calcularFgts(folhaComp);
                this.calcularLiquido(folhaComp);
            }
        }
        return lista;
    }

    private void getBaseFgts(FolhaComplementarPeriodo folhaComp) {
        Double baseFgtsProvento = 0.0;
        Double baseFgtsDesconto = 0.0;
        for (FolhaComplementarPeriodoItem item : folhaComp.getFolhaComplementarPeriodoItem()) {
            if (item.getTipoCalculoEvento().getIncidenciaFgts().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                baseFgtsProvento = baseFgtsProvento + item.getValorComplemento();
                continue;
            }
            if (!item.getTipoCalculoEvento().getIncidenciaFgts().equals((short)1) || !item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) continue;
            baseFgtsDesconto = baseFgtsDesconto + item.getValorComplemento();
        }
        folhaComp.setBaseFgts(Double.valueOf(baseFgtsProvento - baseFgtsDesconto));
    }

    private void calcularFgts(FolhaComplementarPeriodo folhaComp) {
        folhaComp.setVrFgts(UtilityCalculoComplementoSalarioESocial.getTruncarValor(folhaComp.getBaseFgts() * 8.0 / 100.0));
    }

    private void calcularValorIrrf(FolhaComplementarPeriodo folhaComp, TabelaIRRF tabelaIrrf) {
        Double totalBaseIrrf = 0.0;
        Double totalBaseIrrfDec = 0.0;
        Double aliquotaIrrf = 0.0;
        Double vrDeducao = 0.0;
        Double vrDependente = tabelaIrrf.getVrDeducaoPorDependente();
        totalBaseIrrf = folhaComp.getBaseIrrf() + folhaComp.getBaseIrrfAnterior() - folhaComp.getVrInss() - vrDependente * (double)folhaComp.getNrDepIrrf().shortValue();
        totalBaseIrrfDec = folhaComp.getBaseIrrfDec() + folhaComp.getBaseIrrfDecAnterior() - folhaComp.getVrInssDec() - vrDependente * (double)folhaComp.getNrDepIrrf().shortValue();
        for (Object o : tabelaIrrf.getItensTabela()) {
            ItemTabelaIRRF i = (ItemTabelaIRRF)o;
            if (!(i.getValorAte() > totalBaseIrrf)) continue;
            aliquotaIrrf = (double)i.getAliquota();
            vrDeducao = (double)i.getVrDeducao();
            break;
        }
        folhaComp.setBaseIrrf(totalBaseIrrf);
        folhaComp.setAliquotaIrrf(aliquotaIrrf);
        Double vlrIrrf = UtilityCalculoComplementoSalarioESocial.getTruncarValor(folhaComp.getBaseIrrf() * aliquotaIrrf / 100.0) - folhaComp.getVrIrrfAnterior() - vrDeducao;
        if (vlrIrrf < 0.0) {
            vlrIrrf = 0.0;
        }
        if (folhaComp.getVrIrrfAnterior() == 0.0 && vlrIrrf < tabelaIrrf.getVrMinimoADescontar()) {
            vlrIrrf = 0.0;
        }
        folhaComp.setVrIrrf(vlrIrrf);
        for (Object o : tabelaIrrf.getItensTabela()) {
            ItemTabelaIRRF i = (ItemTabelaIRRF)o;
            if (!(i.getValorAte() > totalBaseIrrfDec)) continue;
            aliquotaIrrf = (double)i.getAliquota();
            vrDeducao = (double)i.getVrDeducao();
            break;
        }
        folhaComp.setBaseIrrfDec(totalBaseIrrfDec);
        folhaComp.setAliquotaIrrfDec(aliquotaIrrf);
        Double vlrIrrfDec = UtilityCalculoComplementoSalarioESocial.getTruncarValor(folhaComp.getBaseIrrf() * aliquotaIrrf / 100.0) - folhaComp.getVrIrrfDecAnterior() - vrDeducao;
        if (vlrIrrfDec < 0.0) {
            vlrIrrfDec = 0.0;
        }
        folhaComp.setVrIrrfDec(vlrIrrfDec);
    }

    private void getBaseIrrf(FolhaComplementarPeriodo folhaComp) {
        Double baseIrrfProvento = 0.0;
        Double baseIrrfDesconto = 0.0;
        Double baseIrrfDecProvento = 0.0;
        Double baseIrrfDecDesconto = 0.0;
        for (FolhaComplementarPeriodoItem item : folhaComp.getFolhaComplementarPeriodoItem()) {
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseIrrfDecProvento = baseIrrfDecProvento + item.getValorComplemento();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseIrrfDecDesconto = baseIrrfDecDesconto + item.getValorComplemento();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                baseIrrfProvento = baseIrrfProvento + item.getValorComplemento();
                continue;
            }
            if (!item.getTipoCalculoEvento().getIncidenciaIrrf().equals((short)1) || !item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) continue;
            baseIrrfDesconto = baseIrrfDesconto + item.getValorComplemento();
        }
        folhaComp.setBaseIrrf(Double.valueOf(baseIrrfProvento - baseIrrfDesconto));
        folhaComp.setBaseIrrfDec(Double.valueOf(baseIrrfDecProvento - baseIrrfDecDesconto));
    }

    private void calcularValorInss(FolhaComplementarPeriodo f, TabelaINSS tabelaInss) {
        BaseInssEscalonada base;
        BaseInssEscalonada base2;
        Double bcCalculado;
        Double baseTotalInss = 0.0;
        Double baseTotalInssDec = 0.0;
        Double aliquotaInss = 0.0;
        baseTotalInss = f.getBaseInss() + f.getBaseInssAnterior();
        if (baseTotalInss >= tabelaInss.getVrLimiteMaximoInss()) {
            return;
        }
        baseTotalInssDec = f.getBaseInssDec() + f.getBaseInssDecAnterior();
        ArrayList<Object> bases = new ArrayList<BaseInssEscalonada>();
        Double bcInssSobra = ContatoFormatUtil.arrredondarNumero((Double)baseTotalInss, (int)2);
        Double baseAnterior = 0.0;
        boolean menor = false;
        for (ItemTabelaINSS item : tabelaInss.getItensTabelaINSS()) {
            if (baseTotalInss >= item.getValorAte()) {
                bcCalculado = 0.0;
                if (bcInssSobra > item.getValorAte()) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else if (bcInssSobra > item.getValorAte() - baseAnterior) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else {
                    bcCalculado = bcInssSobra;
                    menor = true;
                }
                baseAnterior = item.getValorAte();
                base2 = new BaseInssEscalonada("FOLHA");
                base2.setBaseInss(bcCalculado);
                baseAnterior = item.getValorAte();
                base2.setAliquota(item.getAliquotaInss());
                base2.setValor(UtilityCalculoComplementoSalarioESocial.getTruncarValor(base2.getBaseInss() * base2.getAliquota() / 100.0));
                bases.add(base2);
                if (!menor) continue;
                break;
            }
            base = new BaseInssEscalonada("FOLHA");
            base.setBaseInss(bcInssSobra);
            base.setAliquota(item.getAliquotaInss());
            base.setValor(UtilityCalculoComplementoSalarioESocial.getTruncarValor(bcInssSobra * base.getAliquota() / 100.0));
            bases.add(base);
            break;
        }
        f.setVrInss(ContatoFormatUtil.arrredondarNumero((Double)(UtilityCalculoComplementoSalarioESocial.getInss(bases) - f.getVrInssAnterior()), (int)2));
        bases = new ArrayList();
        bcInssSobra = ContatoFormatUtil.arrredondarNumero((Double)baseTotalInssDec, (int)2);
        baseAnterior = 0.0;
        menor = false;
        for (ItemTabelaINSS item : tabelaInss.getItensTabelaINSS()) {
            if (baseTotalInss >= item.getValorAte()) {
                bcCalculado = 0.0;
                if (bcInssSobra > item.getValorAte()) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else if (bcInssSobra > item.getValorAte() - baseAnterior) {
                    bcInssSobra = bcInssSobra - (item.getValorAte() - baseAnterior);
                    bcCalculado = item.getValorAte() - baseAnterior;
                } else {
                    bcCalculado = bcInssSobra;
                    menor = true;
                }
                baseAnterior = item.getValorAte();
                base2 = new BaseInssEscalonada("FOLHA");
                base2.setBaseInss(bcCalculado);
                baseAnterior = item.getValorAte();
                base2.setAliquota(item.getAliquotaInss());
                base2.setValor(UtilityCalculoComplementoSalarioESocial.getTruncarValor(base2.getBaseInss() * base2.getAliquota() / 100.0));
                bases.add(base2);
                if (!menor) continue;
                break;
            }
            base = new BaseInssEscalonada("FOLHA");
            base.setBaseInss(bcInssSobra);
            base.setAliquota(item.getAliquotaInss());
            base.setValor(UtilityCalculoComplementoSalarioESocial.getTruncarValor(bcInssSobra * base.getAliquota() / 100.0));
            bases.add(base);
            break;
        }
        f.setVrInssDec(ContatoFormatUtil.arrredondarNumero((Double)(UtilityCalculoComplementoSalarioESocial.getInss(bases) - f.getVrInssdecAnterior()), (int)2));
        if (f.getVrInssDec() < 0.0) {
            f.setVrInssDec(Double.valueOf(0.0));
        }
        if (f.getVrInss() <= 0.0) {
            f.setVrInss(Double.valueOf(0.0));
        }
    }

    private static Double getInss(List<BaseInssEscalonada> bases) {
        Double valor = 0.0;
        for (BaseInssEscalonada base : bases) {
            valor = valor + base.getValor();
        }
        return valor;
    }

    private static Double getTruncarValor(Double valor) {
        BigDecimal bd = BigDecimal.valueOf(valor);
        bd = bd.setScale(2, 1);
        return bd.doubleValue();
    }

    private TabelaINSS getTabelaInss(Date dataPagamento) throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOTabelaINSS().getVOClass());
        bc.and().lessEqual("dataInicial", dataPagamento);
        bc.and().greaterEqual("dataFinal", dataPagamento);
        return (TabelaINSS)CoreService.executeSearchUniqueResult(bc);
    }

    private TabelaIRRF getTabelaIrrf(Date dataPagamento) throws ExceptionService {
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOTabelaIRRF().getVOClass());
        bc.and().lessEqual("dataInicial", dataPagamento);
        bc.and().greaterEqual("dataFinal", dataPagamento);
        return (TabelaIRRF)CoreService.executeSearchUniqueResult(bc);
    }

    private void getBaseInss(FolhaComplementarPeriodo folhaComp) {
        Double baseInssProvento = 0.0;
        Double baseInssDesconto = 0.0;
        Double baseInssDecProvento = 0.0;
        Double baseInssDecDesconto = 0.0;
        for (FolhaComplementarPeriodoItem item : folhaComp.getFolhaComplementarPeriodoItem()) {
            if (item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseInssDecProvento = baseInssDecProvento + item.getValorComplemento();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue()) && item.getTipoCalculoEvento().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue())) {
                baseInssDecDesconto = baseInssDecDesconto + item.getValorComplemento();
                continue;
            }
            if (item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) && item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                baseInssProvento = baseInssProvento + item.getValorComplemento();
                continue;
            }
            if (!item.getTipoCalculoEvento().getIncidenciaInss().equals((short)1) || !item.getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_DESCONTO.getValue())) continue;
            baseInssDesconto = baseInssDesconto + item.getValorComplemento();
        }
        folhaComp.setBaseInss(Double.valueOf(baseInssProvento - baseInssDesconto));
        folhaComp.setBaseInssDec(Double.valueOf(baseInssDecProvento - baseInssDecDesconto));
    }

    private void calcularLiquido(FolhaComplementarPeriodo folhaComp) {
        Double totalProventos = 0.0;
        Double totalDescontos = 0.0;
        Double liquido = 0.0;
        totalDescontos = folhaComp.getVrInss() + folhaComp.getVrIrrf();
        for (FolhaComplementarPeriodoItem item : folhaComp.getFolhaComplementarPeriodoItem()) {
            if (item.getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                totalProventos = totalProventos + item.getValorComplemento();
                totalProventos = ToolFormatter.arrredondarNumero((Double)totalProventos, (int)2);
                continue;
            }
            if (!item.getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("2")) continue;
            totalDescontos = totalDescontos + item.getValorComplemento();
            totalDescontos = ToolFormatter.arrredondarNumero((Double)totalDescontos, (int)2);
        }
        liquido = ToolFormatter.arrredondarNumero((Double)(totalProventos - totalDescontos), (int)2);
        folhaComp.setTotalProventos(totalProventos);
        folhaComp.setTotalDescontos(totalDescontos);
        folhaComp.setVlrLiquido(liquido);
    }

    public void findValoresBasesIrrfPeriodo(Colaborador colaborador, Date dataPagamento, HashMap h) {
        String hql = " select  coalesce(sum(mov.bcIrrfSalario),0) as BC_IRRF , coalesce(sum(mov.vrIrrfSalario),0) as VLR_IRRF,  coalesce(sum(mov.bcInss13Sal),0) - coalesce(sum(mov.vrInss13Sal),0) as BC_IRRF_DEC , coalesce(sum(mov.vrIrrf13Sal),0) as VLR_IRRF_DEC  from MovimentoFolha mov  where  mov.colaborador = :colaborador  and  mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  extract(year from mov.aberturaPeriodo.dataInicio) = :ano  and  extract(month from mov.aberturaPeriodo.dataInicio) = :mes  and  mov.statusFolha.codigo != :rescisao ";
        HashMap hh = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("ano", (Object)DateUtil.yearFromDate(dataPagamento)).setParameter("mes", (Object)DateUtil.monthFromDate(dataPagamento)).setParameter("rescisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (hh != null) {
            h.put("BC_IRRF", hh.get("BC_IRRF"));
            h.put("VLR_IRRF_DEC", hh.get("VLR_IRRF_DEC"));
            h.put("BC_IRRF_DEC", hh.get("BC_IRRF_DEC"));
            h.put("VLR_IRRF", hh.get("VLR_IRRF"));
        }
    }

    public void findValoresBasesInssPeriodo(Colaborador colaborador, Date periodoApuracao, HashMap h) {
        String hql = " select  coalesce(sum(mov.bcInssSalario),0) + coalesce(sum(mov.bcInssFerias),0) as BC_INSS , coalesce(sum(mov.vrInss13Sal),0) as VLR_INSS_DEC,  coalesce(sum(mov.bcInss13Sal),0)  as BC_INSS_DEC , coalesce(sum(mov.vrInssSalario),0) + coalesce(sum(mov.vrInssFerias),0) as VLR_INSS  from MovimentoFolha mov  left join mov.multiplosVinculos mul  where  mov.colaborador = :colaborador  and  extract(year from mov.aberturaPeriodo.periodoApuracao) = :ano  and  extract(month from mov.aberturaPeriodo.periodoApuracao) = :mes  and  mov.statusFolha.codigo != :rescisao  and  mul = null";
        HashMap hh = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("ano", (Object)DateUtil.yearFromDate(periodoApuracao)).setParameter("mes", (Object)DateUtil.monthFromDate(periodoApuracao)).setParameter("rescisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (hh != null) {
            h.put("BC_INSS", hh.get("BC_INSS"));
            h.put("VLR_INSS_DEC", hh.get("VLR_INSS_DEC"));
            h.put("BC_INSS_DEC", hh.get("BC_INSS_DEC"));
            h.put("VLR_INSS", hh.get("VLR_INSS"));
            return;
        }
        hql = " select mov as movimento  from MovimentoFolha mov  inner join mov.multiplosVinculos mul  where  mov.colaborador = :colaborador  and  extract(year from mov.aberturaPeriodo.periodoApuracao) = :ano  and  extract(month from mov.aberturaPeriodo.periodoApuracao) = :mes  and  mov.statusFolha.codigo != :rescisao    ";
        hh = (HashMap)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("colaborador", (Object)colaborador).setParameter("ano", (Object)DateUtil.yearFromDate(periodoApuracao)).setParameter("mes", (Object)DateUtil.monthFromDate(periodoApuracao)).setParameter("rescisao", (Object)EnumConstTipoCalculoEvento.CALCULO_RESCISAO.getValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).uniqueResult();
        if (hh != null) {
            MovimentoFolha mov = (MovimentoFolha)hh.get("movimento");
            Double baseinss = 0.0;
            Double valorinss = 0.0;
            for (BaseInssEscalonada basesIns : mov.getBasesInss()) {
                baseinss = baseinss + basesIns.getBaseInss();
                valorinss = valorinss + basesIns.getValor();
            }
            h.put("BC_INSS", baseinss);
            h.put("VLR_INSS_DEC", 0.0);
            h.put("BC_INSS_DEC", 0.0);
            h.put("VLR_INSS", valorinss);
        }
    }
}

