/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cartacorrecaoeletronica;

import com.touchcomp.basementor.model.vo.EvtNFeCartaCorrecao;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorxml.model.XMLEventoNFe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLEventoNFe;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import mentorcore.exceptions.ExceptionEventoNfe;
import mentorcore.exceptions.ExceptionFileManipulation;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;

class UtilCartaCorrecaoEletronica {
    private static final TLogger logger = TLogger.get(UtilCartaCorrecaoEletronica.class);

    UtilCartaCorrecaoEletronica() {
    }

    public static JasperPrint getJasperPrint(EvtNFeCartaCorrecao cartaCorrecao, Nodo nodo, HashMap map) throws ExceptionService {
        String reportPath = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "mercado" + File.separator + "gestaofaturamento" + File.separator + "faturamento" + File.separator + "cartacorrecaoeletronica" + File.separator + "INDIVIDUAL_CARTA_CORRECAO_ELETRONICA.jasper";
        map.put("LOGRADOURO", cartaCorrecao.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getLogradouro());
        map.put("NUMERO", cartaCorrecao.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getNumero());
        map.put("CEP", cartaCorrecao.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getCep());
        map.put("BAIRRO", cartaCorrecao.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getBairro());
        map.put("CIDADE", cartaCorrecao.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getCidade().getDescricao());
        map.put("UF", cartaCorrecao.getNotaFiscalPropria().getEmpresa().getPessoa().getEndereco().getCidade().getUf().getSigla());
        try {
            CoreRequestContext cq = new CoreRequestContext();
            cq.setAttribute("params", map);
            cq.setAttribute("nodo", nodo);
            CoreServiceFactory.getServiceOpcoesRelatorio().execute(cq, "setarParametrosRelatorio");
            String carta = ToolString.clearSpecialCharacXML((String)UtilCartaCorrecaoEletronica.toXMLString(cartaCorrecao));
            cq = new CoreRequestContext();
            cq.setAttribute("path", reportPath);
            cq.setAttribute("parametros", map);
            cq.setAttribute("inputStream", new ByteArrayInputStream(carta.getBytes()));
            cq.setAttribute("tagInicio", "/retEvento");
            return (JasperPrint)CoreServiceFactory.getCoreReportService().execute(cq, "getJasperPrintXMLSource");
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService("Erro ao gerar a carta de corre\u00e7\u00e3o.", ex);
        }
    }

    private static String toXMLString(EvtNFeCartaCorrecao cartaCorrecao) throws ExceptionEventoNfe, JDOMException, IOException, ExceptionFileManipulation {
        ServiceXMLEventoNFe service = (ServiceXMLEventoNFe)ConfApplicationContext.getBean(ServiceXMLEventoNFe.class);
        SAXBuilder sb = new SAXBuilder();
        SAXBuilder sb2 = new SAXBuilder();
        XMLEventoNFe xml = (XMLEventoNFe)service.get((Serializable)cartaCorrecao.getIdentificador());
        if (xml == null) {
            throw new ExceptionFileManipulation("Carta de Corre\u00e7\u00e3o sem arquivo xml.");
        }
        if (xml.getConteudoRecebido() != null) {
            Document d = sb.build((InputStream)new ByteArrayInputStream(xml.getConteudoRecebido().getBytes()));
            Element e = null;
            if (xml.getConteudoEnviado() != null) {
                Document c = sb2.build((InputStream)new ByteArrayInputStream(xml.getConteudoEnviado().getBytes()));
                e = c.detachRootElement();
            }
            Element cceProc = new Element("retEvento");
            Attribute at = new Attribute("xCorrecao", cartaCorrecao.getJustificativaEvento());
            cceProc.setAttribute(at);
            Element root = d.detachRootElement();
            cceProc.addContent((Content)root);
            if (e != null) {
                cceProc.addContent((Content)e);
            }
            return new XMLOutputter().outputString(cceProc);
        }
        throw new ExceptionEventoNfe("Carta de Corre\u00e7\u00e3o n\u00e3o autorizada");
    }
}

