/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.celulaprodutiva;

import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.PeriodoProducao;
import com.touchcomp.basementor.model.vo.PrevOcupCelulaProdutiva;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdSobEnc;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class AuxCargaCelulaProdutiva {
    public List getCalculoCelulaProdutiva(List osLinhaProd, Short filtrarCelula, Long idCelulaInicial, Long idCelulaFinal, Long idPeriodoProducao, List osLinhaSobEnc) throws ExceptionDatabase {
        List ocupacoes = this.getOcupCelulaProdutiva(filtrarCelula, idCelulaInicial, idCelulaFinal, idPeriodoProducao);
        this.putOcupacoesSalvas(ocupacoes, idPeriodoProducao);
        this.putOsTemporaria(osLinhaProd, ocupacoes);
        this.putOsTemporariaOsSobEnc(osLinhaSobEnc, ocupacoes);
        this.putTempoDisponivel(ocupacoes, idPeriodoProducao);
        return ocupacoes;
    }

    private List getOcupCelulaProdutiva(Short filtrarCelula, Long idCelulaInicial, Long idCelulaFinal, Long idPeriodoProducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object st = "select c.identificador as ID_CELULA_PRODUTIVA, c.descricao as CELULA_PRODUTIVA from CelulaProdutiva c";
        st = (String)st + " where c.ativo = :sim";
        if (filtrarCelula != null && filtrarCelula == 1) {
            st = (String)st + " and c.identificador between :idCelulaInicial and :idCelulaFinal";
        }
        Query q = s.createQuery((String)st);
        if (filtrarCelula != null && filtrarCelula == 1) {
            q.setLong("idCelulaInicial", idCelulaInicial.longValue());
            q.setLong("idCelulaFinal", idCelulaFinal.longValue());
        }
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List cel = q.list();
        return cel;
    }

    private void putTempoDisponivel(List ocupacoes, Long idPeriodoProducao) throws ExceptionDatabase {
        PeriodoProducao per = (PeriodoProducao)CoreDAOFactory.getInstance().getDAOPeriodoProducao().findByPrimaryKey(idPeriodoProducao);
        Session s = CoreBdUtil.getInstance().getSession();
        String st = "select sum(d.numHoras) as TOTAL_HORAS_DISPONIVEIS from DiaPlanejTempoTrabalhoPCP o inner join o.planejTempoTrabalhoPCP p inner join p.celulasProdutivas c inner join o.diaPlanejHorarios d where d.dataInicio >= :dataInicial and d.dataTermino <=:dataFinal and c.celulaProdutiva.identificador = :idCelula and d.tipoTempo = :produtivo";
        Query q = s.createQuery(st);
        for (Object o : ocupacoes) {
            HashMap h = (HashMap)o;
            Long idCelulaProd = (Long)h.get("ID_CELULA_PRODUTIVA");
            q.setLong("idCelula", idCelulaProd.longValue());
            q.setDate("dataInicial", per.getDataInicial());
            q.setDate("dataFinal", per.getDataFinal());
            q.setShort("produtivo", (short)1);
            Double valor = (Double)q.uniqueResult();
            if (valor == null) {
                valor = 0.0;
            }
            Double totHoras = (Double)h.get("TOTAL_HORAS");
            Double totHorasEfic = (Double)h.get("TOTAL_HORAS_EFIC");
            h.put("TOTAL_HORAS_DISPONIVEIS", valor);
            h.put("HORAS_DISPONIVEIS", valor - totHoras);
            h.put("HORAS_DISPONIVEIS_EFIC", valor - totHorasEfic);
            Double divisor = valor * 100.0;
            if (ToolMethods.isEquals((Object)divisor, (Object)0.0)) {
                divisor = 1.0;
            }
            h.put("PERC_OCUP", totHoras / divisor);
            h.put("PERC_OCUP_EFIC", totHorasEfic / divisor);
        }
    }

    private void putOsTemporaria(List osLinhaProd, List ocupacoes) {
        if (osLinhaProd == null) {
            return;
        }
        for (Object o : osLinhaProd) {
            OrdemServicoProdLinhaProd os = (OrdemServicoProdLinhaProd)o;
            for (SubdivisaoOSProdLinhaProd s : os.getSubDivisoesOS()) {
                for (PrevOcupCelulaProdutiva ocu : s.getOcupacoesCelulaProd()) {
                    HashMap found = null;
                    if (ocu.getIdentificador() != null) continue;
                    for (Object ob : ocupacoes) {
                        HashMap f = (HashMap)ob;
                        Long idCelulaProdutiva = (Long)f.get("ID_CELULA_PRODUTIVA");
                        if (!idCelulaProdutiva.equals(ocu.getCelulaProdutiva().getIdentificador())) continue;
                        found = f;
                        break;
                    }
                    if (found == null) {
                        found = new HashMap();
                        found.put("ID_CELULA_PRODUTIVA", ocu.getCelulaProdutiva().getIdentificador());
                        found.put("CELULA_PRODUTIVA", ocu.getCelulaProdutiva().getDescricao());
                        found.put("TOTAL_HORAS", 0.0);
                        found.put("TOTAL_HORAS_EFIC", 0.0);
                        ocupacoes.add(found);
                    }
                    found.put("TOTAL_HORAS", (Double)found.get("TOTAL_HORAS") + ocu.getNumeroHoras());
                    found.put("TOTAL_HORAS_EFIC", (Double)found.get("TOTAL_HORAS_EFIC") + ocu.getNumeroHorasEficEsperada());
                }
            }
        }
    }

    private void putOcupacoesSalvas(List ocupacoes, Long idPeriodoProducao) {
        Session s = CoreBdUtil.getInstance().getSession();
        for (Object o : ocupacoes) {
            HashMap h = (HashMap)o;
            Long idCelula = (Long)h.get("ID_CELULA_PRODUTIVA");
            String st = "select coalesce(sum(o.numeroHoras),0) as TOTAL_HORAS,coalesce(sum(o.numeroHorasEficEsperada),0) as TOTAL_HORAS_EFIC from  PrevOcupCelulaProdutiva o inner join o.celulaProdutiva c where o.celulaProdutiva.identificador=:idCelula and o.periodoProducao.identificador=:idPeriodoProd";
            Query q = s.createQuery(st);
            q.setLong("idCelula", idCelula.longValue());
            q.setLong("idPeriodoProd", idPeriodoProducao.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            h.putAll((HashMap)q.uniqueResult());
        }
    }

    private void putOsTemporariaOsSobEnc(List osLinhaSobEnc, List ocupacoes) {
        if (osLinhaSobEnc == null) {
            return;
        }
        for (Object o : osLinhaSobEnc) {
            OrdemServicoProdSobEnc os = (OrdemServicoProdSobEnc)o;
            for (SubdivisaoOSProdSobEnc s : os.getSubDivisoesOS()) {
                for (PrevOcupCelulaProdutiva ocu : s.getPrevOcupCelProdutiva()) {
                    HashMap found = null;
                    if (ocu.getIdentificador() != null) continue;
                    for (Object ob : ocupacoes) {
                        HashMap f = (HashMap)ob;
                        Long idCelulaProdutiva = (Long)f.get("ID_CELULA_PRODUTIVA");
                        if (!idCelulaProdutiva.equals(ocu.getCelulaProdutiva().getIdentificador())) continue;
                        found = f;
                        break;
                    }
                    if (found == null) {
                        found = new HashMap();
                        found.put("ID_CELULA_PRODUTIVA", ocu.getCelulaProdutiva().getIdentificador());
                        found.put("CELULA_PRODUTIVA", ocu.getCelulaProdutiva().getDescricao());
                        found.put("TOTAL_HORAS", 0.0);
                        found.put("TOTAL_HORAS_EFIC", 0.0);
                        ocupacoes.add(found);
                    }
                    found.put("TOTAL_HORAS", (Double)found.get("TOTAL_HORAS") + ocu.getNumeroHoras());
                    found.put("TOTAL_HORAS_EFIC", (Double)found.get("TOTAL_HORAS_EFIC") + ocu.getNumeroHorasEficEsperada());
                }
            }
        }
    }
}

