/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.celulaprodutiva;

import com.touchcomp.basementor.model.vo.PeriodoProducao;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.tools.DateUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class AuxDesempenhoCelulaProdutiva {
    public List getCalculoCelulaProdutiva(Short filtrarCelula, Long idCelulaInicial, Long idCelulaFinal, PeriodoProducao periodoProducao, Short tipoFiltro, Date dataInicial, Date dataFinal) throws ExceptionDatabase {
        List ocupacoes = this.getCelulaProdutiva(filtrarCelula, idCelulaInicial, idCelulaFinal);
        this.putEventos(ocupacoes, periodoProducao, tipoFiltro, dataInicial, dataFinal);
        this.putCapacidade(ocupacoes, periodoProducao, tipoFiltro, dataInicial, dataFinal);
        this.putTempoDisponivel(ocupacoes, periodoProducao, tipoFiltro, dataInicial, dataFinal);
        this.putTempoUtilizado(ocupacoes, periodoProducao, tipoFiltro, dataInicial, dataFinal);
        return ocupacoes;
    }

    private List getCelulaProdutiva(Short filtrarCelula, Long idCelulaInicial, Long idCelulaFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object st = "select c.identificador as ID_CELULA_PRODUTIVA, c.descricao as CELULA_PRODUTIVA from CelulaProdutiva c";
        if (filtrarCelula != null && filtrarCelula == 1) {
            st = (String)st + " where c.identificador between :idCelulaInicial and :idCelulaFinal";
        }
        Query q = s.createQuery((String)st);
        if (filtrarCelula != null && filtrarCelula == 1) {
            q.setLong("idCelulaInicial", idCelulaInicial.longValue());
            q.setLong("idCelulaFinal", idCelulaFinal.longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List cel = q.list();
        return cel;
    }

    private void putTempoDisponivel(List ocupacoes, PeriodoProducao periodoProducao, Short tipoFiltro, Date dataInicial, Date dataFinal) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        String st = "select distinct d.numHoras as NUM_HORAS,d.identificador as IDENTIFICADOR, d.dataInicio as DATA_INICIO,d.dataTermino as DATA_TERMINO,d.observacao as OBSERVACAO, d.tipoTempo as TIPO_TEMPO from DiaPlanejTempoTrabalhoPCPHor h inner join h.diaPlanejTempoTrabPCP o inner join o.planejTempoTrabalhoPCP p inner join p.celulasProdutivas c inner join o.diaPlanejHorarios d where d.dataInicio >= :dataInicial and d.dataTermino <=:dataFinal and c.identificador = :idCelula and d.tipoTempo = :produtivo order by d.dataInicio";
        Query q = s.createQuery(st);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        for (Object o : ocupacoes) {
            HashMap h = (HashMap)o;
            Long idCelulaProd = (Long)h.get("ID_CELULA_PRODUTIVA");
            q.setLong("idCelula", idCelulaProd.longValue());
            if (tipoFiltro == 0) {
                q.setDate("dataInicial", periodoProducao.getDataInicial());
                q.setDate("dataFinal", periodoProducao.getDataFinal());
            } else {
                q.setDate("dataInicial", dataInicial);
                q.setDate("dataFinal", dataFinal);
            }
            q.setShort("produtivo", (short)1);
            Double valor = 0.0;
            List res = q.list();
            for (Object ob : res) {
                HashMap hS = (HashMap)ob;
                Double aux = (Double)hS.get("NUM_HORAS");
                if (aux == null) continue;
                valor = valor + aux;
            }
            h.put("TOTAL_HORAS_PLANEJAMENTO", valor);
            h.put("LISTA_HORAS", res);
        }
    }

    private void putTempoUtilizado(List celulas, PeriodoProducao periodoProducao, Short tipoFiltro, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        for (Object o : celulas) {
            HashMap h = (HashMap)o;
            Long idCelula = (Long)h.get("ID_CELULA_PRODUTIVA");
            Query q = s.createQuery("select coalesce(sum(o.numeroHoras),0) as TOTAL_OCUPACAO from PrevOcupCelulaProdutiva o inner join o.celulaProdutiva c inner join o.periodoProducao p where c.identificador=:idCelula and ((:tipoFiltro = 0 and p.identificador=:idPeriodoProd) or (:tipoFiltro = 1 and o.dataInicial >=:dataInicial and o.dataFinal <= :dataFinal))");
            q.setLong("idCelula", idCelula.longValue());
            q.setLong("idPeriodoProd", periodoProducao.getIdentificador().longValue());
            q.setShort("tipoFiltro", tipoFiltro.shortValue());
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            h.putAll((HashMap)q.uniqueResult());
        }
    }

    private void putEventos(List ocupacoes, PeriodoProducao periodoProducao, Short tipoFiltro, Date dataInicial, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        for (Object o : ocupacoes) {
            HashMap h = (HashMap)o;
            h.put("TOTAL_HORAS_OPERACIONAIS", 0.0);
            h.put("TOTAL_HORAS_PAR_FUNC", 0.0);
            h.put("TOTAL_HORAS_PREV_COR", 0.0);
            h.put("TOTAL_HORAS_OUTROS", 0.0);
            Long idCelula = (Long)h.get("ID_CELULA_PRODUTIVA");
            String query = "select coalesce(sum(o.horaEvento),0) as TOTAL_HORAS,t.tiposFixos as TIPO_FIXO from EventoOsProducaoLinhaProd o inner join o.tipoEvento t inner join o.subdivisaoOSProd s inner join s.ordemServicoProdLinhaProd os inner join os.periodoProducao p where o.faseProdutiva.celulaProdutiva.identificador=:idCelula and ((:tipoFiltro = 0 and p.identificador=:idPeriodoProd) and (o.tipoApontEvento = :celula  or o.tipoApontEvento = :ambos) or (:tipoFiltro = 1 and o.dataFechamento between :dataInicial and :dataFinal)) group by t.tiposFixos";
            Query q = s.createQuery(query);
            q.setLong("idCelula", idCelula.longValue());
            q.setShort("tipoFiltro", tipoFiltro.shortValue());
            q.setDate("dataInicial", dataInicial);
            q.setDate("dataFinal", dataFinal);
            q.setShort("ambos", (short)5);
            q.setShort("celula", (short)0);
            q.setLong("idPeriodoProd", periodoProducao.getIdentificador().longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List found = q.list();
            double totalHorasApontadas = 0.0;
            for (Object ob : found) {
                HashMap ha = (HashMap)ob;
                Integer tpFixo = (Integer)ha.get("TIPO_FIXO");
                Double aux = (Double)ha.get("TOTAL_HORAS");
                if (aux == null) {
                    aux = 0.0;
                }
                totalHorasApontadas += aux.doubleValue();
                if (tpFixo == 0) {
                    h.put("TOTAL_HORAS_OPERACIONAIS", aux);
                    continue;
                }
                if (tpFixo == 1) {
                    h.put("TOTAL_HORAS_PAR_FUNC", aux);
                    continue;
                }
                if (tpFixo == 2) {
                    h.put("TOTAL_HORAS_PREV_COR", aux);
                    continue;
                }
                h.put("TOTAL_HORAS_OUTROS", aux);
            }
            h.put("TOTAL_HORAS_APONTADAS", totalHorasApontadas);
        }
    }

    private void putCapacidade(List ocupacoes, PeriodoProducao periodoProducao, Short tipoFiltro, Date dataInicial, Date dataFinal) {
        for (Object o : ocupacoes) {
            HashMap h = (HashMap)o;
            if (tipoFiltro == 0) {
                h.put("CAPACIDADE", DateUtil.calcularDifHoras(periodoProducao.getDataInicial(), periodoProducao.getDataFinal()));
                continue;
            }
            h.put("CAPACIDADE", DateUtil.calcularDifHoras(dataInicial, dataFinal));
        }
    }
}

