/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.centrocusto;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilGerarListagemCentroCusto {
    JasperPrint gerarListagemCentroCusto(Integer grauCentro, Integer ordem, String centroInicial, String centroFinal, String fecho, HashMap params, Nodo nodo) throws ExceptionService {
        params.put("FECHO", fecho);
        List centros = this.getPlanoContasParaListagem(grauCentro, ordem, centroInicial, centroFinal);
        CoreRequestContext relatorio = new CoreRequestContext();
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", params).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        relatorio.setAttribute("path", this.getPath());
        relatorio.setAttribute("parametros", params);
        relatorio.setAttribute("dados", centros);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private List getPlanoContasParaListagem(Integer grauCentro, Integer ordem, String centroInicial, String centroFinal) {
        String orderBy = " c.codigo";
        Object defaultQuery = "select c.identificador    AS IDENTIFICADOR,                   c.codigo           AS CODIGO,                   c.nome             AS NOME,                   c.marca            AS MARCA FROM CentroCusto c WHERE";
        switch (grauCentro) {
            case 1: {
                defaultQuery = (String)defaultQuery + " substring(c.codigo , 4 , 9)  like '000000' AND ";
                break;
            }
            case 2: {
                defaultQuery = (String)defaultQuery + " substring(c.codigo , 7 , 9)  like '000' AND ";
                break;
            }
            case 3: {
                orderBy = ordem == 1 ? " c.nome, c.marca " : " c.codigo ";
            }
        }
        defaultQuery = (String)defaultQuery + " c.codigo BETWEEN :centroCustoInicial AND :centroCustoFinal  order by " + orderBy;
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery((String)defaultQuery);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setString("centroCustoInicial", centroInicial);
        q.setString("centroCustoFinal", centroFinal);
        return q.list();
    }

    private String getPath() {
        return CoreUtilityFactory.getUtilityJasperReports().getPathReports() + "list" + File.separator + "LISTAGEM_CENTRO_CUSTO.jasper";
    }
}

