/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.checklist;

import com.touchcomp.basementor.model.vo.CheckList;
import com.touchcomp.basementor.model.vo.CheckListItem;
import com.touchcomp.basementor.model.vo.EmailEnviadoRelPessoa;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaItem;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorbinary.model.ArqFotosItemCheckList;
import com.touchcomp.basementorbinary.service.impl.arqfotositemchecklist.ServiceBinaryArqFotosItemCheckListImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;

class AuxSalvarProcessarCheckList {
    CheckList doIt(CheckList ch, HashMap imagens) throws ExceptionService {
        try {
            ch = this.salvarCheckImages(ch, imagens);
            List rel = ch.getRelacionamentosGerados();
            for (CheckListItem item : ch.getItensCheckList()) {
                if (item.getModeloCheckListItOpcao().getOpcaoCheckList().getGerarCRM() != 1) continue;
                this.gerarCrm(item, rel, ch);
            }
            return ch;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionService(ex);
        }
    }

    private void gerarCrm(CheckListItem item, List<RelacionamentoPessoa> saved, CheckList check) {
        Usuario user = item.getModeloCheckListItOpcao().getOpcaoCheckList().getUsuario();
        SetorUsuario set = item.getModeloCheckListItOpcao().getOpcaoCheckList().getSetorUsuario();
        RelacionamentoPessoa found = null;
        if (user == null) {
            user = check.getUsuario();
        }
        if (user != null && set != null) {
            for (RelacionamentoPessoa s : saved) {
                if (!user.equals((Object)s.getUsuario()) || !set.equals((Object)s.getSetor())) continue;
                found = s;
                break;
            }
        }
        if (found != null) {
            for (RelacionamentoPessoa s : saved) {
                if (!s.getUsuario().equals((Object)user) || !s.getSetor().equals((Object)set)) continue;
                found = s;
                break;
            }
        }
        if (found == null) {
            Pessoa pes = null;
            if (check.getOrigemCheckList().getContratoLocacao() != null) {
                if (check.getOrigemCheckList().getContratoLocacao().getCliente() != null) {
                    pes = check.getOrigemCheckList().getContratoLocacao().getCliente().getPessoa();
                } else if (check.getOrigemCheckList().getContratoLocacao().getTomador() != null) {
                    pes = check.getOrigemCheckList().getContratoLocacao().getTomador().getPessoa();
                }
            } else {
                pes = check.getOrigemCheckList().getPessoa();
            }
            found = new RelacionamentoPessoa();
            found.setAgendamento(Short.valueOf((short)0));
            found.setCheckList(item.getCheckList());
            found.setClassificacaoMarketing(item.getModeloCheckListItOpcao().getOpcaoCheckList().getClassificacaoMarketing());
            found.setDataCadastro(new Date());
            found.setDataRelacionamento(check.getDataHoraCheckList());
            if (pes != null) {
                found.setEmailContato(this.getEmailPrincipal(pes));
                found.setEmailsEnviados(this.getEmailsParaEnvio(pes, found));
            }
            found.setEmpresa(item.getCheckList().getEmpresa());
            found.setPessoa(pes);
            found.setPrioridadeMarketing(item.getModeloCheckListItOpcao().getOpcaoCheckList().getPrioridadeMarketing());
            found.setProcedenciaSolicitacao(item.getModeloCheckListItOpcao().getOpcaoCheckList().getProcedenciaSolicitacao());
            found.setSetor(set);
            found.setUsuario(user);
            found.setUsuarioAgendamento(user);
            saved.add(found);
        }
        this.updateItensRel(found, item);
        found.setAssunto(this.buildAssunto(found));
    }

    private EmailPessoa getEmailPrincipal(Pessoa pes) {
        String email = pes.getComplemento().getEmailPrincipal();
        EmailPessoa first = null;
        EmailPessoa found = null;
        for (EmailPessoa e : pes.getComplemento().getEmails()) {
            if (first == null && e.getAtivo() != null && e.getAtivo() == 1 && e.getEnviarDadosRelacionamento() != null && e.getEnviarDadosRelacionamento() == 1) {
                first = e;
            }
            if (e.getEmail() == null || !e.getEmail().equalsIgnoreCase(email)) continue;
            found = e;
            break;
        }
        return found != null ? found : first;
    }

    private List<EmailEnviadoRelPessoa> getEmailsParaEnvio(Pessoa pes, RelacionamentoPessoa rel) {
        ArrayList<EmailEnviadoRelPessoa> aux = new ArrayList<EmailEnviadoRelPessoa>();
        for (EmailPessoa e : pes.getComplemento().getEmails()) {
            if (e.getAtivo() == null || e.getAtivo() != 1 || e.getEnviarDadosRelacionamento() == null || e.getEnviarDadosRelacionamento() != 1) continue;
            EmailEnviadoRelPessoa el = new EmailEnviadoRelPessoa();
            el.setEmail(e.getEmail());
            el.setRelacionamentoPessoa(rel);
            aux.add(el);
        }
        return aux;
    }

    private String buildAssunto(RelacionamentoPessoa found) {
        StringBuilder sb = new StringBuilder();
        found.getItensTarefasRel().stream().forEach(item -> sb.append(item.getTarefa()).append("\n"));
        return sb.toString();
    }

    private void updateItensRel(RelacionamentoPessoa found, CheckListItem item) {
        RelacionamentoPessoaItem itFound = null;
        for (RelacionamentoPessoaItem it : found.getItensTarefasRel()) {
            if (!it.getCheckListItem().equals((Object)item)) continue;
            itFound = it;
            break;
        }
        if (itFound == null) {
            itFound = new RelacionamentoPessoaItem();
            itFound.setCheckListItem(item);
            itFound.setObservacao(item.getObservacao());
            itFound.setRelacionamentoPessoa(found);
            itFound.setTarefa(item.getModeloCheckListItem().getDescricao());
            found.setSolucionado(Short.valueOf((short)0));
            found.getItensTarefasRel().add(itFound);
        }
    }

    private CheckList salvarCheckImages(CheckList ch, HashMap imagens) throws ExceptionDatabase {
        if (imagens == null) {
            imagens = new HashMap();
        }
        ServiceBinaryArqFotosItemCheckListImpl service = (ServiceBinaryArqFotosItemCheckListImpl)ConfApplicationContext.getBean(ServiceBinaryArqFotosItemCheckListImpl.class);
        LinkedList<CheckListItem> aux = new LinkedList<CheckListItem>();
        for (CheckListItem it : ch.getItensCheckList()) {
            List data = (List)imagens.get(it);
            data = data == null ? new ArrayList() : data;
            it.setCheckList(null);
            it = (CheckListItem)CoreDAOFactory.getInstance().getDAOCheckList().saveOrUpdate(it);
            for (ArqFotosItemCheckList d : data) {
                d.setIdItemCheckList(it.getIdentificador());
                service.saveOrUpdate((Object)d);
            }
            aux.add(it);
        }
        for (CheckListItem a : aux) {
            a.setCheckList(ch);
        }
        ch.setItensCheckList(aux);
        return (CheckList)CoreDAOFactory.getInstance().getDAOCheckList().saveOrUpdate(ch);
    }
}

