/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.chequeterceiros;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;

public class ServiceChequeTerceiros
extends CoreService {
    public static final String VERIFICAR_DADOS_CHEQUE = "verificarDadosCheque";
    public static final String VERIFICA_BORDERO = "verificaBordero";
    public static final String VERIFICAR_CHEQUE_TERCEIROS = "verificarChequeTerceiros";
    public static final String BUSCAR_SALDO_CHEQUES_NAO_COMPENSADOS_ID_PESSOA = "buscarSaldoChequesNaoCompensados";
    public static final String BUSCAR_SALDO_CHEQUES_DEVOLVIDOS_ID_GRUPO_PESSOA = "buscarSaldoChequesDevolvidosGrupoPessoas";
    public static final String BUSCAR_SALDO_CHEQUES_NAO_COMPENSADOS_ID_GRUPO_PESSOA = "buscarSaldoChequesNaoCompensadosGrupoPessoas";
    public static final String FIND_CHEQUE_TERCEIROS = "findChequeTerceiros";
    public static final String BUSCAR_SALDO_CHEQUES_DEVOLVIDOS_ID_PESSOA = "buscarSaldoChequesDevolvidos";

    public List verificarDadosCheque(CoreRequestContext request) {
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().verificarDadosCheque(request);
    }

    public List verificaBordero(CoreRequestContext request) {
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().verificaBordero(request);
    }

    public List verificarChequeTerceiros(CoreRequestContext request) {
        Pessoa pessoa = (Pessoa)request.getAttribute("pessoa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short pedidosGrupoPessoa = (Short)request.getAttribute("pedidosGrupoPessoa");
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().verificarChequeTerceiros(pessoa, dataInicial, dataFinal, empresa, pedidosGrupoPessoa);
    }

    public Double buscarSaldoChequesNaoCompensados(CoreRequestContext r) throws ExceptionService {
        Long idPessoa = (Long)r.getAttribute("idPessoa");
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().saldoChequesNaoCompensados(idPessoa);
    }

    public Double buscarSaldoChequesDevolvidosGrupoPessoas(CoreRequestContext r) throws ExceptionService {
        Long idGrupoPessoa = (Long)r.getAttribute("idGrupoPessoa");
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().saldoChequesDevolvidosGrupoPessoas(idGrupoPessoa);
    }

    public Double buscarSaldoChequesNaoCompensadosGrupoPessoas(CoreRequestContext r) throws ExceptionService {
        Long idGrupoPessoa = (Long)r.getAttribute("idGrupoPessoa");
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().saldoChequesNaoCompensadosGrupoPessoa(idGrupoPessoa);
    }

    public List findChequeTerceiros(CoreRequestContext request) {
        Long idChequeTerceiros = (Long)request.getAttribute("idChequeTerceiros");
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().findChequeTerceiros(idChequeTerceiros);
    }

    public Double buscarSaldoChequesDevolvidos(CoreRequestContext r) throws ExceptionService {
        Long idPessoa = (Long)r.getAttribute("idPessoa");
        return CoreDAOFactory.getInstance().getDAOChequeTerceiros().saldoChequesDevolvidos(idPessoa);
    }
}

