/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cliente;

import com.touchcomp.basementor.model.impl.EstatisticasGrupoPessoas;
import com.touchcomp.basementor.model.impl.EstatisticasPessoa;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.TransportadorRedespacho;
import com.touchcomp.basementorservice.service.impl.estatisticasfinanccomercpessoa.ServiceEstatisticasFinancGrupoPessoasImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.cliente.UtilEstatisticasCliente;

public class ServiceCliente
extends CoreService {
    public static final String FIND_ESTATISTICAS_CLIENTE = "findEstatisticasCliente";
    public static final String FIND_ESTATISTICAS_GRUPO_PESSOAS_CLIENTE = "findEstatisticasGrupoPessoasCliente";
    public static final String SINC_REG_TAB_PR_CLIENTE_GR_CIDADES = "sincRegTabPRClienteGrCidades";
    public static final String FIND_PRODUTOS_SEM_GIRO_CLIENTE = "findProdutosSemGiroCliente";
    public static final String FIND_PRODUTOS_NUNCA_COMPRADOS_CLIENTE = "findProdutosNuncaCompradosCliente";
    public static String FIND_CLIENTE_FATURAMENTO = "findClienteFaturamento";
    public static final String ATUALIZAR_TRANSPORTADOR_REDESPACHO_REPRESENTANTE_CLIENTE = "atualizarTransportadorRedespachoRepresentanteCliente";

    public EstatisticasPessoa findEstatisticasCliente(CoreRequestContext cq) throws ExceptionService, ExceptionDatabase {
        Pessoa pessoa = (Pessoa)cq.getAttribute("pessoa");
        Short incluirCheques = (Short)cq.getAttribute("incluirChequesAnalise");
        Short desconsiderarTitulosDevolucao = (Short)cq.getAttribute("desconsiderarTitlosDeDevolucao");
        return new UtilEstatisticasCliente().getValoresAbaEstatistica(pessoa, incluirCheques, desconsiderarTitulosDevolucao);
    }

    public EstatisticasGrupoPessoas findEstatisticasGrupoPessoasCliente(CoreRequestContext cq) throws ExceptionService, ExceptionDatabase {
        GrupoPessoas grupoPessoa = (GrupoPessoas)cq.getAttribute("grupoPessoa");
        Short incluirCheques = (Short)cq.getAttribute("incluirChequesAnalise");
        ServiceEstatisticasFinancGrupoPessoasImpl service = (ServiceEstatisticasFinancGrupoPessoasImpl)Context.get(ServiceEstatisticasFinancGrupoPessoasImpl.class);
        return service.findEstatisticasGrupoPessoas(grupoPessoa, Boolean.valueOf(ToolMethods.isAffirmative((Number)incluirCheques)));
    }

    public String sincRegTabPRClienteGrCidades(CoreRequestContext cq) throws ExceptionService, ExceptionDatabase {
        return CoreDAOFactory.getInstance().getDAOCliente().sincRegTabPRClienteGrCidadesO();
    }

    public List<HashMap> findProdutosSemGiroCliente(CoreRequestContext cq) throws ExceptionService, ExceptionDatabase {
        Long idCliente = (Long)cq.getAttribute("idCliente");
        Long idEmpresa = (Long)cq.getAttribute("idEmpresa");
        Long idEspecie = (Long)cq.getAttribute("idEspecie");
        Long idSubespecie = (Long)cq.getAttribute("idSubespecie");
        Integer numeroDias = (Integer)cq.getAttribute("numeroDias");
        Integer nrMaxRegistros = (Integer)cq.getAttribute("nrMaxRegistros");
        return CoreDAOFactory.getInstance().getDAOCliente().findProdutosSemGiroCliente(idCliente, numeroDias, idEmpresa, nrMaxRegistros, idEspecie, idSubespecie);
    }

    public List<HashMap> findProdutosNuncaCompradosCliente(CoreRequestContext cq) throws ExceptionService, ExceptionDatabase {
        Long idCliente = (Long)cq.getAttribute("idCliente");
        Long idEmpresa = (Long)cq.getAttribute("idEmpresa");
        Long idEspecie = (Long)cq.getAttribute("idEspecie");
        Long idSubespecie = (Long)cq.getAttribute("idSubespecie");
        Integer nrMaxRegistros = (Integer)cq.getAttribute("nrMaxRegistros");
        return CoreDAOFactory.getInstance().getDAOCliente().findProdutosNuncaCompradosCliente(idCliente, idEmpresa, nrMaxRegistros, idEspecie, idSubespecie);
    }

    public Object findClienteFaturamento(CoreRequestContext request) throws ExceptionDatabase {
        Long pessoa = (Long)request.getAttribute("pessoa");
        return CoreDAOFactory.getInstance().getDAOCliente().findClienteFaturamento(pessoa);
    }

    public void atualizarTransportadorRedespachoRepresentanteCliente(CoreRequestContext request) {
        Integer tipo = (Integer)request.getAttribute("TIPO");
        Transportador transportadorAtual = (Transportador)request.getAttribute("TRANSPORTADOR_ATUAL");
        Transportador transportadorNova = (Transportador)request.getAttribute("TRANSPORTADOR_NOVA");
        TransportadorRedespacho redespachoAtual = (TransportadorRedespacho)request.getAttribute("REDESPACHO_ATUAL");
        TransportadorRedespacho redespachoNova = (TransportadorRedespacho)request.getAttribute("REDESPACHO_NOVA");
        Representante representanteAtual = (Representante)request.getAttribute("REPRESENTANTE_ATUAL");
        Representante representanteNova = (Representante)request.getAttribute("REPRESENTANTE_NOVA");
        List listaUf = (List)request.getAttribute("LISTA_UF");
        TabelaCalculoFrete tabelaFrete = (TabelaCalculoFrete)request.getAttribute("TABELA_FRETE");
        CoreDAOFactory.getInstance().getDAOCliente().atualizarTransportadorRedespachoRepresentanteCliente(tipo, transportadorAtual, transportadorNova, redespachoAtual, redespachoNova, representanteAtual, representanteNova, listaUf, tabelaFrete);
    }
}

