/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cliente;

import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.model.impl.DadosEstatisticosFaturamento;
import com.touchcomp.basementor.model.impl.EstatisticasGrupoPessoas;
import com.touchcomp.basementor.model.impl.EstatisticasPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRps;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.titulo.ServiceTitulo;
import mentorcore.tools.DateUtil;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilEstatisticasCliente {
    UtilEstatisticasCliente() {
    }

    private void setOnMapCliente(EstatisticasPessoa e) {
        e.setDataLiberacao(e.getCliente().getFinanceiro().getDataLiberacaoCredito());
        e.setDiasVigorLimite(e.getCliente().getFinanceiro().getDiasVigorLimiteCred());
        e.setValorLimiteCredito(e.getCliente().getFinanceiro().getLimiteCredito());
        e.setValorLimiteCreditoFinanceiro(e.getCliente().getFinanceiro().getLimiteCreditoFinanceiro());
        if (e.getDataLiberacao() != null && e.getDiasVigorLimite() != null) {
            e.setDataValidadeLimite(DateUtil.nextDays(e.getDataLiberacao(), e.getDiasVigorLimite()));
        }
        this.setValoresUltimaFatura(e);
        this.setValoresMaiorFatura(e);
        this.setValoresMedioPedido(e);
        this.setValorPedidosAbertos(e);
        this.setPrimeiraCompraCliente(e);
        Double limiteDisponiveL = e.getValorLimiteCredito() - e.getValorPedidosAbertos() - e.getValorChequesNaoCompensados() - e.getSaldoDevedor() - e.getValorChequesDevolvidos();
        e.setValorLimiteDisponivel(limiteDisponiveL);
        Double limiteDisponivelFinanceiro = e.getValorLimiteCreditoFinanceiro() - (e.getSaldoTitulosVencidosAbertos() + e.getSaldoTitulosAVencer());
        e.setValorLimiteDisponivelFinanceiro(limiteDisponivelFinanceiro);
    }

    private void setOnMapTomador(EstatisticasPessoa e) {
        this.setValoresUltimaFaturaTomador(e);
        this.setValoresMaiorFaturaTomador(e);
    }

    public EstatisticasPessoa getValoresAbaEstatistica(Pessoa pessoa, Short incluirCheques, Short desconsiderarTitulosDevolucao) throws ExceptionService, ExceptionDatabase {
        TomadorPrestadorRps tomador;
        Long idPessoa = pessoa.getIdentificador();
        EstatisticasPessoa e = new EstatisticasPessoa(pessoa);
        e.setSaldoTitulosVencidosAbertos(this.findSaldoTitulosVencidosEmAberto(idPessoa));
        e.setSaldoTitulosAVencer(this.findSaldoTitulosAVencer(idPessoa));
        e.setMediaDiasAtraso(this.findAVGDiasAtrazoEmAberto(idPessoa, desconsiderarTitulosDevolucao));
        e.setSaldoTitulosAbertos(this.findSaldoTitulosAbertos(idPessoa));
        e.setSaldoAntecipadoPagar(this.findSaldoTitulosAntecipadoPagar(idPessoa));
        e.setSaldoAntecipadoReceber(this.findSaldoTitulosAntecipadoReceber(idPessoa));
        e.setValorTotalTitulos(this.findValorTotalTitulos(idPessoa));
        e.setNumTitulosProtestados(this.findNumTitulosProtestados(idPessoa));
        e.setNumTitulosCartorio(this.findNumTitulosCartorio(idPessoa));
        e.setMaiorAtraso(this.findMaiorAtrasoTitulo(idPessoa, desconsiderarTitulosDevolucao));
        e.setAtrasoMedio(this.findAtrasoMedioTitulos(idPessoa, desconsiderarTitulosDevolucao));
        e.setPorcentagem(this.findPercentualAtrasoTitulos(idPessoa));
        e.setSaldoDevedor(this.getSaldoDevedor(idPessoa, incluirCheques));
        e.setValorChequesNaoCompensados(this.getSaldoDevedorChequesNaoCompCliente(idPessoa));
        e.setValorChequesDevolvidos(this.getSaldoDevedorChequesDevolvidosCliente(idPessoa));
        e.setValorTotalTitulosAntecPag(this.findValorTotalTitulosAntecipadosPago(idPessoa));
        e.setValorTotalTitulosAntecRec(this.findValorTotalTitulosAntecipadosRecebido(idPessoa));
        Cliente cliente = this.getDadosCliente(e);
        if (cliente != null) {
            e.setCliente(cliente);
            this.setOnMapCliente(e);
        }
        if ((tomador = this.getDadosTomadorPrestadorRps(idPessoa)) != null) {
            e.setTomadorPrestadorRPS(tomador);
            this.setOnMapTomador(e);
        }
        return e;
    }

    private Double findSaldoTitulosVencidosEmAberto(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select coalesce(sum(t.valor),0)  from Titulo t  where t.pessoa.identificador = :idPessoa  and (t.dataVencimento)< :dataCorrente and t.pagRec = :rec  and t.provisao = :realizado ";
        Query q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setDate("dataCorrente", new Date());
        q.setShort("rec", (short)1);
        q.setShort("realizado", (short)1);
        Double valorTitulos = (Double)q.uniqueResult();
        hql = "select coalesce(sum(b.valor),0) from BaixaTitulo b where b.titulo.pessoa.identificador =:idPessoa  and (b.titulo.dataVencimento ) < :dataCorrente and b.titulo.pagRec=:rec  and b.titulo.provisao=:realizado ";
        q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setDate("dataCorrente", new Date());
        q.setShort("rec", (short)1);
        q.setShort("realizado", (short)1);
        Double valorBaixas = (Double)q.uniqueResult();
        return valorTitulos - valorBaixas;
    }

    private Double findAVGDiasAtrazoEmAberto(Long idPessoa, Short desconsiderarTitulosDevolucao) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select \navg(current_date() - t.dataVencimento)\nfrom Titulo t\n     inner join t.pessoa p\n     left join BaixaTitulo b on (b.titulo = t)\n         inner join b.grupoDeBaixaFormas g\nwhere t.dataVencimento < current_date()\nand t.valorSaldo > 0\nand p.identificador = :idPessoa\nand t.pagRec = :recebimento\nand t.provisao = :realizado\nand (:desconsiderarTitulosDevolucao <> 1 or g.formaPagamento <> :formaDePagamentoDevolucao)\n";
        Query q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("recebimento", (short)1);
        q.setShort("realizado", (short)1);
        q.setShort("desconsiderarTitulosDevolucao", desconsiderarTitulosDevolucao.shortValue());
        q.setShort("formaDePagamentoDevolucao", (short)2);
        Double diasAtraso = (Double)q.uniqueResult();
        if (ToolMethods.isEquals((Object)diasAtraso, null)) {
            return 0.0;
        }
        return diasAtraso;
    }

    private Double findSaldoTitulosAbertos(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select coalesce(sum(t.valor),0)  from Titulo t  where t.pessoa.identificador = :idPessoa  and t.pagRec = :rec  and t.provisao = :provisao ";
        Query q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        Double valorTitulos = (Double)q.uniqueResult();
        hql = "select coalesce(sum(b.valor),0) from BaixaTitulo b where b.titulo.pessoa.identificador =:idPessoa  and b.titulo.pagRec=:rec  and b.titulo.provisao=:provisao ";
        q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        Double valorBaixas = (Double)q.uniqueResult();
        return valorTitulos - valorBaixas;
    }

    private Double findSaldoTitulosAVencer(Long idPessoa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(t.valor),0)  from Titulo t where t.pessoa.identificador =:idPessoa  and t.pagRec=:rec  and t.provisao=:provisao and t.dataVencimento >= :dataAtual");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setDate("dataAtual", new Date());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        Double valorTot = (Double)q.uniqueResult();
        q = s.createQuery("select coalesce(sum(b.valor),0)  from BaixaTitulo b where b.titulo.pessoa.identificador =:idPessoa  and b.titulo.pagRec=:rec  and b.titulo.provisao=:provisao and b.titulo.dataVencimento >= :dataAtual");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setDate("dataAtual", new Date());
        q.setShort("rec", (short)1);
        q.setShort("provisao", (short)1);
        Double valorBaixa = (Double)q.uniqueResult();
        return valorTot - valorBaixa;
    }

    private Double findValorTotalTitulos(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  sum(t.valor) as valorTotalTitulos  from Titulo t  where  t.pessoa.identificador = :idPessoa  and t.provisao = :realizado  and t.pagRec = :rec");
        q.setShort("rec", (short)1);
        q.setShort("realizado", (short)1);
        q.setLong("idPessoa", idPessoa.longValue());
        return (Double)q.uniqueResult();
    }

    private Long findNumTitulosProtestados(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select count(*)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and sc.tipoCobranca = :protestada ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("protestada", EnumConstSituacaoCobranca.PROTESTADA.getEnumId().shortValue());
        Long numTitulosProtestados = (Long)q.uniqueResult();
        return numTitulosProtestados;
    }

    private Long findNumTitulosCartorio(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select count(*)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and sc.tipoCobranca = :cartorio ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("cartorio", EnumConstSituacaoCobranca.CARTORIO.getEnumId().shortValue());
        Long numTitulosProtestados = (Long)q.uniqueResult();
        return numTitulosProtestados;
    }

    private Double findMaiorAtrasoTitulo(Long idPessoa, Short desconsiderarTitulosDevolucao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select max(gb.dataLiquidacao - (bt.titulo.dataVencimento + bt.titulo.carteiraCobranca.diasToleranciaVencimento)) as maiorAtraso  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gbf  inner join gbf.baixaTitulo bt          inner join bt.grupoDeBaixaFormas g\n where bt.titulo.pessoa.identificador = :idPessoa  and bt.titulo.pagRec = :rec  and bt.titulo.provisao = :realizado and (:desconsiderarTitulosDevolucao <> 1 or g.formaPagamento <> :formaDePagamentoDevolucao)\n");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("realizado", (short)1);
        q.setShort("desconsiderarTitulosDevolucao", desconsiderarTitulosDevolucao.shortValue());
        q.setShort("formaDePagamentoDevolucao", (short)2);
        Double maiorAtraso = (Double)q.uniqueResult();
        return maiorAtraso;
    }

    private Double findAtrasoMedioTitulos(Long idPessoa, Short desconsiderarTitulosDevolucao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select avg((gb.dataLiquidacao - (bt.titulo.dataVencimento + bt.titulo.carteiraCobranca.diasToleranciaVencimento))*1.0) as maiorAtraso  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gbf  inner join gbf.baixaTitulo bt          inner join bt.grupoDeBaixaFormas g\n where bt.titulo.pessoa.identificador = :idPessoa  and bt.titulo.pagRec = :recebimento  and bt.titulo.provisao = :realizado and (:desconsiderarTitulosDevolucao <> 1 or g.formaPagamento <> :formaDePagamentoDevolucao)\n");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("recebimento", (short)1);
        q.setShort("realizado", (short)1);
        q.setShort("desconsiderarTitulosDevolucao", desconsiderarTitulosDevolucao.shortValue());
        q.setShort("formaDePagamentoDevolucao", (short)2);
        Double atrasoMedio = (Double)q.uniqueResult();
        return atrasoMedio;
    }

    private Double findPercentualAtrasoTitulos(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  count(bt.titulo.identificador) as quantidadeTituloAtrasados  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gbf  inner join gbf.baixaTitulo bt  where bt.titulo.pessoa.identificador = :idPessoa  and bt.titulo.pagRec = :rec  and bt.titulo.provisao = :realizado  and gb.dataLiquidacao > (bt.titulo.dataVencimento + bt.titulo.carteiraCobranca.diasToleranciaVencimento)");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("rec", (short)1);
        q.setShort("realizado", (short)1);
        Long quantidadeTituloAtrasados = (Long)q.uniqueResult();
        Query q2 = s.createQuery(" select  count(bt.titulo.identificador) as quantidadeTituloTotal  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gbf  inner join gbf.baixaTitulo bt  where bt.titulo.pessoa.identificador = :idPessoa  and bt.titulo.pagRec = :rec and bt.titulo.provisao = :realizado ");
        q2.setLong("idPessoa", idPessoa.longValue());
        q2.setShort("rec", (short)1);
        q2.setShort("realizado", (short)1);
        Long quantidadeTituloTotal = (Long)q2.uniqueResult();
        Double porcentagem = 0.0;
        if (quantidadeTituloTotal != null && quantidadeTituloTotal > 0L) {
            porcentagem = (double)quantidadeTituloAtrasados.longValue() * 100.0 / (double)quantidadeTituloTotal.longValue();
        }
        return porcentagem;
    }

    private void setPrimeiraCompraCliente(EstatisticasPessoa est) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  nfp.dataEmissaoNota as DATA_EMISSAO, nfp.valoresNfPropria.valorTotal as VALOR_TOTAL_ULTIMA_FATURA,  cast(nfp.numeroNota as long) as NUMERO_NOTA_ULTIMA_FATURA,  nfp.serie as SERIE_NOTA_ULTIMA_FATURA  from NotaFiscalPropria nfp  where  nfp.dataEmissaoNota = (  select min(nfp2.dataEmissaoNota)  from NotaFiscalPropria nfp2  where nfp2.unidadeFatCliente.cliente = :cliente)  and nfp.unidadeFatCliente.cliente = :cliente");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setEntity("cliente", (Object)est.getCliente());
        q.setMaxResults(1);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_EMISSAO"));
            e.setValor((Double)m.get("VALOR_TOTAL_ULTIMA_FATURA"));
            e.setSerie((String)m.get("SERIE_NOTA_ULTIMA_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_ULTIMA_FATURA")));
            est.setPrimeiraFatura(e);
        }
    }

    private void setValoresMaiorFatura(EstatisticasPessoa est) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  nfp.valoresNfPropria.valorTotal as VALOR_NOTA_MAIOR_FATURA,  cast(nfp.numeroNota as long) as NUMERO_NOTA_MAIOR_FATURA,  nfp.serie as SERIE_NOTA_MAIOR_FATURA,  nfp.dataEmissaoNota as DATA_NOTA_MAIOR_FATURA  from NotaFiscalPropria nfp  where  nfp.valoresNfPropria.valorTotal = (select max(nfp2.valoresNfPropria.valorTotal)  from NotaFiscalPropria nfp2  where  nfp2.unidadeFatCliente.cliente = :cliente ) and nfp.unidadeFatCliente.cliente = :cliente");
        q.setEntity("cliente", (Object)est.getCliente());
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_NOTA_MAIOR_FATURA"));
            e.setValor((Double)m.get("VALOR_NOTA_MAIOR_FATURA"));
            e.setSerie((String)m.get("SERIE_NOTA_MAIOR_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_MAIOR_FATURA")));
            est.setMaiorFatura(e);
        }
    }

    private void setValoresMedioPedido(EstatisticasPessoa e) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  avg(p.valorTotal) as VALOR_MEDIO_PEDIDO from Pedido p  inner join p.unidadeFatCliente u inner join u.cliente c inner join p.situacaoPedido s where c.identificador =:cliente and s.cancelarTitulos<>:sim");
        q.setEntity("cliente", (Object)e.getCliente());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        e.setValorMedioPedido((Double)q.uniqueResult());
    }

    private void setValoresUltimaFatura(EstatisticasPessoa est) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  nfp.dataEmissaoNota as DATA_EMISSAO, nfp.valoresNfPropria.valorTotal as VALOR_TOTAL_ULTIMA_FATURA,  cast(nfp.numeroNota as long) as NUMERO_NOTA_ULTIMA_FATURA,  nfp.serie as SERIE_NOTA_ULTIMA_FATURA  from NotaFiscalPropria nfp  where  nfp.dataEmissaoNota = (  select max(nfp2.dataEmissaoNota)  from NotaFiscalPropria nfp2  where nfp2.unidadeFatCliente.cliente = :cliente)  and nfp.unidadeFatCliente.cliente = :cliente");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setEntity("cliente", (Object)est.getCliente());
        q.setMaxResults(1);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_EMISSAO"));
            e.setValor((Double)m.get("VALOR_TOTAL_ULTIMA_FATURA"));
            e.setSerie((String)m.get("SERIE_NOTA_ULTIMA_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_ULTIMA_FATURA")));
            est.setUltimaFatura(e);
        }
    }

    private Cliente getDadosCliente(EstatisticasPessoa p) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getDAOCliente().getVOClass());
        c.add((Criterion)Restrictions.eq((String)"pessoa", (Object)p.getPessoa()));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.setMaxResults(1);
        Cliente cliente = (Cliente)c.uniqueResult();
        if (cliente != null) {
            return cliente;
        }
        s = CoreBdUtil.getInstance().getSession();
        c = s.createCriteria(CoreDAOFactory.getInstance().getDAOCliente().getVOClass());
        c.add((Criterion)Restrictions.eq((String)"pessoa", (Object)p.getPessoa()));
        c.setMaxResults(1);
        return (Cliente)c.uniqueResult();
    }

    private Double getSaldoDevedorTitulosCliente(Long idPessoa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idPessoa", idPessoa);
        Double valor = (Double)CoreServiceFactory.getServiceTitulo().execute(request, ServiceTitulo.FIND_SALDO_TITULOS_ABERTOS_ID_PESSOA);
        if (valor == null) {
            valor = 0.0;
        }
        return valor;
    }

    private Double getSaldoDevedorChequesAbertoCliente(Long idPessoa) throws ExceptionService {
        Double valorChequesAberto = this.getSaldoDevedorChequesDevolvidosCliente(idPessoa);
        valorChequesAberto = valorChequesAberto + this.getSaldoDevedorChequesNaoCompCliente(idPessoa);
        return valorChequesAberto;
    }

    private Double getSaldoDevedorChequesDevolvidosCliente(Long idPessoa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idPessoa", idPessoa);
        Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesDevolvidos");
        valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
        return valorChequesAberto;
    }

    private Double getSaldoDevedorChequesNaoCompCliente(Long idPessoa) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idPessoa", idPessoa);
        Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesNaoCompensados");
        valorChequesAberto = valorChequesAberto == null ? 0.0 : valorChequesAberto;
        return valorChequesAberto;
    }

    private Double getSaldoDevedor(Long idPessoa, Short incluirCheques) throws ExceptionService {
        Double valor = this.getSaldoDevedorTitulosCliente(idPessoa);
        if (valor == null) {
            valor = 0.0;
        }
        if (incluirCheques != null && incluirCheques == 1) {
            valor = valor + this.getSaldoDevedorChequesAbertoCliente(idPessoa);
        }
        return valor;
    }

    private TomadorPrestadorRps getDadosTomadorPrestadorRps(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select cc from TomadorPrestadorRps cc  inner join cc.pessoa p where  p.identificador = :idPessoa ");
        q.setLong("idPessoa", idPessoa.longValue());
        return (TomadorPrestadorRps)q.uniqueResult();
    }

    private void setValoresMaiorFaturaTomador(EstatisticasPessoa est) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  r.valorLiquidoNfse as VALOR_NOTA_MAIOR_FATURA,  r.numeroNFse as NUMERO_NOTA_MAIOR_FATURA,  r.serie as SERIE_NOTA_MAIOR_FATURA,  r.dataEmissao as DATA_NOTA_MAIOR_FATURA  from Rps r  where  r.valorLiquidoNfse = (select max(r2.valorLiquidoNfse)  from Rps r2  where  r2.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador ) and r.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador");
        q.setEntity("tomador", (Object)est.getTomadorPrestadorRPS());
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(1);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_NOTA_MAIOR_FATURA"));
            e.setValor((Double)m.get("VALOR_NOTA_MAIOR_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_MAIOR_FATURA")));
            e.setSerie((String)m.get("SERIE_NOTA_MAIOR_FATURA"));
            est.setMaiorFatura(e);
        }
    }

    private void setValoresUltimaFaturaTomador(EstatisticasPessoa est) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select  r.dataEmissao as DATA_EMISSAO_ULTIMA_NOTA, r.valorLiquidoNfse as VALOR_TOTAL_ULTIMA_FATURA,  r.numeroNFse as NUMERO_NOTA_ULTIMA_FATURA,  r.serie as SERIE_NOTA_ULTIMA_FATURA  from Rps r where  r.dataEmissao = (  select max(r2.dataEmissao)  from Rps r2  where r2.unidadeTomPrestRPS.tomadorPrestadorRPS = :tomador )");
        q.setEntity("tomador", (Object)est.getTomadorPrestadorRPS());
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_EMISSAO_ULTIMA_NOTA"));
            e.setValor((Double)m.get("VALOR_TOTAL_ULTIMA_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_ULTIMA_FATURA")));
            e.setSerie((String)m.get("SERIE_NOTA_ULTIMA_FATURA"));
            est.setUltimaFatura(e);
        }
    }

    EstatisticasGrupoPessoas getValoresAbaEstatistica(GrupoPessoas grupoPessoa, Short incluirCheques) throws ExceptionService {
        EstatisticasGrupoPessoas e = new EstatisticasGrupoPessoas(grupoPessoa);
        e.setLimiteCredito(grupoPessoa.getLimiteCredito());
        e.setLimiteCreditoFinanceiro(grupoPessoa.getLimiteCreditoFinanceiro());
        e.setDataLiberacao(grupoPessoa.getDataLiberacaoCredito());
        e.setDiasValidade(grupoPessoa.getDiasVigorLimiteCred());
        e.setSaldoAberto(this.getSaldoDevedorGrupoPessoas(grupoPessoa));
        e.setChequesDevolvidos(this.getSaldoChequesDevolvidosGrupoPessoas(grupoPessoa));
        e.setChequesNaoCompensados(this.getSaldoDevedorChequesNaoCompGrupoPessoas(grupoPessoa));
        e.setSaldoVencido(this.getSaldoTitulosVencidos(grupoPessoa));
        Double limiteDispGrPess = e.getLimiteCredito() - e.getSaldoAberto() - e.getChequesDevolvidos() - e.getChequesNaoCompensados();
        e.setLimiteDisponivel(limiteDispGrPess);
        Integer diasLimiteGr = e.getDiasValidade();
        if (e.getDataLiberacao() != null) {
            Date dataVal = DateUtil.nextDays(e.getDataLiberacao(), diasLimiteGr);
            e.setDataLimite(dataVal);
        }
        return e;
    }

    private Double getSaldoDevedorGrupoPessoas(GrupoPessoas g) throws ExceptionService {
        Double vlr = 0.0;
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("identificador", g.getIdentificador());
        vlr = (Double)CoreServiceFactory.getServiceSaldoTitulo().execute(cq, "getSaldoDevedorGrupoPessoa");
        return vlr;
    }

    private Double getSaldoChequesDevolvidosGrupoPessoas(GrupoPessoas gr) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idGrupoPessoa", gr.getIdentificador());
        Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesDevolvidosGrupoPessoas");
        return valorChequesAberto;
    }

    private Double getSaldoDevedorChequesNaoCompGrupoPessoas(GrupoPessoas gr) throws ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("idGrupoPessoa", gr.getIdentificador());
        Double valorChequesAberto = (Double)CoreServiceFactory.getServiceChequeTerceiros().execute(request, "buscarSaldoChequesNaoCompensadosGrupoPessoas");
        return valorChequesAberto;
    }

    private Double getSaldoTitulosVencidos(GrupoPessoas g) throws ExceptionService {
        Double vlr = 0.0;
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("identificador", g.getIdentificador());
        cq.setAttribute("diasTolerancia", 0);
        vlr = (Double)CoreServiceFactory.getServiceSaldoTitulo().execute(cq, "getSaldoVencidoGrupoPessoa");
        return vlr;
    }

    private Double findSaldoTitulosAntecipadoPagar(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct t.identificador as ID_TITULO, t.valor as VALOR from Titulo t inner join t.pessoa p where t.antecipado = 1 AND t.provisao = :provisao  AND t.pagRec = :pagRec AND p.identificador = :idPessoa AND t.valor > (select coalesce(sum(b.valor),0) from BaixaTituloAntecipado b where b.titulo = t)";
        Query q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("pagRec", (short)0);
        q.setShort("provisao", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List titulos = q.list();
        Double valorTitulos = 0.0;
        for (HashMap h : titulos) {
            Long idTitulo = (Long)h.get("ID_TITULO");
            Double valor = (Double)h.get("VALOR");
            hql = " select coalesce(sum(b.valor),0)  from BaixaTituloAntecipado b where b.titulo.identificador = :idTitulo";
            q = s.createQuery(hql);
            q.setLong("idTitulo", idTitulo.longValue());
            Double vrBaixa = (Double)q.uniqueResult();
            valorTitulos = valorTitulos + (valor - vrBaixa);
        }
        return valorTitulos;
    }

    private Double findSaldoTitulosAntecipadoReceber(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        String hql = "select distinct t.identificador as ID_TITULO, t.valor as VALOR from Titulo t inner join t.pessoa p where t.antecipado = 1 AND t.provisao = :provisao  AND t.pagRec = :pagRec AND p.identificador = :idPessoa AND t.valor > (select coalesce(sum(b.valor),0) from BaixaTituloAntecipado b where b.titulo = t)";
        Query q = s.createQuery(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("pagRec", (short)1);
        q.setShort("provisao", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List titulos = q.list();
        Double valorTitulos = 0.0;
        for (HashMap h : titulos) {
            Long idTitulo = (Long)h.get("ID_TITULO");
            Double valor = (Double)h.get("VALOR");
            hql = " select coalesce(sum(b.valor),0)  from BaixaTituloAntecipado b where b.titulo.identificador = :idTitulo";
            q = s.createQuery(hql);
            q.setLong("idTitulo", idTitulo.longValue());
            Double vrBaixa = (Double)q.uniqueResult();
            valorTitulos = valorTitulos + (valor - vrBaixa);
        }
        return valorTitulos;
    }

    private Double findValorTotalTitulosAntecipadosPago(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select coalesce(sum(t.valor),0)  from Titulo t  where t.pessoa.identificador = :idPessoa  and t.provisao = :realizado  and t.pagRec = :pag  and t.antecipado = :antecipado ");
        q.setShort("pag", (short)0);
        q.setShort("realizado", (short)1);
        q.setShort("antecipado", (short)1);
        q.setLong("idPessoa", idPessoa.longValue());
        return (Double)q.uniqueResult();
    }

    private Double findValorTotalTitulosAntecipadosRecebido(Long idPessoa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(" select coalesce(sum(t.valor),0)  from Titulo t  where t.pessoa.identificador = :idPessoa  and t.provisao = :realizado  and t.pagRec = :rec  and t.antecipado = :antecipado ");
        q.setShort("rec", (short)1);
        q.setShort("realizado", (short)1);
        q.setShort("antecipado", (short)1);
        q.setLong("idPessoa", idPessoa.longValue());
        return (Double)q.uniqueResult();
    }

    private void setValorPedidosAbertos(EstatisticasPessoa e) {
        ServicePedidoImpl service = (ServicePedidoImpl)Context.get(ServicePedidoImpl.class);
        e.setValorPedidosAbertos(Double.valueOf(service.getValorPedidosAberto(e.getPessoa())));
    }
}

