/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.clientetouch;

import com.touchcomp.basementor.model.vo.ClienteFinancContSistemas;
import com.touchcomp.basementor.model.vo.CustoMensal;
import com.touchcomp.basementor.model.vo.CustoMensalModulo;
import com.touchcomp.basementor.model.vo.CustoOutrosServicos;
import com.touchcomp.basementor.model.vo.CustoReembolso;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacaoContato;
import com.touchcomp.basementor.model.vo.TipoReembolsoContSistemas;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.ContatoFormatUtil;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

class UtilAtualizaClientesTouch {
    void atualizarValores(File fPlan, Integer nrColCnpj, Integer nrColPerc, Integer inicio, Date dataIn, Date dataFim) throws IOException, ExceptionService, ExceptionDatabase {
        Integer n = nrColCnpj;
        nrColCnpj = nrColCnpj - 1;
        n = nrColPerc;
        nrColPerc = nrColPerc - 1;
        n = inicio;
        inicio = inicio - 1;
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(fPlan));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        HSSFSheet sheet = myWorkBook.getSheetAt(0);
        for (Row row : sheet) {
            if (row.getRowNum() < inicio) continue;
            this.extractRowData(row, nrColCnpj, nrColPerc, dataIn, dataFim);
        }
    }

    private void extractRowData(Row row, Integer nrColCnpj, Integer nrColPerc, Date dataIn, Date dataFim) throws ExceptionService, ExceptionDatabase {
        if (row == null || row.getCell(nrColCnpj.intValue()) == null || row.getCell(nrColPerc.intValue()) == null) {
            return;
        }
        String cnpj = ClearUtil.refina(row.getCell(nrColCnpj.intValue()).getStringCellValue());
        Double percReaj = row.getCell(nrColPerc.intValue()).getNumericCellValue();
        if (cnpj == null || cnpj.trim().length() == 0) {
            throw new ExceptionService("Cnpj n\u00e3o informado na linha " + row.getRowNum());
        }
        if (percReaj == null) {
            throw new ExceptionService("Percentual de reajuste n\u00e3o informado na linha " + row.getRowNum());
        }
        ClienteFinancContSistemas cliente = this.getCliente(cnpj);
        this.atualizarMensalidade(cliente, percReaj, dataIn, dataFim);
        this.atualizarReembolso(cliente, percReaj, dataIn, dataFim);
        this.atualizarServicos(cliente, percReaj, dataIn, dataFim);
        CoreDAOFactory.getInstance().getDAOClienteFinancContSistemas().saveOrUpdate(cliente);
    }

    private ClienteFinancContSistemas getCliente(String cnpj) throws ExceptionService {
        Criteria c = CoreBdUtil.getInstance().getSession().createCriteria(ClienteFinancContSistemas.class);
        c.createAlias("clienteContSistemas", "cli");
        c.createAlias("cli.tomadorPrestadorRps", "t");
        c.createAlias("t.pessoa", "p");
        c.createAlias("p.complemento", "comp");
        c.add((Criterion)Restrictions.eq((String)"comp.cnpj", (Object)cnpj));
        c.add((Criterion)Restrictions.eq((String)"p.ativo", (Object)1));
        List l = c.list();
        if (l.size() > 1) {
            throw new ExceptionService("Cliente com o CNPJ " + cnpj + " cadastrado mais de uma vez em duplicidade.");
        }
        if (l.isEmpty()) {
            throw new ExceptionService("Cliente com o CNPJ " + cnpj + " n\u00e3o encontrado.");
        }
        return (ClienteFinancContSistemas)l.get(0);
    }

    private void atualizarMensalidade(ClienteFinancContSistemas cliente, Double percReaj, Date dataIn, Date dataFim) throws ExceptionService {
        if (percReaj <= 0.0) {
            return;
        }
        CustoMensal found = null;
        for (CustoMensal cc : cliente.getCustoMensal()) {
            if (found == null || found.getDataFinal().before(cc.getDataFinal()) && found.getDataFinal().before(dataIn)) {
                found = cc;
            }
            if (!cc.getDataFinal().after(dataIn)) continue;
            throw new ExceptionService("O cliente possui valores de mensalidade para a data citada. Tire da planilha ou edite o cliente. " + cliente.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
        }
        if (found == null) {
            throw new ExceptionService("N\u00e3o foi encontrado custo mensal base para calculo do reajuste para o cliente " + cliente.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
        }
        CustoMensal novo = new CustoMensal();
        novo.setDataInicial(dataIn);
        novo.setDataFinal(dataFim);
        novo.setValor(ContatoFormatUtil.arrredondarNumero(percReaj / 100.0 * found.getValor() + found.getValor(), 2));
        novo.setClienteFinancContSistemas(cliente);
        double vrTotAcu = 0.0;
        LinkedList<CustoMensalModulo> toAdd = new LinkedList<CustoMensalModulo>();
        for (CustoMensalModulo ccm : found.getCustoMensalModulo()) {
            CustoMensalModulo ccmNovo = new CustoMensalModulo();
            ccmNovo.setModuloSistema(ccm.getModuloSistema());
            ccmNovo.setCustoMensal(novo);
            ccmNovo.setValor(ContatoFormatUtil.arrredondarNumero(percReaj / 100.0 * ccm.getValor() + ccm.getValor(), 1));
            vrTotAcu += ccmNovo.getValor().doubleValue();
            toAdd.add(ccmNovo);
        }
        novo.setCustoMensalModulo(toAdd);
        if (novo.getCustoMensalModulo().size() > 0) {
            CustoMensalModulo ccm = (CustoMensalModulo)novo.getCustoMensalModulo().get(0);
            ccm.setValor(Double.valueOf(ccm.getValor() + (novo.getValor() - vrTotAcu)));
        }
        cliente.getCustoMensal().add(novo);
    }

    private void atualizarReembolso(ClienteFinancContSistemas cliente, Double percReaj, Date dataIn, Date dataFim) throws ExceptionService {
        if (percReaj <= 0.0) {
            return;
        }
        HashSet<TipoReembolsoContSistemas> tiposReembolsos = new HashSet<TipoReembolsoContSistemas>();
        for (CustoReembolso cc : cliente.getCustoReembolso()) {
            tiposReembolsos.add(cc.getTipoReembolso());
        }
        for (TipoReembolsoContSistemas tt : tiposReembolsos) {
            CustoReembolso found = null;
            for (CustoReembolso cc : cliente.getCustoReembolso()) {
                if (found == null && cc.getTipoReembolso().equals((Object)tt) || found != null && found.getDataFinal().before(cc.getDataFinal()) && found.getDataFinal().before(dataIn) && cc.getTipoReembolso().equals((Object)tt)) {
                    found = cc;
                }
                if (!cc.getDataFinal().after(dataIn)) continue;
                throw new ExceptionService("O cliente possui valores de reembolsos para a data citada. Tire da planilha ou edite o cliente. " + cliente.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
            }
            if (found == null) {
                throw new ExceptionService("N\u00e3o foi encontrado custo reembolso base para calculo do reajuste para o cliente " + cliente.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
            }
            CustoReembolso novo = new CustoReembolso();
            novo.setDataInicial(dataIn);
            novo.setDataFinal(dataFim);
            novo.setQuantidadeSugerida(found.getQuantidadeSugerida());
            novo.setTipoReembolso(found.getTipoReembolso());
            novo.setValor(ContatoFormatUtil.arrredondarNumero(percReaj / 100.0 * found.getValor() + found.getValor(), 2));
            novo.setClienteFinancContSistemas(cliente);
            cliente.getCustoReembolso().add(novo);
        }
    }

    private void atualizarServicos(ClienteFinancContSistemas cliente, Double percReaj, Date dataIn, Date dataFim) throws ExceptionService {
        if (percReaj <= 0.0) {
            return;
        }
        HashSet<ProcedenciaSolicitacaoContato> procedencias = new HashSet<ProcedenciaSolicitacaoContato>();
        for (CustoOutrosServicos cc : cliente.getCustoOutrosServicos()) {
            procedencias.add(cc.getProcedenciaSolicitacao());
        }
        ArrayList<CustoOutrosServicos> toAdd = new ArrayList<CustoOutrosServicos>();
        for (ProcedenciaSolicitacaoContato tt : procedencias) {
            CustoOutrosServicos found = null;
            for (CustoOutrosServicos cc : cliente.getCustoOutrosServicos()) {
                if (found == null && cc.getProcedenciaSolicitacao().equals((Object)tt) || found != null && found.getDataFinal().before(cc.getDataFinal()) && found.getDataFinal().before(dataIn) && cc.getProcedenciaSolicitacao().equals((Object)tt)) {
                    found = cc;
                }
                if (!cc.getDataFinal().after(dataIn)) continue;
                throw new ExceptionService("O cliente possui valores de servicos para a data citada. Tire da planilha ou edite o cliente. " + cliente.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
            }
            if (found == null) {
                throw new ExceptionService("N\u00e3o foi encontrado custo reembolso base para calculo do reajuste para o cliente " + cliente.getClienteContSistemas().getTomadorPrestadorRps().getPessoa().getNome());
            }
            CustoOutrosServicos novo = new CustoOutrosServicos();
            novo.setDataInicial(dataIn);
            novo.setDataFinal(dataFim);
            novo.setProcedenciaSolicitacao(found.getProcedenciaSolicitacao());
            novo.setValor(ContatoFormatUtil.arrredondarNumero(percReaj / 100.0 * found.getValor() + found.getValor(), 1));
            novo.setClienteFinancContSistemas(cliente);
            toAdd.add(novo);
        }
        cliente.getCustoOutrosServicos().addAll(toAdd);
    }
}

