/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.colaborador.colaborador;

import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDadosFerias;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.HistoricoLotacaoTributaria;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.rh.calculofolha.UtilCalculoFolhaPagamento;

public class ServiceColaborador
extends CoreService {
    public static final String FIND_ULTIMO_REGISTRO_COLABORADOR = "findUltimoRegistroColaborador";
    public static final String FIND_ULTIMO_REGISTRO_COLABORADOR_AUTONOMO = "findUltimoRegistroColaboradorAutonomo";
    public static final String FIND_COLABORADOR_EMPRESA_IDENTIFICADOR = "findColaboradorEmpresaIdentificador";
    public static final String FIND_QUANTIDADE_MOV_FOLHA_SINDICAL = "findQuantidadeMovFolhaSindical";
    public static final String FIND_EVENTOS_RECISAO_COMPLEMENTAR = "findEventosRecisaoComplementar";
    public static final String FIND_ULTIMO_COLABORADOR_SALARIO = "findUltimoColaboradorSalario";
    public static final String FIND_COLABORADOR_POR_EMPRESA = "findColaboradorPorEmpresa";
    public static final String FIND_SALARIO_POR_COLABORADOR = "findSalarioPorColaborador";
    public static final String FIND_SALARIO_POR_FUNCAO_HORAS_MES = "findSalarioPorFuncaoHorasMes";
    public static final String SALVAR_LISTA_COLABORADORES = "salvarListaColaborador";
    public static final String ATUALIZAR_STATUS_COLABORADOR = "atualizarStatusColaborador";
    public static final String FIND_COLABORADORES_POR_TIPO_COLABORADOR = "findColaboradorPorTipoColaborador";
    public static final String REVALIDAR_COLABORADORES_POR_TIPO_COLABORADOR = "revalidarColaboradorPorTipoColaborador";
    public static final String VALIDAR_CONTRATO_VERDE_AMARELO = "validarDadosContratoVerdeAmarelo";
    public static final String EXCLUSAO_COLABORADOR = "exclusaoColaborador";
    public static final String UPDATE_COLABORADOR = "updateColaborador";
    public static final String DELETE_HISTORICO_LOTACAO_TRIBUTARIA = "deleteHistoricoLotacaoTributaria";
    public static final String BUSCAR_ULTIMO_AUTONOMO = "buscarUltimoAutonomo";

    public String findUltimoRegistroColaborador(CoreRequestContext request) {
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Long tipo = (Long)request.getAttribute("tipo");
        Integer nrRegistro = CoreDAOFactory.getInstance().getDAOColaborador().buscarProximoNumeroRegistro(idEmpresa, tipo);
        if (nrRegistro != null) {
            return nrRegistro.toString();
        }
        return "1";
    }

    public String findUltimoRegistroColaboradorAutonomo(CoreRequestContext request) {
        Long idEmpresa = (Long)request.getAttribute("idEmpresa");
        Long tipo = (Long)request.getAttribute("tipo");
        Integer nrRegistro = CoreDAOFactory.getInstance().getDAOColaborador().buscarProximoNumeroRegistroSemVinculo(idEmpresa, tipo);
        if (nrRegistro != null) {
            return nrRegistro.toString();
        }
        return "1";
    }

    public Colaborador findColaboradorEmpresaIdentificador(CoreRequestContext request) {
        Long identificador = (Long)request.getAttribute("identificador");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOColaborador().findColaboradorEmpresaIdentificador(identificador, empresa);
    }

    public Long findQuantidadeMovFolhaSindical(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataFolha = (Date)request.getAttribute("dataFolha");
        return new UtilCalculoFolhaPagamento().findDescontoContribuicaoSindical(colaborador, dataFolha);
    }

    public List findEventosRecisaoComplementar(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataInicio = (Date)request.getAttribute("dataInicio");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return new UtilCalculoFolhaPagamento().findEventosRecisaoComplementar(colaborador, dataInicio, dataFinal);
    }

    public ColaboradorSalario findUltimoColaboradorSalario(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataPagamento = (Date)request.getAttribute("dataPagamento");
        return CoreDAOFactory.getInstance().getDAOColaborador().findColaboradorSalario(colaborador, dataPagamento);
    }

    public List findColaboradorPorEmpresa(CoreRequestContext request) {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return CoreDAOFactory.getInstance().getDAOColaborador().buscarColaboradoresEmpresa(empresa);
    }

    public List findSalarioPorColaborador(CoreRequestContext r) {
        Funcao funcao = (Funcao)r.getAttribute("funcao");
        Date periodo = (Date)r.getAttribute("periodo");
        return CoreDAOFactory.getInstance().getDAOColaborador().findSalarioPorFuncao(funcao, periodo);
    }

    public List findSalarioPorFuncaoHorasMes(CoreRequestContext request) {
        Sindicato sindicato = (Sindicato)request.getAttribute("sindicato");
        Double horasMes = (Double)request.getAttribute("horasMes");
        return CoreDAOFactory.getInstance().getDAOColaborador().findSalarioPorSindicatoHorasMes(sindicato, horasMes);
    }

    public void salvarListaColaborador(CoreRequestContext request) throws ExceptionDatabase {
        List hashs = (List)request.getAttribute("colaboradores");
        for (HashMap hash : hashs) {
            Colaborador c = (Colaborador)hash.get("colaborador");
            c = (Colaborador)CoreDAOFactory.getInstance().getDAOColaborador().saveOrUpdate(c);
            ColaboradorDadosFerias ferias = (ColaboradorDadosFerias)hash.get("ferias");
            if (ferias != null) {
                ferias.setColaborador(c);
                CoreDAOFactory.getInstance().getDAOColaboradorDadosFerias().saveOrUpdate(ferias);
            }
            ColaboradorSalario cs = (ColaboradorSalario)hash.get("colaboradorSalario");
            cs.setColaborador(c);
            CoreDAOFactory.getInstance().getDAOColaboradorSalario().saveOrUpdate(cs);
        }
    }

    public String atualizarStatusColaborador(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        if (colaborador != null && colaborador.getIdentificador() != null) {
            return CoreDAOFactory.getInstance().getDAOColaborador().verificarSituacaoColaborador(colaborador);
        }
        return " ";
    }

    public List<Colaborador> findColaboradorPorTipoColaborador(CoreRequestContext request) {
        TipoEventoEsocial tipoEvento = (TipoEventoEsocial)request.getAttribute("tipoEvento");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return CoreDAOFactory.getInstance().getDAOColaborador().findColaboradoresByTipoColaboradorEsoc(tipoEvento, empresa, dataInicial, dataFinal);
    }

    public List<Colaborador> revalidarColaboradorPorTipoColaborador(CoreRequestContext request) {
        TipoColaborador tipoColaborador = (TipoColaborador)request.getAttribute("tipoColaborador");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Date dataInicial = (Date)request.getAttribute("dataInicial");
        Date dataFinal = (Date)request.getAttribute("dataFinal");
        return CoreDAOFactory.getInstance().getDAOColaborador().revalidarColaboradoresByTipoColaboradorS2200Esoc(tipoColaborador, empresa, dataInicial, dataFinal);
    }

    public void validarDadosContratoVerdeAmarelo(CoreRequestContext r) throws ExceptionService {
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        Double valorSalario = (Double)r.getAttribute("valorSalario");
        Double salarioMinimo = (Double)r.getAttribute("salarioMinimo");
        this.validarSalarioVerdeAmarelo(valorSalario, salarioMinimo);
        this.calcularIdade(colaborador);
        this.validarContratacaoJaExistente(colaborador);
        this.validarDatasContrato(colaborador);
    }

    private void validarSalarioVerdeAmarelo(Double valorSalario, Double salarioMinimo) throws ExceptionService {
        Double salarioPermitido = ContatoFormatUtil.arrredondarNumero((Double)(salarioMinimo * 1.5), (int)2);
        if (valorSalario > salarioPermitido) {
            throw new ExceptionService("Para o tipo de contrato Verde e Amarelo n\u00ef\u00bf\u00bdo \u00ef\u00bf\u00bd Permitido superior a: " + salarioPermitido);
        }
    }

    private void calcularIdade(Colaborador c) throws ExceptionService {
        Long dias;
        Date dataAdmissao = c.getDataAdmissao();
        Date dataNascimento = c.getPessoa().getComplemento().getDataNascimento();
        Long idade = 0L;
        if (dataNascimento != null) {
            if (!dataAdmissao.after(dataNascimento)) {
                throw new ExceptionService("Data de Nascimento superior a data de Admiss\u00ef\u00bf\u00bdo");
            }
        } else {
            throw new ExceptionService("Informe a Data de Nascimento");
        }
        Long dataAtual1 = dataAdmissao.getTime() / 1000L;
        Long dataNiver = dataNascimento.getTime() / 1000L;
        Long total = dataAtual1 - dataNiver;
        idade = dias = Long.valueOf(total / 365L / 24L / 60L / 60L);
        if (idade >= 18L && idade <= 29L) {
            return;
        }
        throw new ExceptionService("Para o tipo de Contrato Verde e Amarelo \u00ef\u00bf\u00bd permitido a idade apenas entre 18 e 29 anos");
    }

    private void validarContratacaoJaExistente(Colaborador colaborador) throws ExceptionService {
        String hql = " select max(col.dataDemissao)  from Colaborador col  where  col.pessoa.identificador = :idPessoa  and  col.dataDemissao is not null  and  col.empresa.identificador = :empresa ";
        Date dataUltimaDemissao = (Date)CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idPessoa", colaborador.getPessoa().getIdentificador().longValue()).setLong("empresa", colaborador.getEmpresa().getIdentificador().longValue()).uniqueResult();
        if (dataUltimaDemissao == null) {
            return;
        }
        Integer difDias = ToolDate.diferenceDayBetweenDatesExclusive((Date)dataUltimaDemissao, (Date)colaborador.getDataAdmissao()) + 1;
        if (difDias < 180) {
            throw new ExceptionService("Colaborador foi Desligado com data Inferior a 180 dias.");
        }
    }

    private void validarDatasContrato(Colaborador colaborador) throws ExceptionService {
        if (colaborador.getPrimeiraDataExperiencia() == null && colaborador.getSegundaDataExperiencia() == null) {
            throw new ExceptionService("Contrato no formato Verde e Amarelo deve por prazo determinado.");
        }
    }

    public void exclusaoColaborador(CoreRequestContext r) throws ExceptionDatabase {
        Colaborador colaborador = (Colaborador)r.getAttribute("vo");
        this.desvincularSaneamento(colaborador);
        this.deleteColaboradorSalario(colaborador);
        CoreDAOFactory.getInstance().getDAOColaborador().delete(colaborador);
    }

    private void desvincularSaneamento(Colaborador colaborador) {
        String hql = " delete from ItemSaneamentoDadosColaborador i where i.colaborador = :colaborador ";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).executeUpdate();
        hql = " update exclusao_eventos_esocial e set e.id_colaborador = null where e.id_colaborador = :colaborador";
        CoreBdUtil.getInstance().getSession().createSQLQuery(hql).setParameter("colaborador", (Object)colaborador.getIdentificador()).executeUpdate();
    }

    private void deleteColaboradorSalario(Colaborador colaborador) {
        String hql = " delete from ColaboradorSalario c where c.colaborador = :colaborador ";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).executeUpdate();
    }

    public Colaborador updateColaborador(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        return (Colaborador)CoreDAOFactory.getInstance().getDAOColaborador().saveOrUpdate(colaborador);
    }

    public Colaborador deleteHistoricoLotacaoTributaria(CoreRequestContext request) throws ExceptionDatabase, ExceptionService {
        Colaborador colaborador;
        HistoricoLotacaoTributaria historico = (HistoricoLotacaoTributaria)request.getAttribute("lotacao");
        if (!ToolMethods.isEquals((Object)historico, (Object)this.getHistoricoLotacaoAtual(colaborador = historico.getColaborador()))) {
            throw new ExceptionService("Existem historicos posteriores ao que esta tentando excluir!");
        }
        colaborador.setLotacaoTributaria(historico.getLotacaoAnterior());
        colaborador.getHistoricoLotacaoTributaria().remove(historico);
        CoreDAOFactory.getInstance().getDAOHistoricoLotacaoTributaria().delete(historico);
        return (Colaborador)CoreDAOFactory.getInstance().getDAOColaborador().saveOrUpdate(colaborador);
    }

    public HistoricoLotacaoTributaria getHistoricoLotacaoAtual(Colaborador colaborador) {
        HistoricoLotacaoTributaria historicoAtual = null;
        Boolean buscarAtual = true;
        for (HistoricoLotacaoTributaria h : colaborador.getHistoricoLotacaoTributaria()) {
            if (buscarAtual.booleanValue()) {
                buscarAtual = false;
                historicoAtual = h;
            }
            if (!historicoAtual.getDataAlteracao().before(h.getDataAlteracao())) continue;
            historicoAtual = h;
        }
        return historicoAtual;
    }

    public Colaborador buscarUltimoAutonomo(CoreRequestContext r) {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        return this.getUltimoAutonomo(empresa);
    }

    private Colaborador getUltimoAutonomo(Empresa empresa) {
        String hql = " from Colaborador c  where  c.empresa = :empresa  and  c.ativo = 1  and  ((c.tipoColaborador.identificador = :autonomo ))   order by c.identificador DESC ";
        return (Colaborador)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("empresa", (Object)empresa).setParameter("autonomo", (Object)EnumConstTipoColaborador.AUTONOMO.getValue()).setMaxResults(1).uniqueResult();
    }
}

