/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.colaborador.migracao;

import com.touchcomp.basementor.constants.enums.cnab.pagamento.EnumConstCnabPagamento;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoAdiantamento;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.impl.ImplLogradouro;
import com.touchcomp.basementor.model.vo.CategoriaSefip;
import com.touchcomp.basementor.model.vo.CategoriaTrabalhador;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorDadosFerias;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.EsocIndicativoAdmissao;
import com.touchcomp.basementor.model.vo.EsocRegimeJornadaTrab;
import com.touchcomp.basementor.model.vo.EsocTipoAdmissao;
import com.touchcomp.basementor.model.vo.EstadoCivil;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GrauInstrucao;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.IndicadorVinculoTrabalhador;
import com.touchcomp.basementor.model.vo.Nacionalidade;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.RacaCor;
import com.touchcomp.basementor.model.vo.Sindicato;
import com.touchcomp.basementor.model.vo.TipoAdmissaoCaged;
import com.touchcomp.basementor.model.vo.TipoAdmissaoRais;
import com.touchcomp.basementor.model.vo.TipoAlteracaoSalarial;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementor.model.vo.TipoLogradouroEndereco;
import com.touchcomp.basementor.model.vo.TipoRegimePrevidenciario;
import com.touchcomp.basementor.model.vo.TipoRegimeTrabalhista;
import com.touchcomp.basementor.model.vo.TipoSalario;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.VinculoEmpregaticio;
import com.touchcomp.basementorservice.service.impl.endereco.ServiceEnderecoImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.ContatoFormatUtil;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionImportacaoBI;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.tools.ClearUtil;
import mentorcore.tools.DateUtil;

public class UtilityMigracaoColaborador {
    public List<HashMap> createColaboradorMigrados(List objects, EmpresaRh empresa) throws ExceptionImportacaoBI, ExceptionService, ParseException {
        ArrayList<HashMap> dadosImportados = new ArrayList<HashMap>();
        for (Object obj : objects) {
            TreeMap dados = (TreeMap)obj;
            Pessoa p = this.verificarCadastroPessoa(dados, empresa.getEmpresa());
            Colaborador c = this.createColaborador(p, dados, empresa);
            System.out.println(c.getPessoa().getNome());
            ColaboradorDadosFerias ferias = this.createDadosFerias(dados);
            ColaboradorSalario cs = this.createColaboradorSalario(c, dados);
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("colaborador", c);
            hash.put("ferias", ferias);
            hash.put("colaboradorSalario", cs);
            dadosImportados.add(hash);
        }
        return dadosImportados;
    }

    private Pessoa verificarCadastroPessoa(TreeMap dados, Empresa empresa) throws ExceptionImportacaoBI, ExceptionService {
        Endereco e;
        Complemento c;
        Pessoa p;
        String cpf = (String)dados.get("CPF");
        if (cpf == null) {
            throw new ExceptionImportacaoBI("Existe dados de Colaboradores sem CPF");
        }
        if ((cpf = ToolString.refina((String)cpf)).length() < 11) {
            cpf = ToolString.completaZeros((String)cpf, (int)11, (boolean)true);
        }
        if ((p = this.findPessoaPorCnpj(cpf)) == null) {
            p = new Pessoa();
            c = new Complemento();
            e = new Endereco();
            p.setDataCadastro(new Date());
            Object obj = this.findEndereco(dados, empresa);
            if (obj instanceof Endereco) {
                e = (Endereco)obj;
                p.setEndereco(e);
            }
        } else {
            c = p.getComplemento();
            e = p.getEndereco();
            e.setNumero((String)dados.get("NUMERO"));
        }
        p.setAtivo(Short.valueOf((short)1));
        p.setDataInicioRelacionamento(p.getDataCadastro());
        p.setNome((String)dados.get("NOME"));
        p.setNomeFantasia((String)dados.get("NOME"));
        c.setAtivo(Short.valueOf((short)1));
        c.setCel1(ToolString.refina((String)((String)dados.get("CELULAR"))));
        c.setCnpj(cpf);
        c.setTipoPessoa(this.getPessoaFisicaJuridica(cpf));
        if (dados.get("DATA_NASCIMENTO") instanceof Date) {
            c.setDataNascimento((Date)dados.get("DATA_NASCIMENTO"));
        } else {
            c.setDataNascimento(DateUtil.strToDate((String)dados.get("DATA_NASCIMENTO")));
        }
        c.setFone1(ToolString.refina((String)((String)dados.get("TELEFONE"))));
        c.setEmailPrincipal(ToolString.refina((String)((String)dados.get("EMAIL"))));
        c.setPessoa(p);
        c.setRg(ToolString.refina((String)((String)dados.get("IDENTIDADE"))));
        c.setOrgaoEmissor((String)dados.get("ORGAO_EXPED_RG"));
        c.setUfEmissaoRG(this.getUfSigla((String)dados.get("UF_RG")));
        if (dados.get("EMISSAO_RG") instanceof Date) {
            c.setDataEmissaoRG((Date)dados.get("EMISSAO_RG"));
        } else {
            c.setDataEmissaoRG(new Date());
        }
        p.setComplemento(c);
        p.setEndereco(e);
        return p;
    }

    private Object findEndereco(TreeMap dados, Empresa empresa) throws ExceptionService {
        Endereco e = new Endereco();
        String cep = (String)dados.get("CEP");
        String bairro = (String)dados.get("BAIRRO");
        String numero = (String)dados.get("NUMERO");
        String complemento = (String)dados.get("COMPLEMENTO");
        String logradouro = (String)dados.get("LOGRADOURO");
        cep = ClearUtil.refina(cep);
        cep = ToolString.completaZeros((String)cep, (int)8, (boolean)false);
        ImplLogradouro l = ((ServiceEnderecoImpl)Context.get(ServiceEnderecoImpl.class)).getLogroudroByCepBDEnderecos(ToolString.refina((String)cep));
        if (l == null) {
            return "Endereco n\u00e3o encontrado para o cep: " + cep + ";";
        }
        e.setCep(l.getCep().trim());
        e.setBairro(bairro.trim());
        e.setLogradouro(logradouro.trim());
        e.setComplemento(complemento);
        e.setCidade(l.getCidade());
        e.setNumero(numero);
        return e;
    }

    private Cidade getCidade(String codIBGE) throws ExceptionService {
        Cidade cidade = (Cidade)CoreDAOFactory.getInstance().getDAOCidade().findCidadePorCodigoIBGE(codIBGE, null);
        if (cidade == null) {
            throw new ExceptionService("Cidade n\u00e3o encontrada com o codigo: " + codIBGE);
        }
        return cidade;
    }

    private Pessoa findPessoaPorCnpj(String cpf) throws ExceptionImportacaoBI {
        String hql = " select distinct(p)  from Pessoa p  where  p.ativo = :sim  and  p.complemento.cnpj = :cpf ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setText("cpf", cpf).list();
        if (ret != null && ret.size() > 1) {
            throw new ExceptionImportacaoBI("Existem mais de uma Pessoa ativa com o CPF: " + cpf);
        }
        if (ret != null && ret.size() == 1) {
            return (Pessoa)ret.get(0);
        }
        return null;
    }

    private Colaborador createColaborador(Pessoa p, TreeMap dados, EmpresaRh empresaRh) throws ExceptionService, ParseException {
        Colaborador vo = new Colaborador();
        vo.setDataCadastro(new Date());
        vo.setEmpresa(empresaRh.getEmpresa());
        vo.setPessoa(p);
        vo.setNumeroRegistro((String)dados.get("NR_REGISTRO"));
        vo.setCentroCusto(this.getCentroCusto((String)dados.get("ID_CENTRO_CUSTO")));
        vo.setTipoColaborador(this.getTipoColaborador((String)dados.get("TIPO_COLABORADOR")));
        vo.setSenhaAcessoColab("0");
        vo.setValorTributosPorHora(Double.valueOf(0.0));
        vo.setDataAtualizacao(null);
        vo.setCarteiraReservista((String)dados.get("CARTEIRA_RESERVISTA"));
        vo.setCarteiraHabilitacao((String)dados.get("CNH"));
        vo.setTituloEleitor((String)dados.get("TITULO_ELEITOR"));
        vo.setRacaCor(this.getRacaCor((String)dados.get("RACA_COR")));
        vo.setAlvaraJudicial(Short.valueOf((short)0));
        Short sexo = new Short((String)dados.get("SEXO"));
        if (sexo == 2) {
            vo.setSexo(Short.valueOf((short)1));
        } else {
            vo.setSexo(Short.valueOf((short)0));
        }
        vo.setRecebimentoSeguroDesemprego(Short.valueOf((short)0));
        vo.setNacionalidade(this.getNacionalidade((String)dados.get("NACIONALIDADE")));
        vo.setGrauInstrucao(this.getGrauInstrucao((String)dados.get("GRAU_INSTRUCAO")));
        vo.setEstadoCivil(this.getEstadoCivil((String)dados.get("COD_ESTADO_CIVIL")));
        vo.setNumeroPis((String)dados.get("NUMERO_PIS"));
        vo.setCarteiraProfissional((String)dados.get("CARTEIRA_PROFISSIONAL"));
        vo.setSerieCarteiraProfissional((String)dados.get("SERIE_CARTEIRA"));
        if (dados.get("DATA_EMISSAO_CTPS") instanceof Date) {
            vo.setDataEmissaoCTPS((Date)dados.get("DATA_EMISSAO_CTPS"));
        } else {
            vo.setDataEmissaoCTPS(DateUtil.strToDate((String)dados.get("DATA_EMISSAO_CTPS")));
        }
        vo.setNomeMae((String)dados.get("NOME_MAE"));
        vo.setNomePai((String)dados.get("NOME_PAI"));
        if (dados.get("DATA_ADMISSAO") instanceof Date) {
            vo.setDataAdmissao((Date)dados.get("DATA_ADMISSAO"));
        } else {
            vo.setDataAdmissao(DateUtil.strToDate((String)dados.get("DATA_ADMISSAO")));
        }
        vo.setTipoAdmissaoRais(this.getTipoAdmissaoRais());
        vo.setTipoAdmissaoCaged(this.getTipoAdmissaoCaged());
        vo.setTipoAdmissaoEsocial(this.getTipoAdmissaoEsocial());
        vo.setOptanteFgts(Short.valueOf((short)1));
        vo.setVinculoEmpregaticio(this.getVinculoEmpregaticio());
        vo.setFuncao(this.getFuncao((String)dados.get("CBO_FUNCAO")));
        vo.setHorarioTrabalho(this.getHorarioTrabalho((String)dados.get("ID_HORARIO_TRABALHO")));
        vo.setTipoSalario(this.getTipoSalario((String)dados.get("TIPO_SALARIO")));
        vo.setHorasTrabDia(Double.valueOf(7.3333));
        vo.setDiasJornada(Double.valueOf(30.0));
        vo.setJornadaSemanal(Integer.valueOf(44));
        vo.setHorasMesColaborador(Double.valueOf(220.0));
        vo.setTipoAdiantamento(EnumConstTipoAdiantamento.NAO_POSSUI_ADIANTAMENTO.getEnumId());
        vo.setPercValorAdiantamento(Double.valueOf(0.0));
        vo.setValorPorHora(Double.valueOf(0.0));
        vo.setAtivo(Short.valueOf((short)1));
        vo.setCategoriaSefip(this.getCategoriaSefip());
        vo.setCategoriaTrabalhador(this.getCategoriaTrabalhador());
        vo.setQtdadeValeTransportes(Double.valueOf(0.0));
        vo.setTipoPagamento(EnumConstCnabPagamento.PAGAMENTO_VIA_BANCO.getEnumId());
        vo.setGerarArredondamento(empresaRh.getGerarArredondamento());
        vo.setCompoePlanilhaExcel(Short.valueOf((short)1));
        vo.setZonaTituloEleitor((String)dados.get("ZONA_TITULO"));
        vo.setSecaoTituloEleitor((String)dados.get("SECAO_TITULO"));
        vo.setTipoEndereco(Short.valueOf((short)1));
        vo.setTipoLogradouroEndereco(this.getTipoLogradouro());
        vo.setRegistroNacionalEstrangeiros("");
        vo.setOrgaoEmissaoRNE("");
        vo.setNumeroOrgaoClasse("");
        vo.setOrgaoEmissorClasse("");
        vo.setColaboradorReabilitado(Short.valueOf((short)0));
        vo.setIndicativoAdmissao(this.getIndicativoAdmissao());
        vo.setRegimeJornadaTrabalho(this.getRegimeJornadaTrabalho());
        vo.setRecebeAposentadoria(Short.valueOf((short)0));
        vo.setValorTicket(Double.valueOf(0.0));
        vo.setAddNoturnoHabitual(Short.valueOf((short)0));
        vo.setHoraExtraHabitual(Short.valueOf((short)0));
        vo.setUtilizacaoEPI(Short.valueOf((short)0));
        vo.setJornadaSemanalTrabalho(Integer.valueOf(44));
        vo.setIndicadorVinculoTrabalhador(this.getIndicadorVinculoTrabalhador());
        vo.setRegimePrevidenciario(this.getTipoRegimePrevidenciario());
        vo.setRegimeTrabalhista(this.getTipoRegimeTrabalhista());
        vo.setGerarFinanceiro(Short.valueOf((short)1));
        vo.setCompoeIntegracaoPonto(Short.valueOf((short)0));
        if (vo.getNacionalidade().getIdentificador() == 1L) {
            vo.setCidadeNascimento(this.getCidade((String)dados.get("CODIGO_CIDADE_NASCIMENTO")));
            vo.setUfCarteiraProfissional(vo.getCidadeNascimento().getUf());
        }
        String cpnjSindicato = (String)dados.get("CNPJ_SINDICATO");
        vo.setSindicato(this.getSindicato(cpnjSindicato));
        if (dados.get("CARGA_HORARIA") instanceof String) {
            vo.setHorasMesColaborador(this.getNumeroFormatado((String)dados.get("CARGA_HORARIA")));
        } else {
            vo.setHorasMesColaborador((Double)dados.get("CARGA_HORARIA"));
        }
        vo.setClassificacaoColaborador(empresaRh.getClassificacaoColaborador());
        return vo;
    }

    private CentroCusto getCentroCusto(String string) throws ExceptionService {
        Long idCentroCusto = new Long(string);
        CentroCusto cc = (CentroCusto)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOCentroCusto(), "identificador", idCentroCusto, 0);
        if (cc == null) {
            throw new ExceptionService("Centro de Custo n\u00e3o encontrado com o identificador: " + string);
        }
        return cc;
    }

    private TipoColaborador getTipoColaborador(String string) throws ExceptionService {
        String aux = ToolString.refina((String)"0");
        Long id = new Long(aux);
        TipoColaborador tpColaborador = (TipoColaborador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoColaborador(), "identificador", id, 0);
        if (tpColaborador == null) {
            throw new ExceptionService("Tipo de Colaborador n\u00e3o encontrado com o codigo: " + id.toString());
        }
        return tpColaborador;
    }

    private RacaCor getRacaCor(String string) throws ExceptionService {
        string = ToolString.refina((String)string);
        Long id = new Long(string);
        RacaCor raca = (RacaCor)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAORacaCor(), "codigo", string, 0);
        if (raca == null) {
            throw new ExceptionService("Ra\u00e7a/Cor n\u00e3o encontrado para o identificador: " + id.toString());
        }
        return raca;
    }

    private Nacionalidade getNacionalidade(String string) throws ExceptionService {
        Long id = new Long(string);
        Nacionalidade nac = (Nacionalidade)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAONacionalidade(), "identificador", id, 0);
        if (nac == null) {
            throw new ExceptionService("Nacionalidade n\u00e3o encontrada com o identificador: " + id);
        }
        return nac;
    }

    private GrauInstrucao getGrauInstrucao(String string) throws ExceptionService {
        Long id = new Long(ToolString.refina((String)string));
        GrauInstrucao g = (GrauInstrucao)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOGrauInstrucao(), "identificador", id, 0);
        if (g == null) {
            throw new ExceptionService("Grau de Instru\u00e7\u00e3o n\u00e3o encontrado para o identificador: " + id);
        }
        return g;
    }

    private EstadoCivil getEstadoCivil(String string) throws ExceptionService {
        Long id = new Long(ToolString.refina((String)string));
        EstadoCivil estCivil = (EstadoCivil)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEstadoCivil(), "identificador", id, 0);
        if (estCivil == null) {
            throw new ExceptionService("Estado Civil n\u00e3o encontrado com o identificador: " + id);
        }
        return estCivil;
    }

    private TipoAdmissaoCaged getTipoAdmissaoCaged() throws ExceptionService {
        return (TipoAdmissaoCaged)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoAdmissaoCaged(), "identificador", 1L, 0);
    }

    private CategoriaSefip getCategoriaSefip() throws ExceptionService {
        return (CategoriaSefip)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOCategoriaSEFIP(), "identificador", 1L, 0);
    }

    private CategoriaTrabalhador getCategoriaTrabalhador() throws ExceptionService {
        return (CategoriaTrabalhador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOCategoriaEmpregado(), "identificador", 1L, 0);
    }

    private TipoAdmissaoRais getTipoAdmissaoRais() throws ExceptionService {
        return (TipoAdmissaoRais)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoAdmissaoRais(), "identificador", 2L, 0);
    }

    private EsocTipoAdmissao getTipoAdmissaoEsocial() throws ExceptionService {
        return (EsocTipoAdmissao)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEsocTipoAdmissao(), "identificador", 1L, 0);
    }

    private VinculoEmpregaticio getVinculoEmpregaticio() throws ExceptionService {
        return (VinculoEmpregaticio)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOVinculoEmpregaticio(), "identificador", 1L, 0);
    }

    private Funcao getFuncao(String cbo) throws ExceptionService {
        cbo = ((String)cbo).substring(0, 4) + "." + ((String)cbo).substring(4, 6);
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOFuncao().getVOClass());
        bc.and().equal("cbo.codigo", cbo);
        List list = CoreService.executeSearch(bc);
        if (list == null || list.isEmpty()) {
            throw new ExceptionService("Fun\u00e7\u00e3o n\u00e3o encontrada com o CBO: " + (String)cbo);
        }
        return (Funcao)list.get(0);
    }

    private HorarioTrabalho getHorarioTrabalho(String string) throws ExceptionService {
        Long id = new Long(string);
        HorarioTrabalho horario = (HorarioTrabalho)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOHorarioTrabalho(), "identificador", id, 0);
        if (horario == null) {
            throw new ExceptionService("Horario de Trabalho n\u00e3o encontrado para o id: " + id);
        }
        return horario;
    }

    private TipoSalario getTipoSalario(String string) throws ExceptionService {
        Long id = new Long(ToolString.refina((String)string));
        TipoSalario tp = (TipoSalario)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoSalario(), "identificador", id, 0);
        if (tp == null) {
            throw new ExceptionService("N\u00e3o foi encontrado Tipo de Colaborador para o identificador: " + id);
        }
        return tp;
    }

    private TipoLogradouroEndereco getTipoLogradouro() throws ExceptionService {
        return (TipoLogradouroEndereco)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoLogradouroEndereco(), "identificador", 2L, 0);
    }

    private EsocIndicativoAdmissao getIndicativoAdmissao() throws ExceptionService {
        return (EsocIndicativoAdmissao)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEsocIndicativoAdmissao(), "identificador", 1L, 0);
    }

    private EsocRegimeJornadaTrab getRegimeJornadaTrabalho() throws ExceptionService {
        return (EsocRegimeJornadaTrab)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEsocRegimeJornadaTrab(), "identificador", 1L, 0);
    }

    private IndicadorVinculoTrabalhador getIndicadorVinculoTrabalhador() throws ExceptionService {
        return (IndicadorVinculoTrabalhador)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOIndicadorVinculoTrabalhador(), "identificador", 1L, 0);
    }

    private TipoRegimePrevidenciario getTipoRegimePrevidenciario() throws ExceptionService {
        return (TipoRegimePrevidenciario)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoRegimePrevidenciario(), "identificador", 1L, 0);
    }

    private TipoRegimeTrabalhista getTipoRegimeTrabalhista() throws ExceptionService {
        return (TipoRegimeTrabalhista)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoRegimeTrabalhista(), "identificador", 1L, 0);
    }

    private Sindicato getSindicato(String cnpj) throws ExceptionService {
        cnpj = ToolString.refina((String)cnpj);
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOSindicato().getVOClass());
        bc.and().equal("pessoa.complemento.cnpj", cnpj);
        List list = CoreService.executeSearch(bc);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (Sindicato)list.get(0);
    }

    private Date getData(Double valor) {
        GregorianCalendar g = new GregorianCalendar();
        valor = ContatoFormatUtil.arrredondarNumero((Double)valor, (int)2);
        Integer inteira = valor.intValue();
        Integer decimal = (int)Math.round((valor - (double)valor.intValue()) * 100.0);
        g.set(11, inteira);
        g.set(12, decimal);
        return g.getTime();
    }

    private UnidadeFederativa getUfSigla(String string) throws ExceptionService {
        if (string == null) {
            string = "MG";
        }
        BaseCriteria bc = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOUnidadeFederativa().getVOClass());
        bc.and().equal("sigla", string.toUpperCase());
        UnidadeFederativa uf = (UnidadeFederativa)CoreService.executeSearchUniqueResult(bc);
        return uf;
    }

    private ColaboradorDadosFerias createDadosFerias(TreeMap dados) {
        String data;
        if (dados.get("DATA_SAIDA_FERIAS") == null) {
            return null;
        }
        if (dados.get("DATA_SAIDA_FERIAS") instanceof String && ((data = (String)dados.get("DATA_SAIDA_FERIAS")) == null || data.isEmpty())) {
            return null;
        }
        Date saidaFerias = DateUtil.strToDate((String)dados.get("DATA_SAIDA_FERIAS"));
        Date retornoFerias = DateUtil.strToDate((String)dados.get("DATA_RETORNO_FERIAS"));
        Date inicioPeriodoAq = DateUtil.strToDate((String)dados.get("DATA_INICIO_PERIODO_AQ"));
        Date finalPeriodoAq = DateUtil.strToDate((String)dados.get("DATA_FINAL_PERIODO_AQ"));
        ColaboradorDadosFerias d = new ColaboradorDadosFerias();
        d.setDataCadastro(new Date());
        d.setDataInicioPeriodo(inicioPeriodoAq);
        d.setDataFimPeriodo(finalPeriodoAq);
        d.setInicioGozoFerias(saidaFerias);
        d.setFimGozoFerias(retornoFerias);
        d.setDataPagamento(DateUtil.nextDays(saidaFerias, -2));
        d.setFechado(Short.valueOf((short)1));
        d.setNumeroFaltas(Double.valueOf(0.0));
        d.setRecidoFerias(Long.valueOf(0L));
        d.setValorFerias(Double.valueOf(0.0));
        return d;
    }

    private ColaboradorSalario createColaboradorSalario(Colaborador c, TreeMap dados) throws ExceptionService, ParseException {
        Double valorSalario = 0.0;
        if (dados.get("VALOR_SALARIO") instanceof String) {
            String salarioTexto = (String)dados.get("VALOR_SALARIO");
            valorSalario = this.getNumeroFormatado(salarioTexto);
        } else {
            valorSalario = (Double)dados.get("VALOR_SALARIO");
        }
        ColaboradorSalario colaboradorSalario = new ColaboradorSalario();
        colaboradorSalario.setColaborador(c);
        colaboradorSalario.setValorSalario(valorSalario);
        colaboradorSalario.setPeriodo(c.getDataAdmissao());
        colaboradorSalario.setDataCadastro(c.getDataCadastro());
        colaboradorSalario.setDataAtualizacao(c.getDataAtualizacao());
        colaboradorSalario.setFuncao(c.getFuncao());
        colaboradorSalario.setObservacao("Salario Admissional");
        colaboradorSalario.setPeriodoDataBase(c.getDataAdmissao());
        colaboradorSalario.setAlteracaoSalarial((TipoAlteracaoSalarial)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOTipoAlteracaoSalarial(), "identificador", 1L, 0));
        return colaboradorSalario;
    }

    private Double getNumeroFormatado(String salarioTexto) throws ParseException {
        DecimalFormat dff = (DecimalFormat)DecimalFormat.getInstance();
        Number numeroCerto = dff.parse(salarioTexto);
        return ContatoFormatUtil.arrredondarNumero((Double)numeroCerto.doubleValue(), (int)2);
    }

    private Short getPessoaFisicaJuridica(String cnpj) {
        if (cnpj != null && cnpj.trim().length() == 14) {
            return EnumConstTipoPessoaComplementar.JURIDICA.getEnumId();
        }
        return EnumConstTipoPessoaComplementar.FISICA.getEnumId();
    }
}

