/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.coleta;

import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.coleta.UtilColeta;
import net.sf.jasperreports.engine.JasperPrint;

public class ServiceColeta
extends CoreService {
    public static final String FIND_COLETAS_POR_EQUIPAMENTO = "findColetasPorEquipamento";
    public static final String FIND_COLETAS_POR_EQUIPAMENTO_TIPO_PONTO = "findColetasPorEquipamentoTipoPonto";
    public static final String GERAR_LISTAGEM_ROTA_COLETA = "gerarListagemRotaColeta";
    public static final String GET_COLETAS_ENTRE_DATAS = "getColetasEntreDatas";
    public static final String FIND_COLETA_POR_PLACA_POSTERIOR = "findColetaPorPlacaPosterior";

    public List<Coleta> findColetasPorEquipamento(CoreRequestContext request) throws ExceptionService {
        Equipamento equipamento = (Equipamento)request.getAttribute("equipamento");
        return CoreDAOFactory.getInstance().getDAOColeta().findColetasPorEquipamento(equipamento);
    }

    public List<Coleta> findColetasPorEquipamentoTipoPonto(CoreRequestContext request) throws ExceptionService {
        Equipamento equipamento = (Equipamento)request.getAttribute("equipamento");
        TipoPontoControle tipoPontoControle = (TipoPontoControle)request.getAttribute("tipoPontoControle");
        return CoreDAOFactory.getInstance().getDAOColeta().findColetasPorEquipamentoTipoPonto(equipamento, tipoPontoControle);
    }

    public JasperPrint gerarListagemRotaColeta(CoreRequestContext request) throws ExceptionService {
        Short filtrarAtivo = (Short)request.getAttribute("FILTRAR_ATIVO");
        Long ativoInicial = (Long)request.getAttribute("ATIVO_INICIAL");
        Long ativoFinal = (Long)request.getAttribute("ATIVO_FINAL");
        Short filtrarEmpresa = (Short)request.getAttribute("FILTRAR_EMPRESA");
        Long empresaInicial = (Long)request.getAttribute("EMPRESA_INICIAL");
        Long empresaFinal = (Long)request.getAttribute("EMPRESA_FINAL");
        Short filtrarLocalizacaoAtivo = (Short)request.getAttribute("FILTRAR_LOCALIZACAO_ATIVO");
        Long localizacaoAtivoInicial = (Long)request.getAttribute("LOCALIZACAO_ATIVO_INICIAL");
        Long localizacaoAtivoFinal = (Long)request.getAttribute("LOCALIZACAO_ATIVO_FINAL");
        String fecho = (String)request.getAttribute("FECHO");
        HashMap defaultParams = (HashMap)request.getAttribute("DEFAULT_PARAMS");
        Nodo nodo = (Nodo)request.getAttribute("NODO");
        return UtilColeta.gerarListagemRotaColeta(filtrarAtivo, ativoInicial, ativoFinal, filtrarEmpresa, empresaInicial, empresaFinal, filtrarLocalizacaoAtivo, localizacaoAtivoInicial, localizacaoAtivoFinal, fecho, defaultParams, nodo);
    }

    public List<Coleta> getColetasEntreDatas(CoreRequestContext request) throws ExceptionService {
        Equipamento equipamento = (Equipamento)request.getAttribute("EQUIPAMENTO");
        TipoPontoControle tipoPontoControle = (TipoPontoControle)request.getAttribute("TIPO_PONTO_CONTROLE");
        Date dataInicial = (Date)request.getAttribute("DATA_INICIAL");
        Date dataFinal = (Date)request.getAttribute("DATA_FINAL");
        return CoreDAOFactory.getInstance().getDAOColeta().getColetasEntreDatas(equipamento, tipoPontoControle, dataInicial, dataFinal);
    }

    public Coleta findColetaPorPlacaPosterior(CoreRequestContext request) {
        String placa = (String)request.getAttribute("placa");
        Date dataConsumo = (Date)request.getAttribute("dataConsumo");
        return CoreDAOFactory.getInstance().getDAOColeta().findColetaPorPlacaPosterior(placa, dataConsumo);
    }
}

