/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.coleta;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilColeta {
    static JasperPrint gerarListagemRotaColeta(Short filtrarAtivo, Long ativoInicial, Long ativoFinal, Short filtrarEmpresa, Long empresaInicial, Long empresaFinal, Short filtrarLocalizacaoAtivo, Long localizacaoAtivoInicial, Long localizacaoAtivoFinal, String fecho, HashMap defaultParams, Nodo nodo) throws ExceptionService {
        String query1 = "SELECT distinct a.identificador AS ID_ATIVO,              a.codigo        AS COD_ATIVO,              a.nome          AS ATIVO,              a2.identificador AS ID_SUB,              a2.codigo        AS COD_SUB,              a2.nome          AS SUB FROM Equipamento a INNER JOIN a.ativos s INNER JOIN s.equipamentoFilho a2 WHERE (:filtrarAtivo             <> 1 OR a.identificador                  BETWEEN :ativoInicial             AND :ativoFinal            ) AND   (:filtrarEmpresa           <> 1 OR a.empresa.identificador          BETWEEN :empresaInicial           AND :empresaFinal          ) AND   (:filtrarLocalizacaoAtivo  <> 1 OR a.localizacaoAtivo.identificador BETWEEN :localizacaoAtivoInicial  AND :localizacaoAtivoFinal ) ORDER BY a.identificador";
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery(query1);
        q.setShort("filtrarAtivo", filtrarAtivo.shortValue());
        q.setLong("ativoInicial", ativoInicial.longValue());
        q.setLong("ativoFinal", ativoFinal.longValue());
        q.setShort("filtrarEmpresa", filtrarEmpresa.shortValue());
        q.setLong("empresaInicial", empresaInicial.longValue());
        q.setLong("empresaFinal", empresaFinal.longValue());
        q.setLong("filtrarLocalizacaoAtivo", (long)filtrarLocalizacaoAtivo.shortValue());
        q.setLong("localizacaoAtivoInicial", localizacaoAtivoInicial.longValue());
        q.setLong("localizacaoAtivoFinal", localizacaoAtivoFinal.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ativos = q.list();
        for (HashMap ativo : ativos) {
            Long idAtivo = (Long)ativo.get("ID_ATIVO");
            String query2 = "SELECT c.numeroColeta                    AS NUMERO_COLETA,              c.valorColeta                     AS VALOR_COLETA,              c.valorAcumulado                  AS VALOR_ACUMULADO,              c.tipoPontoControle.identificador AS ID_TIPO_PONTO_CONTROLE,              c.tipoPontoControle.descricao     AS TIPO_PONTO_CONTROLE,              c.descricao                       AS DESCRICAO FROM Coleta c WHERE c.ativo.identificador = :idAtivo AND c.tipoPontoControle.identificador IN ( SELECT t.tipoPontoControle.identificador FROM TipoPontoControleAtivo t WHERE t.ativo = 1 AND t.equipamento.identificador = :idAtivo ) AND c.numeroColeta = ( SELECT MAX(c2.numeroColeta) FROM Coleta c2 WHERE c2.tipoPontoControle.identificador = c.tipoPontoControle.identificador AND c2.ativo.identificador = :idAtivo) ";
            s = CoreBdUtil.getInstance().getSession();
            q = s.createQuery(query2);
            q.setLong("idAtivo", idAtivo.longValue());
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            ativo.put("COLETAS", q.list());
            Long idSub = (Long)ativo.get("ID_SUB");
            if (idSub == null) continue;
            s = CoreBdUtil.getInstance().getSession();
            q = s.createQuery(query2);
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            q.setLong("idAtivo", idSub.longValue());
            ativo.put("COLETAS_SUB", q.list());
        }
        defaultParams.put("FILTRAR_ATIVO", filtrarAtivo);
        defaultParams.put("ATIVO_INICIAL", ativoInicial);
        defaultParams.put("ATIVO_FINAL", ativoFinal);
        defaultParams.put("FILTRAR_EMPRESA", filtrarEmpresa);
        defaultParams.put("EMPRESA_INICIAL", empresaInicial);
        defaultParams.put("EMPRESA_FINAL", empresaFinal);
        defaultParams.put("FILTRAR_LOCALIZACAO_ATIVO", filtrarLocalizacaoAtivo);
        defaultParams.put("LOCALIZACAO_ATIVO_INICIAL", localizacaoAtivoInicial);
        defaultParams.put("LOCALIZACAO_ATIVO_FINAL", localizacaoAtivoFinal);
        CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", defaultParams).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + File.separator + "manutencequipamentos" + File.separator + "coleta" + File.separator + "LISTAGEM_ROTA_COLETA.jasper";
        CoreRequestContext relatorio = new CoreRequestContext();
        relatorio.setAttribute("path", path);
        relatorio.setAttribute("parametros", defaultParams);
        relatorio.setAttribute("dados", ativos);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(relatorio, "getJasperPrintDataSource");
        return jasperPrint;
    }
}

