/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.compensacaochequeterceiros;

import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.CompensacaoChequeTerceiros;
import com.touchcomp.basementor.model.vo.GrupoCompensacaoTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.utilities.CoreUtilityFactory;

public class ServiceCompensacaoChequeTerceiros
extends CoreService {
    public static final String SALVAR_COMPENSACAO_CHEQUE_TERCEIROS = "salvarCompensacaoChequeTerceiros";
    public static final String DELETAR_COMPENSACAO_CHEQUE_TERCEIROS = "deletarCompensacaoChequeTerceiros";

    public GrupoCompensacaoTerceiros salvarCompensacaoChequeTerceiros(CoreRequestContext request) throws ExceptionDatabase {
        GrupoCompensacaoTerceiros grupoCompensacaoTerceiros = (GrupoCompensacaoTerceiros)request.getAttribute("grupoCompensacaoTerceiros");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)request.getAttribute("opcoesFinanceiras");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)request.getAttribute("opcoesContabeis");
        PlanoContaGerencial planoContaGerencial = (PlanoContaGerencial)request.getAttribute("planoContaGerencial");
        boolean gerarTit = opcoesFinanceiras.getGerarTitChequeDev() != null && opcoesFinanceiras.getGerarTitChequeDev() == 1;
        for (CompensacaoChequeTerceiros c : grupoCompensacaoTerceiros.getCompensacaoChequesTerceiros()) {
            BorderoChequeTerceirosMovBancario bordero = CoreDAOFactory.getInstance().getDAOGrupoCompensacaoTerceiros().pesquisarUltimoBorderoChequeTerceiro(c.getCheque());
            if (bordero != null && bordero.getMovimentoBancarioCredito() != null) {
                bordero.getMovimentoBancarioCredito().setDataCompensacao(c.getDataCompensacao());
                bordero.getMovimentoBancarioDebito().setDataCompensacao(c.getDataCompensacao());
                CoreDAOFactory.getInstance().getDAOBorderoChequeTerceirosMovBancario().saveOrUpdate(bordero);
            }
            if (gerarTit && bordero != null && c.getTipoCompensacaoChTerceiros().getCodigo() == 2 && bordero.getMovimentoBancarioCredito().getContaValor().getPlanoConta() != null && bordero.getMovimentoBancarioCredito().getContaValor().getGerarLancamentoContabil() == 1) {
                PlanoConta pc = bordero.getMovimentoBancarioCredito().getContaValor().getPlanoConta();
                c.setPlanoConta(pc);
                CoreUtilityFactory.getUtilityTitulos().criarTituloDevolucaoCheque(c, planoContaGerencial, grupoCompensacaoTerceiros.getEmpresa(), opcoesFinanceiras, opcoesContabeis);
            }
            if (grupoCompensacaoTerceiros.getObservacao() == null || grupoCompensacaoTerceiros.getObservacao().isEmpty()) continue;
            c.getCheque().setObservacao(c.getCheque().getObservacao() + " " + grupoCompensacaoTerceiros.getObservacao());
            if (c.getCheque().getObservacao().length() <= 5000) continue;
            c.getCheque().setObservacao(c.getCheque().getObservacao().substring(0, 5000));
        }
        return (GrupoCompensacaoTerceiros)CoreDAOFactory.getInstance().getDAOGrupoCompensacaoTerceiros().saveOrUpdate(grupoCompensacaoTerceiros);
    }

    public void deletarCompensacaoChequeTerceiros(CoreRequestContext request) throws ExceptionDatabase {
        GrupoCompensacaoTerceiros grupoCompensacaoTerceiros = (GrupoCompensacaoTerceiros)request.getAttribute("grupoCompensacaoTerceiros");
        CoreDAOFactory.getInstance().getDAOGrupoCompensacaoTerceiros().delete(grupoCompensacaoTerceiros);
        for (CompensacaoChequeTerceiros c : grupoCompensacaoTerceiros.getCompensacaoChequesTerceiros()) {
            BorderoChequeTerceirosMovBancario borderoChequesTerceiros = CoreDAOFactory.getInstance().getDAOGrupoCompensacaoTerceiros().pesquisarUltimoBorderoChequeTerceiro(c.getCheque());
            if (borderoChequesTerceiros == null) continue;
            borderoChequesTerceiros.getMovimentoBancarioCredito().setDataCompensacao(null);
            borderoChequesTerceiros.getMovimentoBancarioDebito().setDataCompensacao(null);
            CoreDAOFactory.getInstance().getDAOBorderoChequesTerceiros().saveOrUpdate(borderoChequesTerceiros);
        }
    }
}

