/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.conferencianfterceiros;

import com.touchcomp.basementor.model.vo.ConferenciaNFTerceiros;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.InfPagamentoNfTerceiros;
import com.touchcomp.basementor.model.vo.IntegracaoNotaTerceirosNotas;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceiros;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFinanceiro;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosFiscal;
import com.touchcomp.basementor.model.vo.LiberacaoNFTerceirosQualidade;
import com.touchcomp.basementor.model.vo.LivroFiscal;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.lancamentocontabil.impl.entradassaidasfiscais.CompLancamentosEntradaSaidaFiscais;
import com.touchcomp.basementorservice.components.requisicao.impl.CompRequisicaoNotaFiscalTerceiros;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.query.Query;

public class UtilConferenciaNFTerceiros {
    public ConferenciaNFTerceiros salvaConferenciaNFTerceiros(ConferenciaNFTerceiros vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis op) throws ExceptionDatabase, ExceptionService, ExceptionInvalidData {
        vo = (ConferenciaNFTerceiros)CoreDAOFactory.getInstance().getDAOConferenciaNFTerceiros().saveOrUpdate(vo);
        if (vo.getConferida().equals((short)1) || vo.getLiberarConferencia().equals((short)1)) {
            this.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, op);
        } else {
            vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf((short)0));
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            nota = this.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, false);
            nota = this.updateNotaTerceiros(nota);
        }
        return vo;
    }

    public LiberacaoNFTerceirosFinanceiro salvaLiberacaoFinanceiraNFTerceiros(LiberacaoNFTerceirosFinanceiro vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis op) throws ExceptionDatabase, ExceptionService, ExceptionInvalidData {
        vo = (LiberacaoNFTerceirosFinanceiro)CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosFinanceiro().saveOrUpdate(vo);
        if (vo.getConferida().equals((short)1)) {
            this.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, op);
        } else {
            vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf((short)0));
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            nota = this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, false);
            nota = this.updateNotaTerceiros(nota);
        }
        return vo;
    }

    public LiberacaoNFTerceirosFiscal salvaLiberacaoFiscalNFTerceiros(LiberacaoNFTerceirosFiscal vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis op) throws ExceptionDatabase, ExceptionService, ExceptionInvalidData {
        vo = (LiberacaoNFTerceirosFiscal)CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosFiscal().saveOrUpdate(vo);
        if (vo.getConferida().equals((short)1)) {
            this.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, op);
        } else {
            vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf((short)0));
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            nota = this.gerarLivrosFiscais(nota, opcoesCompra, false);
            nota = this.gerarLancamentosContabeis(nota, empresaContabilidade, opcoesCompra, false, op);
            nota = this.updateNotaTerceiros(nota);
        }
        return vo;
    }

    public LiberacaoNFTerceirosQualidade salvaLiberacaoQualidadeNFTerceiros(LiberacaoNFTerceirosQualidade vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis op) throws ExceptionDatabase, ExceptionService, ExceptionInvalidData {
        vo = (LiberacaoNFTerceirosQualidade)CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosQualidade().saveOrUpdate(vo);
        if (vo.getConferida().equals((short)1)) {
            this.isValidAndCreateUltimaLiberacao(opcoesCompra, vo.getLiberacaoNota(), empresaContabilidade, true, op);
        } else {
            vo.getLiberacaoNota().setConferidaTotalmente(Short.valueOf((short)0));
            this.updateNotaTerceiros(vo.getLiberacaoNota().getNotaTerceiros());
        }
        return vo;
    }

    private NotaFiscalTerceiros atualizarTitulosNotaTerceiros(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado) {
        block7: {
            block6: {
                if (opcoesCompra.getUtilizarSomenteLibSel() != null && !opcoesCompra.getUtilizarSomenteLibSel().equals((short)0)) break block6;
                for (InfPagamentoNfTerceiros inf : notaTerceiros.getInfPagamentoNfTerceiros()) {
                    for (Titulo t : inf.getTitulos()) {
                        if (liberado.booleanValue()) {
                            t.setProvisao(Short.valueOf((short)1));
                            continue;
                        }
                        t.setProvisao(Short.valueOf((short)0));
                    }
                }
                break block7;
            }
            if (opcoesCompra.getLiberacaoFinanceiro() == null || !opcoesCompra.getLiberacaoFinanceiro().equals((short)1)) break block7;
            for (InfPagamentoNfTerceiros inf : notaTerceiros.getInfPagamentoNfTerceiros()) {
                for (Titulo t : inf.getTitulos()) {
                    if (liberado.booleanValue()) {
                        t.setProvisao(Short.valueOf((short)1));
                        continue;
                    }
                    t.setProvisao(Short.valueOf((short)0));
                }
            }
        }
        return notaTerceiros;
    }

    private NotaFiscalTerceiros atualizarMovimentacaoEstoqueNotaTerceiros(NotaFiscalTerceiros notaTerceiros, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado) {
        block7: {
            block6: {
                if (opcoesCompra.getUtilizarSomenteLibSel() != null && !opcoesCompra.getUtilizarSomenteLibSel().equals((short)0)) break block6;
                for (ItemNotaTerceiros item : notaTerceiros.getItemNotaTerceiros()) {
                    if (item.getModeloFiscal().getMovimentacaoFisica() != 1) continue;
                    for (GradeItemNotaTerceiros gr : item.getGrade()) {
                        if (liberado.booleanValue()) {
                            gr.setMovimentacaoFisica(Short.valueOf((short)1));
                            continue;
                        }
                        gr.setMovimentacaoFisica(Short.valueOf((short)0));
                    }
                }
                break block7;
            }
            if (opcoesCompra.getLiberacaoEstoque() == null || !opcoesCompra.getLiberacaoEstoque().equals((short)1)) break block7;
            for (ItemNotaTerceiros item : notaTerceiros.getItemNotaTerceiros()) {
                if (item.getModeloFiscal().getMovimentacaoFisica() != 1) continue;
                for (GradeItemNotaTerceiros gr : item.getGrade()) {
                    if (liberado.booleanValue()) {
                        gr.setMovimentacaoFisica(Short.valueOf((short)1));
                        continue;
                    }
                    gr.setMovimentacaoFisica(Short.valueOf((short)0));
                }
            }
        }
        return notaTerceiros;
    }

    private NotaFiscalTerceiros updateNotaTerceiros(NotaFiscalTerceiros nota) throws ExceptionDatabase {
        if (nota.getRequisicao() != null) {
            CoreDAOFactory.getInstance().getDAORequisicao().delete(nota.getRequisicao());
            CoreBdUtil.getInstance().getSession().flush();
            nota.setRequisicao(null);
        }
        nota = (NotaFiscalTerceiros)CoreDAOFactory.getInstance().getDAONotaFiscalTerceiros().saveOrUpdate(nota);
        return nota;
    }

    void validarQtdeItensNFTerceirosConferida(NotaFiscalTerceiros vo) throws ExceptionService {
        Double qtdeNova;
        if (vo.getIdentificador() == null) {
            return;
        }
        Double qtdeAntiga = this.getQtdeItensOldNFTerceirosConferida(vo);
        if (!qtdeAntiga.equals(qtdeNova = this.getQtdeItensNewNFTerceirosConferida(vo))) {
            throw new ExceptionService("A quantidade de itens n\u00e3o \u00e9 igual a Confer\u00eancia feita para esta nota anteriormente!");
        }
    }

    private Double getQtdeItensOldNFTerceirosConferida(NotaFiscalTerceiros vo) {
        String hql = "select sum(g.quantidade) from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i inner join i.grade g where  n.identificador = :idNotaTerceiros";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setLong("idNotaTerceiros", vo.getIdentificador().longValue());
        return (Double)q.uniqueResult();
    }

    private Double getQtdeItensNewNFTerceirosConferida(NotaFiscalTerceiros vo) {
        Double qtde = 0.0;
        for (ItemNotaTerceiros item : vo.getItemNotaTerceiros()) {
            for (GradeItemNotaTerceiros gr : item.getGrade()) {
                qtde = qtde + gr.getQuantidade();
            }
        }
        return qtde;
    }

    private NotaFiscalTerceiros gerarLancamentosContabeis(NotaFiscalTerceiros nota, EmpresaContabilidade empresaContabilidade, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado, OpcoesContabeis op) throws ExceptionService, ExceptionInvalidData {
        CompLancamentosEntradaSaidaFiscais comp = (CompLancamentosEntradaSaidaFiscais)ConfApplicationContext.getBean(CompLancamentosEntradaSaidaFiscais.class);
        if (opcoesCompra.getUtilizarSomenteLibSel() == null || opcoesCompra.getUtilizarSomenteLibSel().equals((short)0)) {
            if (liberado.booleanValue()) {
                if (empresaContabilidade.getLancNotaTerceiros().equals((short)0)) {
                    LoteContabil loteContabil = comp.contabilizar(nota, op);
                    IntegracaoNotaTerceirosNotas i = nota.getIntegracaoNotaTerceiros();
                    if (i == null) {
                        i = new IntegracaoNotaTerceirosNotas();
                        i.setNotaFiscalTerceiros(nota);
                    }
                    i.setLoteContabil(loteContabil);
                    nota.setIntegracaoNotaTerceiros(i);
                }
            } else {
                nota.setIntegracaoNotaTerceiros(null);
            }
        } else if (opcoesCompra.getLiberacaoFiscal() != null && opcoesCompra.getLiberacaoFiscal().equals((short)1)) {
            if (liberado.booleanValue()) {
                if (empresaContabilidade.getLancNotaTerceiros().equals((short)0)) {
                    LoteContabil loteContabil = comp.contabilizar(nota, op);
                    IntegracaoNotaTerceirosNotas i = nota.getIntegracaoNotaTerceiros();
                    if (i == null) {
                        i = new IntegracaoNotaTerceirosNotas();
                        i.setNotaFiscalTerceiros(nota);
                    }
                    i.setLoteContabil(loteContabil);
                    nota.setIntegracaoNotaTerceiros(i);
                }
            } else {
                nota.setIntegracaoNotaTerceiros(null);
            }
        }
        return nota;
    }

    private NotaFiscalTerceiros gerarLivrosFiscais(NotaFiscalTerceiros nota, OpcoesCompraSuprimentos opcoesCompra, Boolean liberado) throws ExceptionService {
        block9: {
            block8: {
                if (opcoesCompra.getUtilizarSomenteLibSel() != null && !opcoesCompra.getUtilizarSomenteLibSel().equals((short)0)) break block8;
                if (liberado.booleanValue()) {
                    for (LivroFiscal lv : nota.getLivrosFiscais()) {
                        lv.setCancelado(Short.valueOf((short)0));
                    }
                } else {
                    for (LivroFiscal lv : nota.getLivrosFiscais()) {
                        lv.setCancelado(Short.valueOf((short)1));
                    }
                }
                break block9;
            }
            if (opcoesCompra.getLiberacaoFiscal() == null || !opcoesCompra.getLiberacaoFiscal().equals((short)1)) break block9;
            if (liberado.booleanValue()) {
                for (LivroFiscal lv : nota.getLivrosFiscais()) {
                    lv.setCancelado(Short.valueOf((short)0));
                }
            } else {
                for (LivroFiscal lv : nota.getLivrosFiscais()) {
                    lv.setCancelado(Short.valueOf((short)1));
                }
            }
        }
        return nota;
    }

    private NotaFiscalTerceiros atualizarDataNF(NotaFiscalTerceiros nota, OpcoesCompraSuprimentos opcoesCompra) {
        if (opcoesCompra.getAtualizarDataNFLiberacao().equals((short)1)) {
            nota.setDataEntrada(new Date());
            for (ItemNotaTerceiros i : nota.getItemNotaTerceiros()) {
                for (GradeItemNotaTerceiros g : i.getGrade()) {
                    g.setDataEntradaSaida(nota.getDataEntrada());
                }
            }
            for (LivroFiscal l : nota.getLivrosFiscais()) {
                l.setDataLivro(nota.getDataEntrada());
            }
        }
        return nota;
    }

    Boolean excluirConferenciaNFTerceiros(ConferenciaNFTerceiros vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade) throws ExceptionDatabase, ExceptionService {
        if (vo.getConferida().equals((short)1)) {
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            nota = this.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, false);
        }
        LiberacaoNFTerceiros l = vo.getLiberacaoNota();
        l.setLiberacaoEstoque(null);
        CoreBdUtil.getInstance().getSession().flush();
        vo = (ConferenciaNFTerceiros)CoreDAOFactory.getInstance().getDAOConferenciaNFTerceiros().saveOrUpdate(vo);
        CoreBdUtil.getInstance().getSession().flush();
        return CoreDAOFactory.getInstance().getDAOConferenciaNFTerceiros().delete(vo);
    }

    Boolean excluirLiberacaoFinanceiraNFTerceiros(LiberacaoNFTerceirosFinanceiro vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade) throws ExceptionDatabase, ExceptionService {
        if (vo.getConferida().equals((short)1)) {
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            nota = this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, false);
        }
        LiberacaoNFTerceiros l = vo.getLiberacaoNota();
        l.setLiberacaoFinanceira(null);
        CoreBdUtil.getInstance().getSession().flush();
        vo = (LiberacaoNFTerceirosFinanceiro)CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosFinanceiro().saveOrUpdate(vo);
        CoreBdUtil.getInstance().getSession().flush();
        return CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosFinanceiro().delete(vo);
    }

    Boolean excluirLiberacaoFiscalNFTerceiros(LiberacaoNFTerceirosFiscal vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis op) throws ExceptionDatabase, ExceptionService, ExceptionInvalidData {
        if (vo.getConferida().equals((short)1)) {
            NotaFiscalTerceiros nota = vo.getLiberacaoNota().getNotaTerceiros();
            nota = this.gerarLivrosFiscais(nota, opcoesCompra, false);
            nota = this.gerarLancamentosContabeis(nota, empresaContabilidade, opcoesCompra, false, op);
        }
        LiberacaoNFTerceiros l = vo.getLiberacaoNota();
        l.setLiberacaoFiscal(null);
        CoreBdUtil.getInstance().getSession().flush();
        vo = (LiberacaoNFTerceirosFiscal)CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosFiscal().saveOrUpdate(vo);
        CoreBdUtil.getInstance().getSession().flush();
        return CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosFiscal().delete(vo);
    }

    Boolean excluirLiberacaoQualidadeNFTerceiros(LiberacaoNFTerceirosQualidade vo, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade) throws ExceptionDatabase, ExceptionService {
        LiberacaoNFTerceiros l = vo.getLiberacaoNota();
        l.setLiberacaoQualidade(null);
        CoreBdUtil.getInstance().getSession().flush();
        vo = (LiberacaoNFTerceirosQualidade)CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosQualidade().saveOrUpdate(vo);
        CoreBdUtil.getInstance().getSession().flush();
        return CoreDAOFactory.getInstance().getDAOLiberacaoNFTerceirosQualidade().delete(vo);
    }

    private void isValidAndCreateUltimaLiberacao(OpcoesCompraSuprimentos opcoesCompra, LiberacaoNFTerceiros liberacao, EmpresaContabilidade empresaContabilidade, boolean liberada, OpcoesContabeis op) throws ExceptionService, ExceptionDatabase, ExceptionInvalidData {
        int countTiposLiberacao = 0;
        if (opcoesCompra.getLiberacaoEstoque().equals((short)1)) {
            ++countTiposLiberacao;
        }
        if (opcoesCompra.getLiberacaoFinanceiro().equals((short)1)) {
            ++countTiposLiberacao;
        }
        if (opcoesCompra.getLiberacaoFiscal().equals((short)1)) {
            ++countTiposLiberacao;
        }
        if (opcoesCompra.getLiberacaoQualidade().equals((short)1)) {
            ++countTiposLiberacao;
        }
        if (countTiposLiberacao > 0) {
            if (liberacao.getLiberacaoEstoque() != null && liberacao.getLiberacaoEstoque().getConferida().equals((short)1) && --countTiposLiberacao == 0) {
                this.createLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
            }
            if (liberacao.getLiberacaoFinanceira() != null && liberacao.getLiberacaoFinanceira().getConferida().equals((short)1) && --countTiposLiberacao == 0) {
                this.createLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
            }
            if (liberacao.getLiberacaoFiscal() != null && liberacao.getLiberacaoFiscal().getConferida().equals((short)1) && --countTiposLiberacao == 0) {
                this.createLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
            }
            if (liberacao.getLiberacaoQualidade() != null && liberacao.getLiberacaoQualidade().getConferida().equals((short)1) && --countTiposLiberacao == 0) {
                this.createLiberacoes(liberacao, opcoesCompra, empresaContabilidade, liberada, op);
            }
        }
    }

    private void createLiberacoes(LiberacaoNFTerceiros liberacao, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, boolean liberada, OpcoesContabeis op) throws ExceptionService, ExceptionDatabase, ExceptionInvalidData {
        liberacao.setConferidaTotalmente(Short.valueOf((short)1));
        liberacao.setDataConferenciaTotal(new Date());
        NotaFiscalTerceiros nota = liberacao.getNotaTerceiros();
        nota = this.atualizarDataNF(nota, opcoesCompra);
        nota = this.atualizarTitulosNotaTerceiros(nota, opcoesCompra, liberada);
        nota = this.atualizarMovimentacaoEstoqueNotaTerceiros(nota, opcoesCompra, liberada);
        nota = this.gerarLivrosFiscais(nota, opcoesCompra, liberada);
        nota = this.gerarLancamentosContabeis(nota, empresaContabilidade, opcoesCompra, liberada, op);
        nota = this.updateNotaTerceiros(nota);
        nota = this.gerarRequisicao(nota);
    }

    private NotaFiscalTerceiros gerarRequisicao(NotaFiscalTerceiros nota) throws ExceptionDatabase {
        Requisicao r = new CompRequisicaoNotaFiscalTerceiros().criarRequisicaoNotaTerceiros(nota);
        if (r != null) {
            r.setNotaFiscalTerc(nota);
            nota.setRequisicao((Requisicao)CoreDAOFactory.getInstance().getDAORequisicao().saveOrUpdate(r));
        }
        return nota;
    }
}

