/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.controleequipamento;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.ItemEquipamento;
import com.touchcomp.basementor.model.vo.Produto;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.controleequipamento.UtilControleEquipamento;
import net.sf.jasperreports.engine.JasperPrint;

public class ServiceControleEntregaEquipamento
extends CoreService {
    public static final String BUSCAR_EQUIPAMENTO_POR_COLABORADOR_SEM_ENTREGA = "buscarEquipamentoPorColaborador";
    public static final String BUSCAR_CENTRO_ESTOQUE_POR_ITEM_EQUIPAMENTO = "buscaCentroEstoquePorItemEquipamento";
    public static final String BUSCAR_EQUIPAMENTOS_VENCIDOS = "buscarEquipamentosVencidos";
    public static final String FIND_EQUIPAMENTOS_VENCIDOS = "findEquipamentosVencidos";
    public static final String SAVE_CONTROLE_ENTREGA_EQUIPAMENTO = "saveControleEntregaEquipamento";

    public List buscarEquipamentoPorColaborador(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataEntrega = (Date)request.getAttribute("dataEntrega");
        return new UtilControleEquipamento().buscarEquipamentosSemEntrega(colaborador, dataEntrega);
    }

    public CentroEstoque buscaCentroEstoquePorItemEquipamento(CoreRequestContext request) {
        ItemEquipamento item = (ItemEquipamento)request.getAttribute("itemEquipamento");
        return new UtilControleEquipamento().buscarCentroEstoqueByParametrizacaoEquipamento(item);
    }

    public List buscarEquipamentosVencidos(CoreRequestContext request) {
        Colaborador colaborador = (Colaborador)request.getAttribute("colaborador");
        Date dataEntrega = (Date)request.getAttribute("dataEntrega");
        return new UtilControleEquipamento().findEquipamentosVencidos(dataEntrega, colaborador);
    }

    public JasperPrint findEquipamentosVencidos(CoreRequestContext request) throws ExceptionService {
        Date dataVencimento = (Date)request.getAttribute("dataVencimento");
        Short filtrarProduto = (Short)request.getAttribute("filtrarProduto");
        Produto produto = (Produto)request.getAttribute("produto");
        HashMap params = (HashMap)request.getAttribute("parametros");
        Short ordenacao = (Short)request.getAttribute("ordenacao");
        Short filtrarGrade = (Short)request.getAttribute("filtrarGrade");
        Long idGrade = (Long)request.getAttribute("idGrade");
        return new UtilControleEquipamento().findEquipamentosVencidos(params, dataVencimento, filtrarProduto, produto, ordenacao, filtrarGrade, idGrade);
    }

    public ControleEntregaEquipamento saveControleEntregaEquipamento(CoreRequestContext r) throws ExceptionDatabase, ExceptionService {
        ControleEntregaEquipamento vo = (ControleEntregaEquipamento)r.getAttribute("controleEntrega");
        Short gerarRequisicao = (Short)r.getAttribute("gerarRequisicao");
        return new UtilControleEquipamento().saveControleEntregaEquipamento(vo, gerarRequisicao);
    }
}

