/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.controleequipamento;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ControleEntregaEquipamento;
import com.touchcomp.basementor.model.vo.ItemEquipamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import net.sf.jasperreports.engine.JasperPrint;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilControleEquipamento {
    private static final TLogger logger = TLogger.get(UtilControleEquipamento.class);

    public List buscarEquipamentosSemEntrega(Colaborador colaborador, Date dataEntrega) {
        String hql = " select distinct(itemEq)  from ParametrizacaoEquipamentoSeguranca parametrizacao  inner join parametrizacao.itemEquipamento itemEq  inner join parametrizacao.funcao pFunc  inner join pFunc.funcao func  inner join parametrizacao.paramEquipSegurancaEmpresa param  where  func = :funcaoColaborador  and param.empresa = :empresa and  not exists ( select itemEqui                from ItemControleEquipamento itemEqui                where                itemEqui.itemEquipamento = itemEq                and                itemEqui.controleEntregaEquipamento.colaborador = :colaborador                and                itemEqui.controleEntregaEquipamento.colaborador.funcao = :funcaoColaborador    ) ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("funcaoColaborador", (Object)colaborador.getFuncao()).setEntity("colaborador", (Object)colaborador).setEntity("empresa", (Object)colaborador.getEmpresa()).list();
        return ret;
    }

    public CentroEstoque buscarCentroEstoqueByParametrizacaoEquipamento(ItemEquipamento item) {
        String hql = " select par.centroEstoque  from ParametrizacaoEquipamentoSeguranca par  inner join par.itemEquipamento itemEq  where itemEq = :item ";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("item", (Object)item).list();
        return ret != null && !ret.isEmpty() ? (CentroEstoque)ret.get(0) : null;
    }

    public JasperPrint findEquipamentosVencidos(HashMap parametros, Date dataVencimento, Short filtrarProduto, Produto produto, Short ordenacao, Short filtrarGrade, Long idGrade) throws ExceptionService {
        Long idProduto = 0L;
        if (ToolMethods.isEquals((Object)filtrarProduto, (Object)1)) {
            idProduto = produto.getIdentificador();
        }
        if (ToolMethods.isEquals((Object)filtrarGrade, (Object)0)) {
            idGrade = 0L;
        }
        String hql = "SELECT  \n  cee.dataEntrega     AS DATA_ENTREGA,\n  p.nome              AS PRODUTO,\n  pe.nome             AS COLABORADOR,\n  item.dataVencimento AS DATA_VENCIMENTO,\n  co.numeroRegistro   AS REGISTRO,\n  cor.nome            AS F_DESCRICAO\nFROM ItemControleEquipamento item\n  INNER JOIN item.controleEntregaEquipamento cee\n    INNER JOIN cee.colaborador co\n      INNER JOIN co.pessoa pe\n  INNER JOIN item.itemEquipamento ite\n    INNER JOIN ite.gradeCor gc\n      INNER JOIN gc.cor cor\n      INNER JOIN gc.produtoGrade pdg\n        INNER JOIN pdg.produto p\nWHERE \n  item.dataVencimento  <= :dataVencimento\n  AND (:filtrarProduto = 0 or p.identificador  = :idProduto)\n  AND (:filtrarGrade  <> 1 or gc.identificador = :idGrade)\n  AND (co.ativo = 1)\n  AND (co.dataDemissao = null or co.dataDemissao >= :dataVencimento)\n  AND NOT EXISTS (\n    SELECT  itemE\n    FROM ItemControleEquipamento itemE\n    WHERE itemE.itemAnterior = item ) " + this.getOrdenacao(ordenacao);
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setLong("idProduto", idProduto.longValue()).setDate("dataVencimento", dataVencimento).setShort("filtrarProduto", filtrarProduto.shortValue()).setShort("filtrarGrade", filtrarGrade.shortValue()).setLong("idGrade", idGrade.longValue()).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        Object path = System.getProperty("user.dir");
        path = (String)path + File.separator + "reports" + File.separator + "rh" + File.separator + "segurancatrabalho" + File.separator + "controleentregaequipamento" + File.separator + "LISTAGEM_MANUTENCAO_EQUIPAMENTO.jasper";
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("path", path);
        request.setAttribute("parametros", parametros);
        request.setAttribute("dados", ret);
        JasperPrint jasperPrint = (JasperPrint)CoreServiceFactory.getCoreReportService().execute(request, "getJasperPrintDataSource");
        return jasperPrint;
    }

    private String getOrdenacao(Short ordenacao) {
        if (ordenacao.equals((short)1)) {
            return " order by pe.nome ";
        }
        return " order by item.dataVencimento ";
    }

    public List findEquipamentosVencidos(Date dataEntrega, Colaborador colaborador) {
        String hql = " select itemControle from ItemControleEquipamento itemControle  inner join itemControle.controleEntregaEquipamento controle where  itemControle.controleEntregaEquipamento.colaborador = :colaborador  and  not exists (select itemE from ItemControleEquipamento itemE where itemE.itemAnterior = itemControle )  and itemControle.dataVencimento <= :dataEntrega and controle.empresa = :empresa";
        List ret = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setEntity("empresa", (Object)colaborador.getEmpresa()).setDate("dataEntrega", dataEntrega).list();
        return ret;
    }

    public ControleEntregaEquipamento saveControleEntregaEquipamento(ControleEntregaEquipamento vo, Short gerarRequisicao) throws ExceptionDatabase, ExceptionService {
        if (gerarRequisicao != null && gerarRequisicao == 1) {
            Requisicao r = this.criarRequisicaoEquipamentos(vo);
            vo.setRequisicao(r);
        }
        return (ControleEntregaEquipamento)CoreDAOFactory.getInstance().getDAOControleEntregaEquipamento().saveOrUpdate(vo);
    }

    private Requisicao criarRequisicaoEquipamentos(ControleEntregaEquipamento c) throws ExceptionService {
        return ((HelperRequisicao)Context.get(HelperRequisicao.class)).gerarRequisicaoEntregaEquipamento(c);
    }
}

