/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.controlequallinprod;

import com.touchcomp.basementor.model.vo.ControleQualLinProd;
import com.touchcomp.basementor.model.vo.ControleQualLinProdSubOS;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementor.model.vo.SubdivisaoOSProdLinhaProd;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.components.roteiroproducao.CompRoteiroProducao;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;

class UtilControleQualLinProd {
    UtilControleQualLinProd() {
    }

    public Object pesquisarSubosContQualidade(Date dataIn, Date dataFinal, Usuario usuario, Empresa empresa, Short agruparOSProdutos) {
        List subOS = this.pesquisarSubosContQualidade(dataIn, dataFinal);
        List subespecies = this.getSubEspeciesPercVerificar();
        ArrayList<ControleQualLinProd> aux = new ArrayList<ControleQualLinProd>();
        for (Object o : subOS) {
            SubdivisaoOSProdLinhaProd s = (SubdivisaoOSProdLinhaProd)o;
            ControleQualLinProd c = null;
            for (ControleQualLinProd a : aux) {
                if (!a.getRoteiroProducao().equals((Object)s.getRoteiroProducao()) || !a.getGradeFormulaProduto().equals((Object)s.getGradeFormulaProduto())) continue;
                if (agruparOSProdutos == 1 && a.getGradeCor().equals((Object)s.getGradeCor())) {
                    c = a;
                    break;
                }
                if (agruparOSProdutos != 0) continue;
                c = a;
                break;
            }
            if (c == null) {
                c = this.getNewControleQualidade(subespecies, usuario, empresa, s.getGradeCor());
                c.setGradeFormulaProduto(s.getGradeFormulaProduto());
                c.setRoteiroProducao(s.getRoteiroProducao());
                c.setFaseProdutiva(CompRoteiroProducao.getFirstAtiva((RoteiroProducao)s.getRoteiroProducao()));
                aux.add(c);
            }
            c.setGradeCor(s.getGradeCor());
            ControleQualLinProdSubOS cs = new ControleQualLinProdSubOS();
            cs.setControleQualLinProd(c);
            cs.setSubosLinProd(s);
            c.setQtdTotalSubOS(Double.valueOf(c.getQtdTotalSubOS() + s.getQuantidadePrevista()));
            c.setQtdAVerificar(Double.valueOf(c.getQtdTotalSubOS() * (c.getPercVerificar() / 100.0)));
            c.getControleQualSubOS().add(cs);
        }
        return aux;
    }

    public List pesquisarSubosContQualidade(Date dataIn, Date dataFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct s from SubdivisaoOSProdLinhaProd s  left join s.contQualidadeProdSubOS c where s.dataPrevisao between :dataIn and :dataFinal and c.identificador is null and exists(select o.identificador from OpcoesContQualiProdSubesp o where o.subespecie = s.gradeCor.produtoGrade.produto.subEspecie)");
        q.setDate("dataIn", dataIn);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public List getSubEspeciesPercVerificar() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct s.subespecie.identificador as SUB_ESPECIE,s.percentualVerificacao as PERC_VERIFICACAO from OpcoesContQualiProdSubesp s ");
        q.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
        return q.list();
    }

    private ControleQualLinProd getNewControleQualidade(List subespecies, Usuario usuario, Empresa empresa, GradeCor gc) {
        ControleQualLinProd c = new ControleQualLinProd();
        c.setDataCadastro(new Date());
        c.setUsuario(usuario);
        c.setEmpresa(empresa);
        for (Object o : subespecies) {
            HashMap h = (HashMap)o;
            Long id = (Long)h.get("SUB_ESPECIE");
            if (id.longValue() != gc.getProdutoGrade().getProduto().getSubEspecie().getIdentificador().longValue()) continue;
            c.setPercVerificar((Double)h.get("PERC_VERIFICACAO"));
        }
        return c;
    }
}

