/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompra;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.cotacaocompra.UtilCarregarFornecedoresCotProduto;
import mentorcore.service.impl.cotacaocompra.UtilGerarCotacaoNecessidade;
import mentorcore.service.impl.cotacaocompra.UtilGerarOrdemCompra;
import mentorcore.service.impl.cotacaocompra.UtilGerarPlanilhaCotacao;
import mentorcore.service.impl.cotacaocompra.UtilGerarPlanilhaCotacaoModelo;
import mentorcore.service.impl.cotacaocompra.UtilLLerPlanilhaCotacao;
import mentorcore.service.impl.cotacaocompra.UtilLLerPlanilhaCotacaoModelo;

public class ServiceCotacaoCompra
extends CoreService {
    public static final String LER_PLANILHAS_COTACAO = "lerPlanilhasCotacao";
    public static final String LER_PLANILHAS_COTACAO_MODELO = "lerPlanilhasCotacaoModelo";
    public static final String GERAR_PLANILHAS_COTACAO = "gerarPlanilhasCotacao";
    public static final String GERAR_PLANILHAS_COTACAO_MODELO = "gerarPlanilhasCotacaoModelo";
    public static final String GERAR_PLANILHAS_COTACAO_ENVIAR_EMAIL = "gerarPlanilhasCotacaoEnviarEmail";
    public static final String GERAR_PLANILHAS_COTACAO_ENVIAR_EMAIL_MODELO = "gerarPlanilhasCotacaoEnviarEmailModelo";
    public static final String GERAR_ORDENS_COMPRA_COTACAO = "gerarOrdensCompraCotacao";
    public static final String GERAR_COTACAO_NECESSIDADE_COMPRA = "gerarCotacaoNecessidadeCompra";
    public static final String FIND_FORNECEDORES_COTACAO_PREFERENCIAIS = "findFornecedoresCotacaoPreferenciais";
    public static final String PRE_GERACAO_ORDENS_COMPRA_COTACAO = "preGeracaoOrdensCompraCotacao";

    public List lerPlanilhasCotacao(CoreRequestContext cq) throws ExceptionService, IOException {
        List files = (List)cq.getAttribute("files");
        OpcoesCompraSuprimentos opcoesCompraSuprimentos = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompraSuprimentos");
        CondicoesPagamento condicaoMutante = (CondicoesPagamento)cq.getAttribute("condMutante");
        return new UtilLLerPlanilhaCotacao().importarPlanilhaExcelFornecedores(files, condicaoMutante, opcoesCompraSuprimentos);
    }

    public Object lerPlanilhasCotacaoModelo(CoreRequestContext cq) throws ExceptionService, IOException {
        List files = (List)cq.getAttribute("files");
        OpcoesCompraSuprimentos opcoesCompraSuprimentos = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompraSuprimentos");
        ConfPlanilhaExcelCotCompra conf = (ConfPlanilhaExcelCotCompra)cq.getAttribute("modeloPlanilha");
        CondicoesPagamento condicaoMutante = (CondicoesPagamento)cq.getAttribute("condMutante");
        return new UtilLLerPlanilhaCotacaoModelo().importarPlanilhaExcelFornecedores(files, conf, condicaoMutante, opcoesCompraSuprimentos);
    }

    public Object gerarPlanilhasCotacao(CoreRequestContext cq) throws ExceptionService {
        CotacaoCompra c = (CotacaoCompra)cq.getAttribute("cotacaoCompra");
        String diretorio = (String)cq.getAttribute("diretorio");
        new UtilGerarPlanilhaCotacao().exportarPlanilhaExcelFornecedores(c, diretorio);
        return Boolean.TRUE;
    }

    public Object gerarPlanilhasCotacaoModelo(CoreRequestContext cq) throws ExceptionService {
        CotacaoCompra c = (CotacaoCompra)cq.getAttribute("cotacaoCompra");
        String diretorio = (String)cq.getAttribute("diretorio");
        ConfPlanilhaExcelCotCompra modeloPlanilha = (ConfPlanilhaExcelCotCompra)cq.getAttribute("modeloPlanilha");
        new UtilGerarPlanilhaCotacaoModelo().exportarPlanilhaExcelFornecedores(c, diretorio, modeloPlanilha);
        return Boolean.TRUE;
    }

    public Object gerarPlanilhasCotacaoEnviarEmail(CoreRequestContext cq) throws ExceptionService {
        CotacaoCompra cotacaoCompra = (CotacaoCompra)cq.getAttribute("cotacaoCompra");
        HashMap emails = (HashMap)cq.getAttribute("emails");
        ModeloEmail modeloEmail = (ModeloEmail)cq.getAttribute("modeloEmail");
        ServidorEmail servidorEmail = (ServidorEmail)cq.getAttribute("servidorEmail");
        new UtilGerarPlanilhaCotacao().exportarPlanilhaExcelFornecedores(cotacaoCompra, emails, modeloEmail, servidorEmail);
        return Boolean.TRUE;
    }

    public Object gerarPlanilhasCotacaoEnviarEmailModelo(CoreRequestContext cq) throws ExceptionService {
        CotacaoCompra cotacaoCompra = (CotacaoCompra)cq.getAttribute("cotacaoCompra");
        HashMap emails = (HashMap)cq.getAttribute("emails");
        ModeloEmail modeloEmail = (ModeloEmail)cq.getAttribute("modeloEmail");
        ServidorEmail servidorEmail = (ServidorEmail)cq.getAttribute("servidorEmail");
        ConfPlanilhaExcelCotCompra modeloPlanilha = (ConfPlanilhaExcelCotCompra)cq.getAttribute("modeloPlanilha");
        new UtilGerarPlanilhaCotacaoModelo().exportarPlanilhaExcelFornecedores(cotacaoCompra, emails, modeloEmail, servidorEmail, modeloPlanilha);
        return Boolean.TRUE;
    }

    public static List<CotacaoCompra> gerarOrdensCompraCotacao(CoreRequestContext cq) throws ExceptionService {
        List cotacoes = (List)cq.getAttribute("cotacoes");
        Usuario user = (Usuario)cq.getAttribute("user");
        Empresa emp = (Empresa)cq.getAttribute("empresa");
        OpcoesCompraSuprimentos opcoes = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompra");
        OpcoesFinanceiras opcoesFin = (OpcoesFinanceiras)cq.getAttribute("opcoesFinanceiras");
        OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)cq.getAttribute("opcoesGerenciais");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)cq.getAttribute("opcoesContabeis");
        EmpresaContabilidade empresaContabilidade = (EmpresaContabilidade)cq.getAttribute("empresaContabilidade");
        return new UtilGerarOrdemCompra().buildOrdensCompraFromCotacoes(cotacoes, opcoes, user, emp, opcoesFin, opcoesGerenciais, empresaContabilidade, opcoesContabeis);
    }

    public static CotacaoCompra gerarCotacaoNecessidadeCompra(CoreRequestContext cq) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionDatabase {
        List necessidadesCompra = (List)cq.getAttribute("necessidadesCompra");
        Usuario user = (Usuario)cq.getAttribute("user");
        Empresa emp = (Empresa)cq.getAttribute("empresa");
        EmpresaContabilidade empresaContabilidade = (EmpresaContabilidade)cq.getAttribute("empresaContabilidade");
        OpcoesCompraSuprimentos opcoes = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompra");
        OpcoesContabeis opcoesContabeis = (OpcoesContabeis)cq.getAttribute("opcoesContabeis");
        OpcoesEstoque opcoesEstoque = (OpcoesEstoque)cq.getAttribute("opcoesEstoque");
        return new UtilGerarCotacaoNecessidade().gerarCotacaoCompraFromNecessidade(necessidadesCompra, user, emp, opcoes, empresaContabilidade, opcoesContabeis, opcoesEstoque);
    }

    public static List<FornecedorItemCotacaoCompra> findFornecedoresCotacaoPreferenciais(CoreRequestContext cq) throws ExceptionService {
        ItemCotacaoCompra item = (ItemCotacaoCompra)cq.getAttribute("itemCotacaoCompra");
        Empresa emp = (Empresa)cq.getAttribute("empresa");
        OpcoesCompraSuprimentos opcoesCotacoesCompra = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCotacoesCompra");
        return new UtilCarregarFornecedoresCotProduto().findFornecedoresItemCotacaoCompra(item, emp, opcoesCotacoesCompra);
    }

    public static List<CotacaoCompra> preGeracaoOrdensCompraCotacao(CoreRequestContext cq) throws ExceptionService, ExceptionInvalidData {
        try {
            List cotacoes = (List)cq.getAttribute("cotacoes");
            Usuario user = (Usuario)cq.getAttribute("user");
            Empresa emp = (Empresa)cq.getAttribute("empresa");
            OpcoesCompraSuprimentos opcoes = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompra");
            OpcoesFinanceiras opcoesFin = (OpcoesFinanceiras)cq.getAttribute("opcoesFinanceiras");
            OpcoesGerenciais opcoesGerenciais = (OpcoesGerenciais)cq.getAttribute("opcoesGerenciais");
            OpcoesContabeis opcoesContabeis = (OpcoesContabeis)cq.getAttribute("opcoesContabeis");
            EmpresaContabilidade empresaContabilidade = (EmpresaContabilidade)cq.getAttribute("empresaContabilidade");
            return new UtilGerarOrdemCompra().preGeracaoOrdensCompraFromCotacoes(cotacoes, opcoes, user, emp, opcoesFin, opcoesGerenciais, empresaContabilidade, opcoesContabeis);
        }
        catch (ExceptionInvalidData | ExceptionTitulo ex) {
            Logger.getLogger(ServiceCotacaoCompra.class.getName()).log(Level.SEVERE, null, ex);
            throw new ExceptionService(ex.getMessage(), ex);
        }
    }
}

