/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.notaterceiros.CompNotaTerceiros;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.cotacaocompra.UtilGerarCotacaoNecessidade;

class UtilCarregarFornecedoresCotProduto {
    private final TLogger logger = TLogger.get(UtilCarregarFornecedoresCotProduto.class);

    UtilCarregarFornecedoresCotProduto() {
    }

    public List<FornecedorItemCotacaoCompra> findFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, Empresa emp, OpcoesCompraSuprimentos opcoes) throws ExceptionService {
        List leadTimeFornecedor = this.getLeadTime(itemCotacaoCompra.getGradeCor(), emp);
        return this.findFornecedoresItemCotacaoCompra(itemCotacaoCompra, emp, leadTimeFornecedor, opcoes);
    }

    public List<FornecedorItemCotacaoCompra> findFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, Empresa emp, List<LeadTimeFornProduto> leadTimeFornecedor, OpcoesCompraSuprimentos opcoes) throws ExceptionService {
        ArrayList<FornecedorItemCotacaoCompra> fornecedoresItemCotacaoCompra = new ArrayList<FornecedorItemCotacaoCompra>();
        for (LeadTimeFornProduto leadProd : leadTimeFornecedor) {
            FornecedorItemCotacaoCompra f = this.buildFornecedorItemCotacaoCompra(itemCotacaoCompra, leadProd, emp, opcoes);
            if (ToolMethods.isEquals((Object)f, null) || !ToolMethods.isEquals((Object)f.getUnidadeFaturamentoFornecedor().getFornecedor().getAtivo(), (Object)EnumConstantsMentorSimNao.SIM.value)) continue;
            fornecedoresItemCotacaoCompra.add(f);
        }
        return fornecedoresItemCotacaoCompra;
    }

    private List getLeadTime(GradeCor gradeCor, Empresa emp) throws ExceptionService {
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("gradeCor", gradeCor);
        cq.setAttribute("empresa", emp);
        List homologadoList = (List)CoreServiceFactory.getServiceLeadTimeFornecedor().execute(cq, "findLeadTimeGradeCorHomologado");
        if (!ToolMethods.isNull((Object)homologadoList).booleanValue() && !homologadoList.isEmpty()) {
            return homologadoList;
        }
        return (List)CoreServiceFactory.getServiceLeadTimeFornecedor().execute(cq, "findLeadTimeGradeCor");
    }

    private CondicoesPagamento findCondicaoPagamentoMutante() throws ExceptionService {
        BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOCondicoesPagamento().getVOClass());
        b.and().equal("condMutante", (short)1);
        b.and().equal("tipoCondEntrada", (short)1);
        List list = CoreService.executeSearch(b);
        if (list != null && !list.isEmpty()) {
            return (CondicoesPagamento)list.get(0);
        }
        throw new ExceptionService("Primeiro, cadastre uma condi\u00e7\u00e3o de pagamento mutante e liberada para ser utilizada na entrada!");
    }

    private FornecedorItemCotacaoCompra buildFornecedorItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, LeadTimeFornProduto leadTimeFornProduto, Empresa emp, OpcoesCompraSuprimentos opcoes) throws ExceptionService {
        LeadTimeFornProdutoInfFiscal leadTime = this.getInfFiscalLeadTime(leadTimeFornProduto);
        EmpresaContabilidade empresaContabilidade = this.findEmpresaContabilidade(emp);
        if (leadTime != null) {
            FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
            f.setItemCotacaoCompra(itemCotacaoCompra);
            f.setAquisicaoPreferencial(Short.valueOf((short)0));
            f.setCondicoesPagamento(this.findCondicaoPagamentoMutante());
            f.setDataCadastro(itemCotacaoCompra.getDataCadastro());
            f.setItemCotacaoCompra(itemCotacaoCompra);
            f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
            f.setCondicaoPagamentoMutante(leadTime.getParcelas());
            f.setCondicoesPagamento(leadTime.getCondicoesPagamento());
            f.setDataCadastro(new Date());
            f.setJustficativaAquisicaoPreferencial(leadTime.getMotivoAqPref());
            f.setModeloFiscal(leadTime.getModeloFiscal());
            f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
            f.setSelecionado(Short.valueOf((short)1));
            f.setTipoFrete(leadTime.getTipoFrete());
            f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
            f.setValorUnitario(leadTime.getValorUnitNegociado());
            f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
            f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
            f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
            new UtilGerarCotacaoNecessidade().setFornecedorItemCotacaoCompraLivroFiscal(f, emp, empresaContabilidade, opcoes);
            return f;
        }
        FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
        f.setItemCotacaoCompra(itemCotacaoCompra);
        f.setAquisicaoPreferencial(Short.valueOf((short)0));
        f.setDataCadastro(itemCotacaoCompra.getDataCadastro());
        f.setAquisicaoPreferencial(leadTimeFornProduto.getAquisicaoPreferencial());
        f.setUnidadeFaturamentoFornecedor(leadTimeFornProduto.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        if (!ToolMethods.isEquals((Object)f.getUnidadeFaturamentoFornecedor(), null) && !ToolMethods.isEquals((Object)f.getUnidadeFaturamentoFornecedor().getFornecedor(), null)) {
            f.setCondicoesPagamento(f.getUnidadeFaturamentoFornecedor().getFornecedor().getCondicaoPagamento());
        }
        f.setPrazoEntrega(Long.valueOf(leadTimeFornProduto.getLeadTime().longValue()));
        f.setFornecedorItemCotacaoCompraLivroFiscal(new FornecedorItemCotacaoCompraLivroFiscal());
        f.setModeloFiscal(this.findModeloFiscal(itemCotacaoCompra, f.getUnidadeFaturamentoFornecedor(), emp, opcoes));
        if (itemCotacaoCompra.getGradeCor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            f.setCustoMedio(CompNotaTerceiros.getCustoMedioProd((Produto)itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), (Empresa)emp));
            f.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd((Produto)itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), (Empresa)emp));
            f.setMenorCusto(CompNotaTerceiros.getMenorCustoProd((Produto)itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), (Empresa)emp));
        }
        return f;
    }

    private LeadTimeFornProdutoInfFiscal getInfFiscalLeadTime(LeadTimeFornProduto leadPref) throws ExceptionService {
        if (leadPref.getInfFiscalLeadTime() == null || leadPref.getInfFiscalLeadTime().isEmpty()) {
            return null;
        }
        return (LeadTimeFornProdutoInfFiscal)leadPref.getInfFiscalLeadTime().get(0);
    }

    private EmpresaContabilidade findEmpresaContabilidade(Empresa emp) {
        try {
            BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getEmpresaContabilidadeDAO().getVOClass());
            b.and().equal("empresa", emp);
            EmpresaContabilidade empCont = (EmpresaContabilidade)CoreService.executeSearchUniqueResult(b);
            return empCont;
        }
        catch (ExceptionService ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private ModeloFiscal findModeloFiscal(ItemCotacaoCompra itemCotacao, UnidadeFatFornecedor unidadeFornecedor, Empresa empresa, OpcoesCompraSuprimentos opcoes) {
        Produto produto = itemCotacao.getGradeCor().getProdutoGrade().getProduto();
        NaturezaOperacao naturezaOperacao = itemCotacao.getNaturezaOperacao();
        if (naturezaOperacao != null && produto != null && unidadeFornecedor.getIdentificador() != null && unidadeFornecedor.getFornecedor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugAutoModFiscalCotCompras())) {
            try {
                HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
                return helper.getFirst(produto, unidadeFornecedor, naturezaOperacao, empresa);
            }
            catch (ExceptionObjNotFound ex) {
                this.logger.error(ex.getMessage());
            }
        }
        return null;
    }
}

