/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.opcoesestoque.EnumConstOpEstoqueOp;
import com.touchcomp.basementor.constants.enums.piscofins.EnumConstTipoAliquotaPisCofins;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.AliquotaSt;
import com.touchcomp.basementor.model.vo.CategoriaSt;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemUnidadeMedida;
import com.touchcomp.basementor.model.vo.LeadTimeFornProduto;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjNotFound;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacao.ExceptionParametrizacao;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.components.calculovalores.BaseCalculoValores;
import com.touchcomp.basementorservice.components.contabil.CompParametrizacaoContabilNF;
import com.touchcomp.basementorservice.components.notaterceiros.CompNotaTerceiros;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorservice.helpers.impl.modelofiscal.HelperModeloFiscal;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesestoque.HelperOpcoesEstoque;
import com.touchcomp.basementorservice.helpers.impl.produto.HelperProduto;
import com.touchcomp.basementorservice.helpers.impl.unidadefatfornecedor.HelperUnidadeFatFornecedor;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.ServiceLeadTimeFornProdutoImpl;
import com.touchcomp.basementorservice.service.impl.necessidadecompra.ServiceNecessidadeCompraImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionCFOPNotFound;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionCategoriaSTNotFound;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionParametrizacaoCtbModFiscalNotFound;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.service.impl.cotacaocompra.UtilCarregarFornecedoresCotProduto;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

public class UtilGerarCotacaoNecessidade {
    private final TLogger logger = TLogger.get(UtilGerarCotacaoNecessidade.class);

    public CotacaoCompra gerarCotacaoCompraFromNecessidade(List<HashMap> mapNecessidades, Usuario usuario, Empresa emp, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound, ExceptionDatabase {
        CotacaoCompra cotacaoCompra = this.buildCotacaoCompra(emp, usuario, opcoesCompra);
        Object observacao = "";
        HashMap<Long, String> hh = new HashMap<Long, String>();
        Short gerarObsNecessidade = opcoesCompra.getReplicarObsNecessidadeCotacao();
        Short gerarObsGrupoNecessidade = opcoesCompra.getReplicarObsGrupoNecessidadeCotacao();
        for (HashMap h : mapNecessidades) {
            NecessidadeCompra necessidadeCompra = (NecessidadeCompra)((ServiceNecessidadeCompraImpl)ConfApplicationContext.getBean(ServiceNecessidadeCompraImpl.class)).get((Serializable)((Long)h.get("idNecessidadeCompra")));
            CoreDAOFactory.getInstance().getDAONecessidadeCompra().evict(necessidadeCompra);
            if (necessidadeCompra.getObservacao() != null && gerarObsNecessidade.equals((short)1)) {
                observacao = (String)observacao + necessidadeCompra.getObservacao() + " ";
            }
            if (necessidadeCompra.getGrupoNecCompra() != null && gerarObsGrupoNecessidade.equals((short)1)) {
                hh.put(necessidadeCompra.getGrupoNecCompra().getIdentificador(), necessidadeCompra.getGrupoNecCompra().getObservacao());
            }
            List leadTimesFornecedor = (List)h.get("lead");
            if (necessidadeCompra.getItemCotacaoCompraGerada() != null) {
                throw new ExceptionService("A Necessidade de Compra " + necessidadeCompra.getIdentificador() + " j\u00e1 possui uma Cotacao de Compra gerada: " + necessidadeCompra.getItemCotacaoCompraGerada().getCotacaoCompra().getIdentificador());
            }
            this.buildItemCotacaoCompra(cotacaoCompra, necessidadeCompra, leadTimesFornecedor, opcoesCompra, empresaContabilidade, opcoesContabeis, opcoesEstoque);
            necessidadeCompra.setSituacaoNecessidadeCompra(opcoesCompra.getSituacaoNecessidadeCotacao());
        }
        Set set = hh.keySet();
        Object obsGrupoNecessidade = "";
        for (Long id : set) {
            String ob = (String)hh.get(id);
            if (ob == null) continue;
            obsGrupoNecessidade = (String)obsGrupoNecessidade + ob + " ";
        }
        new HelperCotacaoCompra().build(cotacaoCompra).definirDataMaxEntrega();
        cotacaoCompra.setObservacao(((String)observacao).trim() + " " + ((String)obsGrupoNecessidade).trim());
        return cotacaoCompra;
    }

    private CotacaoCompra buildCotacaoCompra(Empresa emp, Usuario user, OpcoesCompraSuprimentos opcoes) {
        CotacaoCompra cotacaoCompra = new CotacaoCompra();
        cotacaoCompra.setDataAtualizacao(DateUtil.toTimestamp(new Date()));
        cotacaoCompra.setDataCotacaoCompra(new Date());
        cotacaoCompra.setDataCadastro(new Date());
        cotacaoCompra.setDataPrevFinalizacao(ToolDate.nextDays((Date)cotacaoCompra.getDataCotacaoCompra(), (int)(opcoes.getDiasValidadeCotCompras() != null ? (int)opcoes.getDiasValidadeCotCompras().shortValue() : 0)));
        cotacaoCompra.setEmpresa(emp);
        cotacaoCompra.setFechada(Short.valueOf((short)0));
        cotacaoCompra.setItensCotacaoCompra(new ArrayList());
        cotacaoCompra.setUsuarioComprador(user);
        cotacaoCompra.setSituacaoCotacaoCompra(opcoes.getSituacaoCotacaoCompraCadastro());
        return cotacaoCompra;
    }

    private void buildItemCotacaoCompra(CotacaoCompra cotacaoCompra, NecessidadeCompra necessidadeCompra, List<HashMap> leadTimeFornecedor, OpcoesCompraSuprimentos opcoes, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound {
        ItemCotacaoCompra itemCotacaoCompra = this.findItemCotacaoCompra(cotacaoCompra, necessidadeCompra, leadTimeFornecedor, opcoes, empresaContabilidade, opcoesContabeis, opcoesEstoque);
        itemCotacaoCompra.getNecessidadesCompra().add(necessidadeCompra);
    }

    private ItemCotacaoCompra findItemCotacaoCompra(CotacaoCompra cotacaoCompra, NecessidadeCompra necessidadeCompra, List<HashMap> leadTimeFornecedor, OpcoesCompraSuprimentos opcoes, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis, OpcoesEstoque opcoesEstoque) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound {
        ItemCotacaoCompra itemCotacaoCompra = null;
        HelperOpcoesEstoque helper = (HelperOpcoesEstoque)Context.get(HelperOpcoesEstoque.class);
        if (ToolMethods.isAffirmative((Number)((Number)CompOpcoes.getOption((List)helper.build(opcoesEstoque).getItens(), (EnumOpDinamicasInterface)EnumConstOpEstoqueOp.UNIFICAR_ITENS_NECESSIDADE_COTACAO, Short.class)))) {
            for (ItemCotacaoCompra existentItemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
                if (!existentItemCotacaoCompra.getGradeCor().getIdentificador().equals(necessidadeCompra.getGradeCor().getIdentificador()) || necessidadeCompra.getNaturezaOperacao() != null && !Objects.equals(necessidadeCompra.getNaturezaOperacao(), existentItemCotacaoCompra.getNaturezaOperacao()) || necessidadeCompra.getCentroCusto() != null && !Objects.equals(necessidadeCompra.getCentroCusto(), existentItemCotacaoCompra.getCentroCustoReq())) continue;
                itemCotacaoCompra = existentItemCotacaoCompra;
            }
        }
        if (itemCotacaoCompra == null) {
            itemCotacaoCompra = new ItemCotacaoCompra();
            if (necessidadeCompra.getNaturezaOperacao() != null) {
                itemCotacaoCompra.setNaturezaOperacao(necessidadeCompra.getNaturezaOperacao());
            } else {
                itemCotacaoCompra.setNaturezaOperacao(opcoes.getNaturezaOperacao());
            }
            itemCotacaoCompra.setCotacaoCompra(cotacaoCompra);
            itemCotacaoCompra.setDataCadastro(cotacaoCompra.getDataCadastro());
            itemCotacaoCompra.setFatorConversao(this.getFatorConversao(necessidadeCompra.getGradeCor()));
            itemCotacaoCompra.setUnidadeMedida(this.getUnidadeMedida(necessidadeCompra.getGradeCor()));
            itemCotacaoCompra.setGradeCor(necessidadeCompra.getGradeCor());
            itemCotacaoCompra.setNecessidadesCompra(new ArrayList());
            itemCotacaoCompra.getNecessidadesCompra().add(necessidadeCompra);
            itemCotacaoCompra.setQuantidade(necessidadeCompra.getQuantidadeNecessidade());
            itemCotacaoCompra.setAtivo(necessidadeCompra.getAtivo());
            itemCotacaoCompra.setCentroCustoReq(necessidadeCompra.getCentroCusto());
            itemCotacaoCompra.setObservacao(necessidadeCompra.getObservacao());
            if (necessidadeCompra.getAquisicaoPreferencial() == 1) {
                itemCotacaoCompra.setFornecedoresItemCotacaoCompra(this.criarFornecedoresItemCotacaoCompra(itemCotacaoCompra, necessidadeCompra, necessidadeCompra.getEmpresa(), empresaContabilidade, opcoesContabeis, opcoes));
            } else if (leadTimeFornecedor != null) {
                LeadTimeFornProduto leadPref = this.getLeadTimesPreferencial(leadTimeFornecedor);
                if (leadPref != null) {
                    itemCotacaoCompra.setFornecedoresItemCotacaoCompra(this.buildFornecedorPreferencial(itemCotacaoCompra, leadPref, necessidadeCompra.getEmpresa(), empresaContabilidade, opcoesContabeis, opcoes));
                } else {
                    itemCotacaoCompra.setFornecedoresItemCotacaoCompra(this.findFornecedoresItemCotacaoCompra(itemCotacaoCompra, this.getLeadTimesSelecionados(leadTimeFornecedor), opcoes.getEmpresa(), opcoes));
                }
            }
            cotacaoCompra.getItensCotacaoCompra().add(itemCotacaoCompra);
        } else {
            itemCotacaoCompra.setQuantidade(Double.valueOf(itemCotacaoCompra.getQuantidade() + necessidadeCompra.getQuantidadeNecessidade()));
            itemCotacaoCompra.setObservacao(itemCotacaoCompra.getObservacao() + " " + necessidadeCompra.getObservacao());
        }
        necessidadeCompra.setItemCotacaoCompraGerada(itemCotacaoCompra);
        return itemCotacaoCompra;
    }

    private Double getFatorConversao(GradeCor gradeCor) {
        List itens;
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida() != null && !gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().isEmpty() && (itens = new HelperProduto().build(gradeCor.getProdutoGrade().getProduto()).getItensUnidMedidasAtivoUnProd()).size() > 0) {
            return ((ItemUnidadeMedida)itens.get(0)).getFatorConversao();
        }
        return 1.0;
    }

    private UnidadeMedida getUnidadeMedida(GradeCor gradeCor) throws ExceptionService {
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getUnidadeMedida() != null) {
            return gradeCor.getProdutoGrade().getProduto().getUnidadeMedida();
        }
        if (gradeCor.getProdutoGrade() != null && gradeCor.getProdutoGrade().getProduto() != null && gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida() != null && !gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().isEmpty()) {
            return ((ItemUnidadeMedida)gradeCor.getProdutoGrade().getProduto().getItemUnidadeMedida().get(0)).getUnidadeMedida();
        }
        throw new ExceptionService("N\u00e3o foi poss\u00edvel encontrar a unidade de medida para o produto: " + gradeCor.getProdutoGrade().getProduto().getIdentificador() + " - " + gradeCor.getProdutoGrade().getProduto().getNome());
    }

    private LeadTimeFornProduto getLeadTimesPreferencial(List<HashMap> leadTimeFornecedor) {
        for (HashMap h : leadTimeFornecedor) {
            HashMap lead = (HashMap)h.get("lead");
            LeadTimeFornProduto leadProd = (LeadTimeFornProduto)((ServiceLeadTimeFornProdutoImpl)ConfApplicationContext.getBean(ServiceLeadTimeFornProdutoImpl.class)).get((Serializable)((Long)lead.get("ID_LEAD_PRODUTO")));
            if (leadProd.getAquisicaoPreferencial() == null || leadProd.getAquisicaoPreferencial() != 1) continue;
            return leadProd;
        }
        return null;
    }

    private List<LeadTimeFornProduto> getLeadTimesSelecionados(List<HashMap> leadTimeFornecedor) {
        ArrayList<LeadTimeFornProduto> toRet = new ArrayList<LeadTimeFornProduto>();
        for (HashMap h : leadTimeFornecedor) {
            HashMap lead = (HashMap)h.get("lead");
            LeadTimeFornProduto leadProd = (LeadTimeFornProduto)((ServiceLeadTimeFornProdutoImpl)ConfApplicationContext.getBean(ServiceLeadTimeFornProdutoImpl.class)).get((Serializable)((Long)lead.get("ID_LEAD_PRODUTO")));
            Boolean cotar = (Boolean)h.get("cotar");
            if (cotar == null || !cotar.booleanValue()) continue;
            toRet.add(leadProd);
        }
        return toRet;
    }

    private List<FornecedorItemCotacaoCompra> buildFornecedorPreferencial(ItemCotacaoCompra item, LeadTimeFornProduto leadPref, Empresa emp, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound {
        LeadTimeFornProdutoInfFiscal inf = this.getInfFiscalLeadTime(leadPref);
        item.setNaturezaOperacao(inf.getNaturezaOperacao());
        FornecedorItemCotacaoCompra f = new FornecedorItemCotacaoCompra();
        f.setItemCotacaoCompra(item);
        f.setAquisicaoPreferencial(leadPref.getAquisicaoPreferencial());
        f.setCondicaoPagamentoMutante(inf.getParcelas());
        f.setCondicoesPagamento(inf.getCondicoesPagamento());
        f.setDataCadastro(new Date());
        f.setJustficativaAquisicaoPreferencial(inf.getMotivoAqPref());
        f.setModeloFiscal(inf.getModeloFiscal());
        f.setPrazoEntrega(Long.valueOf(leadPref.getLeadTime().longValue()));
        f.setSelecionado(Short.valueOf((short)1));
        f.setTipoFrete(inf.getTipoFrete());
        f.setUnidadeFaturamentoFornecedor(leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor());
        f.setValorUnitario(inf.getValorUnitNegociado());
        try {
            CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
            CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(f.getModeloFiscal(), item.getGradeCor().getProdutoGrade().getProduto(), leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor(), item.getNaturezaOperacao(), emp, leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor().getCategoriaPessoa(), opcoesContabeis);
            f.setPlanoConta(dados.getPlanoContaDeb());
            f.setPlanoContaGerencial(dados.getPcGerencial());
        }
        catch (ExceptionInvalidData | ExceptionParametrizacao ex) {
            TLogger.get(ex.getClass()).error(ex);
        }
        ArrayList<FornecedorItemCotacaoCompra> ret = new ArrayList<FornecedorItemCotacaoCompra>();
        this.setFornecedorItemCotacaoCompraLivroFiscal(f, emp, empresaContabilidade, opcoes);
        ret.add(f);
        return ret;
    }

    private LeadTimeFornProdutoInfFiscal getInfFiscalLeadTime(LeadTimeFornProduto leadPref) throws ExceptionService {
        if (leadPref.getInfFiscalLeadTime() == null || leadPref.getInfFiscalLeadTime().isEmpty()) {
            throw new ExceptionService("Foi determinado aquisi\u00e7\u00e3o preferencial para o fornecedor/produto e n\u00e3o foi definido as caracter\u00edsticas fiscais.\n" + leadPref.getLeadTimeFornecedor().getUnidadeFatFornecedor().getFornecedor().getPessoa().getNome() + " - " + leadPref.getGradeCor().getProdutoGrade().getProduto().getNome());
        }
        return (LeadTimeFornProdutoInfFiscal)leadPref.getInfFiscalLeadTime().get(0);
    }

    public void setFornecedorItemCotacaoCompraLivroFiscal(FornecedorItemCotacaoCompra f, Empresa emp, EmpresaContabilidade empresaContabilidade, OpcoesCompraSuprimentos opcoes) throws ExceptionService {
        try {
            Produto produto = f.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto();
            ModeloFiscal modeloFiscal = f.getModeloFiscal();
            FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal = new FornecedorItemCotacaoCompraLivroFiscal();
            f.setFornecedorItemCotacaoCompraLivroFiscal(itemFornCotacaoLivroFiscal);
            itemFornCotacaoLivroFiscal.setCfop(this.getCfop(f, emp));
            if (modeloFiscal.getTipoIRRF() != null && modeloFiscal.getTipoIRRF() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaIrrf(produto.getAliquotaIrrf());
                itemFornCotacaoLivroFiscal.setPercentualReducaoIrrf(produto.getPercRedIrrf());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaIrrf(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoIrrf(Double.valueOf(0.0));
            }
            if (modeloFiscal.getTipoINSS() != null && modeloFiscal.getTipoINSS() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaInss(produto.getAliquotaIrrf());
                itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoInss(produto.getPercRedIrrf());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaInss(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoBaseCalculoInss(Double.valueOf(0.0));
            }
            if (modeloFiscal.getTipoSestSenat() != null && modeloFiscal.getTipoSestSenat() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaSestSenat(produto.getPercSestSenat());
                itemFornCotacaoLivroFiscal.setPercentualReducaoSestSenat(produto.getPercRedSestSenat());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaSestSenat(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoSestSenat(Double.valueOf(0.0));
            }
            if (modeloFiscal.getTipoFunrural() != null && modeloFiscal.getTipoFunrural() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaFunrural(produto.getAliquotaFunrural());
                itemFornCotacaoLivroFiscal.setPercentualReducaoFunrural(produto.getPercRedFunrural());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaFunrural(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoFunrural(Double.valueOf(0.0));
            }
            if (modeloFiscal.getTipoLei10833() != null && modeloFiscal.getTipoLei10833() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaLei10833(produto.getAliquotaLei10833());
                itemFornCotacaoLivroFiscal.setPercentualReducaoLei10833(produto.getPercRedLei10833());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaLei10833(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoLei10833(Double.valueOf(0.0));
            }
            if (modeloFiscal.getTipoOutros() != null && modeloFiscal.getTipoOutros() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaOutros(produto.getAliquotaOutros());
                itemFornCotacaoLivroFiscal.setPercentualReducaoOutros(produto.getPercRedOutros());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaOutros(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoOutros(Double.valueOf(0.0));
            }
            if (modeloFiscal.getTipoContSoc() != null && modeloFiscal.getTipoContSoc() == 1) {
                itemFornCotacaoLivroFiscal.setAliquotaContribuicaoSocial(produto.getAliquotaContSoc());
                itemFornCotacaoLivroFiscal.setPercentualReducaoContribuicaoSocial(produto.getPercRedContSoc());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaContribuicaoSocial(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setPercentualReducaoContribuicaoSocial(Double.valueOf(0.0));
            }
            if (modeloFiscal.getIssRetido() != null && modeloFiscal.getIssRetido() != 2) {
                itemFornCotacaoLivroFiscal.setAliquotaIss(produto.getAliquotaIss());
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaIss(Double.valueOf(0.0));
            }
            if (modeloFiscal.getModeloFiscalPisCofins().getCalcularPisNormal().equals((short)1)) {
                if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    itemFornCotacaoLivroFiscal.setAliquotaPis(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPis());
                } else {
                    itemFornCotacaoLivroFiscal.setAliquotaPis(produto.getAliquotaPis());
                }
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaPis(Double.valueOf(0.0));
            }
            if (modeloFiscal.getModeloFiscalPisCofins().getCalcularPisSt().equals((short)1)) {
                if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    itemFornCotacaoLivroFiscal.setAliquotaPisSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaPisSt());
                } else {
                    itemFornCotacaoLivroFiscal.setAliquotaPisSt(produto.getAliquotaPisSt());
                }
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaPisSt(Double.valueOf(0.0));
            }
            if (modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsNormal().equals((short)1)) {
                if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofins(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    itemFornCotacaoLivroFiscal.setAliquotaCofins(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofins());
                } else {
                    itemFornCotacaoLivroFiscal.setAliquotaCofins(produto.getAliquotaCofins());
                }
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaCofins(Double.valueOf(0.0));
            }
            if (modeloFiscal.getModeloFiscalPisCofins().getCalcularCofinsSt().equals((short)1)) {
                if (ToolMethods.isEquals((Object)modeloFiscal.getModeloFiscalPisCofins().getTipoAliquotaPisCofinsSt(), (Object)EnumConstTipoAliquotaPisCofins.ALIQUOTA_INFORMADA.getValue())) {
                    itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(modeloFiscal.getModeloFiscalPisCofins().getAliquotaCofinsSt());
                } else {
                    itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(produto.getAliquotaCofins());
                }
            } else {
                itemFornCotacaoLivroFiscal.setAliquotaCofinsSt(Double.valueOf(0.0));
            }
            Double aliquotaIpi = BaseCalculoValores.getAliquotaIpi((Produto)produto, (ModeloFiscalIpi)modeloFiscal.getModeloFiscalIpi());
            itemFornCotacaoLivroFiscal.setAliquotaIpi(aliquotaIpi);
            Double alICMS = ((HelperModeloFiscal)Context.get(HelperModeloFiscal.class)).getAliquotaICMS(f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), emp.getPessoa().getEndereco().getCidade().getUf(), produto, f.getModeloFiscal());
            itemFornCotacaoLivroFiscal.setAliquotaIcms(alICMS);
            CoreUtilityFactory.getUtilityCalculosImpostosFiscaisCotacao().calcularImpostosFiscaisFornecedorItemCotacaoCompra(f, f.getUnidadeFaturamentoFornecedor(), emp.getPessoa().getEndereco().getCidade().getUf(), f.getItemCotacaoCompra().getGradeCor(), f.getItemCotacaoCompra().getQuantidade(), f.getItemCotacaoCompra().getFatorConversao(), empresaContabilidade, emp, opcoes);
            AliquotaSt aliquotaSt = null;
            try {
                if (itemFornCotacaoLivroFiscal.getCategoriaSt() != null && itemFornCotacaoLivroFiscal.getUnidadeFederativaIcmsSt() != null) {
                    aliquotaSt = this.procurarAliquotaSt(itemFornCotacaoLivroFiscal.getCategoriaSt(), itemFornCotacaoLivroFiscal.getUnidadeFederativaIcmsSt());
                } else if (modeloFiscal.getModeloFiscalIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt() != null && modeloFiscal.getModeloFiscalIcms().getIncidenciaIcms().getIcmsSt() == 1 && produto != null && produto.getCategoriaSutr() != null) {
                    aliquotaSt = this.procurarAliquotaSt(produto.getCategoriaSutr(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf());
                    itemFornCotacaoLivroFiscal.setCategoriaSt(produto.getCategoriaSutr());
                    itemFornCotacaoLivroFiscal.setUnidadeFederativaIcmsSt(f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf());
                }
                if (aliquotaSt != null) {
                    itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(aliquotaSt.getIndiceAlteracao());
                    itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(aliquotaSt.getDescontoPadrao());
                    itemFornCotacaoLivroFiscal.setAliquotaIcmsST(aliquotaSt.getAliquotaIcms());
                } else {
                    itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(Double.valueOf(0.0));
                    itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(Double.valueOf(0.0));
                    itemFornCotacaoLivroFiscal.setAliquotaIcmsST(Double.valueOf(0.0));
                }
                this.valoresDadosIcmsSt(itemFornCotacaoLivroFiscal);
            }
            catch (ExceptionService ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
                itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setAliquotaIcmsST(Double.valueOf(0.0));
            }
            catch (ExceptionCategoriaSTNotFound ex) {
                this.logger.error(ex.getClass(), (Throwable)ex);
                itemFornCotacaoLivroFiscal.setIndicadorAlteracaoIcmsST(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setDescontoPadraoIcmsST(Double.valueOf(0.0));
                itemFornCotacaoLivroFiscal.setAliquotaIcmsST(Double.valueOf(0.0));
            }
        }
        catch (ExceptionCalculoPisCofins ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService(ex.getMessage());
        }
        catch (ExceptionCalculoIPI ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService(ex.getMessage());
        }
        catch (ExceptionCalculoICMS ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService(ex.getMessage());
        }
    }

    private void valoresDadosIcmsSt(FornecedorItemCotacaoCompraLivroFiscal itemFornCotacaoLivroFiscal) {
        itemFornCotacaoLivroFiscal.setValorBaseCalculoIcmsSt(Double.valueOf(itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * itemFornCotacaoLivroFiscal.getIndicadorAlteracaoIcmsST() - itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * (itemFornCotacaoLivroFiscal.getDescontoPadraoIcmsST() / 100.0)));
        itemFornCotacaoLivroFiscal.setValorIcmsSt(Double.valueOf(itemFornCotacaoLivroFiscal.getValorBaseCalculoIcms() * (itemFornCotacaoLivroFiscal.getAliquotaIcmsST() / 100.0) - itemFornCotacaoLivroFiscal.getValorIcms()));
        if (itemFornCotacaoLivroFiscal.getValorIcmsSt() < 0.0) {
            itemFornCotacaoLivroFiscal.setValorIcmsSt(Double.valueOf(0.0));
        }
    }

    private AliquotaSt procurarAliquotaSt(CategoriaSt categoriaSt, UnidadeFederativa unidadeFederativaCliente) throws ExceptionCategoriaSTNotFound, ExceptionService {
        CoreRequestContext request = new CoreRequestContext();
        request.setAttribute("categoriaSt", categoriaSt);
        request.setAttribute("unidadeFederativa", unidadeFederativaCliente);
        AliquotaSt aliquotaSt = (AliquotaSt)CoreServiceFactory.getServiceAliquotaSt().execute(request, "procurarAliquotaSt");
        if (aliquotaSt == null) {
            throw new ExceptionCategoriaSTNotFound("Al\u00edquota de Substitui\u00e7\u00e3o Tribut\u00e1ria n\u00e3o encontrada para a Categoria " + (categoriaSt != null ? categoriaSt.getNome() : "") + " e UF " + unidadeFederativaCliente.getSigla());
        }
        return aliquotaSt;
    }

    private Cfop getCfop(FornecedorItemCotacaoCompra f, Empresa emp) throws ExceptionService {
        try {
            Cfop cfop = CoreUtilityFactory.getUtilityCFOP().findCfopEntrada(emp.getPessoa().getEndereco().getCidade().getUf(), f.getUnidadeFaturamentoFornecedor().getPessoa().getEndereco().getCidade().getUf(), f.getModeloFiscal());
            return cfop;
        }
        catch (ExceptionCFOPNotFound ex) {
            throw new ExceptionService(ex.getMessage(), ex);
        }
    }

    private List<FornecedorItemCotacaoCompra> findFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, List<LeadTimeFornProduto> leadTimesSelecionados, Empresa emp, OpcoesCompraSuprimentos opcoes) throws ExceptionService {
        return new UtilCarregarFornecedoresCotProduto().findFornecedoresItemCotacaoCompra(itemCotacaoCompra, emp, leadTimesSelecionados, opcoes);
    }

    private List<FornecedorItemCotacaoCompra> criarFornecedoresItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, NecessidadeCompra necessidadeCompra, Empresa empresa, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis, OpcoesCompraSuprimentos opcoes) throws ExceptionService, ExceptionParametrizacaoCtbModFiscalNotFound {
        ArrayList<FornecedorItemCotacaoCompra> ret = new ArrayList<FornecedorItemCotacaoCompra>();
        FornecedorItemCotacaoCompra fornecedorItemCotacao = new FornecedorItemCotacaoCompra();
        fornecedorItemCotacao.setItemCotacaoCompra(itemCotacaoCompra);
        fornecedorItemCotacao.setUnidadeFaturamentoFornecedor(necessidadeCompra.getUnidadeFatFornecedor());
        fornecedorItemCotacao.setModeloFiscal(this.findModeloFiscal(itemCotacaoCompra, necessidadeCompra, opcoes));
        try {
            CompParametrizacaoContabilNF comp = (CompParametrizacaoContabilNF)Context.get(CompParametrizacaoContabilNF.class);
            CompParametrizacaoContabilNF.DadosContas dados = comp.getPlanoContasNfTerceiros(fornecedorItemCotacao.getModeloFiscal(), itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), necessidadeCompra.getUnidadeFatFornecedor(), itemCotacaoCompra.getNaturezaOperacao(), empresa, necessidadeCompra.getUnidadeFatFornecedor().getCategoriaPessoa(), opcoesContabeis);
            fornecedorItemCotacao.setPlanoConta(dados.getPlanoContaDeb());
            fornecedorItemCotacao.setPlanoContaGerencial(dados.getPcGerencial());
        }
        catch (ExceptionInvalidData | ExceptionParametrizacao ex) {
            TLogger.get(ex.getClass()).error(ex);
        }
        fornecedorItemCotacao.setDataCadastro(new Date());
        fornecedorItemCotacao.setAquisicaoPreferencial(necessidadeCompra.getAquisicaoPreferencial());
        fornecedorItemCotacao.setMotivoAquisPref(necessidadeCompra.getMotivoAquisPref());
        fornecedorItemCotacao.setJustficativaAquisicaoPreferencial(necessidadeCompra.getMotivoAquisicaoPreferencial());
        fornecedorItemCotacao.setTipoFrete(necessidadeCompra.getTipoFrete());
        fornecedorItemCotacao.setPrazoEntrega(necessidadeCompra.getPrazoEntrega());
        fornecedorItemCotacao.setDataPrevFaturamento(necessidadeCompra.getDataPrevFaturamento());
        fornecedorItemCotacao.setCondicoesPagamento(necessidadeCompra.getCondicoesPagamento());
        fornecedorItemCotacao.setCondicaoPagamentoMutante(necessidadeCompra.getCondicaoMutante());
        if (fornecedorItemCotacao.getModeloFiscal() != null) {
            this.setFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacao, empresa, empresaContabilidade, opcoes);
        }
        fornecedorItemCotacao.setValorUnitario(necessidadeCompra.getValor());
        if (itemCotacaoCompra.getGradeCor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugCustoAutoCotCompras())) {
            fornecedorItemCotacao.setCustoMedio(CompNotaTerceiros.getCustoMedioProd((Produto)itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), (Empresa)empresa));
            fornecedorItemCotacao.setUltimoCusto(CompNotaTerceiros.getUltimoCustoProd((Produto)itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), (Empresa)empresa));
            fornecedorItemCotacao.setMenorCusto(CompNotaTerceiros.getMenorCustoProd((Produto)itemCotacaoCompra.getGradeCor().getProdutoGrade().getProduto(), (Empresa)empresa));
        }
        ret.add(fornecedorItemCotacao);
        return ret;
    }

    private ModeloFiscal findModeloFiscal(ItemCotacaoCompra itemCotacao, NecessidadeCompra necessidadeCompra, OpcoesCompraSuprimentos opcoes) {
        Produto produto = itemCotacao.getGradeCor().getProdutoGrade().getProduto();
        NaturezaOperacao naturezaOperacao = itemCotacao.getNaturezaOperacao();
        UnidadeFatFornecedor unidadeFornecedor = necessidadeCompra.getUnidadeFatFornecedor();
        Empresa empresa = itemCotacao.getCotacaoCompra().getEmpresa();
        if (naturezaOperacao != null && produto != null && unidadeFornecedor != null && unidadeFornecedor.getFornecedor() != null && !ToolMethods.isAffirmative((Number)opcoes.getNaoSugAutoModFiscalCotCompras())) {
            try {
                HelperModeloFiscal helper = (HelperModeloFiscal)ConfApplicationContext.getBean(HelperModeloFiscal.class);
                return helper.getFirst(produto, unidadeFornecedor, naturezaOperacao, empresa);
            }
            catch (ExceptionObjNotFound ex) {
                this.logger.error(ex.getMessage());
            }
        }
        return null;
    }

    private String getCNPJCPF(UnidadeFatFornecedor unidadeFornecedor) {
        return unidadeFornecedor != null && unidadeFornecedor.getFornecedor() != null && unidadeFornecedor.getFornecedor().getPessoa() != null && unidadeFornecedor.getFornecedor().getPessoa().getComplemento() != null && unidadeFornecedor.getFornecedor().getPessoa().getComplemento().getCnpj() != null ? unidadeFornecedor.getFornecedor().getPessoa().getComplemento().getCnpj() : "";
    }

    private Short getContribuinteEstado(UnidadeFatFornecedor unidade) {
        return ((HelperUnidadeFatFornecedor)Context.get(HelperUnidadeFatFornecedor.class)).build(unidade).getContribuinteEstado();
    }
}

