/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.EmailGrupoNecCompra;
import com.touchcomp.basementor.model.vo.EmailsOrdemCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.ItemOrdemCompraNecCompra;
import com.touchcomp.basementor.model.vo.NecessidadeCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.OrdemCompra;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.ordemcompra.CompLiberacaoOrdemCompra;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoDateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;

class UtilGerarOrdemCompra {
    private final TLogger logger = TLogger.get(UtilGerarOrdemCompra.class);

    UtilGerarOrdemCompra() {
    }

    List<CotacaoCompra> buildOrdensCompraFromCotacoes(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesFinanceiras op, OpcoesGerenciais opcoesGerenciais, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionService {
        try {
            LinkedList<CotacaoCompra> toRet = new LinkedList<CotacaoCompra>();
            this.selectBestFornecedor(cotacoes, opcoes);
            for (CotacaoCompra cotacaoCompra : cotacoes) {
                ArrayList<OrdemCompra> ordensCompra = new ArrayList<OrdemCompra>();
                if (cotacaoCompra.getOrdensCompra() != null && !cotacaoCompra.getOrdensCompra().isEmpty()) {
                    throw new ExceptionService("N\u00e3o foi poss\u00edvel gerar as Ordens de Compra para a cota\u00e7\u00e3o: " + cotacaoCompra.getIdentificador() + " pois a mesma j\u00e1 possui Ordens de Compra! \n");
                }
                this.buildOrdensCompraFromCotacaoInternal(ordensCompra, cotacaoCompra, user, emp, opcoes, empresaContabilidade, opcoesGerenciais);
                this.calcularTotalizadoresOrdensCompra(ordensCompra, op);
                cotacaoCompra.setOrdensCompra(ordensCompra);
                this.gerarLiberacaoOrdensCompra(ordensCompra, opcoesContabeis, user);
                this.closeCotacoesCompra(cotacoes, opcoes);
                this.setSituacaoNecessidadeCompra(cotacoes, opcoes);
                toRet.add((CotacaoCompra)CoreDAOFactory.getInstance().getDAOCotacaoCompra().saveOrUpdate(cotacaoCompra));
            }
            return toRet;
        }
        catch (Exception ex) {
            for (CotacaoCompra cot : cotacoes) {
                cot.getOrdensCompra().clear();
            }
            throw new ExceptionService(ex.getMessage(), ex);
        }
    }

    private void buildOrdensCompraFromCotacaoInternal(List<OrdemCompra> ordensCompra, CotacaoCompra cotacaoCompra, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade, OpcoesGerenciais opcoesGerenciais) throws ExceptionService {
        for (ItemCotacaoCompra itemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
            if (!ToolMethods.isEquals((Object)itemCotacaoCompra.getNaoGerarOC(), (Object)0)) continue;
            if (ToolMethods.isEquals((Object)opcoesGerenciais, null) || ToolMethods.isEquals((Object)opcoesGerenciais.getObrigarInfCCCotCompraOrdCompra(), (Object)0) || itemCotacaoCompra.getCentroCustoReq() != null) {
                this.buildOrdensCompraFromItemCotacaoInternal(ordensCompra, itemCotacaoCompra, user, emp, opcoesCompra, empresaContabilidade);
                continue;
            }
            throw new ExceptionService("N\u00e3o foi poss\u00edvel gerar as Ordens de Compra para a cota\u00e7\u00e3o: " + cotacaoCompra.getIdentificador() + ", pois n\u00e3o foi definido Centro de Custo para o item: " + itemCotacaoCompra.getIdentificador() + "!");
        }
    }

    private void buildOrdensCompraFromItemCotacaoInternal(List<OrdemCompra> ordensCompra, ItemCotacaoCompra itemCotacaoCompra, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade) throws ExceptionService {
        for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
            if (fornecedorItemCotacaoCompra.getSelecionado() == null || fornecedorItemCotacaoCompra.getSelecionado() != 1) continue;
            this.buildOrdemCompraFromFornecedorCotacaoInternal(ordensCompra, fornecedorItemCotacaoCompra, user, emp, opcoesCompra, empresaContabilidade);
        }
    }

    private void buildOrdemCompraFromFornecedorCotacaoInternal(List<OrdemCompra> ordensCompra, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra, EmpresaContabilidade empresaContabilidade) throws ExceptionService {
        try {
            OrdemCompra ordemCompra = this.getOrdemCompraFornecedor(ordensCompra, fornecedorItemCotacaoCompra, user, emp, opcoesCompra);
            this.buildItemOrdemCompra(ordemCompra, fornecedorItemCotacaoCompra);
            CoreUtilityFactory.getUtilityOrdemCompra().calcularImpostosFiscaisItOrdemCompra(ordemCompra.getItemOrdemCompra(), ordemCompra.getUnidadeFatFornecedor(), ordemCompra.getEmpresa().getPessoa().getEndereco().getCidade().getUf(), empresaContabilidade);
            this.setPrazoMaximoEntItens(ordemCompra, opcoesCompra);
            this.setarNrSequencial(ordemCompra.getItemOrdemCompra(), opcoesCompra);
            this.setarEmailsOrdemCompra(ordemCompra);
            this.setarObservacaoOrdemCompra(ordemCompra);
        }
        catch (Exception ex) {
            this.logger.error(ex.getClass(), (Throwable)ex);
            throw new ExceptionService(ex.getMessage(), ex);
        }
    }

    private void setPrazoMaximoEntItens(OrdemCompra vo, OpcoesCompraSuprimentos opCompra) {
        Long value = 0L;
        for (ItemOrdemCompra item : vo.getItemOrdemCompra()) {
            if (item.getPrazoEntrega() == null || item.getPrazoEntrega() <= value) continue;
            value = item.getPrazoEntrega();
        }
        vo.setPrazoMaxEntregaItens(value);
        if (ToolMethods.isEquals((Object)opCompra.getUsarDtEmissaoPrevChegada(), (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Long qtd = ToolDate.difBetweenDatesInDays((Date)vo.getDataPrevChegada(), (Date)vo.getDataEmissao());
            vo.setPrazoEntrega(Math.abs(qtd) + " Dia(s)");
        }
    }

    private OrdemCompra getOrdemCompraFornecedor(List<OrdemCompra> ordensCompra, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Usuario user, Empresa emp, OpcoesCompraSuprimentos opcoesCompra) {
        for (OrdemCompra ordemCompra : ordensCompra) {
            if (!ordemCompra.getUnidadeFatFornecedor().equals((Object)fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor())) continue;
            return ordemCompra;
        }
        return this.buildOrdemCompraFornecedor(ordensCompra, fornecedorItemCotacaoCompra, emp, user, opcoesCompra);
    }

    private OrdemCompra buildOrdemCompraFornecedor(List<OrdemCompra> ordensCompra, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, Empresa empresa, Usuario user, OpcoesCompraSuprimentos opcoesCompra) {
        OrdemCompra ordemCompra = new OrdemCompra();
        ordemCompra.setStatusOrdemCompra(opcoesCompra.getStatusOCGerada());
        ordemCompra.setClassificacaoOC(opcoesCompra.getClassificacaoGerarOC());
        ordemCompra.setParcelas(fornecedorItemCotacaoCompra.getCondicaoPagamentoMutante());
        ordemCompra.setPrazoEntrega(fornecedorItemCotacaoCompra.getPrazoEntrega() + " dia(s)");
        ordemCompra.setDataEmissao(new Date());
        ordemCompra.setDataCadastro(new Date());
        ordemCompra.setDataAtualizacao(DateUtil.toTimestamp(new Date()));
        ordemCompra.setUsuario(user);
        ordemCompra.setEmpresa(empresa);
        ordemCompra.setCotacaoCompra(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra());
        ordemCompra.setTipoFrete(fornecedorItemCotacaoCompra.getTipoFrete());
        ordemCompra.setCondicaoPagamento(fornecedorItemCotacaoCompra.getCondicoesPagamento());
        ordemCompra.setMeioPagamento(ordemCompra.getCondicaoPagamento() != null ? ordemCompra.getCondicaoPagamento().getMeioPagamento() : null);
        ordemCompra.setUnidadeFatFornecedor(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor());
        ordemCompra.setItemOrdemCompra(new ArrayList());
        ordemCompra.setObservacoes(new ArrayList());
        ordemCompra.setPessoaContato(fornecedorItemCotacaoCompra.getPessoaContato());
        ordensCompra.add(ordemCompra);
        return ordemCompra;
    }

    private void buildItemOrdemCompra(OrdemCompra ordemCompra, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        ItemOrdemCompra itemOrdemCompra = new ItemOrdemCompra();
        itemOrdemCompra.setFechado(Short.valueOf((short)0));
        itemOrdemCompra.setValorUnitario(fornecedorItemCotacaoCompra.getValorUnitario());
        itemOrdemCompra.setValorDesconto(fornecedorItemCotacaoCompra.getValorDesconto());
        itemOrdemCompra.setValorFrete(fornecedorItemCotacaoCompra.getValorFrete());
        itemOrdemCompra.setVrSeguro(fornecedorItemCotacaoCompra.getValorSeguro());
        itemOrdemCompra.setValorDespAcessoria(fornecedorItemCotacaoCompra.getValorDespesasAcessorias());
        itemOrdemCompra.setVrProduto(Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade()));
        itemOrdemCompra.setVrServico(Double.valueOf(0.0));
        itemOrdemCompra.setValorAgregado(Double.valueOf(0.0));
        itemOrdemCompra.setQuantidadeTotal(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade());
        itemOrdemCompra.setFatorConversao(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getFatorConversao());
        itemOrdemCompra.setProduto(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor().getProdutoGrade().getProduto());
        itemOrdemCompra.setPlanoContaDeb(fornecedorItemCotacaoCompra.getPlanoConta());
        itemOrdemCompra.setMarca(fornecedorItemCotacaoCompra.getMarca());
        itemOrdemCompra.setPrazoEntrega(fornecedorItemCotacaoCompra.getPrazoEntrega());
        itemOrdemCompra.setOrdemCompra(ordemCompra);
        itemOrdemCompra.setModeloFiscal(fornecedorItemCotacaoCompra.getModeloFiscal());
        itemOrdemCompra.setUnidadeMedida(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getUnidadeMedida());
        itemOrdemCompra.setNaturezaOperacao(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNaturezaOperacao());
        itemOrdemCompra.setPlanoContaGerencial(fornecedorItemCotacaoCompra.getPlanoContaGerencial());
        itemOrdemCompra.setGradeItemOrdemCompra(this.buildGradeItemOrdemCompra(itemOrdemCompra, fornecedorItemCotacaoCompra));
        itemOrdemCompra.setItemOrdemCompraLF(this.buildItemordemCompraLivroFiscal(itemOrdemCompra, fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal()));
        itemOrdemCompra.setAtivo(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getAtivo());
        itemOrdemCompra.setCentroCustoReq(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCentroCustoReq());
        itemOrdemCompra.setNaturezaRequisicao(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNaturezaRequisicao());
        itemOrdemCompra.setGerarReqLancarNota(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGerarReqLancarNota());
        itemOrdemCompra.setObservacoes(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getObservacao());
        if (ToolMethods.isNull((Object)ordemCompra.getDataPrevFaturamento()).booleanValue()) {
            if (fornecedorItemCotacaoCompra.getDataPrevFaturamento().after(new Date())) {
                ordemCompra.setDataPrevFaturamento(fornecedorItemCotacaoCompra.getDataPrevFaturamento());
            } else {
                ordemCompra.setDataPrevFaturamento(new Date());
            }
        } else if (ToolMethods.isNotNull((Object)ordemCompra.getDataPrevFaturamento()).booleanValue() && fornecedorItemCotacaoCompra.getDataPrevFaturamento().after(ordemCompra.getDataPrevFaturamento())) {
            ordemCompra.setDataPrevFaturamento(fornecedorItemCotacaoCompra.getDataPrevFaturamento());
        }
        ordemCompra.setDataPrevChegada(fornecedorItemCotacaoCompra.getPrazoEntrega() != null ? ContatoDateUtil.nextPreviousDays((Date)ordemCompra.getDataPrevFaturamento(), (int)fornecedorItemCotacaoCompra.getPrazoEntrega().intValue()) : null);
        if (fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNecessidadesCompra() != null) {
            fornecedorItemCotacaoCompra.getItemCotacaoCompra().getNecessidadesCompra().forEach(n -> {
                Predicate<ItemOrdemCompraNecCompra> p2 = e -> e.getNecessidadeCompra().equals(n);
                if (!itemOrdemCompra.getItemOrdemCompraNecCompra().stream().anyMatch(p2)) {
                    ItemOrdemCompraNecCompra i = new ItemOrdemCompraNecCompra();
                    i.setItemOrdemCompra(itemOrdemCompra);
                    i.setNecessidadeCompra(n);
                    itemOrdemCompra.getItemOrdemCompraNecCompra().add(i);
                }
            });
        }
        itemOrdemCompra.setValorUnitarioMoeda(fornecedorItemCotacaoCompra.getValorUnitarioMoeda());
        itemOrdemCompra.setCotacaoMoeda(fornecedorItemCotacaoCompra.getCotacaoMoeda());
        itemOrdemCompra.setMoeda(fornecedorItemCotacaoCompra.getMoeda());
        ordemCompra.getItemOrdemCompra().add(itemOrdemCompra);
    }

    private List<GradeItemOrdemCompra> buildGradeItemOrdemCompra(ItemOrdemCompra itemOrdemCompra, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        ArrayList<GradeItemOrdemCompra> ret = new ArrayList<GradeItemOrdemCompra>();
        GradeItemOrdemCompra gradeItemOrdemCompra = new GradeItemOrdemCompra();
        gradeItemOrdemCompra.setGradeCor(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor());
        gradeItemOrdemCompra.setItemOrdemCompra(itemOrdemCompra);
        gradeItemOrdemCompra.setQuantidade(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade());
        ret.add(gradeItemOrdemCompra);
        return ret;
    }

    private ItemOrdemCompraLivroFiscal buildItemordemCompraLivroFiscal(ItemOrdemCompra itemOrdemCompra, FornecedorItemCotacaoCompraLivroFiscal livroFiscal) {
        ItemOrdemCompraLivroFiscal itemOrdemCompraLivroFiscal;
        ItemOrdemCompraLivroFiscal itemOrdemCompraLivroFiscal2 = itemOrdemCompraLivroFiscal = itemOrdemCompra.getItemOrdemCompraLF() != null ? itemOrdemCompra.getItemOrdemCompraLF() : new ItemOrdemCompraLivroFiscal();
        if (livroFiscal != null) {
            itemOrdemCompraLivroFiscal.setAliquotaIcms(livroFiscal.getAliquotaIcms());
            itemOrdemCompraLivroFiscal.setAliquotaFunrural(livroFiscal.getAliquotaFunrural());
            itemOrdemCompraLivroFiscal.setAliquotaContSoc(livroFiscal.getAliquotaContribuicaoSocial());
            itemOrdemCompraLivroFiscal.setAliquotaInss(livroFiscal.getAliquotaInss());
            itemOrdemCompraLivroFiscal.setAliquotaIrrf(livroFiscal.getAliquotaIrrf());
            itemOrdemCompraLivroFiscal.setAliquotaIss(livroFiscal.getAliquotaIss());
            itemOrdemCompraLivroFiscal.setAliquotaLei10833(livroFiscal.getAliquotaLei10833());
            itemOrdemCompraLivroFiscal.setAliquotaOutros(livroFiscal.getAliquotaOutros());
            itemOrdemCompraLivroFiscal.setAliquotaCofins(livroFiscal.getAliquotaCofins());
            itemOrdemCompraLivroFiscal.setAliquotaPis(livroFiscal.getAliquotaPis());
            itemOrdemCompraLivroFiscal.setAliquotaCofinsSt(livroFiscal.getAliquotaCofinsSt());
            itemOrdemCompraLivroFiscal.setAliquotaPisSt(livroFiscal.getAliquotaPisSt());
            itemOrdemCompraLivroFiscal.setAliquotaIpi(livroFiscal.getAliquotaIpi());
            itemOrdemCompraLivroFiscal.setVrContSoc(livroFiscal.getValorContribuicaoSocial());
            itemOrdemCompraLivroFiscal.setCfop(livroFiscal.getCfop());
            itemOrdemCompraLivroFiscal.setIndPeriodoApuracao(Double.valueOf(0.0));
            itemOrdemCompraLivroFiscal.setValorTotal(livroFiscal.getValorTotal());
            itemOrdemCompraLivroFiscal.setVrBcCalculoIcmsSt(livroFiscal.getValorBaseCalculoIcmsSt());
            itemOrdemCompraLivroFiscal.setVrDespAduaneira(livroFiscal.getValorDespesaAduaneira());
            itemOrdemCompraLivroFiscal.setPercReducaoBCIcms(livroFiscal.getPercentualReducaoBaseCalculoIcms());
            itemOrdemCompraLivroFiscal.setVrDifAliquota(livroFiscal.getValorDiferencaAliquota());
            itemOrdemCompraLivroFiscal.setVrFunrural(livroFiscal.getValorFunrural());
            itemOrdemCompraLivroFiscal.setVrIcms(livroFiscal.getValorIcms());
            itemOrdemCompraLivroFiscal.setVrIcmsIsento(livroFiscal.getValorIcmsIsento());
            itemOrdemCompraLivroFiscal.setVrIcmsOutros(livroFiscal.getValorIcmsOutros());
            itemOrdemCompraLivroFiscal.setVrIcmsSemAprov(livroFiscal.getValorIcmsSemAproveitamento());
            itemOrdemCompraLivroFiscal.setVrIcmsTributado(livroFiscal.getValorIcmsTributado());
            itemOrdemCompraLivroFiscal.setValorIcmsSimples(livroFiscal.getValorIcmsSimples());
            itemOrdemCompraLivroFiscal.setAliquotaIcmsSimples(livroFiscal.getAliquotaIcmsSimples());
            itemOrdemCompraLivroFiscal.setVrImpostoImportacao(livroFiscal.getValorImpostoImportacao());
            itemOrdemCompraLivroFiscal.setVrInss(livroFiscal.getValorInss());
            itemOrdemCompraLivroFiscal.setVrIof(livroFiscal.getValorIof());
            itemOrdemCompraLivroFiscal.setVrIpiComercio(livroFiscal.getValorIpiComercio());
            itemOrdemCompraLivroFiscal.setVrIpiIndustria(livroFiscal.getValorIpiIndustria());
            itemOrdemCompraLivroFiscal.setVrIpiIsento(livroFiscal.getValorIpiIsento());
            itemOrdemCompraLivroFiscal.setVrIpiObservacao(livroFiscal.getValorIpiObservacao());
            itemOrdemCompraLivroFiscal.setVrIpiOutros(livroFiscal.getValorIpiOutros());
            itemOrdemCompraLivroFiscal.setVrIrrf(livroFiscal.getValorIrrf());
            itemOrdemCompraLivroFiscal.setVrIss(livroFiscal.getValorIss());
            itemOrdemCompraLivroFiscal.setVrLei10833(livroFiscal.getValorLei10833());
            itemOrdemCompraLivroFiscal.setVrOutros(livroFiscal.getValorOutros());
            itemOrdemCompraLivroFiscal.setVrIcmsSt(livroFiscal.getValorIcmsSt());
            itemOrdemCompraLivroFiscal.setVrIpiTributado(livroFiscal.getValorIpiTributado());
            itemOrdemCompraLivroFiscal.setVrBcCalculoIcmsSt(livroFiscal.getValorBaseCalculoIcmsSt());
            itemOrdemCompraLivroFiscal.setVrBcCalculoIcms(livroFiscal.getValorBaseCalculoIcms());
            itemOrdemCompraLivroFiscal.setAliquotaSestSenat(livroFiscal.getAliquotaSestSenat());
            itemOrdemCompraLivroFiscal.setPercRedSestSenat(livroFiscal.getPercentualReducaoSestSenat());
            itemOrdemCompraLivroFiscal.setPercRedBcInss(livroFiscal.getPercentualReducaoBaseCalculoInss());
            itemOrdemCompraLivroFiscal.setValorSestSenat(livroFiscal.getValorSestSenat());
            itemOrdemCompraLivroFiscal.setVrPis(livroFiscal.getValorPis());
            itemOrdemCompraLivroFiscal.setVrCofins(livroFiscal.getValorCofins());
            itemOrdemCompraLivroFiscal.setVrPisSt(livroFiscal.getValorPisSt());
            itemOrdemCompraLivroFiscal.setVrCofinsSt(livroFiscal.getValorCofinsSt());
            itemOrdemCompraLivroFiscal.setIndiceAlteracaoIcmsST(livroFiscal.getIndicadorAlteracaoIcmsST());
            itemOrdemCompraLivroFiscal.setDescontoPadraoIcmsST(livroFiscal.getDescontoPadraoIcmsST());
            itemOrdemCompraLivroFiscal.setAliquotaIcmsST(livroFiscal.getAliquotaIcmsST());
            itemOrdemCompraLivroFiscal.setModalidadeIcmsSt(livroFiscal.getModalidadeIcmsSt());
            itemOrdemCompraLivroFiscal.setUfIcmsSt(livroFiscal.getUnidadeFederativaIcmsSt());
            itemOrdemCompraLivroFiscal.setCategoriaSt(livroFiscal.getCategoriaSt());
            itemOrdemCompraLivroFiscal.setPercRedContSoc(livroFiscal.getPercentualReducaoContribuicaoSocial());
            itemOrdemCompraLivroFiscal.setPercRedFunrural(livroFiscal.getPercentualReducaoFunrural());
            itemOrdemCompraLivroFiscal.setPercRedIrrf(livroFiscal.getPercentualReducaoIrrf());
            itemOrdemCompraLivroFiscal.setPercRedLei10833(livroFiscal.getPercentualReducaoLei10833());
            itemOrdemCompraLivroFiscal.setPercRedOutros(livroFiscal.getPercentualReducaoOutros());
            itemOrdemCompraLivroFiscal.setCalcularIcmsST(livroFiscal.getCalcularIcmsST());
            itemOrdemCompraLivroFiscal.setVrBCCofins(livroFiscal.getValorBaseCalculoCofins());
            itemOrdemCompraLivroFiscal.setVrBCCofinsSt(livroFiscal.getValorBaseCalculoCofinsSt());
            itemOrdemCompraLivroFiscal.setVrBCPis(livroFiscal.getValorBaseCalculoPis());
            itemOrdemCompraLivroFiscal.setVrBCPisSt(livroFiscal.getValorBaseCalculoPisSt());
        }
        return itemOrdemCompraLivroFiscal;
    }

    private void calcularTotalizadoresOrdensCompra(List<OrdemCompra> ordensCompra, OpcoesFinanceiras op) throws ExceptionService {
        for (OrdemCompra ordemCompra : ordensCompra) {
            Double valorProduto = 0.0;
            Double valorServico = 0.0;
            Double valorFrete = 0.0;
            Double valorSeguro = 0.0;
            Double valorDesconto = 0.0;
            Double valorDespAcessoria = 0.0;
            Double BaseCalculoICMS = 0.0;
            Double valorIcms = 0.0;
            Double BaseCalculoIss = 0.0;
            Double valorIss = 0.0;
            Double BaseCalculoICMST = 0.0;
            Double valorICMST = 0.0;
            Double BaseCalculoIPI = 0.0;
            Double valorIpiObservacao = 0.0;
            Double valorLei10833 = 0.0;
            Double valorOutros = 0.0;
            Double valorFunrural = 0.0;
            Double valorIRRF = 0.0;
            Double valorInss = 0.0;
            Double valorTotal = 0.0;
            Double valorIcmsIsento = 0.0;
            Double valorIcmsOutros = 0.0;
            Double valorIpiOutros = 0.0;
            Double valorIpiIsento = 0.0;
            Double valorPis = 0.0;
            Double valorContSocial = 0.0;
            Double valorCofins = 0.0;
            Double valorIcmsSA = 0.0;
            Double valorIpiIndustria = 0.0;
            Double valorIpiTributado = 0.0;
            Double valorSestSenat = 0.0;
            for (ItemOrdemCompra itemOrdemCompra : ordemCompra.getItemOrdemCompra()) {
                valorProduto = valorProduto + itemOrdemCompra.getVrProduto();
                valorServico = valorServico + itemOrdemCompra.getVrServico();
                valorFrete = valorFrete + itemOrdemCompra.getValorFrete();
                valorSeguro = valorSeguro + itemOrdemCompra.getVrSeguro();
                valorDesconto = valorDesconto + itemOrdemCompra.getValorDesconto();
                valorDespAcessoria = valorDespAcessoria + itemOrdemCompra.getValorDespAcessoria();
                BaseCalculoICMS = BaseCalculoICMS + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsTributado();
                valorIcms = valorIcms + itemOrdemCompra.getItemOrdemCompraLF().getVrIcms();
                valorIcmsSA = valorIcmsSA + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsSemAprov();
                valorIcmsOutros = valorIcmsOutros + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsOutros();
                BaseCalculoICMST = BaseCalculoICMST + itemOrdemCompra.getItemOrdemCompraLF().getVrBcCalculoIcmsSt();
                valorICMST = valorICMST + itemOrdemCompra.getItemOrdemCompraLF().getVrIcmsSt();
                BaseCalculoIPI = BaseCalculoIPI + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiTributado();
                valorIpiObservacao = valorIpiObservacao + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiObservacao();
                valorIpiIsento = valorIpiIsento + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiIsento();
                valorIpiIndustria = valorIpiIndustria + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiIndustria();
                valorIpiOutros = valorIpiOutros + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiOutros();
                valorIpiTributado = valorIpiTributado + itemOrdemCompra.getItemOrdemCompraLF().getVrIpiTributado();
                valorIRRF = valorIRRF + itemOrdemCompra.getItemOrdemCompraLF().getVrIrrf();
                valorInss = valorInss + itemOrdemCompra.getItemOrdemCompraLF().getVrInss();
                valorIss = valorIss + itemOrdemCompra.getItemOrdemCompraLF().getVrIss();
                valorTotal = valorTotal + itemOrdemCompra.getItemOrdemCompraLF().getValorTotal();
                valorLei10833 = valorLei10833 + itemOrdemCompra.getItemOrdemCompraLF().getVrLei10833();
                valorFunrural = valorFunrural + itemOrdemCompra.getItemOrdemCompraLF().getVrFunrural();
                valorOutros = valorOutros + itemOrdemCompra.getItemOrdemCompraLF().getVrOutros();
                if (itemOrdemCompra.getItemOrdemCompraLF().getVrCofins() != null) {
                    valorCofins = valorCofins + itemOrdemCompra.getItemOrdemCompraLF().getVrCofins();
                }
                if (itemOrdemCompra.getItemOrdemCompraLF().getVrPis() != null) {
                    valorPis = valorPis + itemOrdemCompra.getItemOrdemCompraLF().getVrPis();
                }
                if (itemOrdemCompra.getItemOrdemCompraLF().getVrContSoc() != null) {
                    valorContSocial = valorContSocial + itemOrdemCompra.getItemOrdemCompraLF().getVrContSoc();
                }
                if (itemOrdemCompra.getItemOrdemCompraLF().getValorSestSenat() == null) continue;
                valorSestSenat = valorSestSenat + itemOrdemCompra.getItemOrdemCompraLF().getValorSestSenat();
            }
            ordemCompra.setValorPis(valorPis);
            ordemCompra.setValorSestSenat(valorSestSenat);
            ordemCompra.setValorCofins(valorCofins);
            ordemCompra.setValorContSoc(valorContSocial);
            ordemCompra.setValorIcmsSa(valorIcmsSA);
            ordemCompra.setValorProduto(valorProduto);
            ordemCompra.setValorServico(valorServico);
            ordemCompra.setValorFrete(valorFrete);
            ordemCompra.setValorSeguro(valorSeguro);
            ordemCompra.setValorDesconto(valorDesconto);
            ordemCompra.setValorDespAcess(valorDespAcessoria);
            ordemCompra.setValorIcms(valorIcms);
            ordemCompra.setValorIss(valorIss);
            ordemCompra.setValorIcmsSt(valorICMST);
            ordemCompra.setValorIpiObservacao(valorIpiObservacao);
            ordemCompra.setValorIrrf(valorIRRF);
            ordemCompra.setValorInss(valorInss);
            ordemCompra.setValorTotal(valorTotal);
            ordemCompra.setValorIpiIndustria(valorIpiIndustria);
            ordemCompra.setValorIpiIsento(valorIpiIsento);
            ordemCompra.setValorIpiOutros(valorIpiOutros);
            ordemCompra.setBcIcmsSt(BaseCalculoICMST);
            ordemCompra.setValorIcmsTributado(BaseCalculoICMS);
            ordemCompra.setValorIcmsIsento(valorIcmsIsento);
            ordemCompra.setValorIcmsOutros(valorIcmsOutros);
            ordemCompra.setValorFunrural(valorFunrural);
            ordemCompra.setValorOutros(valorOutros);
            ordemCompra.setValorLei10833(valorLei10833);
            ordemCompra.setValorIpiTributado(valorIpiTributado);
        }
    }

    private void gerarLiberacaoOrdensCompra(List<OrdemCompra> ordensCompra, OpcoesContabeis opcoes, Usuario user) throws ExceptionTitulo, ExceptionInvalidData {
        CompLiberacaoOrdemCompra compLibOC = (CompLiberacaoOrdemCompra)ConfApplicationContext.getBean(CompLiberacaoOrdemCompra.class);
        for (OrdemCompra ordemCompra : ordensCompra) {
            compLibOC.avaliarOC(ordemCompra, user, opcoes);
        }
    }

    private void selectBestFornecedor(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoesCompra) throws ExceptionService {
        for (CotacaoCompra cot : cotacoes) {
            this.selectBestFornecedor(cot, opcoesCompra);
        }
    }

    private void selectBestFornecedor(CotacaoCompra cotacao, OpcoesCompraSuprimentos opcoesCompra) throws ExceptionService {
        ((HelperCotacaoCompra)Context.get(HelperCotacaoCompra.class)).avaliaMelhorFornecedor(cotacao, opcoesCompra);
    }

    private List<CotacaoCompra> closeCotacoesCompra(List<CotacaoCompra> cotacoesCompra, OpcoesCompraSuprimentos opcoesCompraSup) throws ExceptionService {
        ArrayList<CotacaoCompra> cotacoes = new ArrayList<CotacaoCompra>();
        for (CotacaoCompra cotacaoCompra : cotacoesCompra) {
            cotacaoCompra.setFechada(this.isCotacaoCompraFechada(cotacaoCompra));
            if (cotacaoCompra.getFechada() == 1) {
                cotacaoCompra.setSituacaoCotacaoCompra(opcoesCompraSup.getSituacaoCotacaoCompraGerarOC());
                cotacaoCompra.setDataFinalizacao(new Date());
            }
            cotacoes.add(cotacaoCompra);
        }
        return cotacoes;
    }

    private Short isCotacaoCompraFechada(CotacaoCompra cotacaoCompra) {
        if (cotacaoCompra.getOrdensCompra() != null && !cotacaoCompra.getOrdensCompra().isEmpty()) {
            return (short)1;
        }
        return (short)0;
    }

    List<CotacaoCompra> preGeracaoOrdensCompraFromCotacoes(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoes, Usuario user, Empresa emp, OpcoesFinanceiras op, OpcoesGerenciais opcoesGerenciais, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opcoesContabeis) throws ExceptionService, ExceptionTitulo, ExceptionInvalidData {
        LinkedList<CotacaoCompra> toRet = new LinkedList<CotacaoCompra>();
        this.selectBestFornecedor(cotacoes, opcoes);
        for (CotacaoCompra cotacaoCompra : cotacoes) {
            try {
                ArrayList<OrdemCompra> ordensCompra = new ArrayList<OrdemCompra>();
                if (cotacaoCompra.getOrdensCompra() != null && !cotacaoCompra.getOrdensCompra().isEmpty()) {
                    throw new ExceptionService("N\u00e3o foi poss\u00edvel gerar as Ordens de Compra para a cota\u00e7\u00e3o: " + cotacaoCompra.getIdentificador() + " pois a mesma j\u00e1 possui Ordens de Compra!");
                }
                this.buildOrdensCompraFromCotacaoInternal(ordensCompra, cotacaoCompra, user, emp, opcoes, empresaContabilidade, opcoesGerenciais);
                this.calcularTotalizadoresOrdensCompra(ordensCompra, op);
                cotacaoCompra.setOrdensCompra(ordensCompra);
                this.gerarLiberacaoOrdensCompra(ordensCompra, opcoesContabeis, user);
                toRet.add(cotacaoCompra);
            }
            catch (ExceptionInvalidData ex) {
                Logger.getLogger(UtilGerarOrdemCompra.class.getName()).log(Level.SEVERE, null, ex);
                throw new ExceptionService(ex.getMessage(), ex);
            }
        }
        return toRet;
    }

    public void setarNrSequencial(List<ItemOrdemCompra> itens, OpcoesCompraSuprimentos opcoesCompra) {
        block3: {
            block2: {
                if (opcoesCompra.getAlterarNrSeqItemCompraNaEdicao() != 1) break block2;
                int i = 1;
                for (ItemOrdemCompra it : itens) {
                    it.setNrSequencial(Integer.valueOf(i));
                    ++i;
                }
                break block3;
            }
            Boolean existeItensNaoSalvos = this.existeItensOrdemCompraNaoSalvos(itens);
            if (!existeItensNaoSalvos.booleanValue()) break block3;
            int maiorNrSeq = this.getMaiorNrSequencialItemPedido(itens);
            for (ItemOrdemCompra item : itens) {
                if (item.getIdentificador() != null || item.getNrSequencial() != null && item.getNrSequencial() != 0) continue;
                item.setNrSequencial(Integer.valueOf(++maiorNrSeq));
            }
        }
    }

    private Boolean existeItensOrdemCompraNaoSalvos(List<ItemOrdemCompra> itens) {
        for (ItemOrdemCompra item : itens) {
            if (item.getIdentificador() != null) continue;
            return true;
        }
        return false;
    }

    private int getMaiorNrSequencialItemPedido(List<ItemOrdemCompra> itens) {
        int nrSeq = 0;
        for (ItemOrdemCompra item : itens) {
            if (item.getNrSequencial() == null || item.getNrSequencial() <= nrSeq) continue;
            nrSeq = item.getNrSequencial();
        }
        return nrSeq;
    }

    private void setarEmailsOrdemCompra(OrdemCompra ordemCompra) {
        ordemCompra.getItemOrdemCompra().forEach(i -> this.buscarNecessidadesDuplicados(ordemCompra, i.getItemOrdemCompraNecCompra()));
    }

    private void buscarNecessidadesDuplicados(OrdemCompra ordemCompra, List<ItemOrdemCompraNecCompra> itemOrdemCompraNecCompra) {
        itemOrdemCompraNecCompra.forEach(i -> this.verificarEmailsDuplicados(ordemCompra, i.getNecessidadeCompra().getEmailGrupoNecCompra()));
    }

    private void verificarEmailsDuplicados(OrdemCompra ordemCompra, List<EmailGrupoNecCompra> emailGrupoNecCompra) {
        emailGrupoNecCompra.forEach(eg -> {
            Predicate<EmailsOrdemCompra> p2 = e -> e.getEmail().equals(eg.getEmail());
            if (!ordemCompra.getEmailsOrdemCompra().stream().anyMatch(p2)) {
                EmailsOrdemCompra o = new EmailsOrdemCompra();
                o.setOrdemCompra(ordemCompra);
                o.setEmail(eg.getEmail());
                ordemCompra.getEmailsOrdemCompra().add(o);
            }
        });
    }

    private void setarObservacaoOrdemCompra(OrdemCompra ordemCompra) {
        if (ordemCompra.getCotacaoCompra() != null) {
            ordemCompra.setObservacao(ordemCompra.getCotacaoCompra().getObservacao());
        }
    }

    private void setSituacaoNecessidadeCompra(List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoes) {
        for (CotacaoCompra c : cotacoes) {
            for (ItemCotacaoCompra item : c.getItensCotacaoCompra()) {
                if (item.getNecessidadesCompra() == null) continue;
                for (NecessidadeCompra necessidadeCompra : item.getNecessidadesCompra()) {
                    necessidadeCompra.setSituacaoNecessidadeCompra(opcoes.getSituacaoNecessidadeOrdemCompra());
                }
            }
        }
    }
}

