/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.UtilObservacoes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.impl.cotacaocompra.ConstantsServiceCotacaoCompra;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;

class UtilGerarPlanilhaCotacao {
    UtilGerarPlanilhaCotacao() {
    }

    public void exportarPlanilhaExcelFornecedores(CotacaoCompra cotacaoCompra, String caminhoAquivos) throws ExceptionService {
        HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets = this.buildSheets(cotacaoCompra);
        if (sheets == null || sheets.isEmpty()) {
            throw new ExceptionService("N\u00e3o foi poss\u00edvel gerar a planilha, pois n\u00e3o existe fornecedor informado para os itens!");
        }
        this.writeFiles(sheets, caminhoAquivos);
    }

    private HashMap<UnidadeFatFornecedor, HSSFWorkbook> buildSheets(CotacaoCompra cotacaoCompra) {
        HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets = new HashMap<UnidadeFatFornecedor, HSSFWorkbook>();
        for (ItemCotacaoCompra itemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
                HSSFSheet sheet = this.getSheet(sheets, fornecedorItemCotacaoCompra);
                this.writeDataOnSheet(sheet, fornecedorItemCotacaoCompra);
            }
        }
        return sheets;
    }

    private void writeDataOnSheet(HSSFSheet sheet, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        int rowNumber = sheet.getLastRowNum() + 1;
        HSSFRow row = sheet.createRow(rowNumber);
        GradeCor gradeCor = fornecedorItemCotacaoCompra.getItemCotacaoCompra().getGradeCor();
        Produto produto = gradeCor.getProdutoGrade().getProduto();
        row.createCell(0).setCellValue((double)gradeCor.getIdentificador().longValue());
        row.createCell(1).setCellValue(produto.getNome());
        row.createCell(3).setCellValue(fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade().doubleValue());
        sheet.addMergedRegion(new CellRangeAddress(rowNumber, rowNumber, 1, 2));
    }

    private void writeFiles(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, String caminhoAquivos) throws ExceptionService {
        try {
            for (UnidadeFatFornecedor unidadeFatFornecedor : sheets.keySet()) {
                HSSFWorkbook hssfWorkbook = sheets.get(unidadeFatFornecedor);
                caminhoAquivos = caminhoAquivos.endsWith(File.pathSeparator) ? caminhoAquivos : caminhoAquivos + File.separator;
                FileOutputStream outfile = new FileOutputStream(caminhoAquivos + unidadeFatFornecedor.getFornecedor().getPessoa().getNome().replace("\\\\", "").replace("/", "").replace(" ", "_") + ".xls");
                hssfWorkbook.write((OutputStream)outfile);
                outfile.flush();
                outfile.close();
            }
        }
        catch (FileNotFoundException ex) {
            throw new ExceptionService("N\u00e3o foi poss\u00edvel criar os arquivos no caminho especificado! " + ex.getMessage());
        }
        catch (IOException ex) {
            throw new ExceptionService("N\u00e3o foi poss\u00edvel criar os arquivos no caminho especificado! " + ex.getMessage());
        }
    }

    private HSSFSheet getSheet(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        String nomeFornecedor = fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getFornecedor().getPessoa().getNome();
        if (sheets.get(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor()) != null) {
            return sheets.get(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor()).getSheetAt(0);
        }
        return this.buildSheet(sheets, fornecedorItemCotacaoCompra);
    }

    private HSSFSheet buildSheet(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra) {
        String nomeFornecedor = fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getFornecedor().getPessoa().getNome();
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook();
        HSSFSheet sheet = hssfWorkbook.createSheet(nomeFornecedor.trim());
        this.putCabecalhoEmpresa(sheet, fornecedorItemCotacaoCompra, hssfWorkbook.createCellStyle(), hssfWorkbook.createFont());
        this.putFornecedor(sheet, fornecedorItemCotacaoCompra, hssfWorkbook.createCellStyle(), hssfWorkbook.createFont());
        this.putCotacao(sheet, fornecedorItemCotacaoCompra, hssfWorkbook.createCellStyle(), hssfWorkbook.createFont());
        this.putCabecalhoProdutos(sheet, fornecedorItemCotacaoCompra, hssfWorkbook.createCellStyle(), hssfWorkbook.createFont());
        sheets.put(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor(), hssfWorkbook);
        return sheet;
    }

    private void putCabecalhoEmpresa(HSSFSheet sheet, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, HSSFCellStyle style, HSSFFont font) {
        String nomeEmpresa = fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra().getEmpresa().getPessoa().getNome();
        HSSFRow row = sheet.createRow(ConstantsServiceCotacaoCompra.ROW_CABECALHO_EMPRESA.intValue());
        HSSFCell cell = row.createCell(0);
        row.setHeightInPoints(sheet.getDefaultRowHeightInPoints() + 6.0f);
        font.setFontHeightInPoints((short)14);
        font.setColor(IndexedColors.BLACK.getIndex());
        font.setBold(true);
        font.setItalic(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        sheet.autoSizeColumn(0, true);
        sheet.addMergedRegion(new CellRangeAddress(ConstantsServiceCotacaoCompra.ROW_CABECALHO_EMPRESA.intValue(), ConstantsServiceCotacaoCompra.ROW_CABECALHO_EMPRESA.intValue(), 0, 7));
    }

    private void putFornecedor(HSSFSheet sheet, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, HSSFCellStyle style, HSSFFont font) {
        String identificadorFornecedor = fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getIdentificador().toString();
        String nomeFornecedor = fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getFornecedor().getPessoa().getNome();
        font.setFontHeightInPoints((short)11);
        font.setColor(IndexedColors.BLACK.getIndex());
        font.setBold(true);
        font.setItalic(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFRow row = sheet.createRow(ConstantsServiceCotacaoCompra.ROW_CABECALHO_FORNECEDOR.intValue());
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(style);
        cell.setCellValue("Fornecedor: ");
        sheet.autoSizeColumn(0);
        cell = row.createCell(1);
        font.setBold(true);
        cell.setCellStyle(style);
        cell.setCellValue(identificadorFornecedor);
        sheet.autoSizeColumn(1);
        cell = row.createCell(2);
        font.setBold(true);
        cell.setCellStyle(style);
        cell.setCellValue(nomeFornecedor);
        sheet.autoSizeColumn(2);
    }

    private void putCotacao(HSSFSheet sheet, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, HSSFCellStyle style, HSSFFont font) {
        HSSFRow row = sheet.createRow(ConstantsServiceCotacaoCompra.ROW_CABECALHO_COTACAO.intValue());
        font.setFontHeightInPoints((short)11);
        font.setColor(IndexedColors.BLACK.getIndex());
        font.setBold(true);
        font.setItalic(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setLocked(true);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(style);
        cell.setCellValue("Cotac\u00e3o numero: ");
        sheet.autoSizeColumn(0);
        cell = row.createCell(1);
        font.setBold(true);
        cell.setCellStyle(style);
        cell.setCellValue((double)fornecedorItemCotacaoCompra.getItemCotacaoCompra().getCotacaoCompra().getIdentificador().longValue());
        sheet.autoSizeColumn(1);
    }

    private void putCabecalhoProdutos(HSSFSheet sheet, FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, HSSFCellStyle style, HSSFFont font) {
        HSSFRow row = sheet.createRow(ConstantsServiceCotacaoCompra.ROW_CABECALHO_PRODUTOS.intValue());
        font.setFontHeightInPoints((short)11);
        font.setColor(IndexedColors.BLACK.getIndex());
        font.setBold(true);
        font.setItalic(false);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFont(font);
        style.setLocked(true);
        HSSFCell cell = row.createCell(0);
        cell.setCellStyle(style);
        cell.setCellValue("Identificador");
        sheet.autoSizeColumn(0);
        cell = row.createCell(1);
        cell.setCellStyle(style);
        cell.setCellValue("Produto");
        sheet.autoSizeColumn(1);
        cell = row.createCell(3);
        cell.setCellStyle(style);
        cell.setCellValue("Quantidade");
        sheet.autoSizeColumn(3);
        cell = row.createCell(4);
        cell.setCellStyle(style);
        cell.setCellValue("Valor Unit\u00e1rio");
        sheet.autoSizeColumn(4);
        cell = row.createCell(5);
        cell.setCellStyle(style);
        cell.setCellValue("Prazo Entrega");
        sheet.autoSizeColumn(5);
        cell = row.createCell(6);
        cell.setCellStyle(style);
        cell.setCellValue("Condicao de Pagamento (Ex. 30;60;90;)");
        sheet.autoSizeColumn(6);
        cell = row.createCell(7);
        cell.setCellStyle(style);
        cell.setCellValue("Tipo Frete (0-CIF / 1-FOB)");
        sheet.autoSizeColumn(7);
        sheet.addMergedRegion(new CellRangeAddress(ConstantsServiceCotacaoCompra.ROW_CABECALHO_PRODUTOS.intValue(), ConstantsServiceCotacaoCompra.ROW_CABECALHO_PRODUTOS.intValue(), 1, 2));
    }

    public void exportarPlanilhaExcelFornecedores(CotacaoCompra cotacaoCompra, HashMap<UnidadeFatFornecedor, HashSet<String>> emails, ModeloEmail modeloEmail, ServidorEmail servidorEmail) throws ExceptionService {
        HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets = this.buildSheets(cotacaoCompra);
        this.sendEmails(sheets, emails, modeloEmail, servidorEmail, cotacaoCompra);
    }

    private void sendEmails(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, HashMap<UnidadeFatFornecedor, HashSet<String>> emails, ModeloEmail modeloEmail, ServidorEmail servidorEmail, CotacaoCompra cotacaoCompra) throws ExceptionService {
        for (UnidadeFatFornecedor unidadeFatFornecedor : sheets.keySet()) {
            if (emails.get(unidadeFatFornecedor) == null) continue;
            this.sendEmail(unidadeFatFornecedor, emails.get(unidadeFatFornecedor), sheets.get(unidadeFatFornecedor), modeloEmail, servidorEmail, cotacaoCompra, cotacaoCompra.getUsuarioComprador());
        }
    }

    private void sendEmail(UnidadeFatFornecedor unidadeFatFornecedor, HashSet<String> emails, HSSFWorkbook hssfWorkbook, ModeloEmail modeloEmail, ServidorEmail servidorEmail, CotacaoCompra cotacaoCompra, Usuario user) throws ExceptionService {
        try {
            ToolSendEmail.sendEmailWithException((Email)this.buildEmail(unidadeFatFornecedor, emails, hssfWorkbook.getSheetAt(0), modeloEmail, servidorEmail, cotacaoCompra, user));
        }
        catch (Exception ex) {
            throw new ExceptionService(ex);
        }
    }

    private Email buildEmail(UnidadeFatFornecedor unidadeFatFornecedor, HashSet<String> emails, HSSFSheet sheet, ModeloEmail modeloEmail, ServidorEmail servidorEmail, CotacaoCompra cotacaoCompra, Usuario user) throws ExceptionService {
        try {
            Email ret = new Email(false);
            ret.setAssunto(modeloEmail.getTituloEmail());
            ret.setCorpoMensagem(UtilObservacoes.fillTokens((String)new String(modeloEmail.getModelo()), (Object)this.getFornecedorItemCotacaoCompra(cotacaoCompra, unidadeFatFornecedor)));
            ret.setDescricao(unidadeFatFornecedor.getFornecedor().getPessoa().getNome());
            ret.addDestinatarios(this.getDestinatarios(emails, servidorEmail));
            ret.setRemetente(ToolString.corrigeNome((String)user.getUsuarioBasico().getPessoa().getNome()));
            ret.setServidor(new Email.ServidorEmail(servidorEmail.getServidor(), servidorEmail.getServidorImap(), servidorEmail.getServidorPop(), servidorEmail.getEmail(), servidorEmail.getSenha(), servidorEmail.getPortaEmail(), servidorEmail.getNaoAutenticarEmail(), servidorEmail.getLogin(), servidorEmail.getServerProperties(), servidorEmail.getGerarArquivoExtensaoEml(), servidorEmail.getDebugServer()));
            ret.setZiparAnexos(false);
            ret.addAnexos(this.getAnexos(sheet, unidadeFatFornecedor));
            return ret;
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionService("Erro ao popular os tokens do corpo do email: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionService("Erro ao popular os tokens do corpo do email: " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionService("Erro ao popular os tokens do corpo do email: " + ex.getMessage());
        }
    }

    private List<File> getAnexos(HSSFSheet sheet, UnidadeFatFornecedor unidadeFatFornecedor) throws ExceptionService {
        ArrayList<File> anexos = new ArrayList<File>();
        try {
            File anexo = File.createTempFile(unidadeFatFornecedor.getFornecedor().getPessoa().getNome(), ".xls");
            FileOutputStream outfile = new FileOutputStream(anexo);
            sheet.getWorkbook().write((OutputStream)outfile);
            outfile.flush();
            outfile.close();
            anexos.add(anexo);
        }
        catch (Exception ex) {
            throw new ExceptionService(ex);
        }
        return anexos;
    }

    private FornecedorItemCotacaoCompra getFornecedorItemCotacaoCompra(CotacaoCompra cotacaoCompra, UnidadeFatFornecedor unidadeFatFornecedor) {
        for (ItemCotacaoCompra itemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
                if (!fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getIdentificador().equals(unidadeFatFornecedor.getIdentificador())) continue;
                return fornecedorItemCotacaoCompra;
            }
        }
        return null;
    }

    private String[] getDestinatarios(HashSet<String> emails, ServidorEmail servidorEmail) {
        if (ToolMethods.isStrWithData((String)servidorEmail.getEmailCopia())) {
            emails.add(servidorEmail.getEmailCopia());
        }
        return emails.toArray(new String[0]);
    }
}

