/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompra;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompraItem;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.EmailPessoa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import contatocore.util.UtilObservacoes;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mentorcore.exceptions.ExceptionService;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

class UtilGerarPlanilhaCotacaoModelo {
    UtilGerarPlanilhaCotacaoModelo() {
    }

    public void exportarPlanilhaExcelFornecedores(CotacaoCompra cotacaoCompra, String caminhoAquivos, ConfPlanilhaExcelCotCompra modeloPlanilha) throws ExceptionService {
        try {
            HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets = this.buildSheets(modeloPlanilha, cotacaoCompra);
            if (sheets == null || sheets.isEmpty()) {
                throw new ExceptionService("N\u00e3o foi poss\u00edvel gerar a planilha, pois n\u00e3o existe fornecedor informado para os itens!");
            }
            this.buildData(sheets, modeloPlanilha, cotacaoCompra);
            this.flushDataSheets(sheets, caminhoAquivos);
        }
        catch (Throwable ex) {
            throw new ExceptionService("Erro ao gerar as planilhas.\n" + ex.getMessage(), ex);
        }
    }

    public void exportarPlanilhaExcelFornecedores(CotacaoCompra cotacaoCompra, HashMap<UnidadeFatFornecedor, HashSet<String>> emails, ModeloEmail modeloEmail, ServidorEmail servidorEmail, ConfPlanilhaExcelCotCompra modeloPlanilha) throws ExceptionService {
        try {
            HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets = this.buildSheets(modeloPlanilha, cotacaoCompra);
            this.buildData(sheets, modeloPlanilha, cotacaoCompra);
            this.sendEmails(sheets, emails, modeloEmail, servidorEmail, cotacaoCompra);
        }
        catch (Throwable ex) {
            throw new ExceptionService("Erro ao gerar as planilhas.\n" + ex.getMessage(), ex);
        }
    }

    private HashMap<UnidadeFatFornecedor, HSSFWorkbook> buildSheets(ConfPlanilhaExcelCotCompra modeloPlanilha, CotacaoCompra cotacao) throws IOException {
        HashMap<UnidadeFatFornecedor, HSSFWorkbook> hashMap = new HashMap<UnidadeFatFornecedor, HSSFWorkbook>();
        for (ItemCotacaoCompra itemCotacaoCompra : cotacao.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
                HSSFWorkbook book = hashMap.get(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor());
                if (book != null) continue;
                book = UtilGerarPlanilhaCotacaoModelo.getSheetFile(modeloPlanilha, fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor());
                hashMap.put(fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor(), book);
                this.buildDataFornecedorCotacao(book, cotacao, fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor(), modeloPlanilha);
            }
        }
        return hashMap;
    }

    private static HSSFWorkbook getSheetFile(ConfPlanilhaExcelCotCompra modeloPlanilha, UnidadeFatFornecedor fornecedor) throws FileNotFoundException, IOException {
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new ByteArrayInputStream(modeloPlanilha.getArquivoPlanilha()));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        return myWorkBook;
    }

    private void buildData(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, ConfPlanilhaExcelCotCompra modeloPlanilha, CotacaoCompra cotacao) throws ExceptionService {
        Set<UnidadeFatFornecedor> s = sheets.keySet();
        ConfPlanilhaExcelCotCompraItem codAuxProdutoConf = this.getItem(modeloPlanilha.getItensConf(), "cod_auxiliar_produto");
        ConfPlanilhaExcelCotCompraItem idProdutoConf = this.getItem(modeloPlanilha.getItensConf(), "id_produto");
        ConfPlanilhaExcelCotCompraItem nomeProdutoConf = this.getItem(modeloPlanilha.getItensConf(), "nome_produto");
        ConfPlanilhaExcelCotCompraItem unidMedProdConf = this.getItem(modeloPlanilha.getItensConf(), "unidade_med_produto");
        ConfPlanilhaExcelCotCompraItem quantidadeProdConf = this.getItem(modeloPlanilha.getItensConf(), "quantidade");
        ConfPlanilhaExcelCotCompraItem observacaoItem = this.getItem(modeloPlanilha.getItensConf(), "observacao");
        ConfPlanilhaExcelCotCompraItem observacaoProduto = this.getItem(modeloPlanilha.getItensConf(), "observacao_produto");
        ConfPlanilhaExcelCotCompraItem codCentroCusto = this.getItem(modeloPlanilha.getItensConf(), "cod_centro_custo");
        ConfPlanilhaExcelCotCompraItem centroCusto = this.getItem(modeloPlanilha.getItensConf(), "centro_custo");
        ConfPlanilhaExcelCotCompraItem idFabricante = this.getItem(modeloPlanilha.getItensConf(), "id_fabricante");
        ConfPlanilhaExcelCotCompraItem nomeFabricante = this.getItem(modeloPlanilha.getItensConf(), "nome_fabricante");
        ConfPlanilhaExcelCotCompraItem idGradeCor = this.getItem(modeloPlanilha.getItensConf(), "id_grade_cor");
        ConfPlanilhaExcelCotCompraItem nomeGradeCor = this.getItem(modeloPlanilha.getItensConf(), "nome_grade_cor");
        ConfPlanilhaExcelCotCompraItem nomeAuxProdutoConf = this.getItem(modeloPlanilha.getItensConf(), "nome_aux_produto");
        for (UnidadeFatFornecedor forn : s) {
            List itens = this.getAllItensFornecedor(cotacao, forn);
            HSSFWorkbook book = sheets.get(forn);
            HSSFSheet sheet = book.getSheetAt(0);
            int codAuxLinha = codAuxProdutoConf != null ? codAuxProdutoConf.getLinha() - 1 : 0;
            int idProdLinha = idProdutoConf != null ? idProdutoConf.getLinha() - 1 : 0;
            int nomeProdLinha = nomeProdutoConf != null ? nomeProdutoConf.getLinha() - 1 : 0;
            int unidMedProdLinha = unidMedProdConf != null ? unidMedProdConf.getLinha() - 1 : 0;
            int quantidadeProdLinha = quantidadeProdConf != null ? quantidadeProdConf.getLinha() - 1 : 0;
            int observacaoProdutoLinha = observacaoProduto != null ? observacaoProduto.getLinha() - 1 : 0;
            int observacaoItemLinha = observacaoItem != null ? observacaoItem.getLinha() - 1 : 0;
            int centroCustoLinha = centroCusto != null ? centroCusto.getLinha() - 1 : 0;
            int codCentroCustoLinha = codCentroCusto != null ? codCentroCusto.getLinha() - 1 : 0;
            int idFabricanteLinha = idFabricante != null ? idFabricante.getLinha() - 1 : 0;
            int nomeFabricanteLinha = nomeFabricante != null ? nomeFabricante.getLinha() - 1 : 0;
            int idGradeCorLinha = idGradeCor != null ? idGradeCor.getLinha() - 1 : 0;
            int nomeGradeCorLinha = nomeGradeCor != null ? nomeGradeCor.getLinha() - 1 : 0;
            int nomeAuxLinha = nomeAuxProdutoConf != null ? nomeAuxProdutoConf.getLinha() - 1 : 0;
            for (ItemCotacaoCompra itemCotacao : itens) {
                HSSFCell cell;
                HSSFRow row;
                int column;
                if (idProdutoConf != null && idProdutoConf.getUtilizar() != null && idProdutoConf.getUtilizar() == 1) {
                    column = idProdutoConf.getColuna() - 1;
                    row = this.getRow(idProdLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue((double)itemCotacao.getGradeCor().getProdutoGrade().getProduto().getIdentificador().longValue());
                    idProdLinha += idProdutoConf.getSalto().intValue();
                }
                if (codAuxProdutoConf != null && codAuxProdutoConf.getUtilizar() != null && codAuxProdutoConf.getUtilizar() == 1) {
                    column = codAuxProdutoConf.getColuna() - 1;
                    row = this.getRow(codAuxLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getGradeCor().getProdutoGrade().getProduto().getCodigoAuxiliar());
                    codAuxLinha += codAuxProdutoConf.getSalto().intValue();
                }
                if (idFabricante != null && idFabricante.getUtilizar() != null && idFabricante.getUtilizar() == 1) {
                    column = idFabricante.getColuna() - 1;
                    row = this.getRow(idFabricanteLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue((double)itemCotacao.getGradeCor().getProdutoGrade().getProduto().getFabricante().getIdentificador().longValue());
                    idFabricanteLinha += idFabricante.getSalto().intValue();
                }
                if (nomeFabricante != null && nomeFabricante.getUtilizar() != null && nomeFabricante.getUtilizar() == 1) {
                    column = nomeFabricante.getColuna() - 1;
                    row = this.getRow(nomeFabricanteLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getGradeCor().getProdutoGrade().getProduto().getFabricante().getNome());
                    nomeFabricanteLinha += nomeFabricante.getSalto().intValue();
                }
                if (nomeProdutoConf != null && nomeProdutoConf.getUtilizar() != null && nomeProdutoConf.getUtilizar() == 1) {
                    column = nomeProdutoConf.getColuna() - 1;
                    row = this.getRow(nomeProdLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getGradeCor().getProdutoGrade().getProduto().getNome());
                    nomeProdLinha += nomeProdutoConf.getSalto().intValue();
                }
                if (quantidadeProdConf != null && quantidadeProdConf.getUtilizar() != null && quantidadeProdConf.getUtilizar() == 1) {
                    column = quantidadeProdConf.getColuna() - 1;
                    row = this.getRow(quantidadeProdLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getQuantidade().doubleValue());
                    quantidadeProdLinha += quantidadeProdConf.getSalto().intValue();
                }
                if (unidMedProdConf != null && unidMedProdConf.getUtilizar() != null && unidMedProdConf.getUtilizar() == 1) {
                    column = unidMedProdConf.getColuna() - 1;
                    row = this.getRow(unidMedProdLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getUnidadeMedida().getSigla());
                    unidMedProdLinha += unidMedProdConf.getSalto().intValue();
                }
                if (observacaoProduto != null && observacaoProduto.getUtilizar() != null && observacaoProduto.getUtilizar() == 1) {
                    column = observacaoProduto.getColuna() - 1;
                    row = this.getRow(observacaoProdutoLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getGradeCor().getProdutoGrade().getProduto().getObservacao());
                    observacaoProdutoLinha += observacaoProduto.getSalto().intValue();
                }
                if (observacaoItem != null && observacaoItem.getUtilizar() != null && observacaoItem.getUtilizar() == 1) {
                    column = observacaoItem.getColuna() - 1;
                    row = this.getRow(observacaoItemLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getObservacao());
                    observacaoItemLinha += observacaoItem.getSalto().intValue();
                }
                if (centroCusto != null && centroCusto.getUtilizar() != null && centroCusto.getUtilizar() == 1) {
                    if (itemCotacao.getCentroCustoReq() == null) {
                        throw new ExceptionService("Centro de custo nao informado no item " + String.valueOf(itemCotacao.getGradeCor().getProdutoGrade().getProduto()));
                    }
                    column = centroCusto.getColuna() - 1;
                    row = this.getRow(centroCustoLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getCentroCustoReq().getNome());
                    centroCustoLinha += centroCusto.getSalto().intValue();
                }
                if (codCentroCusto != null && codCentroCusto.getUtilizar() != null && codCentroCusto.getUtilizar() == 1) {
                    if (itemCotacao.getCentroCustoReq() == null) {
                        throw new ExceptionService("Centro de custo nao informado no item " + String.valueOf(itemCotacao.getGradeCor().getProdutoGrade().getProduto()));
                    }
                    column = codCentroCusto.getColuna() - 1;
                    row = this.getRow(codCentroCustoLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getCentroCustoReq().getCodigo());
                    codCentroCustoLinha += codCentroCusto.getSalto().intValue();
                }
                if (idGradeCor != null && idGradeCor.getUtilizar() != null && idGradeCor.getUtilizar() == 1) {
                    column = idGradeCor.getColuna() - 1;
                    row = this.getRow(idGradeCorLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue((double)itemCotacao.getGradeCor().getIdentificador().longValue());
                    idGradeCorLinha += idGradeCor.getSalto().intValue();
                }
                if (nomeGradeCor != null && nomeGradeCor.getUtilizar() != null && nomeGradeCor.getUtilizar() == 1) {
                    column = nomeGradeCor.getColuna() - 1;
                    row = this.getRow(nomeGradeCorLinha, sheet);
                    cell = this.getCell(column, row);
                    cell.setCellValue(itemCotacao.getGradeCor().getCor().getNome());
                    nomeGradeCorLinha += nomeGradeCor.getSalto().intValue();
                }
                if (nomeAuxProdutoConf == null || nomeAuxProdutoConf.getUtilizar() == null || nomeAuxProdutoConf.getUtilizar() != 1) continue;
                column = nomeAuxProdutoConf.getColuna() - 1;
                row = this.getRow(nomeAuxLinha, sheet);
                cell = this.getCell(column, row);
                cell.setCellValue(itemCotacao.getGradeCor().getProdutoGrade().getProduto().getNomeAuxiliar());
                nomeAuxLinha += nomeAuxProdutoConf.getSalto().intValue();
            }
        }
    }

    private void buildDataFornecedorCotacao(HSSFWorkbook book, CotacaoCompra cotacao, UnidadeFatFornecedor fornecedor, ConfPlanilhaExcelCotCompra modeloPlanilha) {
        HSSFSheet sheet = book.getSheetAt(0);
        this.putDataFornecedor(fornecedor, sheet, modeloPlanilha);
        this.putDataCotacao(cotacao, sheet, modeloPlanilha);
    }

    private ConfPlanilhaExcelCotCompraItem getItem(List<ConfPlanilhaExcelCotCompraItem> itens, String key) {
        for (ConfPlanilhaExcelCotCompraItem item : itens) {
            if (!item.getChave().equalsIgnoreCase(key)) continue;
            return item;
        }
        return null;
    }

    private void flushDataSheets(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, String path) throws IOException {
        Set<UnidadeFatFornecedor> keys = sheets.keySet();
        for (UnidadeFatFornecedor f : keys) {
            HSSFWorkbook book = sheets.get(f);
            FileOutputStream outfile = new FileOutputStream(UtilGerarPlanilhaCotacaoModelo.getFile(path, f));
            book.write((OutputStream)outfile);
            outfile.flush();
            outfile.close();
        }
    }

    private static String getFile(String file, UnidadeFatFornecedor fornecedor) {
        return file + File.separator + ToolString.clearSpecialCharacXML((String)(fornecedor.getIdentificador() + " - " + fornecedor.getFornecedor().getPessoa().getNome().replace("\\\\", "").replace("/", "").replace(" ", "_"))) + ".xls";
    }

    private void putDataFornecedor(UnidadeFatFornecedor unid, HSSFSheet sheet, ConfPlanilhaExcelCotCompra modeloPlanilha) {
        HSSFCell cell;
        HSSFRow row;
        HSSFCell cell2;
        HSSFRow row2;
        Fornecedor fornecedor = unid.getFornecedor();
        ConfPlanilhaExcelCotCompraItem item = this.getItem(modeloPlanilha.getItensConf(), "codigo_fornecedor");
        if (item != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue((double)unid.getIdentificador().longValue());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "nome_fornecedor")) != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue(fornecedor.getPessoa().getNome());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "insc_est_fornecedor")) != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue(fornecedor.getPessoa().getComplemento().getInscEst());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "endereco_fornecedor")) != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            Object st = "";
            st = (String)st + fornecedor.getPessoa().getEndereco().getLogradouro();
            if (fornecedor.getPessoa().getEndereco().getNumero() != null && fornecedor.getPessoa().getEndereco().getNumero().trim().length() > 0) {
                st = (String)st + ", ";
                st = (String)st + fornecedor.getPessoa().getEndereco().getNumero();
            }
            if (fornecedor.getPessoa().getEndereco().getComplemento() != null && fornecedor.getPessoa().getEndereco().getComplemento().trim().length() > 0) {
                st = (String)st + ", ";
                st = (String)st + fornecedor.getPessoa().getEndereco().getComplemento();
            }
            if (fornecedor.getPessoa().getEndereco().getBairro() != null && fornecedor.getPessoa().getEndereco().getBairro().trim().length() > 0) {
                st = (String)st + ", ";
                st = (String)st + fornecedor.getPessoa().getEndereco().getBairro();
            }
            cell2.setCellValue((String)st);
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "cidade_fornecedor")) != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue(fornecedor.getPessoa().getEndereco().getCidade().getDescricao());
        }
        item = this.getItem(modeloPlanilha.getItensConf(), "email_fornecedor");
        EmailPessoa email = this.getEmailCotacao(fornecedor.getPessoa().getComplemento().getEmails());
        if (item != null && item.getUtilizar() == 1 && email != null) {
            row = this.getRow(item.getLinha() - 1, sheet);
            cell = this.getCell(item.getColuna() - 1, row);
            cell.setCellValue(((EmailPessoa)fornecedor.getPessoa().getComplemento().getEmails().get(0)).getEmail());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "fone_fornecedor")) != null && item.getUtilizar() == 1) {
            row = this.getRow(item.getLinha() - 1, sheet);
            cell = this.getCell(item.getColuna() - 1, row);
            cell.setCellValue(fornecedor.getPessoa().getComplemento().getFone1());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "uf_fornecedor")) != null && item.getUtilizar() == 1) {
            row = this.getRow(item.getLinha() - 1, sheet);
            cell = this.getCell(item.getColuna() - 1, row);
            cell.setCellValue(fornecedor.getPessoa().getEndereco().getCidade().getUf().getSigla());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "cnpj_fornecedor")) != null && item.getUtilizar() == 1) {
            row = this.getRow(item.getLinha() - 1, sheet);
            cell = this.getCell(item.getColuna() - 1, row);
            cell.setCellValue(fornecedor.getPessoa().getComplemento().getCnpj());
        }
    }

    private void putDataCotacao(CotacaoCompra cotacao, HSSFSheet sheet, ConfPlanilhaExcelCotCompra modeloPlanilha) {
        HSSFCell cell;
        HSSFRow row;
        HSSFCell cell2;
        HSSFRow row2;
        ConfPlanilhaExcelCotCompraItem item = this.getItem(modeloPlanilha.getItensConf(), "codigo_cotacao");
        if (item != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue((double)cotacao.getIdentificador().longValue());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "data_cotacao")) != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue(cotacao.getDataCotacaoCompra());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "nome_usuario")) != null && item.getUtilizar() == 1) {
            row2 = this.getRow(item.getLinha() - 1, sheet);
            cell2 = this.getCell(item.getColuna() - 1, row2);
            cell2.setCellValue(cotacao.getUsuarioComprador().getUsuarioBasico().getPessoa().getNome());
        }
        item = this.getItem(modeloPlanilha.getItensConf(), "email_usuario");
        EmailPessoa email = this.getEmailCotacao(cotacao.getUsuarioComprador().getUsuarioBasico().getPessoa().getComplemento().getEmails());
        if (item != null && item.getUtilizar() == 1 && email != null) {
            row = this.getRow(item.getLinha() - 1, sheet);
            cell = this.getCell(item.getColuna() - 1, row);
            cell.setCellValue(email.getEmail());
        }
        if ((item = this.getItem(modeloPlanilha.getItensConf(), "fone_usuario")) != null && item.getUtilizar() == 1) {
            row = this.getRow(item.getLinha() - 1, sheet);
            cell = this.getCell(item.getColuna() - 1, row);
            cell.setCellValue(cotacao.getUsuarioComprador().getUsuarioBasico().getPessoa().getComplemento().getFone1());
        }
    }

    private List getAllItensFornecedor(CotacaoCompra cotacao, UnidadeFatFornecedor fornecedor) {
        LinkedList<ItemCotacaoCompra> l = new LinkedList<ItemCotacaoCompra>();
        for (ItemCotacaoCompra item : cotacao.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra fornItemCompra : item.getFornecedoresItemCotacaoCompra()) {
                if (!fornItemCompra.getUnidadeFaturamentoFornecedor().equals((Object)fornecedor)) continue;
                l.add(item);
            }
        }
        Collections.sort(l, new Comparator(this){

            public int compare(Object o1, Object o2) {
                ItemCotacaoCompra f1 = (ItemCotacaoCompra)o1;
                ItemCotacaoCompra f2 = (ItemCotacaoCompra)o2;
                return f1.getGradeCor().getProdutoGrade().getProduto().getNome().compareTo(f2.getGradeCor().getProdutoGrade().getProduto().getNome());
            }
        });
        return l;
    }

    private EmailPessoa getEmailCotacao(List<EmailPessoa> emails) {
        for (EmailPessoa em : emails) {
            if (em.getEnviarDadosCotacao() == null || em.getEnviarDadosCotacao() != 1) continue;
            return em;
        }
        return null;
    }

    private void sendEmails(HashMap<UnidadeFatFornecedor, HSSFWorkbook> sheets, HashMap<UnidadeFatFornecedor, HashSet<String>> emails, ModeloEmail modeloEmail, ServidorEmail servidorEmail, CotacaoCompra cotacaoCompra) throws ExceptionService {
        for (UnidadeFatFornecedor unidadeFatFornecedor : sheets.keySet()) {
            if (emails.get(unidadeFatFornecedor) == null) continue;
            HashSet<String> listaEmail = emails.get(unidadeFatFornecedor);
            if (ToolMethods.isStrWithData((String)servidorEmail.getEmailCopia())) {
                listaEmail.add(servidorEmail.getEmailCopia());
            }
            this.sendEmail(unidadeFatFornecedor, listaEmail, sheets.get(unidadeFatFornecedor), modeloEmail, servidorEmail, cotacaoCompra, cotacaoCompra.getUsuarioComprador());
        }
    }

    private void sendEmail(UnidadeFatFornecedor unidadeFatFornecedor, HashSet<String> emails, HSSFWorkbook hssfWorkbook, ModeloEmail modeloEmail, ServidorEmail servidorEmail, CotacaoCompra cotacaoCompra, Usuario user) throws ExceptionService {
        try {
            ToolSendEmail.sendEmailWithException((Email)this.buildEmail(unidadeFatFornecedor, emails, hssfWorkbook.getSheetAt(0), modeloEmail, servidorEmail, cotacaoCompra, user));
        }
        catch (Exception ex) {
            throw new ExceptionService(ex);
        }
    }

    private Email buildEmail(UnidadeFatFornecedor unidadeFatFornecedor, HashSet<String> emails, HSSFSheet sheet, ModeloEmail modeloEmail, ServidorEmail servidorEmail, CotacaoCompra cotacaoCompra, Usuario user) throws ExceptionService {
        try {
            Email ret = new Email(false);
            ret.setAssunto(modeloEmail.getTituloEmail());
            ret.setCorpoMensagem(UtilObservacoes.fillTokens((String)new String(modeloEmail.getModelo()), (Object)this.getFornecedorItemCotacaoCompra(cotacaoCompra, unidadeFatFornecedor)));
            ret.setDescricao(unidadeFatFornecedor.getFornecedor().getPessoa().getNome());
            ret.addDestinatarios(emails.toArray(new String[0]));
            ret.setRemetente(ToolString.corrigeNome((String)user.getUsuarioBasico().getPessoa().getNome()));
            ret.setServidor(new Email.ServidorEmail(servidorEmail.getServidor(), servidorEmail.getServidorImap(), servidorEmail.getServidorPop(), servidorEmail.getEmail(), servidorEmail.getSenha(), servidorEmail.getPortaEmail(), servidorEmail.getNaoAutenticarEmail(), servidorEmail.getLogin(), servidorEmail.getServerProperties(), servidorEmail.getGerarArquivoExtensaoEml(), servidorEmail.getDebugServer()));
            ret.setZiparAnexos(false);
            ret.addAnexos(this.getAnexos(sheet, unidadeFatFornecedor));
            return ret;
        }
        catch (IllegalAccessException ex) {
            throw new ExceptionService("Erro ao popular os tokens do corpo do email: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new ExceptionService("Erro ao popular os tokens do corpo do email: " + ex.getMessage());
        }
        catch (InvocationTargetException ex) {
            throw new ExceptionService("Erro ao popular os tokens do corpo do email: " + ex.getMessage());
        }
    }

    private List<File> getAnexos(HSSFSheet sheet, UnidadeFatFornecedor unidadeFatFornecedor) throws ExceptionService {
        ArrayList<File> anexos = new ArrayList<File>();
        try {
            File anexo = File.createTempFile(unidadeFatFornecedor.getFornecedor().getPessoa().getNome(), ".xls");
            FileOutputStream outfile = new FileOutputStream(anexo);
            sheet.getWorkbook().write((OutputStream)outfile);
            outfile.flush();
            outfile.close();
            anexos.add(anexo);
        }
        catch (Exception ex) {
            throw new ExceptionService(ex);
        }
        return anexos;
    }

    private FornecedorItemCotacaoCompra getFornecedorItemCotacaoCompra(CotacaoCompra cotacaoCompra, UnidadeFatFornecedor unidadeFatFornecedor) {
        for (ItemCotacaoCompra itemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
            for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
                if (!fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getIdentificador().equals(unidadeFatFornecedor.getIdentificador())) continue;
                return fornecedorItemCotacaoCompra;
            }
        }
        return null;
    }

    private HSSFRow getRow(int linha, HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(linha);
        if (row == null) {
            row = sheet.createRow(linha);
        }
        return row;
    }

    private HSSFCell getCell(int coluna, HSSFRow row) {
        HSSFCell cell = row.getCell(coluna);
        if (cell == null) {
            cell = row.createCell(coluna);
        }
        return cell;
    }
}

