/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorspringcontext.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.service.impl.cotacaocompra.ConstantsServiceCotacaoCompra;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

class UtilLLerPlanilhaCotacao {
    private CondicoesPagamento condPagamento;

    UtilLLerPlanilhaCotacao() {
    }

    public List<CotacaoCompra> importarPlanilhaExcelFornecedores(List<File> files, CondicoesPagamento condPagamento, OpcoesCompraSuprimentos opcoesCompraSuprimentos) throws FileNotFoundException, IOException, ExceptionService {
        this.condPagamento = condPagamento;
        ArrayList<CotacaoCompra> cotacoes = new ArrayList<CotacaoCompra>();
        for (File f : files) {
            HSSFSheet sheet = this.getSheetFile(f.getAbsolutePath());
            this.getCotacaoCompra(sheet, cotacoes, opcoesCompraSuprimentos);
        }
        return cotacoes;
    }

    private CondicoesPagamento validarCondicaoPagamentoMutante() throws ExceptionService {
        if (this.condPagamento != null) {
            return this.condPagamento;
        }
        throw new ExceptionService("Primeiro, cadastre uma condi\u00e7\u00e3o de pagamento mutante!");
    }

    private HSSFSheet getSheetFile(String file) throws FileNotFoundException, IOException {
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(new File(file)));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        return myWorkBook.getSheetAt(0);
    }

    private CotacaoCompra getCotacaoCompra(HSSFSheet sheet, List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoesCompraSuprimentos) throws ExceptionService {
        CotacaoCompra cotacaoCompra = this.findCotacaoCompra(sheet, cotacoes);
        this.extractDataToCotacaoCompra(sheet, cotacaoCompra);
        ((HelperCotacaoCompra)Context.get(HelperCotacaoCompra.class)).avaliaMelhorFornecedor(cotacaoCompra, opcoesCompraSuprimentos);
        cotacaoCompra = (CotacaoCompra)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOCotacaoCompra(), cotacaoCompra);
        return cotacaoCompra;
    }

    private CotacaoCompra findCotacaoCompra(HSSFSheet sheet, List<CotacaoCompra> cotacoes) throws ExceptionService {
        Long identificador = this.getLongValue((Cell)sheet.getRow(ConstantsServiceCotacaoCompra.ROW_CABECALHO_COTACAO.intValue()).getCell(1));
        for (CotacaoCompra cc : cotacoes) {
            if (!cc.getIdentificador().equals(identificador)) continue;
            return cc;
        }
        CotacaoCompra cotacaoCompra = (CotacaoCompra)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOCotacaoCompra(), identificador);
        if (cotacaoCompra == null) {
            throw new ExceptionService("Ordem de compra " + identificador + " n\u00e3o encontrada no sistema!");
        }
        cotacoes.add(cotacaoCompra);
        return cotacaoCompra;
    }

    private UnidadeFatFornecedor findUnidadeFatFornecedor(HSSFSheet sheet) throws ExceptionService {
        Long identificador = this.getLongValue((Cell)sheet.getRow(ConstantsServiceCotacaoCompra.ROW_CABECALHO_FORNECEDOR.intValue()).getCell(1));
        UnidadeFatFornecedor unidadeFatFornecedor = (UnidadeFatFornecedor)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOUnidadeFaturamentoFornecedor(), identificador);
        if (unidadeFatFornecedor != null) {
            return unidadeFatFornecedor;
        }
        throw new ExceptionService("Unidade Faturamento Fornecedor " + identificador + " n\u00e3o encontrada no sistema!");
    }

    private GradeCor findGradeCor(HSSFSheet sheet, int row) throws ExceptionService {
        Double numericValue = this.getNumericValue((Cell)sheet.getRow(row).getCell(0));
        Integer integerValue = numericValue.intValue();
        Long identificador = Long.parseLong(integerValue.toString());
        GradeCor gradeCor = (GradeCor)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOGradeCor(), identificador);
        if (gradeCor != null) {
            return gradeCor;
        }
        throw new ExceptionService("Grade cor " + identificador + " n\u00e3o encontrada no sistema!");
    }

    private TipoFrete findTipoFrete(Short tipoFrete) throws ExceptionService {
        List tiposFrete = (List)CoreService.simpleFindByCriteria(CoreDAOFactory.getInstance().getDAOTipoFrete(), "fretePorConta", tipoFrete, 0, null, true);
        if (tiposFrete != null && !tiposFrete.isEmpty()) {
            return (TipoFrete)tiposFrete.get(0);
        }
        throw new ExceptionService("Tipo de frete n\u00e3o encontrado, favor verificar a planilha e seu cadastro!");
    }

    private void extractDataToCotacaoCompra(HSSFSheet sheet, CotacaoCompra cotacaoCompra) throws ExceptionService {
        UnidadeFatFornecedor unidadeFatFornecedor = this.findUnidadeFatFornecedor(sheet);
        for (Row row : sheet) {
            if (row.getRowNum() <= ConstantsServiceCotacaoCompra.ROW_CABECALHO_PRODUTOS) continue;
            this.extractRowData(sheet, row, unidadeFatFornecedor, cotacaoCompra);
        }
    }

    private void extractRowData(HSSFSheet sheet, Row row, UnidadeFatFornecedor unidadeFatFornecedor, CotacaoCompra cotacaoCompra) throws ExceptionService {
        if (this.getNumericValue((Cell)sheet.getRow(row.getRowNum()).getCell(0)) != null) {
            GradeCor gradeCor = this.findGradeCor(sheet, row.getRowNum());
            ItemCotacaoCompra itemCotacaoCompra = this.getItemCotacaoCompra(row, cotacaoCompra, gradeCor);
            FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra = this.getFornecedorItemCotacaoCompra(row, itemCotacaoCompra, unidadeFatFornecedor);
            fornecedorItemCotacaoCompra.setValorUnitario(this.getNumericValue(row.getCell(4)));
            fornecedorItemCotacaoCompra.setFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal() != null ? fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal() : new FornecedorItemCotacaoCompraLivroFiscal());
            fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().setValorTotal(Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade()));
            fornecedorItemCotacaoCompra.setCondicoesPagamento(this.validarCondicaoPagamentoMutante());
            fornecedorItemCotacaoCompra.setCondicaoPagamentoMutante(this.validateCondicaoPagmanetoMutante(this.getCellValue(row.getCell(6))));
            fornecedorItemCotacaoCompra.setPrazoEntrega(this.getLongValue(row.getCell(5)));
            fornecedorItemCotacaoCompra.setTipoFrete(this.findTipoFrete(this.getShortValue(row.getCell(7))));
        }
    }

    private ItemCotacaoCompra getItemCotacaoCompra(Row row, CotacaoCompra cotacaoCompra, GradeCor gradeCor) throws ExceptionService {
        for (ItemCotacaoCompra itemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
            if (!itemCotacaoCompra.getGradeCor().equals((Object)gradeCor)) continue;
            return itemCotacaoCompra;
        }
        throw new ExceptionService("Item Cotacao compra n\u00e3o encontrado para o produto: " + gradeCor.getProdutoGrade().getProduto().getIdentificador() + " - " + gradeCor.getProdutoGrade().getProduto().getNome());
    }

    private FornecedorItemCotacaoCompra getFornecedorItemCotacaoCompra(Row row, ItemCotacaoCompra itemCotacaoCompra, UnidadeFatFornecedor unidadeFatFornecedor) throws ExceptionService {
        for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
            if (!fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().equals((Object)unidadeFatFornecedor)) continue;
            return fornecedorItemCotacaoCompra;
        }
        throw new ExceptionService("N\u00e3o foi encontrado um registro da Unidade Faturamento Fornecedor " + unidadeFatFornecedor.getIdentificador() + " - " + unidadeFatFornecedor.getFornecedor().getPessoa().getNome());
    }

    private String validateCondicaoPagmanetoMutante(String condicao) throws ExceptionService {
        if (condicao.endsWith(";")) {
            return condicao;
        }
        throw new ExceptionService("Condi\u00e7\u00e3o de pagamento inv\u00e1lida, favor verificar se as condi\u00e7\u00f5es informadas atendem ao padr\u00e3o! (Ex. 30;60;90;)");
    }

    private Double getNumericValue(Cell cell) {
        String value = this.getCellValue(cell);
        return value != null && !value.isEmpty() ? Double.valueOf(Double.parseDouble(value)) : null;
    }

    private Long getLongValue(Cell cell) {
        String value = this.getCellValue(cell);
        if (value != null) {
            Double doubleValue = Double.parseDouble(value);
            Integer intValue = doubleValue.intValue();
            return Long.parseLong(intValue.toString());
        }
        return null;
    }

    private Short getShortValue(Cell cell) {
        String value = this.getCellValue(cell);
        if (value != null) {
            Double doubleValue = Double.parseDouble(value);
            Integer intValue = doubleValue.intValue();
            return Short.parseShort(intValue.toString());
        }
        return null;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 0: {
                return Double.toString(cell.getNumericCellValue());
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
        }
        return cell.getStringCellValue();
    }
}

