/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.cotacaocompra;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompra;
import com.touchcomp.basementor.model.vo.ConfPlanilhaExcelCotCompraItem;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompraLivroFiscal;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.HelperCotacaoCompra;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;

class UtilLLerPlanilhaCotacaoModelo {
    private CondicoesPagamento condPagamento;

    UtilLLerPlanilhaCotacaoModelo() {
    }

    public List<CotacaoCompra> importarPlanilhaExcelFornecedores(List<File> files, ConfPlanilhaExcelCotCompra modeloPlanilha, CondicoesPagamento condPagamento, OpcoesCompraSuprimentos opcoesCompraSuprimentos) throws FileNotFoundException, IOException, ExceptionService {
        this.condPagamento = condPagamento;
        ArrayList<CotacaoCompra> cotacoes = new ArrayList<CotacaoCompra>();
        for (File f : files) {
            HSSFSheet sheet = this.getSheetFile(f.getAbsolutePath());
            cotacoes.add(this.getCotacaoCompra(sheet, modeloPlanilha, cotacoes, opcoesCompraSuprimentos));
        }
        return cotacoes;
    }

    private CondicoesPagamento validarCondicaoPagamentoMutante() throws ExceptionService {
        if (this.condPagamento != null) {
            return this.condPagamento;
        }
        throw new ExceptionService("Primeiro, cadastre uma condi\u00e7\u00e3o de pagamento mutante!");
    }

    private HSSFSheet getSheetFile(String file) throws FileNotFoundException, IOException {
        POIFSFileSystem myFileSystem = new POIFSFileSystem((InputStream)new FileInputStream(new File(file)));
        HSSFWorkbook myWorkBook = new HSSFWorkbook(myFileSystem);
        return myWorkBook.getSheetAt(0);
    }

    private CotacaoCompra getCotacaoCompra(HSSFSheet sheet, ConfPlanilhaExcelCotCompra modeloPlanilha, List<CotacaoCompra> cotacoes, OpcoesCompraSuprimentos opcoesCompraSuprimentos) throws ExceptionService {
        CotacaoCompra cotacaoCompra = this.findCotacaoCompra(sheet, modeloPlanilha, cotacoes);
        this.extractDataToCotacaoCompra(sheet, cotacaoCompra, modeloPlanilha);
        ((HelperCotacaoCompra)Context.get(HelperCotacaoCompra.class)).avaliaMelhorFornecedor(cotacaoCompra, opcoesCompraSuprimentos);
        cotacaoCompra = (CotacaoCompra)CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOCotacaoCompra(), cotacaoCompra);
        return cotacaoCompra;
    }

    private CotacaoCompra findCotacaoCompra(HSSFSheet sheet, ConfPlanilhaExcelCotCompra modelo, List<CotacaoCompra> cotacoes) throws ExceptionService {
        ConfPlanilhaExcelCotCompraItem item = this.getItem(modelo.getItensConf(), "codigo_cotacao");
        HSSFRow row = sheet.getRow(item.getLinha() - 1);
        if (row == null) {
            throw new ExceptionService("Identificador da cota\u00e7\u00e3o n\u00e3o encontrado na planilha. Linha " + item.getLinha() + " - " + item.getColuna());
        }
        HSSFCell cell = row.getCell(item.getColuna() - 1);
        if (cell == null) {
            throw new ExceptionService("Identificador da cota\u00e7\u00e3o n\u00e3o encontrado. Linha " + item.getLinha() + " - " + item.getColuna());
        }
        Long identificador = this.getLongValue((Cell)cell);
        for (CotacaoCompra cc : cotacoes) {
            if (!cc.getIdentificador().equals(identificador)) continue;
            return cc;
        }
        CotacaoCompra cotacaoCompra = (CotacaoCompra)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOCotacaoCompra(), identificador);
        if (cotacaoCompra == null) {
            throw new ExceptionService("Ordem de compra " + identificador + " n\u00e3o encontrada no sistema!");
        }
        return cotacaoCompra;
    }

    private UnidadeFatFornecedor findUnidadeFatFornecedor(HSSFSheet sheet, ConfPlanilhaExcelCotCompra modelo) throws ExceptionService {
        ConfPlanilhaExcelCotCompraItem item = this.getItem(modelo.getItensConf(), "codigo_fornecedor");
        HSSFRow row = sheet.getRow(item.getLinha() - 1);
        if (row == null) {
            throw new ExceptionService("Identificador do fornecedor n\u00e3o encontrado na planilha. Linha " + item.getLinha() + " - " + item.getColuna());
        }
        HSSFCell cell = row.getCell(item.getColuna() - 1);
        if (cell == null) {
            throw new ExceptionService("Identificador do fornecedor n\u00e3o encontrado. Linha " + item.getLinha() + " - " + item.getColuna());
        }
        Long identificador = this.getLongValue((Cell)cell);
        UnidadeFatFornecedor unidadeFatFornecedor = (UnidadeFatFornecedor)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOUnidadeFaturamentoFornecedor(), identificador);
        if (unidadeFatFornecedor != null) {
            return unidadeFatFornecedor;
        }
        throw new ExceptionService("Unidade Faturamento Fornecedor " + identificador + " n\u00e3o encontrada no sistema!");
    }

    private GradeCor findGradeCor(HSSFSheet sheet, int rowProduto, int columnProduto, int rowIdGrade, Integer columnIdGrade, int rowNomeGrade, Integer columnNomeGrade) throws ExceptionService {
        HSSFCell cell;
        Double numericValue = this.getNumericValue((Cell)sheet.getRow(rowProduto).getCell(columnProduto - 1));
        if (numericValue <= 0.0) {
            return null;
        }
        Integer integerValue = numericValue.intValue();
        Long identificador = Long.parseLong(integerValue.toString());
        GradeCor gradeCor = null;
        Produto produto = (Produto)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOProduto(), identificador);
        Boolean achou = false;
        if (rowIdGrade > 0 && columnIdGrade > 0) {
            numericValue = this.getNumericValue((Cell)sheet.getRow(rowIdGrade).getCell(columnIdGrade - 1));
            integerValue = numericValue.intValue();
            identificador = Long.parseLong(integerValue.toString());
            if (produto != null && !produto.getGradesProduto().isEmpty()) {
                block0: for (ProdutoGrade produtoGrade : produto.getGradesProduto()) {
                    for (GradeCor gc : produtoGrade.getGradesCores()) {
                        if (!gc.getIdentificador().equals(identificador)) continue;
                        gradeCor = gc;
                        achou = true;
                        continue block0;
                    }
                }
            }
        } else if (!achou.booleanValue() && rowNomeGrade > 0 && columnNomeGrade > 0 && (cell = sheet.getRow(rowNomeGrade).getCell(columnNomeGrade - 1)).getCellType() == 1) {
            String nomeGradeCor = cell.getStringCellValue();
            if (produto != null && !produto.getGradesProduto().isEmpty()) {
                block2: for (ProdutoGrade produtoGrade : produto.getGradesProduto()) {
                    for (GradeCor gc : produtoGrade.getGradesCores()) {
                        if (!gc.getCor().getNome().equals(nomeGradeCor)) continue;
                        gradeCor = gc;
                        achou = true;
                        continue block2;
                    }
                }
            }
        }
        if (!achou.booleanValue() && produto != null && !produto.getGradesProduto().isEmpty()) {
            ProdutoGrade pg = (ProdutoGrade)produto.getGradesProduto().get(0);
            gradeCor = (GradeCor)pg.getGradesCores().get(0);
        }
        if (gradeCor != null) {
            return gradeCor;
        }
        throw new ExceptionService("Grade cor " + identificador + " n\u00e3o encontrada no sistema!");
    }

    private TipoFrete findTipoFrete(Short tipoFrete) throws ExceptionService {
        List tiposFrete = (List)CoreService.simpleFindByCriteria(CoreDAOFactory.getInstance().getDAOTipoFrete(), "fretePorConta", tipoFrete, 0, null, true);
        if (tiposFrete != null && !tiposFrete.isEmpty()) {
            return (TipoFrete)tiposFrete.get(0);
        }
        throw new ExceptionService("Tipo de frete n\u00e3o encontrado com o tipo " + tipoFrete + ", favor verificar a planilha e seu cadastro!");
    }

    private void extractDataToCotacaoCompra(HSSFSheet sheet, CotacaoCompra cotacaoCompra, ConfPlanilhaExcelCotCompra modelo) throws ExceptionService {
        GradeCor gradeCor;
        UnidadeFatFornecedor unidadeFatFornecedor = this.findUnidadeFatFornecedor(sheet, modelo);
        ConfPlanilhaExcelCotCompraItem itemIdProduto = this.getItem(modelo.getItensConf(), "id_produto");
        ConfPlanilhaExcelCotCompraItem itemValorUnitario = this.getItem(modelo.getItensConf(), "valor_unitario");
        ConfPlanilhaExcelCotCompraItem itemTipoFrete = this.getItem(modelo.getItensConf(), "tipo_frete");
        ConfPlanilhaExcelCotCompraItem itemCondPag = this.getItem(modelo.getItensConf(), "condicao_pagamento");
        ConfPlanilhaExcelCotCompraItem itemPrazoEntrega = this.getItem(modelo.getItensConf(), "prazo_entrega");
        ConfPlanilhaExcelCotCompraItem itemPercFrete = this.getItem(modelo.getItensConf(), "perc_frete");
        ConfPlanilhaExcelCotCompraItem itemValorFrete = this.getItem(modelo.getItensConf(), "valor_frete");
        ConfPlanilhaExcelCotCompraItem itemPercDesconto = this.getItem(modelo.getItensConf(), "perc_desconto");
        ConfPlanilhaExcelCotCompraItem itemValorDesconto = this.getItem(modelo.getItensConf(), "valor_desconto");
        ConfPlanilhaExcelCotCompraItem itemPercSeguro = this.getItem(modelo.getItensConf(), "perc_seguro");
        ConfPlanilhaExcelCotCompraItem itemValorSeguro = this.getItem(modelo.getItensConf(), "valor_seguro");
        ConfPlanilhaExcelCotCompraItem itemPercDespAcess = this.getItem(modelo.getItensConf(), "perc_desp_acessorias");
        ConfPlanilhaExcelCotCompraItem itemValorDespAcess = this.getItem(modelo.getItensConf(), "valor_desp_acessorias");
        ConfPlanilhaExcelCotCompraItem itemObservacao = this.getItem(modelo.getItensConf(), "observacao");
        ConfPlanilhaExcelCotCompraItem itemIdGradeCor = this.getItem(modelo.getItensConf(), "id_grade_cor");
        ConfPlanilhaExcelCotCompraItem itemNomeGradeCor = this.getItem(modelo.getItensConf(), "nome_grade_cor");
        int linhaProdGrade = itemIdProduto != null ? itemIdProduto.getLinha() - 1 : 0;
        int linhaValorUnitario = itemValorUnitario != null ? itemValorUnitario.getLinha() - 1 : 0;
        int linhaTipoFrete = itemTipoFrete != null ? itemTipoFrete.getLinha() - 1 : 0;
        int linhaCondPag = itemCondPag != null ? itemCondPag.getLinha() - 1 : 0;
        int linhaPrazoEntrega = itemPrazoEntrega != null ? itemPrazoEntrega.getLinha() - 1 : 0;
        int linhaPercFrete = itemPercFrete != null ? itemPercFrete.getLinha() - 1 : 0;
        int linhaValorFrete = itemValorFrete != null ? itemValorFrete.getLinha() - 1 : 0;
        int linhaPercDesconto = itemPercDesconto != null ? itemPercDesconto.getLinha() - 1 : 0;
        int linhaValorDesconto = itemValorDesconto != null ? itemValorDesconto.getLinha() - 1 : 0;
        int linhaPercSeguro = itemPercSeguro != null ? itemPercSeguro.getLinha() - 1 : 0;
        int linhaValorSeguro = itemValorSeguro != null ? itemValorSeguro.getLinha() - 1 : 0;
        int linhaPercDespAcess = itemPercDespAcess != null ? itemPercDespAcess.getLinha() - 1 : 0;
        int linhaValorDespAcess = itemValorDespAcess != null ? itemValorDespAcess.getLinha() - 1 : 0;
        int linhaObservacao = itemObservacao != null ? itemObservacao.getLinha() - 1 : 0;
        int linhaIdGradeCor = itemIdGradeCor != null && ToolMethods.isEquals((Object)itemIdGradeCor.getUtilizar(), (Object)1) ? itemIdGradeCor.getLinha() - 1 : 0;
        int colunaIdGradeCor = itemIdGradeCor != null && ToolMethods.isEquals((Object)itemIdGradeCor.getUtilizar(), (Object)1) ? itemIdGradeCor.getColuna() : 0;
        int linhaNomeGradeCor = itemNomeGradeCor != null && ToolMethods.isEquals((Object)itemNomeGradeCor.getUtilizar(), (Object)1) ? itemNomeGradeCor.getLinha() - 1 : 0;
        int colunaNomeGradeCor = itemNomeGradeCor != null && ToolMethods.isEquals((Object)itemNomeGradeCor.getUtilizar(), (Object)1) ? itemNomeGradeCor.getColuna() : 0;
        int loops = 0;
        while ((gradeCor = this.findGradeCor(sheet, linhaProdGrade, itemIdProduto.getColuna(), linhaIdGradeCor, colunaIdGradeCor, linhaNomeGradeCor, colunaNomeGradeCor)) != null) {
            HSSFCell cell;
            linhaProdGrade += itemIdProduto.getSalto().intValue();
            if (linhaIdGradeCor > 0) {
                linhaIdGradeCor += itemIdGradeCor.getSalto().intValue();
            }
            if (linhaNomeGradeCor > 0) {
                linhaNomeGradeCor += itemNomeGradeCor.getSalto().intValue();
            }
            ItemCotacaoCompra itemCotacaoCompra = this.getItemCotacaoCompra(cotacaoCompra, gradeCor);
            FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra = this.getFornecedorItemCotacaoCompra(itemCotacaoCompra, unidadeFatFornecedor);
            fornecedorItemCotacaoCompra.setValidado(Short.valueOf((short)1));
            fornecedorItemCotacaoCompra.setFornecedorItemCotacaoCompraLivroFiscal(fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal() != null ? fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal() : new FornecedorItemCotacaoCompraLivroFiscal());
            if (itemValorUnitario != null && itemValorUnitario.getUtilizar() != null && itemValorUnitario.getUtilizar() == 1 && sheet.getRow(linhaValorUnitario) != null && sheet.getRow(linhaValorUnitario).getCell(itemValorUnitario.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaValorUnitario).getCell(itemValorUnitario.getColuna() - 1);
                fornecedorItemCotacaoCompra.setValorUnitario(this.getNumericValue((Cell)cell));
                linhaValorUnitario += itemValorUnitario.getSalto().intValue();
            }
            if (itemPercDesconto != null && itemPercDesconto.getUtilizar() != null && itemPercDesconto.getUtilizar() == 1 && sheet.getRow(linhaPercDesconto) != null && sheet.getRow(linhaPercDesconto).getCell(itemPercDesconto.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaPercDesconto).getCell(itemPercDesconto.getColuna() - 1);
                fornecedorItemCotacaoCompra.setPercentualDesconto(this.getNumericValue((Cell)cell));
                linhaPercDesconto += itemPercDesconto.getSalto().intValue();
            }
            if (itemValorDesconto != null && itemValorDesconto.getUtilizar() != null && itemValorDesconto.getUtilizar() == 1 && sheet.getRow(linhaValorDesconto) != null && sheet.getRow(linhaValorDesconto).getCell(itemValorDesconto.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaValorDesconto).getCell(itemValorDesconto.getColuna() - 1);
                fornecedorItemCotacaoCompra.setValorDesconto(this.getNumericValue((Cell)cell));
                linhaValorDesconto += itemValorDesconto.getSalto().intValue();
            }
            if (itemPercFrete != null && itemPercFrete.getUtilizar() != null && itemPercFrete.getUtilizar() == 1 && sheet.getRow(linhaPercFrete) != null && sheet.getRow(linhaPercFrete).getCell(itemPercFrete.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaPercFrete).getCell(itemPercFrete.getColuna() - 1);
                fornecedorItemCotacaoCompra.setPercentualFrete(this.getNumericValue((Cell)cell));
                linhaPercFrete += itemPercFrete.getSalto().intValue();
            }
            if (itemValorFrete != null && itemValorFrete.getUtilizar() != null && itemValorFrete.getUtilizar() == 1 && sheet.getRow(linhaValorFrete) != null && sheet.getRow(linhaValorFrete).getCell(itemValorFrete.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaValorFrete).getCell(itemValorFrete.getColuna() - 1);
                fornecedorItemCotacaoCompra.setValorFrete(this.getNumericValue((Cell)cell));
                linhaValorFrete += itemValorFrete.getSalto().intValue();
            }
            if (itemPercSeguro != null && itemPercSeguro.getUtilizar() != null && itemPercSeguro.getUtilizar() == 1 && sheet.getRow(linhaPercSeguro) != null && sheet.getRow(linhaPercSeguro).getCell(itemPercSeguro.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaPercSeguro).getCell(itemPercSeguro.getColuna() - 1);
                fornecedorItemCotacaoCompra.setPercentualSeguro(this.getNumericValue((Cell)cell));
                linhaPercSeguro += itemPercSeguro.getSalto().intValue();
            }
            if (itemValorSeguro != null && itemValorSeguro.getUtilizar() != null && itemValorSeguro.getUtilizar() == 1 && sheet.getRow(linhaValorSeguro) != null && sheet.getRow(linhaValorSeguro).getCell(itemValorSeguro.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaValorSeguro).getCell(itemValorSeguro.getColuna() - 1);
                fornecedorItemCotacaoCompra.setValorFrete(this.getNumericValue((Cell)cell));
                linhaValorSeguro += itemValorSeguro.getSalto().intValue();
            }
            if (itemPercDespAcess != null && itemPercDespAcess.getUtilizar() != null && itemPercDespAcess.getUtilizar() == 1 && sheet.getRow(linhaPercDespAcess) != null && sheet.getRow(linhaPercDespAcess).getCell(itemPercDespAcess.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaPercDespAcess).getCell(itemPercDespAcess.getColuna() - 1);
                fornecedorItemCotacaoCompra.setPercentualDespesasAcessorias(this.getNumericValue((Cell)cell));
                linhaPercDespAcess += itemPercDespAcess.getSalto().intValue();
            }
            if (itemValorDespAcess != null && itemValorDespAcess.getUtilizar() != null && itemValorDespAcess.getUtilizar() == 1 && sheet.getRow(linhaValorDespAcess) != null && sheet.getRow(linhaValorDespAcess).getCell(itemValorDespAcess.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaValorDespAcess).getCell(itemValorDespAcess.getColuna() - 1);
                fornecedorItemCotacaoCompra.setValorDespesasAcessorias(this.getNumericValue((Cell)cell));
                linhaValorDespAcess += itemValorDespAcess.getSalto().intValue();
            }
            fornecedorItemCotacaoCompra.getFornecedorItemCotacaoCompraLivroFiscal().setValorTotal(Double.valueOf(fornecedorItemCotacaoCompra.getValorUnitario() * fornecedorItemCotacaoCompra.getItemCotacaoCompra().getQuantidade()));
            if (itemCondPag != null && itemCondPag.getUtilizar() != null && itemCondPag.getUtilizar() == 1 && sheet.getRow(linhaCondPag) != null && sheet.getRow(linhaCondPag).getCell(itemCondPag.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaCondPag).getCell(itemCondPag.getColuna() - 1);
                if (cell.getCellType() == 1) {
                    condPag = cell.getStringCellValue();
                    fornecedorItemCotacaoCompra.setCondicaoPagamentoMutante(this.validateCondicaoPagmanetoMutante((String)condPag));
                } else if (cell.getCellType() == 0) {
                    condPag = cell.getNumericCellValue();
                    fornecedorItemCotacaoCompra.setCondicaoPagamentoMutante(this.validateCondicaoPagmanetoMutante(ContatoFormatUtil.formataNumero((Number)condPag, (int)0) + ";"));
                }
                fornecedorItemCotacaoCompra.setCondicoesPagamento(this.validarCondicaoPagamentoMutante());
                linhaCondPag += itemCondPag.getSalto().intValue();
            }
            if (itemPrazoEntrega != null && itemPrazoEntrega.getUtilizar() != null && itemPrazoEntrega.getUtilizar() == 1 && sheet.getRow(linhaPrazoEntrega) != null && sheet.getRow(linhaPrazoEntrega).getCell(itemPrazoEntrega.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaPrazoEntrega).getCell(itemPrazoEntrega.getColuna() - 1);
                fornecedorItemCotacaoCompra.setPrazoEntrega(this.getLongValue((Cell)cell));
                linhaPrazoEntrega += itemPrazoEntrega.getSalto().intValue();
            }
            if (itemTipoFrete != null && itemTipoFrete.getUtilizar() != null && itemTipoFrete.getUtilizar() == 1 && sheet.getRow(linhaTipoFrete) != null && sheet.getRow(linhaTipoFrete).getCell(itemTipoFrete.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaTipoFrete).getCell(itemTipoFrete.getColuna() - 1);
                TipoFrete tp = this.findTipoFrete(this.getShortValue((Cell)cell));
                fornecedorItemCotacaoCompra.setTipoFrete(tp);
                linhaTipoFrete += itemTipoFrete.getSalto().intValue();
            }
            if (itemObservacao != null && itemObservacao.getUtilizar() != null && itemObservacao.getUtilizar() == 1 && sheet.getRow(linhaObservacao) != null && sheet.getRow(linhaObservacao).getCell(itemObservacao.getColuna() - 1) != null) {
                cell = sheet.getRow(linhaObservacao).getCell(itemObservacao.getColuna() - 1);
                fornecedorItemCotacaoCompra.setObservacao(cell.getStringCellValue());
                linhaObservacao += itemObservacao.getSalto().intValue();
            }
            if (++loops > 5000) {
                throw new ExceptionService("Erro ao ler as planilhas. Loop sem fim. Verifique o campo salto na configura\u00e7\u00e3o da planilha.");
            }
            if (loops != cotacaoCompra.getItensCotacaoCompra().size() && sheet.getRow(linhaProdGrade) != null) continue;
        }
    }

    private ItemCotacaoCompra getItemCotacaoCompra(CotacaoCompra cotacaoCompra, GradeCor gradeCor) throws ExceptionService {
        for (ItemCotacaoCompra itemCotacaoCompra : cotacaoCompra.getItensCotacaoCompra()) {
            if (!itemCotacaoCompra.getGradeCor().getIdentificador().equals(gradeCor.getIdentificador())) continue;
            return itemCotacaoCompra;
        }
        throw new ExceptionService("Item Cotacao compra n\u00e3o encontrado para o produto: " + gradeCor.getProdutoGrade().getProduto().getIdentificador() + " - " + gradeCor.getProdutoGrade().getProduto().getNome());
    }

    private FornecedorItemCotacaoCompra getFornecedorItemCotacaoCompra(ItemCotacaoCompra itemCotacaoCompra, UnidadeFatFornecedor unidadeFatFornecedor) throws ExceptionService {
        for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
            if (!fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().equals((Object)unidadeFatFornecedor)) continue;
            return fornecedorItemCotacaoCompra;
        }
        throw new ExceptionService("N\u00e3o foi encontrado um registro da Unidade Faturamento Fornecedor " + unidadeFatFornecedor.getIdentificador() + " - " + unidadeFatFornecedor.getFornecedor().getPessoa().getNome());
    }

    private String validateCondicaoPagmanetoMutante(String condicao) throws ExceptionService {
        if (condicao.endsWith(";")) {
            return condicao;
        }
        throw new ExceptionService("Condi\u00e7\u00e3o de pagamento inv\u00e1lida, favor verificar se as condi\u00e7\u00f5es informadas atendem ao padr\u00e3o! (Ex. 30;60;90;)");
    }

    private Double getNumericValue(Cell cell) {
        String value = this.getCellValue(cell);
        return value != null && !value.isEmpty() ? Double.parseDouble(value) : 0.0;
    }

    private Long getLongValue(Cell cell) {
        String value = this.getCellValue(cell);
        if (value != null && !value.isEmpty()) {
            Double doubleValue = Double.parseDouble(value);
            Integer intValue = doubleValue.intValue();
            return Long.parseLong(intValue.toString());
        }
        return null;
    }

    private Short getShortValue(Cell cell) {
        String value = this.getCellValue(cell);
        if (value != null && !value.isEmpty()) {
            Double doubleValue = Double.parseDouble(value);
            Integer intValue = doubleValue.intValue();
            return Short.parseShort(intValue.toString());
        }
        return null;
    }

    private String getCellValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 1: {
                return cell.getStringCellValue();
            }
            case 0: {
                return Double.toString(cell.getNumericCellValue());
            }
            case 4: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
        }
        return cell.getStringCellValue();
    }

    private ConfPlanilhaExcelCotCompraItem getItem(List<ConfPlanilhaExcelCotCompraItem> itens, String key) {
        for (ConfPlanilhaExcelCotCompraItem item : itens) {
            if (!item.getChave().equalsIgnoreCase(key)) continue;
            return item;
        }
        return null;
    }
}

