/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.criarmarketingprodutoabaixovenda;

import com.touchcomp.basementor.model.vo.ClassificacaoMarketing;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.ProcedenciaSolicitacao;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoaLog;
import com.touchcomp.basementor.model.vo.Usuario;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.finder.BaseCriteria;
import mentorcore.service.CoreService;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilCriarMarketingProdutoAbaixoVenda {
    UtilCriarMarketingProdutoAbaixoVenda() {
    }

    static synchronized void criarMarketingProdutoAbaixoVenda(Long idUsuario, Long idEmpresa, Long idProcedenciaSolicitacao, Long idClassificacaoMarketing) throws ExceptionDatabase, ExceptionService {
        Date pDataEmissaoInicial = DateUtil.intToDate(2017, 10, 2);
        Date pDataEmissaoFinal = DateUtil.intToDate(2017, 10, 2);
        List listCriticasVendas = UtilCriarMarketingProdutoAbaixoVenda.pesquisarCriticasVendas(pDataEmissaoInicial, pDataEmissaoFinal);
        List result = UtilCriarMarketingProdutoAbaixoVenda.preencherClassificacaoClientes(listCriticasVendas);
        UtilCriarMarketingProdutoAbaixoVenda.preencherProdutos(result, listCriticasVendas);
        UtilCriarMarketingProdutoAbaixoVenda.verificarMarketing(result, idUsuario, idEmpresa, idProcedenciaSolicitacao, idClassificacaoMarketing);
    }

    private static List pesquisarCriticasVendas(Date pDataEmissaoInicial, Date pDataEmissaoFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT cp.identificador                         AS F_ID_PESSOA, cc.identificador                         AS F_ID_CLASSIFICACAO_CLIENTES, cc.descricao                             AS F_CLASSIFICACAO_CLIENTES, p.identificador                          AS F_ID_PRODUTO, p.nome                                   AS F_PRODUTO, SUM(i.quantidadeTotal)                   AS F_QUANTIDADE, SUM(i.quantidadeTotal * i.valorUnitario) AS F_VALOR_TOTAL FROM ItemNotaFiscalPropria          i INNER JOIN i.notaFiscalPropria      n INNER JOIN n.unidadeFatCliente      u INNER JOIN u.cliente                c INNER JOIN c.pessoa                cp INNER JOIN c.classificacaoClientes cc INNER JOIN i.produto                p INNER JOIN i.itemNotaLivroFiscal    l INNER JOIN l.cfop                  lc INNER JOIN n.naturezaOperacao      nn INNER JOIN n.empresa                e WHERE n.dataEmissaoNota BETWEEN :pDataEmissaoInicial AND :pDataEmissaoFinal AND   lc.cfopReceitaVenda = :cfopReceitaVenda AND   nn.entradaSaida = :entradaSaida GROUP BY cp.identificador,          cc.identificador,          cc.descricao,           p.identificador,           p.nome ORDER BY cc.identificador,           p.identificador");
        q.setDate("pDataEmissaoInicial", pDataEmissaoInicial);
        q.setDate("pDataEmissaoFinal", pDataEmissaoFinal);
        q.setShort("cfopReceitaVenda", (short)1);
        q.setShort("entradaSaida", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static List preencherClassificacaoClientes(List<HashMap> listCriticasVendas) {
        ArrayList result = new ArrayList();
        for (HashMap h : listCriticasVendas) {
            Predicate<HashMap> p2 = e -> e.get("F_ID_CLASSIFICACAO_CLIENTES").equals(h.get("F_ID_CLASSIFICACAO_CLIENTES"));
            if (result.stream().anyMatch(p2)) continue;
            HashMap map = new HashMap();
            map.put("F_ID_PESSOA", h.get("F_ID_PESSOA"));
            map.put("F_ID_CLASSIFICACAO_CLIENTES", h.get("F_ID_CLASSIFICACAO_CLIENTES"));
            map.put("F_CLASSIFICACAO_CLIENTES", h.get("F_CLASSIFICACAO_CLIENTES"));
            result.add(map);
        }
        return result;
    }

    private static void preencherProdutos(List<HashMap> result, List<HashMap> listCriticasVendas) {
        for (HashMap h : result) {
            Long idClassificacaoClientes = (Long)h.get("F_ID_CLASSIFICACAO_CLIENTES");
            List<HashMap> listProdClassCliente = UtilCriarMarketingProdutoAbaixoVenda.pesquisarProdutosClassCliente(idClassificacaoClientes);
            UtilCriarMarketingProdutoAbaixoVenda.verificarProdutosVendidos(h, listProdClassCliente, listCriticasVendas, idClassificacaoClientes);
        }
    }

    private static List<HashMap> pesquisarProdutosClassCliente(Long idClassificacaoClientes) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("SELECT p.identificador AS F_ID_PRODUTO, p.nome          AS F_PRODUTO, vp.quantidade   AS F_QUANTIDADE, vp.valorTotal   AS F_VALOR_TOTAL FROM ItemPrevVendasClassCliente         i INNER JOIN i.classificacaoClientes      c INNER JOIN i.prevVendasClassCliente    pc INNER JOIN pc.prevVendasProduto        pp INNER JOIN pp.prevVendasProdutoProduto vp INNER JOIN vp.produto                   p WHERE c.identificador = :idClassificacaoClientes ORDER BY p.identificador");
        q.setLong("idClassificacaoClientes", idClassificacaoClientes.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private static void verificarProdutosVendidos(HashMap h, List<HashMap> listProdClassCliente, List<HashMap> listCriticasVendas, Long idClassificacaoClientes) {
        ArrayList listProdutosVendidosComTabela = new ArrayList();
        for (HashMap hCriticasVendas : listCriticasVendas) {
            if (!idClassificacaoClientes.equals((Long)hCriticasVendas.get("F_ID_CLASSIFICACAO_CLIENTES"))) continue;
            UtilCriarMarketingProdutoAbaixoVenda.verificarProdutosTabela(hCriticasVendas, listProdClassCliente, listProdutosVendidosComTabela);
        }
        h.put("F_LIST_PRODUTOS_VENDIDOS_COM_TABELA", listProdutosVendidosComTabela);
    }

    private static void verificarProdutosTabela(HashMap hCriticasVendas, List<HashMap> listProdClassCliente, List listProdutosVendidosComTabela) {
        for (HashMap hProdClassCliente : listProdClassCliente) {
            if (!hCriticasVendas.get("F_ID_PRODUTO").equals(hProdClassCliente.get("F_ID_PRODUTO"))) continue;
            Double quantidadeVendida = (Double)hCriticasVendas.get("F_QUANTIDADE");
            Double quantidadePrevista = (Double)hProdClassCliente.get("F_QUANTIDADE");
            if (!(quantidadeVendida < quantidadePrevista)) continue;
            listProdutosVendidosComTabela.add(UtilCriarMarketingProdutoAbaixoVenda.criarProdutosVendidosComTabela(hCriticasVendas, hProdClassCliente, quantidadeVendida, quantidadePrevista));
        }
    }

    private static HashMap criarProdutosVendidosComTabela(HashMap hCriticasVendas, HashMap hProdClassCliente, Double quantidadeVendida, Double quantidadePrevista) {
        Long idProduto = (Long)hCriticasVendas.get("F_ID_PRODUTO");
        String produto = (String)hCriticasVendas.get("F_PRODUTO");
        Double percentualQuantidade = quantidadeVendida * 100.0 / quantidadePrevista;
        Double valorVendida = (Double)hCriticasVendas.get("F_VALOR_TOTAL");
        Double valorPrevista = (Double)hProdClassCliente.get("F_VALOR_TOTAL");
        Double percentualValor = valorVendida * 100.0 / valorPrevista;
        HashMap<String, Object> h = new HashMap<String, Object>();
        h.put("F_ID_PRODUTO", idProduto);
        h.put("F_PRODUTO", produto);
        h.put("F_QUANTIDADE_PREVISTA", quantidadePrevista);
        h.put("F_QUANTIDADE_VENDIDA", quantidadeVendida);
        h.put("F_PERCENTUAL_QUANTIDADE", percentualQuantidade);
        h.put("F_VALOR_PREVISTA", valorPrevista);
        h.put("F_VALOR_VENDIDA", valorVendida);
        h.put("F_PERCENTUAL_VALOR", percentualValor);
        return h;
    }

    private static void verificarMarketing(List<HashMap> result, Long idUsuario, Long idEmpresa, Long idProcedenciaSolicitacao, Long idClassificacaoMarketing) throws ExceptionDatabase, ExceptionService {
        ArrayList<RelacionamentoPessoa> listMarketing = new ArrayList<RelacionamentoPessoa>();
        for (HashMap h : result) {
            Long idPessoa = (Long)h.get("F_ID_PESSOA");
            List listProdutosVendidosComTabela = (List)h.get("F_LIST_PRODUTOS_VENDIDOS_COM_TABELA");
            if (listProdutosVendidosComTabela == null || listProdutosVendidosComTabela.isEmpty()) continue;
            listMarketing.add(UtilCriarMarketingProdutoAbaixoVenda.criarMarketing(idPessoa, listProdutosVendidosComTabela, idUsuario, idEmpresa, idProcedenciaSolicitacao, idClassificacaoMarketing));
        }
        CoreDAOFactory.getInstance().getRelacionamentoPessoaDAO().saveOrUpdateCollection(listMarketing);
    }

    private static RelacionamentoPessoa criarMarketing(Long idPessoa, List listProdutosVendidosComTabela, Long idUsuario, Long idEmpresa, Long idProcedenciaSolicitacao, Long idClassificacaoMarketing) throws ExceptionDatabase, ExceptionService {
        Pessoa p = (Pessoa)CoreDAOFactory.getInstance().getDAOPessoa().findByPrimaryKey(idPessoa);
        Usuario u = (Usuario)CoreDAOFactory.getInstance().getDAOUsuario().findByPrimaryKey(idUsuario);
        Empresa e = (Empresa)CoreDAOFactory.getInstance().getDAOEmpresa().findByPrimaryKey(idEmpresa);
        ProcedenciaSolicitacao s = (ProcedenciaSolicitacao)CoreDAOFactory.getInstance().getDAOProcedenciaSolicitacao().findByPrimaryKey(idProcedenciaSolicitacao);
        ClassificacaoMarketing c = (ClassificacaoMarketing)CoreDAOFactory.getInstance().getDAOClassificacaoMarketing().findByPrimaryKey(idClassificacaoMarketing);
        RelacionamentoPessoa r = new RelacionamentoPessoa();
        r = new RelacionamentoPessoa();
        ArrayList<RelacionamentoPessoaLog> firstAgend = new ArrayList<RelacionamentoPessoaLog>();
        RelacionamentoPessoaLog l = new RelacionamentoPessoaLog();
        l.setDataAgendamento(new Date());
        l.setFinalizado(Short.valueOf((short)0));
        l.setRelacionamentoPessoa(r);
        l.setUsuario(u);
        l.setUsuarioAgendamento(u);
        firstAgend.add(l);
        r.setAgendamentos(firstAgend);
        r.setAssunto(UtilCriarMarketingProdutoAbaixoVenda.criarAssunto(listProdutosVendidosComTabela));
        r.setClassificacaoMarketing(c);
        r.setDataCadastro(new Date());
        r.setDataRelacionamento(new Date());
        r.setEmailContato(CoreUtilityFactory.getUtilityPessoa().getPrimeiroEmailsAtivosEnviarRel(p));
        r.setEmpresa(e);
        r.setOrigemRel("Cr\u00edticas de Vendas");
        r.setEmailsEnviados(CoreUtilityFactory.getUtilityPessoa().getEmailsAtivosEnviarRel(p));
        r.setPessoa(p);
        r.setNrProtocolo(UtilCriarMarketingProdutoAbaixoVenda.findNrProtocolo());
        r.setPrioridadeMarketing(UtilCriarMarketingProdutoAbaixoVenda.getPrioridadeMarketing());
        r.setProcedenciaSolicitacao(s);
        r.setUsuario(u);
        r.setUsuarioAgendamento(u);
        r.setSolucionado(Short.valueOf((short)0));
        return r;
    }

    private static Long findNrProtocolo() {
        return (Long)CoreDAOFactory.getInstance().getRelacionamentoPessoaDAO().findNrProtocolo();
    }

    private static PrioridadeMarketing getPrioridadeMarketing() throws ExceptionService {
        BaseCriteria b = BaseCriteria.create(CoreDAOFactory.getInstance().getDAOPrioridadeMarketing().getVOClass());
        b.and().equal("identificador", 3L);
        PrioridadeMarketing p = (PrioridadeMarketing)CoreService.executeSearchUniqueResult(b);
        return p;
    }

    private static String criarAssunto(List<HashMap> listProdutosVendidosComTabela) {
        Object assunto = "";
        for (HashMap h : listProdutosVendidosComTabela) {
            Long idProduto = (Long)h.get("F_ID_PRODUTO");
            String produto = (String)h.get("F_PRODUTO");
            Double quantidadePrevista = (Double)h.get("F_QUANTIDADE_PREVISTA");
            Double quantidadeVendida = (Double)h.get("F_QUANTIDADE_VENDIDA");
            Double percentualQuantidade = (Double)h.get("F_PERCENTUAL_QUANTIDADE");
            assunto = (String)assunto + idProduto.toString() + " - " + produto + "     Quant. Prevista: " + quantidadePrevista.toString() + "     Quant. Vendida: " + quantidadeVendida.toString() + "     Percentual: " + percentualQuantidade.toString();
            assunto = (String)assunto + "/n";
        }
        return assunto;
    }
}

