/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.ctexmlnfectereceive;

import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorxml.model.XMLNFeCTe;
import com.touchcomp.basementorxml.service.interfaces.ServiceXMLNFeCTe;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;

class UtilCTeXMLNFeReceive {
    private static final TLogger logger = TLogger.get(UtilCTeXMLNFeReceive.class);

    UtilCTeXMLNFeReceive() {
    }

    public Object readXMLNFeCTeFromEmail(String senhaEmail, String email, String lerQtsMsgSt, String servidorEntrada, String pastaEntrada) {
        Properties props = new Properties();
        props.put("mail.imaps.ssl.trust", "*");
        OpcoesFaturamentoTransp opcoes = null;
        Session session = Session.getDefaultInstance((Properties)props);
        session.setDebug(false);
        Integer lerQtsMsg = 0;
        if (lerQtsMsgSt != null && lerQtsMsgSt.trim().length() > 0) {
            lerQtsMsg = new Integer(lerQtsMsgSt);
        }
        try {
            Store store = session.getStore("imaps");
            store.connect(servidorEntrada, email, senhaEmail);
            store.getPersonalNamespaces();
            Folder folder = store.getFolder(pastaEntrada);
            Folder folderToCopy = store.getFolder("EmailsLidosMentor");
            if (folderToCopy == null || !folderToCopy.exists()) {
                folderToCopy.create(1);
            }
            folder.open(2);
            Message[] messages = this.getMessages(folder, lerQtsMsg);
            this.readProcessMessages(messages, opcoes);
            this.cutMessages(folder, folderToCopy, messages);
            folder.close(true);
            store.close();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            logger.error(ex.getClass(), ex);
        }
        return Boolean.TRUE;
    }

    private void verificarMultipart(Object msgObj, OpcoesFaturamentoTransp opcoes) throws MessagingException, IOException, JDOMException, Exception {
        if (!(msgObj instanceof Multipart)) {
            return;
        }
        Multipart multipart = (Multipart)msgObj;
        for (int i = 0; i < multipart.getCount(); ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String contentType = part.getContentType();
            logger.info("Content: " + contentType);
            System.out.println("Content: " + contentType);
            if (contentType.startsWith("text/plain")) {
                logger.info("Content: " + contentType);
                System.out.println("Content: " + contentType);
                continue;
            }
            this.validarXML((Part)part, opcoes);
        }
    }

    private void validarXML(Part part, OpcoesFaturamentoTransp opcoes) throws Exception {
        String fileName = part.getFileName();
        if (fileName == null) {
            return;
        }
        if (!fileName.toLowerCase().endsWith("xml")) {
            return;
        }
        InputStream obj = part.getInputStream();
        if (!(obj instanceof InputStream)) {
            return;
        }
        InputStream is = obj;
        this.processSaveFile(is, opcoes);
        logger.info("Lendo xml: " + fileName);
    }

    private Message[] getMessages(Folder folder, Integer lerQtsMsg) throws MessagingException {
        Message[] messages = null;
        if (lerQtsMsg != null && lerQtsMsg > 0) {
            if (folder.getMessageCount() < lerQtsMsg) {
                lerQtsMsg = folder.getMessageCount() - 1;
            }
            messages = folder.getMessages(folder.getMessageCount() - lerQtsMsg, folder.getMessageCount());
        } else {
            messages = folder.getMessages();
        }
        return messages;
    }

    private void cutMessages(Folder folder, Folder dfolder, Message[] msgs) throws MessagingException {
        if (msgs.length != 0) {
            folder.copyMessages(msgs, dfolder);
            folder.setFlags(msgs, new Flags(Flags.Flag.DELETED), true);
            for (int i = 0; i < msgs.length; ++i) {
                if (msgs[i].isSet(Flags.Flag.DELETED)) continue;
                System.out.println("Message # " + String.valueOf(msgs[i]) + " not deleted");
            }
        }
    }

    private void readProcessMessages(Message[] messages, OpcoesFaturamentoTransp opcoes) throws Exception {
        for (int i = 0; i < messages.length; ++i) {
            try {
                Message message = messages[i];
                if (!message.getContentType().equals("APPLICATION/XML")) {
                    Object msgObj = message.getContent();
                    this.verificarMultipart(msgObj, opcoes);
                    continue;
                }
                InputStream inputStream = message.getDataHandler().getDataSource().getInputStream();
                logger.info(message.getContentType());
                this.processSaveFile(inputStream, opcoes);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                logger.error(ex.getMessage());
            }
        }
    }

    private boolean processSaveFile(InputStream f, OpcoesFaturamentoTransp opcoes) throws JDOMException, IOException {
        Date base = new Date();
        Namespace nNFe = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/nfe");
        Namespace nCTe = Namespace.getNamespace((String)"http://www.portalfiscal.inf.br/cte");
        SAXBuilder s = new SAXBuilder();
        String conteudoXML = this.getXMLFromFile(f);
        Document d = s.build((InputStream)new ByteArrayInputStream(conteudoXML.getBytes()));
        Element root = d.getRootElement();
        XMLNFeCTe x = new XMLNFeCTe();
        if (root.getName().equalsIgnoreCase("nfeProc")) {
            Element infNfe = root.getChild("NFe", nNFe).getChild("infNFe", nNFe);
            x.setChaveNFe(infNfe.getAttributeValue("Id").substring(3));
        } else if (root.getName().equalsIgnoreCase("cteProc")) {
            Element infCte = root.getChild("CTe", nCTe).getChild("infCte", nCTe);
            x.setChaveNFe(infCte.getAttributeValue("Id").substring(3));
            if (infCte.getChild("compl", nCTe) != null && infCte.getChild("compl", nCTe).getChild("xCaracAd", nCTe) != null) {
                String xCaracAd = infCte.getChild("compl", nCTe).getChild("xCaracAd", nCTe).getText();
                x.setCnpjTranspAgregado(xCaracAd);
            }
        } else {
            return false;
        }
        x.setConteudoXML(conteudoXML);
        x.setDataChegada(base);
        x.setDataAtualizacao(new Timestamp(new Date().getTime()));
        x.setFlag(Integer.valueOf(0));
        ServiceXMLNFeCTe service = (ServiceXMLNFeCTe)ConfApplicationContext.getBean(ServiceXMLNFeCTe.class);
        if (!service.existXMLNFeCte(x.getChaveNFe())) {
            service.saveOrUpdate((Object)x);
            return true;
        }
        return false;
    }

    private String getXMLFromFile(InputStream f) {
        try {
            StringBuilder linhatotal = new StringBuilder();
            BufferedReader b = new BufferedReader(new InputStreamReader(f));
            String linha = "";
            do {
                if (b != null) {
                    linha = b.readLine();
                }
                if (linha == null) continue;
                linhatotal.append(linha.trim());
            } while (linha != null);
            return linhatotal.toString();
        }
        catch (IOException ex) {
            logger.error(ex.getMessage());
            return "";
        }
    }
}

