/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.depreciacaociap;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.opcoespatrimonio.EnumConstOpcoesPatrimonioOP;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.BaixaBem;
import com.touchcomp.basementor.model.vo.Bem;
import com.touchcomp.basementor.model.vo.BemSpedPisCofins;
import com.touchcomp.basementor.model.vo.BemTipoDepreciacao;
import com.touchcomp.basementor.model.vo.CiapBem;
import com.touchcomp.basementor.model.vo.DepreciacaoBem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemCiapDepreciacaoBaixaBem;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.MovBemSpedPisCofins;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.TipoMovimentacaoCiapBem;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoespatrimonio.HelperOpcoesPatrimonio;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoDateUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreServiceFactory;
import mentorcore.tools.DateUtil;
import mentorcore.utilities.CoreUtilityFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;

public class UtilCalculoItemCiapDepreciacaoBaixaBem {
    public Object gerarItemCiapDereciacaoBaixaBens(Date dataInicial, Date dataFinal, Empresa empresa, Bem bemBaixa, Double coeficienteCredito, Short gerarCiapBem, Short gerarDepreciacaoBem, Short nrTurnos, Short recalcularCiap, Short recalcularDepreciacao, List<ItemCiapDepreciacaoBaixaBem> listItemDepreciacao, Short gerarCiapBaixaBem, OpcoesPatrimonio opcoesPatrimonio) throws Exception {
        ItemCiapDepreciacaoBaixaBem ii;
        Boolean achou;
        List<Object> itens = new ArrayList();
        List<Object> itensParcelas = new ArrayList();
        if (listItemDepreciacao != null) {
            if (ToolMethods.isEquals((Object)recalcularCiap, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                itensParcelas = this.getItensParcelas(listItemDepreciacao);
            }
            for (ItemCiapDepreciacaoBaixaBem itemCiapDepreciacaoBaixaBem : listItemDepreciacao) {
                if (ToolMethods.isEquals((Object)recalcularCiap, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                    itemCiapDepreciacaoBaixaBem.setCiapBem(new ArrayList());
                    itens = listItemDepreciacao;
                }
                if (!ToolMethods.isEquals((Object)recalcularDepreciacao, (Object)EnumConstantsMentorSimNao.SIM.getValue())) continue;
                itemCiapDepreciacaoBaixaBem.setDepreciacaoBem(new ArrayList());
                itemCiapDepreciacaoBaixaBem.setMovBemSpedPisCofins(new ArrayList());
                itens = listItemDepreciacao;
            }
        }
        List<CiapBem> ciapsBens = this.gerarCiapBem(bemBaixa, dataFinal, empresa, coeficienteCredito, gerarCiapBaixaBem, opcoesPatrimonio);
        if (ToolMethods.isEquals((Object)gerarCiapBem, (Object)1) && ToolMethods.isEquals((Object)recalcularCiap, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            for (CiapBem ciapBemNew : ciapsBens) {
                Boolean achou2 = false;
                for (Object i : itens) {
                    if (!i.getBem().equals((Object)ciapBemNew.getBem())) continue;
                    i.getCiapBem().add(ciapBemNew);
                    ciapBemNew.setItemCiapDepreciacaoBaixaBem((ItemCiapDepreciacaoBaixaBem)i);
                    for (HashMap hashMap : itensParcelas) {
                        Short nrParcela = (Short)hashMap.get(i.getBem().getIdentificador());
                        if (nrParcela == null) continue;
                        ciapBemNew.setNumeroParcela(nrParcela);
                        break;
                    }
                    achou2 = true;
                    break;
                }
                if (achou2.booleanValue()) continue;
                ItemCiapDepreciacaoBaixaBem i = new ItemCiapDepreciacaoBaixaBem();
                i.setBem(ciapBemNew.getBem());
                i.getCiapBem().add(ciapBemNew);
                ciapBemNew.setItemCiapDepreciacaoBaixaBem(i);
                itens.add(i);
            }
        }
        if (ToolMethods.isEquals((Object)gerarDepreciacaoBem, (Object)1) && ToolMethods.isEquals((Object)recalcularDepreciacao, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            List<DepreciacaoBem> list = this.gerarDepreciacaoBem(bemBaixa, dataFinal, empresa, ciapsBens, nrTurnos, opcoesPatrimonio);
            for (DepreciacaoBem d : list) {
                achou = false;
                for (ItemCiapDepreciacaoBaixaBem itemCiapDepreciacaoBaixaBem : itens) {
                    if (!itemCiapDepreciacaoBaixaBem.getBem().equals((Object)d.getBemTipoDepreciacao().getBem())) continue;
                    itemCiapDepreciacaoBaixaBem.getDepreciacaoBem().add(d);
                    d.setItemCiapDepreciacaoBaixaBem(itemCiapDepreciacaoBaixaBem);
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                ii = new ItemCiapDepreciacaoBaixaBem();
                ii.setBem(d.getBemTipoDepreciacao().getBem());
                ii.getDepreciacaoBem().add(d);
                d.setItemCiapDepreciacaoBaixaBem(ii);
                itens.add(ii);
            }
        }
        if (ToolMethods.isEquals((Object)recalcularDepreciacao, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            List<MovBemSpedPisCofins> list = this.calcularPisCofinsBem(dataFinal, empresa);
            for (MovBemSpedPisCofins m : list) {
                achou = false;
                for (ItemCiapDepreciacaoBaixaBem itemCiapDepreciacaoBaixaBem : itens) {
                    if (!m.getBemSpedPisCofins().getBem().equals((Object)itemCiapDepreciacaoBaixaBem.getBem())) continue;
                    itemCiapDepreciacaoBaixaBem.getMovBemSpedPisCofins().add(m);
                    m.setItemCiapDepreciacaoBaixaBem(itemCiapDepreciacaoBaixaBem);
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                ii = new ItemCiapDepreciacaoBaixaBem();
                ii.setBem(m.getBemSpedPisCofins().getBem());
                ii.getMovBemSpedPisCofins().add(m);
                m.setItemCiapDepreciacaoBaixaBem(ii);
                itens.add(ii);
            }
        }
        return itens;
    }

    public List findBensCiap(Date dataFinal, Empresa empresa) throws ExceptionDatabase {
        Session s = CoreBdUtil.getInstance().getSession();
        String query = " select distinct      b.identificador  from CiapBem c  right join c.bem b where      b.dataCompra <= :periodo and b.empresa=:empresa     and not exists(from CiapBem c1                     inner join c1.tpMovimentacaoDeprBem t                     inner join c1.itemCiapDepreciacaoBaixaBem item                    where                     (t.codigo=:cod1 or t.codigo=:cod2 or t.codigo=:cod3 or t.codigo=:cod4) and                     c1.bem=b and item.depreciacaoCiap.periodo<:periodo) group by      b.identificador,      b.valorIcms,     b.valorIcmsSt,     b.valorIcmsFrete,     b.valorIcmsDifAliquota  having      count(c.identificador) <= (select (b1.nrParcelasIcms + 1) - b1.nrParcelaIcmsInicial from Bem b1 where b1 = b)";
        Query q = s.createQuery(query);
        q.setDate("periodo", dataFinal);
        q.setString("cod1", "AT");
        q.setString("cod2", "PE");
        q.setString("cod3", "BA");
        q.setString("cod4", "OT");
        q.setEntity("empresa", (Object)empresa);
        List lista = q.list();
        ArrayList<Bem> bens = new ArrayList<Bem>();
        for (Object idBem : lista) {
            bens.add((Bem)CoreDAOFactory.getInstance().getDAOBem().findByPrimaryKey(idBem));
        }
        return bens;
    }

    private Double getSaldoBaixaDisponivel(Bem bem, Date periodo) {
        Session session = CoreBdUtil.getInstance().getSession();
        Criteria criteria = session.createCriteria(BaixaBem.class);
        criteria = criteria.createAlias("bem", "bem");
        criteria.setProjection((Projection)Projections.sum((String)"percentualBaixa"));
        criteria.add((Criterion)Restrictions.eq((String)"bem.identificador", (Object)bem.getIdentificador()));
        criteria.add((Criterion)Restrictions.le((String)"dataBaixa", (Object)ContatoDateUtil.nextPreviousDays((Date)periodo, (int)1)));
        Double saldoBaixado = (Double)criteria.uniqueResult();
        return saldoBaixado != null ? 100.0 - saldoBaixado : 100.0;
    }

    private Short getNextNumeroParcelaCiap(Bem b, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select max(p.numeroParcela)+1 from CiapBem p where p.bem=:bem and p.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa=:empresa");
        q.setEntity("bem", (Object)b);
        q.setEntity("empresa", (Object)empresa);
        Integer parc = (Integer)q.uniqueResult();
        if (parc == null) {
            parc = b.getNrParcelaIcmsInicial() == null || b.getNrParcelaIcmsInicial() == 0 ? Integer.valueOf(1) : Integer.valueOf(b.getNrParcelaIcmsInicial().intValue());
        }
        return parc.shortValue();
    }

    private Double getValorApropriadoBem(Bem b, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(p.vrIcms+p.vrIcmsSt+p.vrIcmsFrete+p.vrIcmsDifAliq),0) from CiapBem p where p.bem=:bem and p.itemCiapDepreciacaoBaixaBem.depreciacaoCiap.empresa=:empresa");
        q.setEntity("bem", (Object)b);
        q.setEntity("empresa", (Object)empresa);
        Double parc = (Double)q.uniqueResult();
        return parc;
    }

    private TipoMovimentacaoCiapBem getTipoMovimentacaoConclusao() {
        return this.getTipoMovimentacaoPorSigla("CI");
    }

    private TipoMovimentacaoCiapBem getTipoMovimentacaoInicial() {
        return this.getTipoMovimentacaoPorSigla("SI");
    }

    private TipoMovimentacaoCiapBem getTipoMovimentacaoDeprAndamentoBem() {
        return this.getTipoMovimentacaoPorSigla("IM");
    }

    private TipoMovimentacaoCiapBem getTipoMovimentacaoDeprAndamentoComponente() {
        return this.getTipoMovimentacaoPorSigla("IA");
    }

    private TipoMovimentacaoCiapBem getTipoMovimentacaoBaixaBem() {
        return this.getTipoMovimentacaoPorSigla("BA");
    }

    private TipoMovimentacaoCiapBem getTipoMovimentacaoPorSigla(String string) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select t from TipoMovimentacaoCiapBem t where t.codigo=:codigo");
        q.setString("codigo", string);
        return (TipoMovimentacaoCiapBem)q.uniqueResult();
    }

    private List<CiapBem> gerarCiapBem(Bem bemBaixa, Date dataFinal, Empresa empresa, Double coeficienteCredito, Short gerarCiapBaixaBem, OpcoesPatrimonio opcoesPatrimonio) throws ExceptionService, ExceptionDatabase {
        ArrayList<Bem> bens = new ArrayList<Bem>();
        if (bemBaixa != null) {
            bens.add(bemBaixa);
        } else {
            bens.addAll(this.findBensCiap(dataFinal, empresa));
        }
        Short calcularCiapProRata = (Short)CompOpcoes.getOption((List)((HelperOpcoesPatrimonio)ConfApplicationContext.getBean(HelperOpcoesPatrimonio.class)).build(opcoesPatrimonio).getItens(), (EnumOpDinamicasInterface)EnumConstOpcoesPatrimonioOP.CALCULAR_CIAP_DE_ACORDO_COM_PRO_RATA_DIE, Short.class);
        ArrayList<CiapBem> toRet = new ArrayList<CiapBem>();
        for (Object e : bens) {
            CiapBem c = new CiapBem();
            Bem bem = (Bem)e;
            Double percentualRestante = this.getSaldoBaixaDisponivel(bem, dataFinal);
            if (bem.getNrParcelaIcmsInicial() > 0) {
                if (!(percentualRestante > 0.0) || bem.getNrParcelasIcms() == null || bem.getNrParcelasIcms() <= 0) continue;
                c.setBem(bem);
                c.setMovimentoGerAuto(Short.valueOf((short)1));
                if (bem.getNrParcelasIcms() <= 0) {
                    throw new ExceptionService("Verifique o bem " + bem.getIdentificador() + " - " + bem.getDescricao() + ", pois as parcelas est\u00e3o erradas.");
                }
                Boolean calculoProRata = false;
                if (ToolMethods.isAffirmative((Number)calcularCiapProRata)) {
                    Integer mesCompraBem = ToolDate.getMonthFromDate((Date)bem.getDataCompra()) + 1;
                    Integer mesCiap = ToolDate.getMonthFromDate((Date)dataFinal) + 1;
                    Integer anoCompraBem = ToolDate.getYearFromDate((Date)bem.getDataCompra());
                    Integer anoCiap = ToolDate.getYearFromDate((Date)dataFinal);
                    if (ToolMethods.isEquals((Object)mesCiap, (Object)mesCompraBem) && ToolMethods.isEquals((Object)anoCiap, (Object)anoCompraBem)) {
                        calculoProRata = true;
                    }
                }
                if (!calculoProRata.booleanValue()) {
                    c.setVrIcms(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcms() / (double)bem.getNrParcelasIcms().shortValue() * coeficienteCredito), (int)2));
                    c.setVrIcmsNaoApropriado(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcms() / (double)bem.getNrParcelasIcms().shortValue() - c.getVrIcms()), (int)2));
                    c.setVrIcmsDifAliq(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsDifAliquota() / (double)bem.getNrParcelasIcms().shortValue() * coeficienteCredito), (int)2));
                    c.setVrIcmsDifAliqNaoApropriado(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsDifAliquota() / (double)bem.getNrParcelasIcms().shortValue() - c.getVrIcmsDifAliq()), (int)2));
                    if (c.getVrIcmsDifAliqNaoApropriado() < 0.0) {
                        c.setVrIcmsDifAliqNaoApropriado(Double.valueOf(0.0));
                    }
                    c.setVrIcmsFrete(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsFrete() / (double)bem.getNrParcelasIcms().shortValue() * coeficienteCredito), (int)2));
                    c.setVrIcmsFreteNaoApropriado(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsFrete() / (double)bem.getNrParcelasIcms().shortValue() - c.getVrIcmsFrete()), (int)2));
                    if (c.getVrIcmsFreteNaoApropriado() < 0.0) {
                        c.setVrIcmsFreteNaoApropriado(Double.valueOf(0.0));
                    }
                    c.setVrIcmsSt(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsSt() / (double)bem.getNrParcelasIcms().shortValue() * coeficienteCredito), (int)2));
                    c.setVrIcmsStNaoApropriado(ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsSt() / (double)bem.getNrParcelasIcms().shortValue() - c.getVrIcmsSt()), (int)2));
                    if (c.getVrIcmsStNaoApropriado() < 0.0) {
                        c.setVrIcmsStNaoApropriado(Double.valueOf(0.0));
                    }
                } else {
                    Integer diasMes = ToolDate.getDaysOnMonth((Date)dataFinal);
                    Integer diasACalcular = diasMes - ToolDate.getDayFromDate((Date)bem.getDataCompra());
                    Double valorParcelaTotal = ToolFormatter.arrredondarNumero((Double)(bem.getValorIcms() / (double)bem.getNrParcelasIcms().shortValue()), (int)2);
                    Double valorDia = ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal / (double)diasMes.intValue()), (int)2);
                    c.setVrIcms(ToolFormatter.arrredondarNumero((Double)(valorDia * (double)diasACalcular.intValue()), (int)2));
                    c.setVrIcmsNaoApropriado(ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal - c.getVrIcms()), (int)2));
                    if (c.getVrIcmsNaoApropriado() < 0.0) {
                        c.setVrIcmsNaoApropriado(Double.valueOf(0.0));
                    }
                    valorParcelaTotal = ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsDifAliquota() / (double)bem.getNrParcelasIcms().shortValue()), (int)2);
                    valorDia = ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal / (double)diasMes.intValue()), (int)2);
                    c.setVrIcmsDifAliq(ToolFormatter.arrredondarNumero((Double)(valorDia * (double)diasACalcular.intValue()), (int)2));
                    c.setVrIcmsDifAliqNaoApropriado(ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal - c.getVrIcmsDifAliq()), (int)2));
                    if (c.getVrIcmsDifAliqNaoApropriado() < 0.0) {
                        c.setVrIcmsDifAliqNaoApropriado(Double.valueOf(0.0));
                    }
                    valorParcelaTotal = ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsFrete() / (double)bem.getNrParcelasIcms().shortValue()), (int)2);
                    valorDia = ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal / (double)diasMes.intValue()), (int)2);
                    c.setVrIcmsFrete(ToolFormatter.arrredondarNumero((Double)(valorDia * (double)diasACalcular.intValue()), (int)2));
                    c.setVrIcmsFreteNaoApropriado(ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal - c.getVrIcmsFrete()), (int)2));
                    if (c.getVrIcmsFreteNaoApropriado() < 0.0) {
                        c.setVrIcmsFreteNaoApropriado(Double.valueOf(0.0));
                    }
                    valorParcelaTotal = ToolFormatter.arrredondarNumero((Double)(bem.getValorIcmsSt() / (double)bem.getNrParcelasIcms().shortValue()), (int)2);
                    valorDia = ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal / (double)diasMes.intValue()), (int)2);
                    c.setVrIcmsSt(ToolFormatter.arrredondarNumero((Double)(valorDia * (double)diasACalcular.intValue()), (int)2));
                    c.setVrIcmsStNaoApropriado(ToolFormatter.arrredondarNumero((Double)(valorParcelaTotal - c.getVrIcmsSt()), (int)2));
                    if (c.getVrIcmsStNaoApropriado() < 0.0) {
                        c.setVrIcmsStNaoApropriado(Double.valueOf(0.0));
                    }
                }
                c.setNumeroParcela(this.getNextNumeroParcelaCiap(bem, empresa));
                Double valorApropriadoBem = this.getValorApropriadoBem(bem, empresa);
                if (valorApropriadoBem == 0.0 && c.getNumeroParcela() == 1) {
                    c.setTpMovimentacaoDeprBem(this.getTipoMovimentacaoInicial());
                } else if ((valorApropriadoBem > 0.0 || c.getNumeroParcela() > 1) && bem.getBemPrincipal() != null) {
                    c.setTpMovimentacaoDeprBem(this.getTipoMovimentacaoDeprAndamentoComponente());
                } else if ((valorApropriadoBem > 0.0 || c.getNumeroParcela() > 1) && bem.getBemPrincipal() == null) {
                    c.setTpMovimentacaoDeprBem(this.getTipoMovimentacaoDeprAndamentoBem());
                }
                if (c.getNumeroParcela().intValue() <= c.getBem().getNrParcelasIcms().intValue()) {
                    toRet.add(c);
                }
                if (!ToolMethods.isEquals((Object)gerarCiapBaixaBem, (Object)1) || !ToolMethods.isEquals((Object)c.getNumeroParcela().intValue(), (Object)c.getBem().getNrParcelasIcms().intValue())) continue;
                CiapBem cAux = new CiapBem();
                cAux.setBem(bem);
                cAux.setTpMovimentacaoDeprBem(this.getTipoMovimentacaoBaixaBem());
                cAux.setVrIcms(Double.valueOf(0.0));
                cAux.setVrIcmsDifAliq(Double.valueOf(0.0));
                cAux.setVrIcmsDifAliqNaoApropriado(Double.valueOf(0.0));
                cAux.setVrIcmsFrete(Double.valueOf(0.0));
                cAux.setVrIcmsFreteNaoApropriado(Double.valueOf(0.0));
                cAux.setVrIcmsSt(Double.valueOf(0.0));
                cAux.setVrIcmsStNaoApropriado(Double.valueOf(0.0));
                cAux.setMovimentoGerAuto(Short.valueOf((short)1));
                toRet.add(cAux);
                continue;
            }
            if (bem.getBemPrincipal() == null || bem.getNrParcelaIcmsInicial() != 0 || !ToolDate.comparaMesAno((String)ToolDate.dateToStr((Date)dataFinal, (String)"dd/MM/yyyy"), (String)ToolDate.dateToStr((Date)bem.getDataCompra(), (String)"dd/MM/yyyy"))) continue;
            CiapBem cAux = new CiapBem();
            cAux.setBem(bem);
            cAux.setMovimentoGerAuto(Short.valueOf((short)1));
            cAux.setNumeroParcela(EnumConstantsMentorSimNao.NAO.getEnumId());
            cAux.setTpMovimentacaoDeprBem(this.getTipoMovimentacaoDeprAndamentoComponente());
            cAux.setVrIcms(Double.valueOf(0.0));
            cAux.setVrIcmsNaoApropriado(bem.getValorIcms());
            cAux.setVrIcmsSt(Double.valueOf(0.0));
            cAux.setVrIcmsStNaoApropriado(bem.getValorIcmsSt());
            cAux.setVrIcmsFrete(Double.valueOf(0.0));
            cAux.setVrIcmsFreteNaoApropriado(bem.getValorIcmsFrete());
            cAux.setVrIcmsDifAliq(Double.valueOf(0.0));
            cAux.setVrIcmsDifAliqNaoApropriado(bem.getValorIcmsDifAliquota());
            toRet.add(cAux);
        }
        return toRet;
    }

    private List<DepreciacaoBem> gerarDepreciacaoBem(Bem bemBaixa, Date dataFinal, Empresa empresa, List ciapsBens, Short nrTurnos, OpcoesPatrimonio opcoesPatrimonio) throws Exception {
        List bens = this.findBensDepreciacao(dataFinal, empresa, bemBaixa);
        ArrayList<DepreciacaoBem> toRet = new ArrayList<DepreciacaoBem>();
        for (Object o : bens) {
            BemTipoDepreciacao b = (BemTipoDepreciacao)o;
            DepreciacaoBem c = new DepreciacaoBem();
            Double percentualRestante = this.getSaldoBaixaDisponivel(b.getBem(), dataFinal);
            if (b.getBem().getIdentificador() == 167L) {
                System.out.println("teste");
            }
            if (!(percentualRestante > 0.0)) continue;
            Double bcCalcInitDepr = b.getValor();
            Double vlrDepr = 0.0;
            Double vlrDeprAcel = 0.0;
            Double valorDepreciado = 0.0;
            Double valorOutrasDepreciacoes = 0.0;
            boolean deprNormal = false;
            boolean bl = deprNormal = b.getTipoDepreciacao().getDepreciacaoNormal() == 1;
            if (deprNormal) {
                Double dif;
                Double vlrIcmsNAprop = this.findSomaValorIcmsNaoApropriado(b.getBem(), ciapsBens);
                vlrIcmsNAprop = ToolFormatter.arrredondarNumero((Double)vlrIcmsNAprop, (int)2);
                valorDepreciado = this.findSomaValorDeprNormal(b);
                valorDepreciado = ToolFormatter.arrredondarNumero((Double)valorDepreciado, (int)2);
                bcCalcInitDepr = bcCalcInitDepr + vlrIcmsNAprop;
                vlrDepr = bcCalcInitDepr * (b.getBem().getTipoBem().getTaxaAnualDepreciacao() / 100.0) / 12.0;
                vlrDepr = ToolFormatter.arrredondarNumero((Double)vlrDepr, (int)2);
                valorOutrasDepreciacoes = b.getBem().getValorOutrasDepreciacoes();
                if (b.getBem().getTipoBem().getTrabalhaTurnos() == 1 && nrTurnos > 1) {
                    vlrDeprAcel = nrTurnos == 2 ? Double.valueOf(vlrDepr / 2.0) : vlrDepr;
                }
                if ((dif = ToolFormatter.arrredondarNumero((Double)(bcCalcInitDepr - (valorDepreciado + vlrDepr + vlrDeprAcel + valorOutrasDepreciacoes)), (int)2)) < 0.0) {
                    vlrDepr = vlrDepr - Math.abs(dif);
                }
            } else {
                vlrDepr = bcCalcInitDepr * (b.getBem().getTipoBem().getTaxaAnualDepreciacao() / 100.0) / 12.0;
                vlrDepr = ToolFormatter.arrredondarNumero((Double)vlrDepr, (int)2);
                valorDepreciado = this.findSomaValorDepr(b);
                valorDepreciado = ToolFormatter.arrredondarNumero((Double)valorDepreciado, (int)2);
                if (b.getBem().getTipoBem().getTrabalhaTurnos() == 1 && nrTurnos > 1) {
                    vlrDeprAcel = nrTurnos == 2 ? Double.valueOf(vlrDepr / 2.0) : vlrDepr;
                }
            }
            c.setBemTipoDepreciacao(b);
            vlrDeprAcel = vlrDeprAcel * (percentualRestante / 100.0);
            vlrDepr = vlrDepr * (percentualRestante / 100.0);
            Double dif = ToolFormatter.arrredondarNumero((Double)(bcCalcInitDepr - (valorDepreciado + vlrDepr + vlrDeprAcel + valorOutrasDepreciacoes)), (int)2);
            if (dif < 0.0) {
                vlrDepr = vlrDepr - Math.abs(dif);
                dif = 0.0;
            }
            Integer diasMes = ContatoDateUtil.getTotalDaysInMonth((Date)dataFinal);
            Double depreciacaoDiaria = vlrDepr / (double)diasMes.intValue();
            Double depreciacaoDiariaAcelerada = vlrDeprAcel / (double)diasMes.intValue();
            Date fimPeriodo = DateUtil.nextDays(dataFinal, 1);
            Integer diasDepreciacao = DateUtil.diferenceDayBetweenDates(ContatoDateUtil.getFirstDayMonth((Date)dataFinal), fimPeriodo);
            c.setValorDeprecAcelerada(Double.valueOf(depreciacaoDiariaAcelerada * (double)diasDepreciacao.intValue()));
            c.setValorDepreciacao(Double.valueOf(depreciacaoDiaria * (double)diasDepreciacao.intValue()));
            c.setLoteContabil(CoreServiceFactory.getServiceLancamento().integrarDepreciacaoBem(c, dataFinal, opcoesPatrimonio));
            c.setLancamentoCtbGerencial(this.getLancamentoCtbGerencial(b.getBem(), c, dataFinal, empresa));
            if (dif == 0.0) {
                b.setDeprTotalmente(Short.valueOf((short)1));
                CoreBdUtil.getInstance().getSession().evict((Object)b);
            }
            this.calcularPisCofinsDepreciacaoBem(c);
            toRet.add(c);
        }
        return toRet;
    }

    private List findBensDepreciacao(Date periodo, Empresa empresa, Bem bem) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select distinct bt from DepreciacaoBem c right join c.bemTipoDepreciacao btd right join btd.bem b right join b.bensTipoDepreciacao bt left join c.itemCiapDepreciacaoBaixaBem item left join item.depreciacaoCiap dc where btd.dataInicial < :periodo  and b.tipoBem.depreciar = :depreciar  and (bt.deprTotalmente<>:depr or bt.deprTotalmente is null) and b.empresa=:empresa";
        if (bem != null) {
            query = (String)query + " and b.identificador = :idBem";
        }
        Query q = s.createQuery((String)query);
        q.setDate("periodo", periodo);
        q.setShort("depreciar", (short)1);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("depr", (short)1);
        if (bem != null) {
            q.setLong("idBem", bem.getIdentificador().longValue());
        }
        return q.list();
    }

    private Double findSomaValorIcmsNaoApropriado(Bem bem, List<CiapBem> baseCiapMes) {
        Double vrIcmsNaoApropMes = 0.0;
        for (CiapBem d : baseCiapMes) {
            if (!d.getBem().equals((Object)bem)) continue;
            vrIcmsNaoApropMes = vrIcmsNaoApropMes + (d.getVrIcmsDifAliqNaoApropriado() + d.getVrIcmsFreteNaoApropriado() + d.getVrIcmsNaoApropriado() + d.getVrIcmsStNaoApropriado());
        }
        Double valor = this.findValorIcmsNaoApropriadoPorBem(bem);
        valor = valor + vrIcmsNaoApropMes;
        return valor;
    }

    private Double findValorIcmsNaoApropriadoPorBem(Bem bem) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(c.vrIcmsNaoApropriado),0) from CiapBem c right join c.bem b where b=:bem");
        q.setEntity("bem", (Object)bem);
        Double vlr = (Double)q.uniqueResult();
        if (vlr == null) {
            vlr = 0.0;
        }
        return vlr;
    }

    private Double findSomaValorDeprNormal(BemTipoDepreciacao b) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(d.valorDepreciacao+d.valorDeprecAcelerada),0) from DepreciacaoBem d where d.bemTipoDepreciacao=:bemTp");
        q.setEntity("bemTp", (Object)b);
        Double value = (Double)q.uniqueResult();
        return value;
    }

    private Double findSomaValorDepr(BemTipoDepreciacao b) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select coalesce(sum(d.valorDepreciacao+d.valorDeprecAcelerada),0) from DepreciacaoBem d where d.bemTipoDepreciacao=:bemTp");
        q.setEntity("bemTp", (Object)b);
        Double value = (Double)q.uniqueResult();
        return value;
    }

    private LancamentoCtbGerencial getLancamentoCtbGerencial(Bem bem, DepreciacaoBem c, Date periodo, Empresa empresa) throws ExceptionService {
        return CoreUtilityFactory.getUtilityLancamentosGerenciais().criarLancamentoGerencialDepreciacaoBens(bem, c, periodo, empresa);
    }

    private void calcularPisCofinsDepreciacaoBem(DepreciacaoBem c) throws ExceptionService {
        ArrayList<MovBemSpedPisCofins> dados = new ArrayList<MovBemSpedPisCofins>();
        Bem bem = c.getBemTipoDepreciacao().getBem();
        System.out.println("\n\nBEM: " + bem.getIdentificador());
        if (TMethods.isEquals((Object)bem.getBemUsadoPisCofins(), (Object)1) && (bem.getBemSpedPisCofins() == null || bem.getBemSpedPisCofins().getNaturezaBCCredito() == null)) {
            throw new ExceptionService("O bem " + bem.getIdentificador() + "-" + bem.getDescricao() + " est\u00e1 sem informa\u00e7oes de Pis/Cofins!");
        }
        if (bem.getBemUsadoPisCofins().equals((short)1) && (bem.getBemSpedPisCofins().getNaturezaBCCredito().getCodigo().equals("09") || bem.getBemSpedPisCofins().getNaturezaBCCredito().getCodigo().equals("11"))) {
            BemSpedPisCofins pc = bem.getBemSpedPisCofins();
            MovBemSpedPisCofins m = new MovBemSpedPisCofins();
            m.setBemSpedPisCofins(pc);
            m.setParcOperNaoBcCred(Double.valueOf(0.0));
            m.setVrBcCred(Double.valueOf(0.0));
            m.setVrOperDep(Double.valueOf(c.getValorDepreciacao() + c.getValorDeprecAcelerada()));
            m.setVrBcCofins(Double.valueOf(m.getVrOperDep() - m.getParcOperNaoBcCred()));
            m.setVrBcPis(Double.valueOf(m.getVrOperDep() - m.getParcOperNaoBcCred()));
            m.setVrCofins(Double.valueOf(m.getVrBcCofins() * pc.getAliquotaCofins() / 100.0));
            m.setVrPis(Double.valueOf(m.getVrBcPis() * pc.getAliquotaPis() / 100.0));
            m.setParcela(Short.valueOf((short)0));
            dados.add(m);
        }
        c.setMovBemSpedPisCofins(dados);
    }

    public List<MovBemSpedPisCofins> calcularPisCofinsBem(Date dataFinal, Empresa empresa) {
        List bens = this.findBensSpedPisCofins(dataFinal, empresa);
        ArrayList<MovBemSpedPisCofins> toRet = new ArrayList<MovBemSpedPisCofins>();
        for (Object o : bens) {
            BemSpedPisCofins b = (BemSpedPisCofins)o;
            MovBemSpedPisCofins m = new MovBemSpedPisCofins();
            m.setBemSpedPisCofins(b);
            m.setVrBcCred(Double.valueOf(b.getVrBcCred() - b.getParcOperNaoBcCred()));
            m.setParcOperNaoBcCred(b.getParcOperNaoBcCred());
            m.setVrOperDep(Double.valueOf(m.getVrBcCred() / (double)b.getNrParcela().shortValue()));
            m.setVrBcCofins(Double.valueOf(m.getVrBcCred() / (double)b.getNrParcela().shortValue()));
            m.setVrBcPis(Double.valueOf(m.getVrBcCred() / (double)b.getNrParcela().shortValue()));
            m.setVrPis(Double.valueOf(m.getVrBcPis() * b.getAliquotaPis() / 100.0));
            m.setVrCofins(Double.valueOf(m.getVrBcCofins() * b.getAliquotaCofins() / 100.0));
            Short ultParcela = this.findUltParcelaMovBemSpedPisCofins(b);
            m.setParcela(ultParcela);
            toRet.add(m);
        }
        return toRet;
    }

    private List findBensSpedPisCofins(Date periodo, Empresa empresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct c from BemSpedPisCofins c where c.bem.dataCompra < :periodo  and c.bem.empresa.identificador=:empresa and (c.naturezaBCCredito.codigo = :cod1) and c.bem.bemUsadoPisCofins = :usado");
        q.setDate("periodo", periodo);
        q.setString("cod1", "10");
        q.setShort("usado", (short)1);
        q.setLong("empresa", empresa.getIdentificador().longValue());
        List l = q.list();
        return l;
    }

    public Short findUltParcelaMovBemSpedPisCofins(BemSpedPisCofins b) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select count(c) from MovBemSpedPisCofins c where c.bemSpedPisCofins = :bemSpedPisCofins");
        q.setEntity("bemSpedPisCofins", (Object)b);
        Long cont = (Long)q.uniqueResult();
        short nrParcelaInicial = b.getNrParcelaInicial();
        if (cont == null || cont == 0L) {
            return nrParcelaInicial;
        }
        cont = cont + (long)nrParcelaInicial;
        return cont.shortValue();
    }

    private List<HashMap> getItensParcelas(List<ItemCiapDepreciacaoBaixaBem> listItemDepreciacao) {
        ArrayList<HashMap> itens = new ArrayList<HashMap>();
        for (ItemCiapDepreciacaoBaixaBem bem : listItemDepreciacao) {
            for (CiapBem ciapBem : bem.getCiapBem()) {
                HashMap<Long, Short> h = new HashMap<Long, Short>();
                h.put(bem.getBem().getIdentificador(), ciapBem.getNumeroParcela());
                itens.add(h);
            }
        }
        return itens;
    }
}

