/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.depreciacaociap;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonioIncidenciaIcmsTotal;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonioIncidenciaIcmsTrib;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilCalculoValoresDepreciacao {
    UtilCalculoValoresDepreciacao() {
    }

    public HashMap calcularValoresDepreciacao(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op) {
        Double valorTotalSaidas = this.getValorTotalSaidas(dataInicial, dataFinal, empresa, op);
        Double valorTributado = this.getValorTotalTributado(dataInicial, dataFinal, empresa, op);
        Double valorExportacao = this.getValorTotalExportacao(dataInicial, dataFinal, empresa, op);
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put("valorTotalSaidas", valorTotalSaidas);
        h.put("valorTributado", valorTributado);
        h.put("valorExportacao", valorExportacao);
        return h;
    }

    private Double getValorTotalSaidas(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op) {
        HashMap hash = new HashMap();
        this.getValorTotalSaidasNotasProprias(dataInicial, dataFinal, empresa, op, hash);
        this.getValorTotalSaidasCTe(dataInicial, dataFinal, empresa, op, hash);
        this.getValorTotalSaidasNFCe(dataInicial, dataFinal, empresa, op, hash);
        this.getValorDevolucoesTotalSaidas(dataInicial, dataFinal, empresa, op, hash);
        Double valorTotal = (Double)hash.get("VALOR_TOTAL");
        Double valorIcmsST = (Double)hash.get("VALOR_ICMS_ST");
        Double valorIpi = (Double)hash.get("VALOR_IPI");
        Double valorDevolucoes = (Double)hash.get("VALOR_DEVOLUCOES");
        if (op.getAbaterIcmsStTotal().equals((short)1)) {
            valorTotal = valorTotal - valorIcmsST;
        }
        if (op.getAbaterIpiTotal().equals((short)1)) {
            valorTotal = valorTotal - valorIpi;
        }
        if (op.getAbaterDevolucaoVendasTotal().equals((short)1)) {
            valorTotal = valorTotal - valorDevolucoes;
        }
        return valorTotal;
    }

    private Double getValorTotalTributado(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op) {
        HashMap hash = new HashMap();
        this.getValorTotalTributadoNotasProprias(dataInicial, dataFinal, empresa, op, hash);
        this.getValorTotalTributadoCTe(dataInicial, dataFinal, empresa, op, hash);
        this.getValorTotalTributadoNFCe(dataInicial, dataFinal, empresa, op, hash);
        this.getValorDevolucoesTotalSaidasTributadas(dataInicial, dataFinal, empresa, op, hash);
        Double valorTotal = (Double)hash.get("VALOR_TOTAL");
        Double valorIcmsST = (Double)hash.get("VALOR_ICMS_ST");
        Double valorIpi = (Double)hash.get("VALOR_IPI");
        Double valorDevolucoes = (Double)hash.get("VALOR_DEVOLUCOES");
        if (op.getAbaterIcmsStTrib().equals((short)1)) {
            valorTotal = valorTotal - valorIcmsST;
        }
        if (op.getAbaterIpiTrib().equals((short)1)) {
            valorTotal = valorTotal - valorIpi;
        }
        if (op.getAbaterDevolucaoVendasTrib().equals((short)1)) {
            valorTotal = valorTotal - valorDevolucoes;
        }
        return valorTotal;
    }

    private Double getValorTotalExportacao(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op) {
        Double valorTotal = 0.0;
        if (op.getIncluirExportacoesTrib().equals((short)1)) {
            Session s = CoreBdUtil.getInstance().getSession();
            Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL, coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, l.incidenciaIcms.codigo as COD_ICMS from NotaFiscalPropria n inner join n.livrosFiscais l  where l.dataLivro between :dataIn and :dataFim  and l.cancelado = :nao and l.empresa = :empresa and l.cfop.cfopComercialExportadora = :sim and l.cfop.cfopDevolucaoVenda = :nao and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
            if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1)) {
                hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
            }
            if (op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
                hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
            }
            if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTrib())) {
                hql = (String)hql + " and (";
                Integer cont = 1;
                for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                    hql = cont.intValue() != op.getIncidenciaIcmsTrib().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                    Integer n = cont;
                    cont = cont + 1;
                }
            }
            hql = (String)hql + " group by l.incidenciaIcms.codigo";
            Query q = s.createQuery((String)hql);
            q.setShort("sim", (short)1);
            q.setShort("nao", (short)0);
            q.setDate("dataIn", dataInicial);
            q.setDate("dataFim", dataFinal);
            q.setEntity("empresa", (Object)empresa);
            q.setString("codSitDoc1", "00");
            q.setString("codSitDoc2", "01");
            q.setString("codSitDoc3", "06");
            q.setString("codSitDoc4", "07");
            q.setString("codSitDoc5", "08");
            List lista = q.list();
            block1: for (HashMap result : lista) {
                String codIncIcms = (String)result.get("COD_ICMS");
                for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                    if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                    if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                        valorTotal = valorTotal + (Double)result.get("VALOR_BC");
                        continue block1;
                    }
                    valorTotal = valorTotal + (Double)result.get("VALOR_TOTAL");
                    continue block1;
                }
            }
        }
        return valorTotal;
    }

    private void getValorDevolucoesTotalSaidas(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        if (op.getAbaterDevolucaoVendasTotal().equals((short)1)) {
            this.getValorDevolucoesTotalSaidaNotaPropria(dataInicial, dataFinal, empresa, op, hash);
            this.getValorDevolucoesTotalSaidaNotaTerceiros(dataInicial, dataFinal, empresa, op, hash);
        } else {
            hash.put("VALOR_DEVOLUCOES", 0.0);
        }
    }

    private void getValorDevolucoesTotalSaidaNotaPropria(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL, coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST, coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI, l.incidenciaIcms.codigo as COD_ICMS from NotaFiscalPropria n inner join n.livrosFiscais l  where l.dataLivro between :dataIn and :dataFim  and l.cancelado = :nao and l.empresa = :empresa and l.cfop.cfopDevolucaoVenda = :sim and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTotais())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTotais().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " group by l.incidenciaIcms.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_DEVOLUCOES") != null) {
                hash.put("VALOR_DEVOLUCOES", (Double)hash.get("VALOR_DEVOLUCOES") + valorTotal);
                continue;
            }
            hash.put("VALOR_DEVOLUCOES", Double.valueOf(valorTotal));
        }
    }

    private void getValorDevolucoesTotalSaidaNotaTerceiros(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL, coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST, coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI, l.incidenciaIcms.codigo as COD_ICMS from NotaFiscalTerceiros n inner join n.livrosFiscais l  where l.dataLivro between :dataIn and :dataFim  and l.empresa = :empresa and l.cancelado = :nao and l.cfop.cfopDevolucaoVenda = :sim and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTotais())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTotais().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " group by l.incidenciaIcms.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_DEVOLUCOES") != null) {
                hash.put("VALOR_DEVOLUCOES", (Double)hash.get("VALOR_DEVOLUCOES") + valorTotal);
                continue;
            }
            hash.put("VALOR_DEVOLUCOES", Double.valueOf(valorTotal));
        }
    }

    private void getValorDevolucoesTotalSaidasTributadas(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        if (op.getAbaterDevolucaoVendasTrib().equals((short)1)) {
            this.getValorDevolucoesTotalSaidaTributadaNotaPropria(dataInicial, dataFinal, empresa, op, hash);
            this.getValorDevolucoesTotalSaidaTributadaNotaTerceiros(dataInicial, dataFinal, empresa, op, hash);
        } else {
            hash.put("VALOR_DEVOLUCOES", 0.0);
        }
    }

    private void getValorDevolucoesTotalSaidaTributadaNotaPropria(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL, coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST, coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI, l.incidenciaIcms.codigo as COD_ICMS from NotaFiscalPropria n inner join n.livrosFiscais l  where l.dataLivro between :dataIn and :dataFim  and l.cancelado = :nao and l.empresa = :empresa and l.cfop.cfopDevolucaoVenda = :sim and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTrib())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTrib().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " group by l.incidenciaIcms.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_DEVOLUCOES") != null) {
                hash.put("VALOR_DEVOLUCOES", (Double)hash.get("VALOR_DEVOLUCOES") + valorTotal);
                continue;
            }
            hash.put("VALOR_DEVOLUCOES", Double.valueOf(valorTotal));
        }
    }

    private void getValorDevolucoesTotalSaidaTributadaNotaTerceiros(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL,  coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST, coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI, l.incidenciaIcms.codigo as COD_ICMS from NotaFiscalTerceiros n inner join n.livrosFiscais l  where l.dataLivro between :dataIn and :dataFim  and l.cancelado = :nao and l.empresa = :empresa and l.cfop.cfopDevolucaoVenda = :sim and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTrib())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTrib().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " group by l.incidenciaIcms.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("sim", (short)1);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_DEVOLUCOES") != null) {
                hash.put("VALOR_DEVOLUCOES", (Double)hash.get("VALOR_DEVOLUCOES") + valorTotal);
                continue;
            }
            hash.put("VALOR_DEVOLUCOES", Double.valueOf(valorTotal));
        }
    }

    private void getValorTotalSaidasNotasProprias(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL, coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST, coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI, l.incidenciaIcms.codigo as COD_INC_ICMS from NotaFiscalPropria n  inner join n.livrosFiscais l where l.dataLivro between :dataIn and :dataFim  and l.empresa = :empresa and l.cfop.cfopDevolucaoVenda = :nao and l.cancelado = :nao and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTotais())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTotais().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " group by l.incidenciaIcms.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_INC_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_TOTAL") != null) {
                hash.put("VALOR_TOTAL", (Double)hash.get("VALOR_TOTAL") + valorTotal);
                continue;
            }
            hash.put("VALOR_TOTAL", valorTotal);
        }
    }

    private void getValorTotalTributadoNotasProprias(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select coalesce(sum(l.valorTotal),0) as VALOR_TOTAL, coalesce(sum(l.valorIcmsTributado),0) as VALOR_BC, coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST, coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI, l.incidenciaIcms.codigo as COD_INC_ICMS from NotaFiscalPropria n  inner join n.livrosFiscais l where l.dataLivro between :dataIn and :dataFim  and l.empresa = :empresa and l.cfop.cfopDevolucaoVenda = :nao and l.cancelado = :nao and (   n.situacaoDocumento.codigo = :codSitDoc1       or n.situacaoDocumento.codigo = :codSitDoc2       or n.situacaoDocumento.codigo = :codSitDoc3       or n.situacaoDocumento.codigo = :codSitDoc4       or n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTrib())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTrib().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " group by l.incidenciaIcms.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_INC_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_TOTAL") != null) {
                hash.put("VALOR_TOTAL", (Double)hash.get("VALOR_TOTAL") + valorTotal);
                continue;
            }
            hash.put("VALOR_TOTAL", valorTotal);
        }
    }

    private void getValorTotalSaidasCTe(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  coalesce(sum(l.valorTotal),0) as VALOR_TOTAL,  coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST,  coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI  from Cte n inner join n.livrosFiscais l where     l.dataLivro between :dataInicial and :dataFinal and l.empresa = :empresa and n.cteInfo.status = :autorizado";
        if (op.getNaoIncluirIndustrializacaoTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTotal().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTotais())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTotais().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("autorizado", (short)100);
        if (op.getNaoIncluirIndustrializacaoTotal().equals((short)1) || op.getNaoIncluirTransferenciaTotal().equals((short)1)) {
            q.setShort("nao", (short)0);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap result = (HashMap)q.uniqueResult();
        Double valorIpi = (Double)result.get("VALOR_IPI");
        Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
        Double valorTotal = (Double)result.get("VALOR_TOTAL");
        if (hash.get("VALOR_IPI") != null) {
            hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
        } else {
            hash.put("VALOR_IPI", valorIpi);
        }
        if (hash.get("VALOR_ICMS_ST") != null) {
            hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
        } else {
            hash.put("VALOR_ICMS_ST", valorIcmsST);
        }
        if (hash.get("VALOR_TOTAL") != null) {
            hash.put("VALOR_TOTAL", (Double)hash.get("VALOR_TOTAL") + valorTotal);
        } else {
            hash.put("VALOR_TOTAL", valorTotal);
        }
    }

    private void getValorTotalTributadoCTe(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = " select  coalesce(sum(l.valorTotal),0) as VALOR_TOTAL,  coalesce(sum(l.valorIcmsSt),0) as VALOR_ICMS_ST,  coalesce(sum(l.valorIpiIndustria + l.valorIpiComercio),0) as VALOR_IPI  from Cte n inner join n.livrosFiscais l where     l.dataLivro between :dataInicial and :dataFinal and l.empresa = :empresa and n.cteInfo.status = :autorizado";
        if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
            hql = (String)hql + " and l.cfop.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTrib())) {
            hql = (String)hql + " and (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTrib().size() ? (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' or" : (String)hql + " l.incidenciaIcms.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        Query q = s.createQuery((String)hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("autorizado", (short)100);
        if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1) || op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
            q.setShort("nao", (short)0);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap result = (HashMap)q.uniqueResult();
        Double valorIpi = (Double)result.get("VALOR_IPI");
        Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
        Double valorTotal = (Double)result.get("VALOR_TOTAL");
        if (hash.get("VALOR_IPI") != null) {
            hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
        } else {
            hash.put("VALOR_IPI", valorIpi);
        }
        if (hash.get("VALOR_ICMS_ST") != null) {
            hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
        } else {
            hash.put("VALOR_ICMS_ST", valorIcmsST);
        }
        if (hash.get("VALOR_TOTAL") != null) {
            hash.put("VALOR_TOTAL", (Double)hash.get("VALOR_TOTAL") + valorTotal);
        } else {
            hash.put("VALOR_TOTAL", valorTotal);
        }
    }

    private void getValorTotalSaidasNFCe(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT COALESCE(SUM(l.valorTotal), 0)                             AS VALOR_TOTAL, COALESCE(SUM(l.valorIcmsTributado), 0)                     AS VALOR_BC, COALESCE(SUM(l.valorIcmsSt), 0)                            AS VALOR_ICMS_ST, COALESCE(SUM(l.valorIpiIndustria + l.valorIpiComercio), 0) AS VALOR_IPI, i.codigo                                                   AS COD_INC_ICMS FROM       NFCe             n INNER JOIN n.livrosFiscais  l INNER JOIN l.incidenciaIcms i INNER JOIN l.cfop           c WHERE l.dataLivro  BETWEEN :dataIn AND :dataFim AND l.empresa            = :empresa AND c.cfopDevolucaoVenda = :nao AND l.cancelado          = :nao AND (   n.situacaoDocumento.codigo = :codSitDoc1       OR n.situacaoDocumento.codigo = :codSitDoc2       OR n.situacaoDocumento.codigo = :codSitDoc3       OR n.situacaoDocumento.codigo = :codSitDoc4       OR n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTotal().equals((short)1)) {
            hql = (String)hql + " AND c.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTotal().equals((short)1)) {
            hql = (String)hql + " AND c.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTotais())) {
            hql = (String)hql + " AND (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTotais().size() ? (String)hql + " i.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' OR" : (String)hql + " i.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " GROUP BY i.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_INC_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_TOTAL") != null) {
                hash.put("VALOR_TOTAL", (Double)hash.get("VALOR_TOTAL") + valorTotal);
                continue;
            }
            hash.put("VALOR_TOTAL", valorTotal);
        }
    }

    private void getValorTotalTributadoNFCe(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesPatrimonio op, HashMap hash) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object hql = "SELECT COALESCE(SUM(l.valorTotal), 0)                             AS VALOR_TOTAL, COALESCE(SUM(l.valorIcmsTributado), 0)                     AS VALOR_BC, COALESCE(SUM(l.valorIcmsSt), 0)                            AS VALOR_ICMS_ST, COALESCE(SUM(l.valorIpiIndustria + l.valorIpiComercio), 0) AS VALOR_IPI, i.codigo                                                   AS COD_INC_ICMS FROM       NFCe             n INNER JOIN n.livrosFiscais  l INNER JOIN l.incidenciaIcms i INNER JOIN l.cfop           c WHERE l.dataLivro  BETWEEN :dataIn AND :dataFim AND l.empresa            = :empresa AND c.cfopDevolucaoVenda = :nao AND l.cancelado          = :nao AND (   n.situacaoDocumento.codigo = :codSitDoc1       OR n.situacaoDocumento.codigo = :codSitDoc2       OR n.situacaoDocumento.codigo = :codSitDoc3       OR n.situacaoDocumento.codigo = :codSitDoc4       OR n.situacaoDocumento.codigo = :codSitDoc5)";
        if (op.getNaoIncluirIndustrializacaoTrib().equals((short)1)) {
            hql = (String)hql + " AND c.cfopIndustrializacao = :nao";
        }
        if (op.getNaoIncluirTransferenciaTrib().equals((short)1)) {
            hql = (String)hql + " AND c.cfopTransferencia = :nao";
        }
        if (ToolMethods.isWithData((Collection)op.getIncidenciaIcmsTrib())) {
            hql = (String)hql + " AND (";
            Integer cont = 1;
            for (OpcoesPatrimonioIncidenciaIcmsTrib inc : op.getIncidenciaIcmsTrib()) {
                hql = cont.intValue() != op.getIncidenciaIcmsTrib().size() ? (String)hql + " i.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "' OR" : (String)hql + " i.codigo = '" + inc.getIncidenciaIcms().getCodigo() + "')";
                Integer n = cont;
                cont = cont + 1;
            }
        }
        hql = (String)hql + " GROUP BY i.codigo";
        Query q = s.createQuery((String)hql);
        q.setShort("nao", (short)0);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codSitDoc1", "00");
        q.setString("codSitDoc2", "01");
        q.setString("codSitDoc3", "06");
        q.setString("codSitDoc4", "07");
        q.setString("codSitDoc5", "08");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List lista = q.list();
        for (HashMap result : lista) {
            Double valorIpi = (Double)result.get("VALOR_IPI");
            Double valorIcmsST = (Double)result.get("VALOR_ICMS_ST");
            Double valorTotal = 0.0;
            String codIncIcms = (String)result.get("COD_INC_ICMS");
            for (OpcoesPatrimonioIncidenciaIcmsTotal inc : op.getIncidenciaIcmsTotais()) {
                if (!inc.getIncidenciaIcms().getCodigo().equals(codIncIcms)) continue;
                if (inc.getTipoValorCalculoCiap() != null && inc.getTipoValorCalculoCiap().getIdentificador().equals(2L)) {
                    valorTotal = (Double)result.get("VALOR_BC");
                    break;
                }
                valorTotal = (Double)result.get("VALOR_TOTAL");
                break;
            }
            if (hash.get("VALOR_IPI") != null) {
                hash.put("VALOR_IPI", (Double)hash.get("VALOR_IPI") + valorIpi);
            } else {
                hash.put("VALOR_IPI", valorIpi);
            }
            if (hash.get("VALOR_ICMS_ST") != null) {
                hash.put("VALOR_ICMS_ST", (Double)hash.get("VALOR_ICMS_ST") + valorIcmsST);
            } else {
                hash.put("VALOR_ICMS_ST", valorIcmsST);
            }
            if (hash.get("VALOR_TOTAL") != null) {
                hash.put("VALOR_TOTAL", (Double)hash.get("VALOR_TOTAL") + valorTotal);
                continue;
            }
            hash.put("VALOR_TOTAL", valorTotal);
        }
    }
}

