/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.devolucaopedcomercio;

import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercio;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercioItens;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercioLancComissao;
import com.touchcomp.basementor.model.vo.DevolucaoPedComercioPedidos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.ItemPedidoComercio;
import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.PedidoComercio;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.helpers.impl.grupodebaixa.HelperGrupoDeBaixa;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.tools.ContatoFormatUtil;
import mentorcore.utilities.impl.titulos.UtilityTitulos;

public class ServiceDevolucaoPedComercio
extends CoreService {
    public static final String SALVAR_DEVOLUCAO_PED_COMERCIO = "salvarDevolucaoPedComercio";
    public static final String EXISTE_PEDIDO_COMERCIO_DEVOLVIDO = "existePedComercioDevolvido";
    public static final String DELETAR_DEVOLUCAO_PED_COMERCIO = "deletarDevolucaoPedComercio";
    public static final String QTDE_ITEM_PEDIDO_COMERCIO_DEVOLVIDO = "qtdeItemPedComercioDevolvido";

    public DevolucaoPedComercio salvarDevolucaoPedComercio(CoreRequestContext r) throws ExceptionGeracaoTitulos, ExceptionDatabase, ExceptionInvalidData {
        DevolucaoPedComercio vo = (DevolucaoPedComercio)r.getAttribute("devolucaoPedComercio");
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)r.getAttribute("opcoesFinanceiras");
        EmpresaContabilidade empresaContabilidade = (EmpresaContabilidade)r.getAttribute("empresaContabilidade");
        OpcoesContabeis opCont = (OpcoesContabeis)r.getAttribute("opcoesContabeis");
        GrupoDeBaixa grupoBaixaDevolucao = null;
        GrupoDeBaixa grupoBaixaCredito = null;
        if (vo.getIdentificador() != null && vo.getIdentificador() > 0L) {
            grupoBaixaDevolucao = vo.getGrupoDeBaixa();
            grupoBaixaCredito = vo.getGrupoDeBaixaCredito();
        }
        if (vo.getGerarTituloBaixaDevolucao().equals((short)1)) {
            this.getGrupoDeBaixaDevolucao(vo, opcoesFinanceiras, empresaContabilidade, opCont);
        } else {
            vo.setGrupoDeBaixa(null);
            vo.setGrupoDeBaixaCredito(null);
        }
        if (vo.getGerarLancamentoEstornoComissao().equals((short)1)) {
            vo.setLancamentosComissao(this.getLancamentosComissaoRepresentante(vo));
        } else {
            vo.setLancamentosComissao(new ArrayList());
            vo.setDataLancamentoEstornoComissao(null);
        }
        vo = (DevolucaoPedComercio)CoreDAOFactory.getInstance().getDAODevolucaoPedComercio().saveOrUpdate(vo);
        boolean exists = false;
        if (vo.getGrupoDeBaixaCredito() != null) {
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    b.getTitulo().setDevolucaoPedComercio(vo);
                    exists = true;
                }
            }
        }
        if (exists) {
            vo = (DevolucaoPedComercio)CoreDAOFactory.getInstance().getDAODevolucaoVendas().saveOrUpdate(vo);
        }
        if (vo.getGrupoDeBaixa() == null && grupoBaixaDevolucao != null) {
            grupoBaixaDevolucao = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaDevolucao.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaDevolucao);
        }
        if (vo.getGrupoDeBaixaCredito() == null && grupoBaixaCredito != null) {
            ArrayList<Titulo> titulos = new ArrayList<Titulo>();
            for (GrupoDeBaixaFormas gbf : grupoBaixaCredito.getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    titulos.add(b.getTitulo());
                }
            }
            grupoBaixaCredito = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaCredito.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaCredito);
            for (Titulo t : titulos) {
                t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(t.getIdentificador());
                CoreDAOFactory.getInstance().getDAOTitulo().delete(t);
            }
        }
        return vo;
    }

    private void getGrupoDeBaixaDevolucao(DevolucaoPedComercio vo, OpcoesFinanceiras opcaoFinanceira, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionDatabase, ExceptionInvalidData {
        if (vo.getValorBaixaDevolucao() > 0.0) {
            this.gerarBaixaDevolucao(vo);
        } else {
            vo.setGrupoDeBaixa(null);
        }
        if (vo.getValorCredito() > 0.0) {
            this.gerarTituloCreditoAntecipado(vo, opcaoFinanceira, empresaContabilidade, opCont);
        } else {
            vo.setGrupoDeBaixaCredito(null);
        }
    }

    private void gerarBaixaDevolucao(DevolucaoPedComercio vo) {
        Date dataBaixa = vo.getNotaPropriaGerada().getDataEmissaoNota();
        GrupoDeBaixa g = null;
        if (vo.getGrupoDeBaixa() != null) {
            g = vo.getGrupoDeBaixa();
            g.setDataLiquidacao(dataBaixa);
            for (GrupoDeBaixaFormas gbf : g.getGrupoDeBaixaFormas()) {
                gbf.setBaixaTitulo(new ArrayList());
            }
        } else {
            Short pagRec = 1;
            g = this.getGrupoDeBaixa(dataBaixa, vo.getEmpresa(), pagRec);
        }
        Double vrBaixaDevolucao = ContatoFormatUtil.arrredondarNumero(vo.getValorBaixaDevolucao(), 2);
        Double valorSaldoTitulos = 0.0;
        int nrParcelas = 0;
        for (DevolucaoPedComercioPedidos d : vo.getPedidosDevolvidos()) {
            PedidoComercio n = d.getPedidoComercio();
            for (Titulo t : n.getTitulos()) {
                valorSaldoTitulos = valorSaldoTitulos + t.getValorSaldo();
                ++nrParcelas;
            }
        }
        Double percentual = ContatoFormatUtil.arrredondarNumero(vrBaixaDevolucao * 100.0 / valorSaldoTitulos, 4);
        Double valorTotalBaixasGeradas = 0.0;
        int count = 0;
        for (DevolucaoPedComercioPedidos d : vo.getPedidosDevolvidos()) {
            PedidoComercio n = d.getPedidoComercio();
            for (Titulo t : n.getTitulos()) {
                Double valorBaixa = ContatoFormatUtil.arrredondarNumero(t.getValorSaldo() * percentual / 100.0, 2);
                valorTotalBaixasGeradas = valorTotalBaixasGeradas + valorBaixa;
                if (nrParcelas == ++count && !vrBaixaDevolucao.equals(valorTotalBaixasGeradas)) {
                    Double diferenca = ContatoFormatUtil.arrredondarNumero(vrBaixaDevolucao - valorTotalBaixasGeradas, 2);
                    valorBaixa = diferenca > 0.0 ? ContatoFormatUtil.arrredondarNumero(valorBaixa + diferenca, 2) : ContatoFormatUtil.arrredondarNumero(valorBaixa - diferenca, 2);
                }
                if (!(valorBaixa > 0.0)) continue;
                BaixaTitulo b = this.getBaixaTitulo(t, valorBaixa, g);
                for (GrupoDeBaixaFormas gbf : g.getGrupoDeBaixaFormas()) {
                    gbf.getBaixaTitulo().add(b);
                }
            }
        }
        if (!g.getGrupoDeBaixaFormas().isEmpty()) {
            vo.setGrupoDeBaixa(g);
        } else {
            vo.setGrupoDeBaixa(null);
        }
    }

    private void gerarTituloCreditoAntecipado(DevolucaoPedComercio vo, OpcoesFinanceiras opcaoFinanceira, EmpresaContabilidade empresaContabilidade, OpcoesContabeis opCont) throws ExceptionGeracaoTitulos, ExceptionDatabase, ExceptionInvalidData {
        Short pagRec = 1;
        Titulo t = new UtilityTitulos().criarTituloCreditoAntecipadoDevolucaoPedComercio(vo, opcaoFinanceira, empresaContabilidade, pagRec, opCont);
        t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t);
        this.gerarBaixaCreditoDevolucao(vo, t, pagRec);
    }

    private void gerarBaixaCreditoDevolucao(DevolucaoPedComercio vo, Titulo t, Short pagRec) {
        Date dataBaixa = vo.getNotaPropriaGerada().getDataEmissaoNota();
        GrupoDeBaixa g = null;
        if (vo.getGrupoDeBaixaCredito() != null) {
            g = vo.getGrupoDeBaixaCredito();
            g.setDataLiquidacao(dataBaixa);
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                gbf.setBaixaTitulo(new ArrayList());
            }
        } else {
            g = this.getGrupoDeBaixa(dataBaixa, vo.getEmpresa(), pagRec);
        }
        if (t.getValor() > 0.0) {
            BaixaTitulo b = this.getBaixaTitulo(t, t.getValor(), g);
            for (GrupoDeBaixaFormas gbf : g.getGrupoDeBaixaFormas()) {
                gbf.getBaixaTitulo().add(b);
            }
        }
        if (!g.getGrupoDeBaixaFormas().isEmpty()) {
            new HelperGrupoDeBaixa(g).setLancamentoPisCofins();
            vo.setGrupoDeBaixaCredito(g);
        } else {
            vo.setGrupoDeBaixaCredito(null);
        }
    }

    private BaixaTitulo getBaixaTitulo(Titulo t, Double valorBaixa, GrupoDeBaixa g) {
        BaixaTitulo b = new BaixaTitulo();
        b.setTitulo(t);
        b.setValor(valorBaixa);
        b.setTotalOperacao(valorBaixa);
        for (GrupoDeBaixaFormas gbf : g.getGrupoDeBaixaFormas()) {
            b.setGrupoDeBaixaFormas(gbf);
        }
        return b;
    }

    private GrupoDeBaixa getGrupoDeBaixa(Date dataBaixa, Empresa empresa, Short pagRec) {
        GrupoDeBaixa g = new GrupoDeBaixa();
        g.setDataCadastro(new Date());
        g.setDataLiquidacao(dataBaixa);
        g.setEmpresa(empresa);
        g.setPagRec(pagRec);
        GrupoDeBaixaFormas gbf = new GrupoDeBaixaFormas();
        gbf.setGrupoDeBaixa(g);
        gbf.setAgrupamento(Short.valueOf((short)0));
        gbf.setFormaPagamento(Short.valueOf((short)2));
        gbf.setGrupoDeBaixa(g);
        g.setGrupoDeBaixaFormas(Arrays.asList(gbf));
        return g;
    }

    private List<DevolucaoPedComercioLancComissao> getLancamentosComissaoRepresentante(DevolucaoPedComercio vo) {
        Date dataLanc = vo.getDataLancamentoEstornoComissao();
        ArrayList<DevolucaoPedComercioLancComissao> lancamentos = new ArrayList<DevolucaoPedComercioLancComissao>();
        for (DevolucaoPedComercioPedidos d : vo.getPedidosDevolvidos()) {
            PedidoComercio n = d.getPedidoComercio();
            Double valorTotalComissao = 0.0;
            for (DevolucaoPedComercioItens i : vo.getDevolucaoItens()) {
                if (!i.getItemPedidoComercio().getPedidoComercio().getIdentificador().equals(n.getIdentificador())) continue;
                Double qtdeDevolver = i.getQtdeDevolver();
                Double qtdeTotalItem = i.getItemPedidoComercio().getQuantidadeTotal();
                Double valorTotalItem = i.getItemPedidoComercio().getValorTotal();
                Double valorComissao = qtdeDevolver * valorTotalItem / qtdeTotalItem * i.getItemPedidoComercio().getPercComissao() / 100.0;
                valorTotalComissao = valorTotalComissao + valorComissao;
            }
            Boolean existeComissao = false;
            Representante representante = null;
            for (Titulo t : n.getTitulos()) {
                if (t.getRepresentantes() == null || t.getRepresentantes().isEmpty() || (representante = ((TituloRepresentante)t.getRepresentantes().get(0)).getRepresentante()) == null) continue;
                existeComissao = true;
            }
            if (!existeComissao.booleanValue()) continue;
            lancamentos.add(this.getLancamentoComissaoRepresentante(dataLanc, valorTotalComissao, representante, vo));
        }
        return lancamentos;
    }

    private DevolucaoPedComercioLancComissao getLancamentoComissaoRepresentante(Date dataLanc, Double valorTotalComissao, Representante representante, DevolucaoPedComercio vo) {
        LancamentoComissaoRepresentante l = new LancamentoComissaoRepresentante();
        l.setDataCadastro(new Date());
        l.setDataLancamento(dataLanc);
        l.setDebCred(Short.valueOf((short)0));
        l.setEmpresa(vo.getEmpresa());
        l.setGerarMovimentoBancario(Short.valueOf((short)0));
        l.setRepresentante(representante);
        l.setValor(valorTotalComissao);
        StringBuilder sb = new StringBuilder();
        sb.append("Lancamento de estorno de comissao referente a devolucao total/parcial dos(s) pedidos(s): ");
        for (DevolucaoPedComercioPedidos n : vo.getPedidosDevolvidos()) {
            sb.append(n.getPedidoComercio().getIdentificador());
            sb.append(" ");
        }
        for (DevolucaoPedComercioItens d : vo.getDevolucaoItens()) {
            sb.append("(NF: ");
            sb.append(d.getItemPedidoComercio().getPedidoComercio().getIdentificador());
            sb.append(" Item: ");
            sb.append(d.getItemPedidoComercio().getProduto().getIdentificador());
            sb.append(" Qtde Item: ");
            sb.append(ContatoFormatUtil.arrredondarNumero(d.getItemPedidoComercio().getQuantidadeTotal(), 2));
            sb.append(" Perc Comissao: ");
            sb.append(ContatoFormatUtil.arrredondarNumero(d.getItemPedidoComercio().getPercComissao(), 2));
            sb.append(" Qtde Devolver: ");
            sb.append(ContatoFormatUtil.arrredondarNumero(d.getQtdeDevolver(), 2));
            sb.append(")  ");
        }
        l.setObservacao(sb.toString());
        DevolucaoPedComercioLancComissao d = new DevolucaoPedComercioLancComissao();
        d.setDevolucaoPedComercio(vo);
        d.setLancamentoComissaoRepresentante(l);
        return d;
    }

    public DevolucaoPedComercioPedidos existePedComercioDevolvido(CoreRequestContext r) {
        PedidoComercio n = (PedidoComercio)r.getAttribute("pedidoComercio");
        return CoreDAOFactory.getInstance().getDAODevolucaoPedComercio().existePedComercioDevolvido(n);
    }

    public void deletarDevolucaoPedComercio(CoreRequestContext r) throws ExceptionDatabase, ExceptionService {
        DevolucaoPedComercio vo = (DevolucaoPedComercio)r.getAttribute("devolucaoPedComercio");
        Titulo tituloAntecipadoCredito = null;
        if (vo.getGrupoDeBaixaCredito() != null) {
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    b.getTitulo().setDevolucaoVendas(null);
                    tituloAntecipadoCredito = b.getTitulo();
                }
            }
        }
        CoreDAOFactory.getInstance().getDAODevolucaoPedComercio().delete(vo);
        if (tituloAntecipadoCredito != null) {
            tituloAntecipadoCredito = (Titulo)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTitulo(), tituloAntecipadoCredito.getIdentificador());
            tituloAntecipadoCredito.setDevolucaoVendas(null);
            CoreDAOFactory.getInstance().getDAOTitulo().delete(tituloAntecipadoCredito);
        }
    }

    public Double qtdeItemPedComercioDevolvido(CoreRequestContext r) {
        ItemPedidoComercio n = (ItemPedidoComercio)r.getAttribute("itemPedidoComercio");
        return CoreDAOFactory.getInstance().getDAODevolucaoPedComercio().qtdeItemPedComercioDevolvido(n);
    }
}

