/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.devolucaovendas;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.DevolucaoVendas;
import com.touchcomp.basementor.model.vo.DevolucaoVendasItens;
import com.touchcomp.basementor.model.vo.DevolucaoVendasLancComissao;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFPropria;
import com.touchcomp.basementor.model.vo.DevolucaoVendasNFTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixaFormas;
import com.touchcomp.basementor.model.vo.InfPagamentoNfPropria;
import com.touchcomp.basementor.model.vo.IntegracaoNotaPropriaNotas;
import com.touchcomp.basementor.model.vo.IntegracaoNotaTerceirosNotas;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.LancamentoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.boletotitulo.ExceptionGeracaoTitulos;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalterceiros.ServiceNotaFiscalTerceirosImpl;
import com.touchcomp.basementorspringcontext.Context;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.tools.ContatoFormatUtil;

public class ServiceDevolucaoVendas
extends CoreService {
    public static final String SALVAR_DEVOLUCAO_VENDAS = "salvarDevolucaoVendas";
    public static final String EXISTE_NF_PROPRIA_DEVOLVIDA = "existeNFPropriaDevolvida";
    public static final String EXISTE_NF_TERCEIROS_DEVOLVIDA = "existeNFTerceirosDevolvida";
    public static final String DELETAR_DEVOLUCAO_VENDAS = "deletarDevolucaoVendas";
    public static final String EXCLUIR_TITULO_BAIXA_DEVOLUCAO_VENDAS = "excluirTituloBaixaDevolucaoVendas";
    public static final String FIND_SALDO_GRADE_NOTA_PROPRIA_DEVOLUCAO = "findSaldoGradeNotaPropriaDevolucao";
    public static final String FIND_SALDO_GRADE_NOTA_TERCEIROS_DEVOLUCAO = "findSaldoGradeNotaTerceirosDevolucao";
    public static final String FIND_SALDO_GRADE_NFCE_DEVOLUCAO = "findSaldoGradeNFCeDevolucao";
    public static final String FIND_SALDO_GRADE_PEDIDO_DEVOLUCAO = "findSaldoGradePedidoDevolucao";
    public static final String SALVAR_DEVOLUCAO_VENDAS_1 = "salvarDevolucaoVendas1";

    public DevolucaoVendas salvarDevolucaoVendas(CoreRequestContext r) throws ExceptionGeracaoTitulos, ExceptionDatabase, ExceptionService {
        DevolucaoVendas vo = (DevolucaoVendas)r.getAttribute("devolucaoVendas");
        GrupoDeBaixa grupoBaixaDevolucao = null;
        GrupoDeBaixa grupoBaixaCredito = null;
        Titulo tituloDevolver = null;
        if (vo.getIdentificador() != null && vo.getIdentificador() > 0L) {
            grupoBaixaDevolucao = vo.getGrupoDeBaixa();
            grupoBaixaCredito = vo.getGrupoDeBaixaCredito();
            tituloDevolver = vo.getTituloDevolver();
        }
        if (vo.getGrupoDeBaixaCredito() != null && (vo.getIdentificador() == null || vo.getIdentificador() == 0L)) {
            for (Object gf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (Object b : gf.getBaixaTitulo()) {
                    Titulo t = b.getTitulo();
                    t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t);
                    b.setTitulo(t);
                }
            }
        }
        if (vo.getGerarTituloBaixaDevolucao().equals((short)0)) {
            vo.setGrupoDeBaixa(null);
            vo.setGrupoDeBaixaCredito(null);
            vo.setTituloDevolver(null);
            vo.setDataVencimentoTituloDevolver(null);
        }
        if (vo.getGerarLancamentoEstornoComissao().equals((short)1)) {
            vo.setLancamentosComissao(this.getLancamentosComissaoRepresentante(vo));
        } else {
            vo.setLancamentosComissao(new ArrayList());
            vo.setDataLancamentoEstornoComissao(null);
        }
        vo = (DevolucaoVendas)CoreDAOFactory.getInstance().getDAODevolucaoVendas().saveOrUpdate(vo);
        boolean exists = false;
        if (vo.getGrupoDeBaixaCredito() != null) {
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    b.getTitulo().setDevolucaoVendas(vo);
                    exists = true;
                }
            }
        }
        if (vo.getTituloDevolver() != null) {
            vo.getTituloDevolver().setDevolucaoVendas(vo);
            exists = true;
        }
        if (exists) {
            vo = (DevolucaoVendas)CoreDAOFactory.getInstance().getDAODevolucaoVendas().saveOrUpdate(vo);
        }
        if (vo.getGrupoDeBaixa() == null && grupoBaixaDevolucao != null) {
            grupoBaixaDevolucao = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaDevolucao.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaDevolucao);
        }
        if (vo.getGrupoDeBaixaCredito() == null && grupoBaixaCredito != null) {
            ArrayList<Titulo> titulos = new ArrayList<Titulo>();
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    titulos.add(b.getTitulo());
                }
            }
            grupoBaixaCredito = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaCredito.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaCredito);
            for (Titulo t : titulos) {
                t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(t.getIdentificador());
                CoreDAOFactory.getInstance().getDAOTitulo().delete(t);
            }
        }
        if (vo.getTituloDevolver() == null && tituloDevolver != null) {
            tituloDevolver = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(tituloDevolver.getIdentificador());
            CoreDAOFactory.getInstance().getDAOTitulo().delete(tituloDevolver);
        }
        return vo;
    }

    private List<DevolucaoVendasLancComissao> getLancamentosComissaoRepresentante(DevolucaoVendas vo) {
        Date dataLanc = vo.getDataLancamentoEstornoComissao();
        ArrayList<DevolucaoVendasLancComissao> lancamentos = new ArrayList<DevolucaoVendasLancComissao>();
        for (DevolucaoVendasNFPropria d : vo.getNotasPropriaDevolvida()) {
            NotaFiscalPropria n = d.getNotaFiscalPropria();
            Double valorTotalComissao = 0.0;
            for (DevolucaoVendasItens i : vo.getDevolucaoItens()) {
                if (!i.getItemNotaPropria().getNotaFiscalPropria().getIdentificador().equals(n.getIdentificador())) continue;
                Double qtdeDevolver = i.getQtdeDevolver();
                Double qtdeTotalItem = i.getItemNotaPropria().getQuantidadeTotal();
                Double valorTotalItem = this.getValorItem(i.getItemNotaPropria());
                Double valorComissao = qtdeDevolver * valorTotalItem / qtdeTotalItem * i.getItemNotaPropria().getPercComissao() / 100.0;
                valorTotalComissao = valorTotalComissao + valorComissao;
            }
            Boolean existeComissao = false;
            Representante representante = null;
            for (InfPagamentoNfPropria i : n.getInfPagamentoNfPropria()) {
                for (Titulo t : i.getTitulos()) {
                    if (t.getRepresentantes() == null || t.getRepresentantes().isEmpty() || (representante = ((TituloRepresentante)t.getRepresentantes().get(0)).getRepresentante()) == null) continue;
                    existeComissao = true;
                }
            }
            if (!existeComissao.booleanValue() || !(valorTotalComissao > 0.0)) continue;
            lancamentos.add(this.getLancamentoComissaoRepresentante(dataLanc, valorTotalComissao, representante, vo));
        }
        return lancamentos;
    }

    private DevolucaoVendasLancComissao getLancamentoComissaoRepresentante(Date dataLanc, Double valorTotalComissao, Representante representante, DevolucaoVendas vo) {
        LancamentoComissaoRepresentante l = new LancamentoComissaoRepresentante();
        l.setDataCadastro(new Date());
        l.setDataLancamento(dataLanc);
        l.setDebCred(Short.valueOf((short)0));
        l.setEmpresa(vo.getEmpresa());
        l.setGerarMovimentoBancario(Short.valueOf((short)0));
        l.setRepresentante(representante);
        l.setValor(valorTotalComissao);
        StringBuilder sb = new StringBuilder();
        sb.append("Lancamento de estorno de comissao referente a devolucao total/parcial da(s) nota(s): ");
        for (DevolucaoVendasNFPropria n : vo.getNotasPropriaDevolvida()) {
            sb.append(n.getNotaFiscalPropria().getNumeroNota());
            sb.append(" ");
        }
        for (DevolucaoVendasItens d : vo.getDevolucaoItens()) {
            sb.append("(NF: ");
            sb.append(d.getItemNotaPropria().getNotaFiscalPropria().getNumeroNota());
            sb.append(" Item: ");
            sb.append(d.getItemNotaPropria().getProduto().getIdentificador());
            sb.append(" Qtde Item: ");
            sb.append(ContatoFormatUtil.arrredondarNumero(d.getItemNotaPropria().getQuantidadeTotal(), 2));
            sb.append(" Perc Comissao: ");
            sb.append(ContatoFormatUtil.arrredondarNumero(d.getItemNotaPropria().getPercComissao(), 2));
            sb.append(" Qtde Devolver: ");
            sb.append(ContatoFormatUtil.arrredondarNumero(d.getQtdeDevolver(), 2));
            sb.append(")  ");
        }
        l.setObservacao(sb.toString());
        DevolucaoVendasLancComissao d = new DevolucaoVendasLancComissao();
        d.setDevolucaoVendas(vo);
        d.setLancamentoComissaoRepresentante(l);
        return d;
    }

    public DevolucaoVendasNFPropria existeNFPropriaDevolvida(CoreRequestContext r) {
        NotaFiscalPropria n = (NotaFiscalPropria)r.getAttribute("notaPropria");
        return CoreDAOFactory.getInstance().getDAODevolucaoVendas().existeNFPropriaDevolvida(n);
    }

    public DevolucaoVendasNFTerceiros existeNFTerceirosDevolvida(CoreRequestContext r) {
        NotaFiscalTerceiros n = (NotaFiscalTerceiros)r.getAttribute("notaTerceiros");
        return CoreDAOFactory.getInstance().getDAODevolucaoVendas().existeNFTerceirosDevolvida(n);
    }

    public void deletarDevolucaoVendas(CoreRequestContext r) throws ExceptionDatabase, ExceptionService {
        DevolucaoVendas vo = (DevolucaoVendas)r.getAttribute("devolucaoVendas");
        Titulo tituloAntecipadoCredito = null;
        if (vo.getGrupoDeBaixaCredito() != null) {
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    b.getTitulo().setDevolucaoVendas(null);
                    tituloAntecipadoCredito = b.getTitulo();
                }
            }
        }
        CoreDAOFactory.getInstance().getDAODevolucaoVendas().delete(vo);
        if (tituloAntecipadoCredito != null) {
            tituloAntecipadoCredito = (Titulo)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTitulo(), tituloAntecipadoCredito.getIdentificador());
            tituloAntecipadoCredito.setDevolucaoVendas(null);
            CoreDAOFactory.getInstance().getDAOTitulo().delete(tituloAntecipadoCredito);
        }
    }

    private Double getValorItem(ItemNotaFiscalPropria i) {
        Double valor = i.getVrProduto() + i.getVrServico() - i.getValorDesconto();
        if (i.getVrDescontoNaoDest() != null) {
            // empty if block
        }
        if (i.getVrSeguroNaoDest() != null) {
            valor = valor - i.getVrSeguroNaoDest();
        }
        if (i.getVrFreteNaoDest() != null) {
            valor = valor - i.getVrFreteNaoDest();
        }
        if (i.getVrDespAcessoriaNaoDest() != null) {
            valor = valor - i.getVrDespAcessoriaNaoDest();
        }
        return valor;
    }

    public DevolucaoVendas excluirTituloBaixaDevolucaoVendas(CoreRequestContext r) throws ExceptionDatabase {
        DevolucaoVendas vo = (DevolucaoVendas)r.getAttribute("devolucaoVendas");
        GrupoDeBaixa grupoBaixaDevolucao = vo.getGrupoDeBaixa();
        GrupoDeBaixa grupoBaixaCredito = vo.getGrupoDeBaixaCredito();
        Titulo tituloDevolver = vo.getTituloDevolver();
        vo.getLancamentosComissao().clear();
        vo.setLancamentosComissao(new ArrayList());
        vo.setGrupoDeBaixa(null);
        vo.setGrupoDeBaixaCredito(null);
        vo.setTituloDevolver(null);
        vo = (DevolucaoVendas)CoreDAOFactory.getInstance().getDAODevolucaoVendas().saveOrUpdate(vo);
        if (grupoBaixaDevolucao != null) {
            grupoBaixaDevolucao = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaDevolucao.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaDevolucao);
        }
        if (grupoBaixaCredito != null) {
            Titulo t = ((BaixaTitulo)((GrupoDeBaixaFormas)grupoBaixaCredito.getGrupoDeBaixaFormas().get(0)).getBaixaTitulo().get(0)).getTitulo();
            grupoBaixaCredito = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaCredito.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaCredito);
            t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(t.getIdentificador());
            CoreDAOFactory.getInstance().getDAOTitulo().delete(t);
        }
        if (tituloDevolver != null) {
            tituloDevolver = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(tituloDevolver.getIdentificador());
            CoreDAOFactory.getInstance().getDAOTitulo().delete(tituloDevolver);
        }
        return vo;
    }

    public Double findSaldoGradeNotaPropriaDevolucao(CoreRequestContext r) {
        GradeItemNotaFiscalPropria g = (GradeItemNotaFiscalPropria)r.getAttribute("gradeItemNotaPropria");
        return CoreDAOFactory.getInstance().getDAODevolucaoVendas().findSaldoGradeNotaPropriaDevolucao(g);
    }

    public Double findSaldoGradeNotaTerceirosDevolucao(CoreRequestContext r) {
        GradeItemNotaTerceiros g = (GradeItemNotaTerceiros)r.getAttribute("gradeItemNotaTerceiros");
        return CoreDAOFactory.getInstance().getDAODevolucaoVendas().findSaldoGradeNotaTerceirosDevolucao(g);
    }

    public Double findSaldoGradeNFCeDevolucao(CoreRequestContext r) {
        NFCeItem g = (NFCeItem)r.getAttribute("gradeItemNFCe");
        return CoreDAOFactory.getInstance().getDAODevolucaoVendas().findSaldoGradeNFCeDevolucao(g);
    }

    public Double findSaldoGradePedidoDevolucao(CoreRequestContext r) {
        GradeItemPedido g = (GradeItemPedido)r.getAttribute("gradeItemPedido");
        return CoreDAOFactory.getInstance().getDAODevolucaoVendas().findSaldoGradePedidoDevolucao(g);
    }

    public DevolucaoVendas salvarDevolucaoVendas1(CoreRequestContext r) throws ExceptionGeracaoTitulos, ExceptionDatabase, ExceptionService {
        Object i;
        LoteContabil lote;
        Object nota;
        DevolucaoVendas vo = (DevolucaoVendas)r.getAttribute("devolucaoVendas");
        GrupoDeBaixa grupoBaixaDevolucao = null;
        GrupoDeBaixa grupoBaixaCredito = null;
        Titulo tituloDevolver = null;
        if (vo.getIdentificador() != null && vo.getIdentificador() > 0L) {
            grupoBaixaDevolucao = vo.getGrupoDeBaixa();
            grupoBaixaCredito = vo.getGrupoDeBaixaCredito();
            tituloDevolver = vo.getTituloDevolver();
        }
        if (vo.getNotaPropriaGerada() != null) {
            nota = vo.getNotaPropriaGerada();
            if (nota.getIntegracaoNotaPropriaNotas() != null && nota.getIntegracaoNotaPropriaNotas().getLoteContabil() != null) {
                lote = nota.getIntegracaoNotaPropriaNotas().getLoteContabil();
                i = new IntegracaoNotaPropriaNotas();
                i.setNotaPropria((NotaFiscalPropria)nota);
                i.setLoteContabil(lote);
                nota.setIntegracaoNotaPropriaNotas((IntegracaoNotaPropriaNotas)i);
            }
            vo.setNotaPropriaGerada((NotaFiscalPropria)((ServiceNotaFiscalPropriaImpl)Context.get(ServiceNotaFiscalPropriaImpl.class)).saveOrUpdate((InterfaceVO)nota));
        }
        if (vo.getNotaTerceirosGerada() != null) {
            nota = vo.getNotaTerceirosGerada();
            if (nota.getIntegracaoNotaTerceiros() != null && nota.getIntegracaoNotaTerceiros().getLoteContabil() != null) {
                lote = nota.getIntegracaoNotaTerceiros().getLoteContabil();
                i = new IntegracaoNotaTerceirosNotas();
                i.setNotaFiscalTerceiros((NotaFiscalTerceiros)nota);
                i.setLoteContabil(lote);
                nota.setIntegracaoNotaTerceiros((IntegracaoNotaTerceirosNotas)i);
            }
            vo.setNotaTerceirosGerada((NotaFiscalTerceiros)((ServiceNotaFiscalTerceirosImpl)Context.get(ServiceNotaFiscalTerceirosImpl.class)).saveOrUpdate((InterfaceVO)nota));
        }
        if (vo.getGrupoDeBaixaCredito() != null && (vo.getIdentificador() == null || vo.getIdentificador() == 0L)) {
            for (Object gf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (Object b : gf.getBaixaTitulo()) {
                    Titulo t = b.getTitulo();
                    t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().saveOrUpdate(t);
                    b.setTitulo(t);
                }
            }
        }
        if (vo.getGerarTituloBaixaDevolucao().equals((short)0)) {
            vo.setGrupoDeBaixa(null);
            vo.setGrupoDeBaixaCredito(null);
            vo.setTituloDevolver(null);
            vo.setDataVencimentoTituloDevolver(null);
        }
        vo = (DevolucaoVendas)CoreDAOFactory.getInstance().getDAODevolucaoVendas().saveOrUpdate(vo);
        boolean exists = false;
        if (vo.getGrupoDeBaixaCredito() != null) {
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    b.getTitulo().setDevolucaoVendas(vo);
                    exists = true;
                }
            }
        }
        if (vo.getTituloDevolver() != null) {
            vo.getTituloDevolver().setDevolucaoVendas(vo);
            exists = true;
        }
        if (exists) {
            vo = (DevolucaoVendas)CoreDAOFactory.getInstance().getDAODevolucaoVendas().saveOrUpdate(vo);
        }
        if (vo.getGrupoDeBaixa() == null && grupoBaixaDevolucao != null) {
            grupoBaixaDevolucao = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaDevolucao.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaDevolucao);
        }
        if (vo.getGrupoDeBaixaCredito() == null && grupoBaixaCredito != null) {
            ArrayList<Titulo> titulos = new ArrayList<Titulo>();
            for (GrupoDeBaixaFormas gbf : vo.getGrupoDeBaixaCredito().getGrupoDeBaixaFormas()) {
                for (BaixaTitulo b : gbf.getBaixaTitulo()) {
                    titulos.add(b.getTitulo());
                }
            }
            grupoBaixaCredito = (GrupoDeBaixa)CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().findByPrimaryKey(grupoBaixaCredito.getIdentificador());
            CoreDAOFactory.getInstance().getDAOGrupoDeBaixaTitulo().delete(grupoBaixaCredito);
            for (Titulo t : titulos) {
                t = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(t.getIdentificador());
                CoreDAOFactory.getInstance().getDAOTitulo().delete(t);
            }
        }
        if (vo.getTituloDevolver() == null && tituloDevolver != null) {
            tituloDevolver = (Titulo)CoreDAOFactory.getInstance().getDAOTitulo().findByPrimaryKey(tituloDevolver.getIdentificador());
            CoreDAOFactory.getInstance().getDAOTitulo().delete(tituloDevolver);
        }
        return vo;
    }
}

