/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.diagnosticoos;

import com.touchcomp.basementor.model.vo.Nodo;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreServiceFactory;
import mentorcore.utilities.CoreUtilityFactory;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilListagemAssistenciaTipoDiagnostico {
    UtilListagemAssistenciaTipoDiagnostico() {
    }

    Object gerarRelatorio(Short filtrarData, Date dataDiagInicial, Date dataDiagFinal, Short filtrarDataCadastro, Date dataCadInicial, Date dataCadFinal, Short filtrarDataPrevIn, Date dataPrevInInicial, Date dataPrevInFinal, Short filtrarDataPrevFech, Date dataPrevFechInicial, Date dataPrevFechFinal, Short filtrarDataFech, Date dataFechInicial, Date dataFechFinal, Short filtrarTipoDiag, Long idTipoDiagInicial, Long idTipoDiagFinal, Short filtrarEspecie, Long idEspecieInicial, Long idEspecieFinal, Short filtrarSubEspecie, Long idSubEspecieInicial, Long idSubEspecieFinal, Nodo nodo, HashMap h) throws ExceptionService {
        List data = this.filtrarDados(filtrarData, dataDiagInicial, dataDiagFinal, filtrarDataCadastro, dataCadInicial, dataCadFinal, filtrarDataPrevIn, dataPrevInInicial, dataPrevInFinal, filtrarDataPrevFech, dataPrevFechInicial, dataPrevFechFinal, filtrarDataFech, dataFechInicial, dataFechFinal, filtrarTipoDiag, idTipoDiagInicial, idTipoDiagFinal, filtrarEspecie, idEspecieInicial, idEspecieFinal, filtrarSubEspecie, idSubEspecieInicial, idSubEspecieFinal);
        this.putTotais(data);
        h.put("FILTRAR_DATA", filtrarData);
        h.put("DATA_DIAGNOSTICO_INICIAL", dataDiagInicial);
        h.put("DATA_DIAGNOSTICO_FINAL", dataDiagFinal);
        h.put("FILTRAR_DATA_CADASTRO", filtrarDataCadastro);
        h.put("DATA_CADASTRO_INICIAL", dataCadInicial);
        h.put("DATA_CADASTRO_FINAL", dataCadFinal);
        h.put("FILTRAR_DATA_PREV_INICIO", filtrarDataPrevIn);
        h.put("DATA_PREV_INICIO_INICIAL", dataPrevInInicial);
        h.put("DATA_PREV_INICIO_FINAL", dataPrevInFinal);
        h.put("FILTRAR_DATA_PREV_FECH", filtrarDataPrevFech);
        h.put("DATA_PREV_FECH_INICIAL", dataPrevFechInicial);
        h.put("DATA_PREV_FECH_FINAL", dataPrevFechFinal);
        h.put("FILTRAR_DATA_FECH", filtrarDataFech);
        h.put("DATA_FECH_INICIAL", dataFechInicial);
        h.put("DATA_FECH_FINAL", dataFechFinal);
        h.put("FILTRAR_TIPO_DIAGNOSTICO", filtrarTipoDiag);
        h.put("ID_TIPO_DIAGNOSTICO_INICIAL", idTipoDiagInicial);
        h.put("ID_TIPO_DIAGNOSTICO_FINAL", idTipoDiagFinal);
        h.put("FILTRAR_ESPECIE", filtrarEspecie);
        h.put("ID_ESPECIE_INICIAL", idEspecieInicial);
        h.put("ID_ESPECIE_FINAL", idEspecieFinal);
        h.put("FILTRAR_SUBESPECIE", filtrarSubEspecie);
        h.put("ID_SUBESPECIE_INICIAL", idSubEspecieInicial);
        h.put("ID_SUBESPECIE_FINAL", idSubEspecieFinal);
        h = (HashMap)CoreServiceFactory.getServiceOpcoesRelatorio().execute(CoreRequestContext.newInstance().setAttribute("params", h).setAttribute("nodo", nodo), "setarParametrosRelatorio");
        String path = CoreUtilityFactory.getUtilityJasperReports().getPathReports() + "manufatura" + File.separator + "sobencomenda" + File.separator + "assistenciatecnica" + File.separator + "relatorios" + File.separator + "listagemassistenciaportipodiagnostico" + File.separator + "LISTAGEM_ASSISTENCIA_POR_TIPO_DIAGNOSTICO.jasper";
        CoreRequestContext cq = new CoreRequestContext();
        cq.setAttribute("path", path);
        cq.setAttribute("parametros", h);
        cq.setAttribute("dados", data);
        return CoreServiceFactory.getCoreReportService().execute(cq, "getJasperPrintDataSource");
    }

    private List filtrarDados(Short filtrarData, Date dataDiagInicial, Date dataDiagFinal, Short filtrarDataCadastro, Date dataCadInicial, Date dataCadFinal, Short filtrarDataPrevIn, Date dataDataPrevInInicial, Date dataDataPrevInFinal, Short filtrarDataPrevFech, Date dataDataPrevFechInicial, Date dataDataPrevFechFinal, Short filtrarDataFech, Date dataDataFechInicial, Date dataDataFechFinal, Short filtrarTipoDiag, Long idTipoDiagInicial, Long idTipoDiagFinal, Short filtrarEspecie, Long idEspecieInicial, Long idEspecieFinal, Short filtrarSubEspecie, Long idSubEspecieInicial, Long idSubEspecieFinal) {
        Session s = CoreBdUtil.getInstance().getSession();
        Criteria c = s.createCriteria(CoreDAOFactory.getInstance().getDAODiagnosticoOS().getVOClass());
        c.createAlias("ordemServProdSobEnc", "os");
        c.createAlias("os.gradeCor", "gcOS");
        c.createAlias("gcOS.produtoGrade", "pgOS");
        c.createAlias("pgOS.produto", "pOS");
        c.createAlias("pOS.especie", "eOS");
        c.createAlias("pOS.subEspecie", "sOS");
        c.createAlias("itemDiagnosticoOS", "itemDiagostico");
        c.createAlias("itemDiagostico.tipoDiagnosticoOS", "tipoDiagnostico");
        c.createAlias("itemDiagostico.celulaProdutiva", "cel", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("itemDiagostico.gradeCor", "gcD", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("gcD.produtoGrade", "pgD", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("pgD.produto", "pD", JoinType.LEFT_OUTER_JOIN);
        if (filtrarData == 1) {
            c.add(Restrictions.between((String)"dataDiagnostico", (Object)dataDiagInicial, (Object)dataDiagFinal));
        }
        if (filtrarDataCadastro == 1) {
            c.add(Restrictions.between((String)"dataCadastro", (Object)dataCadInicial, (Object)dataCadFinal));
        }
        if (filtrarDataFech == 1) {
            c.add(Restrictions.between((String)"os.dataFechamento", (Object)dataDataFechInicial, (Object)dataDataFechFinal));
        }
        if (filtrarDataPrevFech == 1) {
            c.add(Restrictions.between((String)"os.dataPrevFechamento", (Object)dataDataPrevFechInicial, (Object)dataDataPrevFechFinal));
        }
        if (filtrarDataPrevIn == 1) {
            c.add(Restrictions.between((String)"os.dataPrevInicio", (Object)dataDataPrevInInicial, (Object)dataDataPrevInFinal));
        }
        if (filtrarEspecie == 1) {
            c.add(Restrictions.between((String)"eOS.identificador", (Object)idEspecieInicial, (Object)idEspecieFinal));
        }
        if (filtrarSubEspecie == 1) {
            c.add(Restrictions.between((String)"sOS.identificador", (Object)idSubEspecieInicial, (Object)idSubEspecieFinal));
        }
        if (filtrarTipoDiag == 1) {
            c.add(Restrictions.between((String)"tipoDiagnostico.identificador", (Object)idTipoDiagInicial, (Object)idTipoDiagFinal));
        }
        ProjectionList prop = Projections.projectionList();
        prop.add((Projection)Projections.property((String)"tipoDiagnostico.tipoDiagnostico"), "TIPO_DIAGNOSTICO");
        prop.add((Projection)Projections.property((String)"tipoDiagnostico.identificador"), "ID_DIAGNOSTICO");
        prop.add((Projection)Projections.property((String)"tipoDiagnostico.descricao"), "DIAGNOSTICO");
        prop.add((Projection)Projections.property((String)"cel.identificador"), "ID_CELULA_PROD");
        prop.add((Projection)Projections.property((String)"cel.descricao"), "CELULA_PRODUTIVA");
        prop.add((Projection)Projections.property((String)"pD.identificador"), "ID_PRODUTO");
        prop.add((Projection)Projections.property((String)"pD.codigoAuxiliar"), "CODIGO_AUXILIAR");
        prop.add((Projection)Projections.property((String)"pD.nome"), "PRODUTO");
        c.setProjection((Projection)prop);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        c.addOrder(Order.asc((String)"tipoDiagnostico.tipoDiagnostico"));
        c.addOrder(Order.asc((String)"tipoDiagnostico.descricao"));
        return c.list();
    }

    private void putTotais(List data) {
        Long idProd;
        Long idCelula;
        Long idDiag;
        Short tipoDiag;
        HashMap h;
        Integer totalProcessos = 0;
        Integer totalMaterial = 0;
        Integer total = data.size();
        HashMap<Object, Number> totaisDiag = new HashMap<Object, Number>();
        for (Object o : data) {
            h = (HashMap)o;
            tipoDiag = (Short)h.get("TIPO_DIAGNOSTICO");
            idDiag = (Long)h.get("ID_DIAGNOSTICO");
            idCelula = (Long)h.get("ID_CELULA_PROD");
            idProd = (Long)h.get("ID_PRODUTO");
            if (tipoDiag == 0) {
                var13_13 = totalProcessos;
                totalProcessos = totalProcessos + 1;
            } else {
                var13_13 = totalMaterial;
                totalMaterial = totalMaterial + 1;
            }
            if (h.get(idDiag) == null) {
                totaisDiag.put(idDiag, 1);
            } else {
                totaisDiag.put(idDiag, (Long)h.get(idDiag) + 1L);
            }
            if (idCelula != null) {
                if (h.get(idCelula) == null) {
                    totaisDiag.put("Cel" + idCelula, 1);
                } else {
                    totaisDiag.put("Cel" + idCelula, (Long)h.get("Cel" + idCelula) + 1L);
                }
            }
            if (idProd == null) continue;
            if (h.get(idProd) == null) {
                totaisDiag.put("Prod" + idProd, 1);
                continue;
            }
            totaisDiag.put("Prod" + idProd, (Long)h.get("Prod" + idProd) + 1L);
        }
        for (Object o : data) {
            h = (HashMap)o;
            tipoDiag = (Short)h.get("TIPO_DIAGNOSTICO");
            idDiag = (Long)h.get("ID_DIAGNOSTICO");
            idCelula = (Long)h.get("ID_CELULA_PROD");
            idProd = (Long)h.get("ID_PRODUTO");
            h.put("TOTAL_ATENDIMENTOS", total);
            if (tipoDiag == 0) {
                h.put("TOTAL_ATEND_TIPO_DIAGNOSTICO", totalProcessos);
                h.put("PERC_ATEND_TIPO_DIAGNOSTICO", (double)totalProcessos.intValue() * 1.0 / (double)total.intValue());
            } else {
                h.put("TOTAL_ATEND_TIPO_DIAGNOSTICO", totalMaterial);
                h.put("PERC_ATEND_TIPO_DIAGNOSTICO", (double)totalMaterial.intValue() * 1.0 / (double)total.intValue());
            }
            h.put("TOTAL_DIAGNOSTICO", (Integer)totaisDiag.get(idDiag));
            h.put("PERC_DIAGNOSTICO", (double)((Integer)totaisDiag.get(idDiag)).intValue() * 1.0 / (double)total.intValue());
            if (idCelula != null) {
                h.put("TOTAL_CELULA", (Integer)totaisDiag.get("Cel" + idCelula));
                h.put("PERC_CELULA", (double)((Integer)totaisDiag.get("Cel" + idCelula)).intValue() * 1.0 / (double)total.intValue());
            }
            if (idProd == null) continue;
            h.put("TOTAL_PRODUTO", (Integer)totaisDiag.get("Prod" + idProd));
            h.put("PERC_PRODUTO", (double)((Integer)totaisDiag.get("Prod" + idProd)).intValue() * 1.0 / (double)total.intValue());
        }
    }
}

