/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.distribuicaosobracooperado;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstImpostosRetidos;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.CfopBonificacaoDistSobraCoop;
import com.touchcomp.basementor.model.vo.CfopFatEntradaDistSobraCoop;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.DistribuicaoSobraCooperado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemDistribuicaoSobraCooperado;
import com.touchcomp.basementor.model.vo.ItemTabelaIRRFPlr;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesContabeisImpostosRetidos;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.TabelaIRRFPlr;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.components.opcoes.CompOpcoesContabeis;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import mentorcore.tools.ContatoFormatUtil;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

class UtilCalculoDistribuicaoSobraCooperado {
    Short TIPO_CLASSIFICACAO_DOC = 1;
    Short TIPO_CLASSIFICACAO_CLIENTE = 0;

    UtilCalculoDistribuicaoSobraCooperado() {
    }

    List<ItemDistribuicaoSobraCooperado> calcularValoresDistribuicaoSobraCooperado(Date dataInicial, Date dataFinal, Empresa empresa, Double valorDistribuicao, List<CfopBonificacaoDistSobraCoop> listCfopsBonificacao, Short calcularIrrf, Short filtrarGrupoEmpresa, List<CfopFatEntradaDistSobraCoop> listCfopsFatEntrada, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) throws ExceptionService {
        List lista = this.getValoresVendasNFProprias(dataInicial, dataFinal, empresa, filtrarGrupoEmpresa, classificacaoClientes, tipoClassificacao);
        this.getValoresVendasNFCe(dataInicial, dataFinal, empresa, lista, filtrarGrupoEmpresa, classificacaoClientes, tipoClassificacao);
        this.getValoresFatEntradaNFProprias(dataInicial, dataFinal, empresa, lista, filtrarGrupoEmpresa, listCfopsFatEntrada, classificacaoClientes, tipoClassificacao);
        this.getValoresRPS(dataInicial, dataFinal, empresa, lista, filtrarGrupoEmpresa, classificacaoClientes);
        this.getValoresDevolucoesNFPropria(dataInicial, dataFinal, empresa, lista, filtrarGrupoEmpresa, classificacaoClientes, tipoClassificacao);
        this.getValoresDevolucoesNFTerceiros(dataInicial, dataFinal, empresa, lista, filtrarGrupoEmpresa);
        this.getValoresBonificacaoPorCfops(dataInicial, dataFinal, empresa, lista, listCfopsBonificacao, filtrarGrupoEmpresa, classificacaoClientes, tipoClassificacao);
        List<ItemDistribuicaoSobraCooperado> itens = this.criarItensDistribuicao(lista);
        this.aplicarPercentualDistribuicao(itens, valorDistribuicao, dataInicial, dataFinal, calcularIrrf);
        return itens;
    }

    private List getValoresVendasNFProprias(Date dataInicial, Date dataFinal, Empresa empresa, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_VENDA, n.unidadeFatCliente.pessoa.complemento.cnpj as CNPJ  from NotaFiscalPropria n inner join n.itensNotaPropria i  inner join i.itemNotaLivroFiscal ilf  where n.dataEmissaoNota between :dataIn and :dataFim and n.naturezaOperacao.entradaSaida = :entSaida and ilf.cfop.cfopDevolucaoVenda = :nao and ilf.cfop.cfopReceitaVenda = :sim and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatCliente is not null)";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_DOC)) {
            query = (String)query + " and n.classificacaoCliente = :classificacao";
        } else if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_CLIENTE)) {
            query = (String)query + " and n.unidadeFatCliente.cliente.classificacaoClientes = :classificacao";
        }
        query = (String)query + " group by n.unidadeFatCliente.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("entSaida", (short)1);
        q.setShort("nao", EnumConstantsMentorSimNao.NAO.getValue());
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        if (classificacaoClientes != null) {
            q.setEntity("classificacao", (Object)classificacaoClientes);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valores = q.list();
        for (HashMap h : valores) {
            h.put("VALOR_DEVOLUCAO", 0.0);
            h.put("VALOR_BONIFICACAO", 0.0);
            h.put("VALOR_FAT_ENTRADA", 0.0);
            h.put("VALOR_RPS", 0.0);
        }
        return valores;
    }

    private List getValoresVendasNFCe(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> lista, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(i.valorTotal) as VALOR_VENDA, n.unidadeFatCliente.pessoa.complemento.cnpj as CNPJ  from NFCe n inner join n.itens i   where n.dataEmissao between :dataIn and :dataFim and n.naturezaOperacao.entradaSaida = :entSaida and i.cfop.cfopDevolucaoVenda = :nao and i.cfop.cfopReceitaVenda = :sim and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatCliente is not null) and i.status = :ativo";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_DOC)) {
            query = (String)query + " and n.classificacaoCliente = :classificacao";
        } else if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_CLIENTE)) {
            query = (String)query + " and n.unidadeFatCliente.cliente.classificacaoClientes = :classificacao";
        }
        query = (String)query + " group by n.unidadeFatCliente.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("entSaida", (short)1);
        q.setShort("nao", EnumConstantsMentorSimNao.NAO.getValue());
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.getValue());
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        if (classificacaoClientes != null) {
            q.setEntity("classificacao", (Object)classificacaoClientes);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valores = q.list();
        for (HashMap h : valores) {
            String cnpjPessoa = (String)h.get("CNPJ");
            Double valorVenda = (Double)h.get("VALOR_VENDA");
            Boolean achou = false;
            for (HashMap hh : lista) {
                String cnpjPessoa2 = (String)hh.get("CNPJ");
                if (!cnpjPessoa.equals(cnpjPessoa2)) continue;
                Double valorVenda2 = (Double)hh.get("VALOR_VENDA");
                hh.put("VALOR_VENDA", valorVenda + valorVenda2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            HashMap<String, Object> hh = new HashMap<String, Object>();
            hh.put("VALOR_VENDA", valorVenda);
            hh.put("VALOR_DEVOLUCAO", 0.0);
            hh.put("VALOR_BONIFICACAO", 0.0);
            hh.put("VALOR_FAT_ENTRADA", 0.0);
            hh.put("VALOR_RPS", 0.0);
            hh.put("CNPJ", cnpjPessoa);
            lista.add(hh);
        }
        return valores;
    }

    private List getValoresFatEntradaNFProprias(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> lista, Short filtrarGrupoEmpresa, List<CfopFatEntradaDistSobraCoop> listCfopFatEntrada, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        if (ToolMethods.isWithData(listCfopFatEntrada)) {
            String listaCfop = this.getStringCfop(listCfopFatEntrada);
            Session s = CoreBdUtil.getInstance().getSession();
            String query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_FAT_ENTRADA, n.unidadeFatCliente.pessoa.complemento.cnpj as CNPJ  from NotaFiscalPropria n inner join n.itensNotaPropria i  inner join i.itemNotaLivroFiscal ilf  where n.dataEmissaoNota between :dataIn and :dataFim and n.naturezaOperacao.entradaSaida = :entSaida and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatCliente is not null) and ilf.cfop.identificador in " + listaCfop;
            query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : query + " and n.empresa.identificador = :idEmpresa";
            if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_DOC)) {
                query = query + " and n.classificacaoCliente = :classificacao";
            } else if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_CLIENTE)) {
                query = query + " and n.unidadeFatCliente.cliente.classificacaoClientes = :classificacao";
            }
            query = query + " group by n.unidadeFatCliente.pessoa.complemento.cnpj";
            Query q = s.createQuery(query);
            q.setDate("dataIn", dataInicial);
            q.setDate("dataFim", dataFinal);
            q.setShort("entSaida", (short)2);
            q.setString("codSit1", "02");
            q.setString("codSit2", "03");
            q.setString("codSit3", "04");
            if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
                q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
            } else {
                q.setLong("idEmpresa", empresa.getIdentificador().longValue());
            }
            if (classificacaoClientes != null) {
                q.setEntity("classificacao", (Object)classificacaoClientes);
            }
            q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
            List valores = q.list();
            for (HashMap h : valores) {
                String cnpjPessoa = (String)h.get("CNPJ");
                Double valorFatEntrada = (Double)h.get("VALOR_FAT_ENTRADA");
                Boolean achou = false;
                for (HashMap hh : lista) {
                    String cnpjPessoa2 = (String)hh.get("CNPJ");
                    if (!cnpjPessoa.equals(cnpjPessoa2)) continue;
                    Double valorFatEntrada2 = (Double)hh.get("VALOR_FAT_ENTRADA");
                    hh.put("VALOR_FAT_ENTRADA", valorFatEntrada + valorFatEntrada2);
                    achou = true;
                    break;
                }
                if (achou.booleanValue()) continue;
                HashMap<String, Object> hh = new HashMap<String, Object>();
                hh.put("VALOR_VENDA", 0.0);
                hh.put("VALOR_DEVOLUCAO", 0.0);
                hh.put("VALOR_BONIFICACAO", 0.0);
                hh.put("VALOR_FAT_ENTRADA", valorFatEntrada);
                hh.put("VALOR_RPS", 0.0);
                hh.put("CNPJ", cnpjPessoa);
                lista.add(hh);
            }
        }
        return lista;
    }

    private void getValoresDevolucoesNFPropria(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> lista, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_DEVOLUCAO, n.unidadeFatCliente.pessoa.complemento.cnpj as CNPJ  from NotaFiscalPropria n inner join n.itensNotaPropria i  inner join i.itemNotaLivroFiscal ilf  where n.dataEmissaoNota between :dataIn and :dataFim and n.naturezaOperacao.entradaSaida = :entSaida and ilf.cfop.cfopDevolucaoVenda = :sim and ilf.cfop.cfopReceitaVenda = :nao and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatCliente is not null)";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_DOC)) {
            query = (String)query + " and n.classificacaoCliente = :classificacao";
        } else if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_CLIENTE)) {
            query = (String)query + " and n.unidadeFatCliente.cliente.classificacaoClientes = :classificacao";
        }
        query = (String)query + " group by n.unidadeFatCliente.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("entSaida", (short)2);
        q.setShort("nao", EnumConstantsMentorSimNao.NAO.getValue());
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        if (classificacaoClientes != null) {
            q.setEntity("classificacao", (Object)classificacaoClientes);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List devolucoes = q.list();
        for (HashMap h : devolucoes) {
            String cnpjPessoa = (String)h.get("CNPJ");
            Double valorDevolucao = (Double)h.get("VALOR_DEVOLUCAO");
            Boolean achou = false;
            for (HashMap hh : lista) {
                String cnpjPessoa2 = (String)hh.get("CNPJ");
                if (!cnpjPessoa.equals(cnpjPessoa2)) continue;
                Double valorDevolucao2 = (Double)hh.get("VALOR_DEVOLUCAO");
                hh.put("VALOR_DEVOLUCAO", valorDevolucao + valorDevolucao2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            HashMap<String, Object> hh = new HashMap<String, Object>();
            hh.put("VALOR_VENDA", 0.0);
            hh.put("VALOR_DEVOLUCAO", valorDevolucao);
            hh.put("VALOR_BONIFICACAO", 0.0);
            hh.put("VALOR_FAT_ENTRADA", 0.0);
            hh.put("VALOR_RPS", 0.0);
            hh.put("CNPJ", cnpjPessoa);
            lista.add(hh);
        }
    }

    private void getValoresDevolucoesNFTerceiros(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> lista, Short filtrarGrupoEmpresa) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(ilf.valorTotal) as VALOR_DEVOLUCAO, n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj as CNPJ  from NotaFiscalTerceiros n inner join n.itemNotaTerceiros i  inner join i.itemNotaLivroFiscal ilf  where n.dataEntrada between :dataIn and :dataFim and i.naturezaOperacao.entradaSaida = :entSaida and ilf.cfop.cfopDevolucaoVenda = :sim and ilf.cfop.cfopReceitaVenda = :nao and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatFornecedor is not null)";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        query = (String)query + " group by n.unidadeFatFornecedor.fornecedor.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("entSaida", (short)0);
        q.setShort("nao", EnumConstantsMentorSimNao.NAO.getValue());
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List devolucoes = q.list();
        for (HashMap h : devolucoes) {
            String cnpjPessoa = (String)h.get("CNPJ");
            Double valorDevolucao = (Double)h.get("VALOR_DEVOLUCAO");
            Boolean achou = false;
            for (HashMap hh : lista) {
                String cnpjPessoa2 = (String)hh.get("CNPJ");
                if (!cnpjPessoa.equals(cnpjPessoa2)) continue;
                Double valorDevolucao2 = (Double)hh.get("VALOR_DEVOLUCAO");
                hh.put("VALOR_DEVOLUCAO", valorDevolucao + valorDevolucao2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            HashMap<String, Object> hh = new HashMap<String, Object>();
            hh.put("VALOR_VENDA", 0.0);
            hh.put("VALOR_DEVOLUCAO", valorDevolucao);
            hh.put("VALOR_BONIFICACAO", 0.0);
            hh.put("VALOR_FAT_ENTRADA", 0.0);
            hh.put("VALOR_RPS", 0.0);
            hh.put("CNPJ", cnpjPessoa);
            lista.add(hh);
        }
    }

    private List<ItemDistribuicaoSobraCooperado> criarItensDistribuicao(List<HashMap> lista) throws ExceptionService {
        ArrayList<ItemDistribuicaoSobraCooperado> itens = new ArrayList<ItemDistribuicaoSobraCooperado>();
        List cooperados = (List)CoreService.simpleFindAll(CoreDAOFactory.getInstance().getDAOCooperado());
        block0: for (HashMap h : lista) {
            String cnpjPessoa = (String)h.get("CNPJ");
            Double valorVenda = (Double)h.get("VALOR_VENDA") != null ? (Double)h.get("VALOR_VENDA") : 0.0;
            Double valorDevolucao = (Double)h.get("VALOR_DEVOLUCAO") != null ? (Double)h.get("VALOR_DEVOLUCAO") : 0.0;
            Double valorBonificacao = (Double)h.get("VALOR_BONIFICACAO") != null ? (Double)h.get("VALOR_BONIFICACAO") : 0.0;
            Double valorFatEntrada = (Double)h.get("VALOR_FAT_ENTRADA") != null ? (Double)h.get("VALOR_FAT_ENTRADA") : 0.0;
            Double valorRps = (Double)h.get("VALOR_RPS") != null ? (Double)h.get("VALOR_RPS") : 0.0;
            for (Cooperado c : cooperados) {
                Boolean achou = false;
                for (UnidadeFatCliente unidFatCliente : c.getCliente().getUnidadeFatClientes()) {
                    if (!ToolMethods.isEquals((Object)unidFatCliente.getPessoa().getComplemento().getCnpj(), (Object)cnpjPessoa)) continue;
                    ItemDistribuicaoSobraCooperado i = new ItemDistribuicaoSobraCooperado();
                    i.setCooperado(c);
                    i.setValorDevolucao(ContatoFormatUtil.arrredondarNumero(valorDevolucao, 2));
                    i.setValorVenda(ContatoFormatUtil.arrredondarNumero(valorVenda, 2));
                    i.setValorBonificacao(ContatoFormatUtil.arrredondarNumero(valorBonificacao, 2));
                    i.setValorFatEntrada(ContatoFormatUtil.arrredondarNumero(valorFatEntrada, 2));
                    i.setValorPrestacaoServicos(ContatoFormatUtil.arrredondarNumero(valorRps, 2));
                    Double valorTotal = ContatoFormatUtil.arrredondarNumero(valorVenda + valorFatEntrada + valorRps - valorDevolucao - valorBonificacao, 2);
                    if (valorTotal <= 0.0) {
                        valorTotal = 0.0;
                    }
                    i.setValorTotal(valorTotal);
                    itens.add(i);
                    achou = true;
                    break;
                }
                if (!achou.booleanValue()) continue;
                continue block0;
            }
        }
        return itens;
    }

    private void aplicarPercentualDistribuicao(List<ItemDistribuicaoSobraCooperado> itens, Double valorDistribuicao, Date dataInicial, Date dataFinal, Short calcularIrrf) throws ExceptionService {
        Double valorTotal = 0.0;
        int count = 0;
        TabelaIRRFPlr tabela = this.getTabelaIRRF(dataInicial);
        if (ToolMethods.isEquals((Object)calcularIrrf, (Object)EnumConstantsMentorSimNao.SIM.getValue()) && ToolMethods.isNull((Object)tabela).booleanValue()) {
            throw new ExceptionService("Nenhuma Tabela de IRRF PLR foi encontrada para o per\u00edodo informado. Por favor, acesse o recurso 1290 - Tabela IRRF PLR para verificar!");
        }
        for (ItemDistribuicaoSobraCooperado i : itens) {
            valorTotal = valorTotal + i.getValorTotal();
            valorTotal = ContatoFormatUtil.arrredondarNumero(valorTotal, 2);
            ++count;
        }
        Double somaValor = 0.0;
        int count2 = 0;
        this.ordenarItens(itens);
        for (ItemDistribuicaoSobraCooperado i : itens) {
            Double dif;
            Double percentual = ContatoFormatUtil.arrredondarNumero(i.getValorTotal() * 100.0 / valorTotal, 6);
            Double valor = ContatoFormatUtil.arrredondarNumero(valorDistribuicao * percentual / 100.0, 2);
            Double valorIrrf = 0.0;
            if (ToolMethods.isEquals((Object)i.getCooperado().getCliente().getPessoa().getComplemento().getTipoPessoa(), (Object)EnumConstTipoPessoaComplementar.FISICA.getEnumId())) {
                valorIrrf = this.getCalculoIrrf(valor, tabela, calcularIrrf);
            }
            i.setValorIrrf(valorIrrf);
            i.setPercDistribuicao(percentual);
            i.setValorDistribuicao(ContatoFormatUtil.arrredondarNumero(valor - valorIrrf, 2));
            somaValor = somaValor + valor;
            if (count != ++count2) continue;
            somaValor = ContatoFormatUtil.arrredondarNumero(somaValor, 2);
            valorDistribuicao = ContatoFormatUtil.arrredondarNumero(valorDistribuicao, 2);
            if (somaValor < valorDistribuicao) {
                dif = valorDistribuicao - somaValor;
                i.setValorDistribuicao(Double.valueOf(valor + dif - valorIrrf));
                continue;
            }
            if (!(somaValor > valorDistribuicao)) continue;
            dif = somaValor - valorDistribuicao;
            i.setValorDistribuicao(Double.valueOf(valor - dif - valorIrrf));
        }
    }

    private void getValoresBonificacaoPorCfops(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> lista, List<CfopBonificacaoDistSobraCoop> listCfops, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        for (CfopBonificacaoDistSobraCoop cb : listCfops) {
            Long idCfop = cb.getCfop().getIdentificador();
            List<HashMap> listBonificacaoNP = this.getValoresVendasNFPropriasBonificacao(dataInicial, dataFinal, empresa, idCfop, filtrarGrupoEmpresa, classificacaoClientes, tipoClassificacao);
            List<HashMap> listBonificacaoNFCe = this.getValoresVendasNFCeBonificacao(dataInicial, dataFinal, empresa, idCfop, filtrarGrupoEmpresa, classificacaoClientes, tipoClassificacao);
            this.mesclarBonificacao(lista, listBonificacaoNP);
            this.mesclarBonificacao(lista, listBonificacaoNFCe);
        }
    }

    private List<HashMap> getValoresVendasNFPropriasBonificacao(Date dataInicial, Date dataFinal, Empresa empresa, Long idCfop, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(i.itemNotaLivroFiscal.valorTotal) as VALOR_BONIFICACAO, n.unidadeFatCliente.pessoa.complemento.cnpj as CNPJ  from NotaFiscalPropria n inner join n.itensNotaPropria i  inner join i.itemNotaLivroFiscal ilf  where n.dataEmissaoNota between :dataIn and :dataFim and n.naturezaOperacao.entradaSaida = :entSaida and ilf.cfop.identificador = :idcfop and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatCliente is not null)";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_DOC)) {
            query = (String)query + " and n.classificacaoCliente = :classificacao";
        } else if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_CLIENTE)) {
            query = (String)query + " and n.unidadeFatCliente.cliente.classificacaoClientes = :classificacao";
        }
        query = (String)query + " group by n.unidadeFatCliente.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("entSaida", (short)1);
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        q.setLong("idcfop", idCfop.longValue());
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        if (classificacaoClientes != null) {
            q.setEntity("classificacao", (Object)classificacaoClientes);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    private List<HashMap> getValoresVendasNFCeBonificacao(Date dataInicial, Date dataFinal, Empresa empresa, Long idCfop, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes, Short tipoClassificacao) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(i.valorTotal) as VALOR_BONIFICACAO, n.unidadeFatCliente.pessoa.complemento.cnpj as CNPJ  from NFCe n inner join n.itens i  where n.dataEmissao between :dataIn and :dataFim and n.naturezaOperacao.entradaSaida = :entSaida and i.cfop.identificador = :idcfop and (n.situacaoDocumento.codigo <> :codSit1 and n.situacaoDocumento.codigo <> :codSit2 and n.situacaoDocumento.codigo <> :codSit3) and (n.unidadeFatCliente is not null) and i.status = :ativo";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_DOC)) {
            query = (String)query + " and n.classificacaoCliente = :classificacao";
        } else if (classificacaoClientes != null && ToolMethods.isEquals((Object)tipoClassificacao, (Object)this.TIPO_CLASSIFICACAO_CLIENTE)) {
            query = (String)query + " and n.unidadeFatCliente.cliente.classificacaoClientes = :classificacao";
        }
        query = (String)query + " group by n.unidadeFatCliente.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("entSaida", (short)1);
        q.setString("codSit1", "02");
        q.setString("codSit2", "03");
        q.setString("codSit3", "04");
        q.setLong("idcfop", idCfop.longValue());
        q.setShort("ativo", EnumConstantsMentorSimNao.SIM.getValue());
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        if (classificacaoClientes != null) {
            q.setEntity("classificacao", (Object)classificacaoClientes);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valores = q.list();
        return valores;
    }

    private void mesclarBonificacao(List<HashMap> lista, List<HashMap> listaBonificacao) {
        for (Map map : lista) {
            String cnpjPessoa1 = (String)map.get("CNPJ");
            Double bonificacao = (Double)map.get("VALOR_BONIFICACAO");
            for (Map map2 : listaBonificacao) {
                String cnpjPessoa2 = (String)map2.get("CNPJ");
                Double bonificacao2 = (Double)map2.get("VALOR_BONIFICACAO");
                if (!cnpjPessoa1.equals(cnpjPessoa2)) continue;
                bonificacao = bonificacao + bonificacao2;
            }
            map.put("VALOR_BONIFICACAO", bonificacao);
        }
    }

    private TabelaIRRFPlr getTabelaIRRF(Date dataInicial) throws ExceptionService {
        String hql = " from TabelaIRRFPlr t  where  :dataInicial between t.dataInicial and t.dataFinal ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("dataInicial", (Object)dataInicial).list();
        if (retorno == null || retorno.isEmpty()) {
            return null;
        }
        if (retorno.size() > 1) {
            throw new ExceptionService("Existem mais de uma Tabela de IRRF PLR para o Periodo Informado");
        }
        return (TabelaIRRFPlr)retorno.get(0);
    }

    private Double getCalculoIrrf(Double valor, TabelaIRRFPlr tabela, Short calcularIrrf) {
        Double vlrIrrf = 0.0;
        if (calcularIrrf.equals(EnumConstantsMentorSimNao.NAO.getValue())) {
            return vlrIrrf;
        }
        if (tabela == null) {
            return vlrIrrf;
        }
        for (ItemTabelaIRRFPlr itemTabelaIRRFPlr : tabela.getItensTabela()) {
            if (!(itemTabelaIRRFPlr.getValorAte() > valor)) continue;
            Double valorIrrf = valor * (itemTabelaIRRFPlr.getAliquota() / 100.0) - itemTabelaIRRFPlr.getVrDeducao();
            return ContatoFormatUtil.arrredondarNumero(valorIrrf, 2);
        }
        return vlrIrrf;
    }

    public Titulo gerarTituloIRRF(DistribuicaoSobraCooperado vo, OpcoesContabeis oc, OpcoesFinanceiras op) throws ExceptionService {
        Double valorIrrf = this.getValorIrrf(vo);
        if (valorIrrf == 0.0) {
            return null;
        }
        OpcoesContabeisImpostosRetidos irrf = CompOpcoesContabeis.getOpcoesImpostoRetido((OpcoesContabeis)oc, (EnumConstImpostosRetidos)EnumConstImpostosRetidos.IRRF);
        if (irrf.getDiaVencimentoImpostoRetido() == null || irrf.getDiaVencimentoImpostoRetido() == 0) {
            throw new ExceptionService("Informe o dia de vencimento do IRRF na empresa Contabilidade");
        }
        if (irrf.getPessoaImpostoRetido() == null) {
            throw new ExceptionService("Informe a Pessoa do IRRF na empresa Contabilidade");
        }
        if (irrf.getPlanoContaImpostoRetido() == null) {
            throw new ExceptionService("Informe o Plano de conta Contabil IRRF na empresa Contabilidade");
        }
        if (irrf.getPlanoContaGerencialImpostoRetido() == null) {
            throw new ExceptionService("Informe o Plano Gerencial IRRF na empresa Contabilidade");
        }
        Date dataVencimento = this.getVencimento(vo.getDataVencimento(), irrf.getDiaVencimentoImpostoRetido().intValue());
        return this.getTituloIrrf(irrf.getPessoaImpostoRetido(), irrf.getPlanoContaImpostoRetido(), irrf.getPlanoContaGerencialImpostoRetido(), vo, "Titulo Referente a IRRF - Distribuicao de Lucro", valorIrrf, dataVencimento, EnumConstantsMentorSimNao.SIM.getValue(), op, (short)0);
    }

    public Titulo getTituloIrrf(Pessoa p, PlanoConta pc, PlanoContaGerencial pcGer, DistribuicaoSobraCooperado vo, String obs, Double valor, Date dataTitulo, Short num, OpcoesFinanceiras op, Short tipoTitulo) {
        Titulo t = new Titulo();
        t.setCarteiraCobranca(op.getCarteiraCobrancaTitPag());
        t.setDataCadastro(new Date());
        t.setDataEmissao(vo.getDataEmissao());
        t.setDataCompetencia(vo.getDataEmissao());
        t.setDataEntradaSaida(t.getDataCompetencia());
        t.setEmpresa(vo.getEmpresa());
        t.setDataVencimento(dataTitulo);
        t.setDataVencimentoBase(dataTitulo);
        t.setNaoCompoeFluxo(Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()));
        t.setNumParcTituloEstnota(Short.valueOf((short)1));
        t.setObservacao(obs);
        t.setPagRec(tipoTitulo);
        t.setPercJurosMes(Double.valueOf(0.0));
        t.setPessoa(p);
        t.setClassificacaoPessoa(op.getClassificacaoClientes());
        t.setNumParcTituloEstnota(num);
        t.setPlanoConta(pc);
        t.setProvisao(Short.valueOf((short)1));
        t.setTipoDoc(op.getTipoDocFinanceiro());
        t.setTipoPessoa(EnumConstPessoa.PESSOA.getEnumId());
        t.setValor(valor);
        t.setVrAbatimento(Double.valueOf(0.0));
        t.setVrDescontoCondicional(Double.valueOf(0.0));
        t.setVrIofPago(Double.valueOf(0.0));
        t.setVrJurosDia(Double.valueOf(0.0));
        LancamentoCtbGerencial l = ((HelperLancamentoCtbGerencial)Context.get(HelperLancamentoCtbGerencial.class)).newLancamentoCtbGerencial(null, dataTitulo, dataTitulo, Short.valueOf(EnumLancamentoCTBGerencial.DEBITO.getValue()), t.getEmpresa(), Short.valueOf(EnumConstantsMentorSimNao.NAO.getValue()), obs, pcGer, null, Short.valueOf(EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue()), null, valor, null);
        ArrayList<LancamentoCtbGerencial> aux = new ArrayList<LancamentoCtbGerencial>();
        aux.add(l);
        t.setLancCtbGerencial(aux);
        return t;
    }

    private Double getValorIrrf(DistribuicaoSobraCooperado vo) {
        Double valorIrrf = 0.0;
        for (ItemDistribuicaoSobraCooperado i : vo.getItensDistribuicaoSobraCooperado()) {
            valorIrrf = valorIrrf + ToolFormatter.arrredondarNumero((Double)i.getValorIrrf(), (int)2);
            valorIrrf = ToolFormatter.arrredondarNumero((Double)valorIrrf, (int)2);
        }
        return valorIrrf;
    }

    private Date getVencimento(Date dataVencimento, Integer diaVencimento) {
        GregorianCalendar g = new GregorianCalendar();
        g.setTime(dataVencimento);
        g.add(2, 1);
        g.set(5, diaVencimento);
        return g.getTime();
    }

    private String getStringCfop(List<CfopFatEntradaDistSobraCoop> listCfopFatEntrada) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int cont = 1;
        for (CfopFatEntradaDistSobraCoop c : listCfopFatEntrada) {
            if (cont < listCfopFatEntrada.size()) {
                sb.append(c.getCfop().getIdentificador());
                sb.append(", ");
            } else {
                sb.append(c.getCfop().getIdentificador());
            }
            ++cont;
        }
        sb.append(")");
        return sb.toString();
    }

    private List getValoresRPS(Date dataInicial, Date dataFinal, Empresa empresa, List<HashMap> lista, Short filtrarGrupoEmpresa, ClassificacaoClientes classificacaoClientes) {
        Session s = CoreBdUtil.getInstance().getSession();
        Object query = "select sum(n.valorLiquidoNfse) as VALOR_RPS, n.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.complemento.cnpj as CNPJ  from Rps n  where n.dataEmissao between :dataIn and :dataFim and n.status = :normal";
        query = ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue()) ? (String)query + " and n.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa" : (String)query + " and n.empresa.identificador = :idEmpresa";
        if (classificacaoClientes != null) {
            query = (String)query + " and n.unidadeTomPrestRPS.tomadorPrestadorRPS.classificacaoPessoa = :classificacaoPessoa ";
        }
        query = (String)query + " group by n.unidadeTomPrestRPS.tomadorPrestadorRPS.pessoa.complemento.cnpj";
        Query q = s.createQuery((String)query);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setShort("normal", (short)1);
        if (ToolMethods.isEquals((Object)filtrarGrupoEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setLong("idGrupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        } else {
            q.setLong("idEmpresa", empresa.getIdentificador().longValue());
        }
        if (classificacaoClientes != null) {
            q.setEntity("classificacaoPessoa", (Object)classificacaoClientes);
        }
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List valores = q.list();
        for (HashMap h : valores) {
            String cnpjPessoa = (String)h.get("CNPJ");
            Double valorRps = (Double)h.get("VALOR_RPS");
            Boolean achou = false;
            for (HashMap hh : lista) {
                String cnpjPessoa2 = (String)hh.get("CNPJ");
                if (!cnpjPessoa.equals(cnpjPessoa2)) continue;
                Double valorRps2 = (Double)hh.get("VALOR_RPS");
                hh.put("VALOR_RPS", valorRps + valorRps2);
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            HashMap<String, Object> hh = new HashMap<String, Object>();
            hh.put("VALOR_VENDA", 0.0);
            hh.put("VALOR_DEVOLUCAO", 0.0);
            hh.put("VALOR_BONIFICACAO", 0.0);
            hh.put("VALOR_FAT_ENTRADA", 0.0);
            hh.put("VALOR_RPS", valorRps);
            hh.put("CNPJ", cnpjPessoa);
            lista.add(hh);
        }
        return lista;
    }

    private void ordenarItens(List<ItemDistribuicaoSobraCooperado> itens) {
        Collections.sort(itens, new Comparator<ItemDistribuicaoSobraCooperado>(this){

            @Override
            public int compare(ItemDistribuicaoSobraCooperado o1, ItemDistribuicaoSobraCooperado o2) {
                return o1.getValorTotal().compareTo(o2.getValorTotal());
            }
        });
    }
}

