/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.duplicatatransporte;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.EmpresaContabilidade;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.ItemDupTransporteNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemDuplicataTransporte;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceirosFreteCtrc;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.ValoresNfTerceiros;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionCalculoICMS;
import mentorcore.exceptions.ExceptionCalculoIPI;
import mentorcore.exceptions.ExceptionCalculoPisCofins;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.utilities.CoreUtilityFactory;
import mentorcore.utilities.impl.calculoimpostos.CalculosImpFiscaisNotaTerceiros;

public class ServiceDuplicataTransporte
extends CoreService {
    public static final String SALVAR_ITEM_DUP_TRANSPORTE = "salvarDuplicataTransporte";
    public static final String EXCLUIR_ITEM_DUP_TRANSPORTE = "excluirDuplicataTransporte";

    public Object salvarDuplicataTransporte(CoreRequestContext cq) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionInvalidData {
        ItemDuplicataTransporte item = (ItemDuplicataTransporte)cq.getAttribute("itemDuplicataTransporte");
        EmpresaContabilidade empCont = (EmpresaContabilidade)cq.getAttribute("empresaContabilidade");
        EmpresaFinanceiro empFin = (EmpresaFinanceiro)cq.getAttribute("empresaFinanceiro");
        OpcoesFinanceiras opFin = (OpcoesFinanceiras)cq.getAttribute("opcoesFinanceiras");
        OpcoesContabeis opCont = (OpcoesContabeis)cq.getAttribute("opcoesContabeis");
        OpcoesCompraSuprimentos opCompra = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompras");
        OpcoesEstoque opcoesEstoque = (OpcoesEstoque)cq.getAttribute("opcoesEstoque");
        OpcoesImpostos opcoesImpostos = (OpcoesImpostos)cq.getAttribute("opcoesImposto");
        Usuario usuario = (Usuario)cq.getAttribute("usuario");
        if (item.getGerarNFTerceirosCte() == 1) {
            CoreUtilityFactory.getUtilityGeracaoNFTerceiros().gerarNFTerceirosItemDupTransporte(item, opFin, empCont, empFin, opCont, opCompra, opcoesEstoque, usuario, opcoesImpostos);
            double vlrConhecimento = item.getNotaTercGerada().getValoresNfTerceiros().getValorTotal();
            double totalCalc = 0.0;
            double totaisNF = item.getItemDuplicataTransNFTerc().stream().mapToDouble(i -> i.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorTotal()).sum();
            ItemDupTransporteNotaTerceiros last = null;
            for (ItemDupTransporteNotaTerceiros itemNF : item.getItemDuplicataTransNFTerc()) {
                double perc = itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorTotal() / totaisNF;
                double calc = ContatoFormatUtil.arrredondarNumero((Double)(vlrConhecimento * perc), (int)2);
                totalCalc += calc;
                itemNF.setValorRateio(Double.valueOf(calc));
                itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().setValorFreteCtrc(Double.valueOf(calc));
                itemNF.getNotaFiscalTerceiros().getNotaTerceirosFreteCtrc().add(this.criarNotaTerceirosFreteCtrc(item.getNotaTercGerada(), itemNF.getNotaFiscalTerceiros(), calc));
                this.calcValoresNF(itemNF, empCont, opCompra, opcoesImpostos);
                last = itemNF;
            }
            if (last != null) {
                last.getNotaFiscalTerceiros().getValoresNfTerceiros().setValorFreteCtrc(Double.valueOf(last.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorFreteCtrc() + (vlrConhecimento - totalCalc)));
                NotaFiscalTerceirosFreteCtrc n = (NotaFiscalTerceirosFreteCtrc)last.getNotaFiscalTerceiros().getNotaTerceirosFreteCtrc().get(0);
                n.setValorFreteCtrc(Double.valueOf(last.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorFreteCtrc() + (vlrConhecimento - totalCalc)));
                this.calcValoresNF(last, empCont, opCompra, opcoesImpostos);
            }
        }
        return CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOItemDuplicataTransporte(), item);
    }

    private void calcValoresNF(ItemDupTransporteNotaTerceiros itemNF, EmpresaContabilidade empCont, OpcoesCompraSuprimentos opcoesCompras, OpcoesImpostos opImpostos) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins {
        CalculosImpFiscaisNotaTerceiros.calcularImpostosFiscaisItNotaTerceiros(itemNF.getNotaFiscalTerceiros().getDataEntrada(), itemNF.getNotaFiscalTerceiros().getItemNotaTerceiros(), itemNF.getNotaFiscalTerceiros().getUnidadeFatFornecedor(), itemNF.getNotaFiscalTerceiros().getUfPrestacao(), itemNF.getNotaFiscalTerceiros().getEmpresa().getPessoa().getEndereco().getCidade().getUf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorFreteInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorFreteCtrc(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorSeguroInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorDescontoInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorDespAcessoriaInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorAgregadoInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorIcmsInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorIpiInf(), itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().getValorTotalInf(), itemNF.getNotaFiscalTerceiros().getNaoRatearVlrAcess() != null && itemNF.getNotaFiscalTerceiros().getNaoRatearVlrAcess() == 1, itemNF.getNotaFiscalTerceiros().getNaoRatearVlrFrete() != null && itemNF.getNotaFiscalTerceiros().getNaoRatearVlrFrete() == 1, itemNF.getNotaFiscalTerceiros().getNaoRatearVlrSeguro() != null && itemNF.getNotaFiscalTerceiros().getNaoRatearVlrSeguro() == 1, itemNF.getNotaFiscalTerceiros().getNaoRatearVlrDesconto() != null && itemNF.getNotaFiscalTerceiros().getNaoRatearVlrDesconto() == 1, itemNF.getNotaFiscalTerceiros().getNaoRatearVlrAgregado() != null && itemNF.getNotaFiscalTerceiros().getNaoRatearVlrAgregado() == 1, empCont, opcoesCompras, opImpostos);
        ValoresNfTerceiros vr = CoreUtilityFactory.getUtilityNotaFiscalTerceiros().calcularTotalizadores(itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros(), itemNF.getNotaFiscalTerceiros().getItemNotaTerceiros(), itemNF.getNotaFiscalTerceiros().getNotaTerceirosFreteCtrc());
        vr.setNotaFiscalTerceiros(itemNF.getNotaFiscalTerceiros());
        itemNF.getNotaFiscalTerceiros().setValoresNfTerceiros(vr);
    }

    public Object excluirDuplicataTransporte(CoreRequestContext cq) throws ExceptionService, ExceptionCalculoICMS, ExceptionCalculoIPI, ExceptionCalculoPisCofins, ExceptionDatabase {
        ItemDuplicataTransporte item = (ItemDuplicataTransporte)cq.getAttribute("itemDuplicataTransporte");
        EmpresaContabilidade empCont = (EmpresaContabilidade)cq.getAttribute("empresaContabilidade");
        OpcoesCompraSuprimentos opCompra = (OpcoesCompraSuprimentos)cq.getAttribute("opcoesCompras");
        OpcoesImpostos opcoesImpostos = (OpcoesImpostos)cq.getAttribute("opcoesImposto");
        for (ItemDupTransporteNotaTerceiros itemNF : item.getItemDuplicataTransNFTerc()) {
            itemNF.setValorRateio(Double.valueOf(0.0));
            itemNF.getNotaFiscalTerceiros().getValoresNfTerceiros().setValorFreteCtrc(Double.valueOf(0.0));
            this.calcValoresNF(itemNF, empCont, opCompra, opcoesImpostos);
            itemNF.getNotaFiscalTerceiros().setNotaTerceirosFreteCtrc(new ArrayList());
        }
        if (ToolMethods.isEquals((Object)item.getGerarNFTerceirosCte(), (Object)EnumConstantsMentorSimNao.NAO.getValue())) {
            item.setNotaTercGerada(null);
            CoreService.simpleSave(CoreDAOFactory.getInstance().getDAOItemDuplicataTransporte(), item);
        }
        LinkedList itens = CoreDAOFactory.getInstance().getDAOItemDupTransporteNotaTerceiros().saveOrUpdateCollection(item.getItemDuplicataTransNFTerc());
        item.setItemDuplicataTransNFTerc((List)itens);
        CoreBdUtil.getInstance().getSession().flush();
        item = (ItemDuplicataTransporte)CoreDAOFactory.getInstance().getDAOItemDuplicataTransporte().findByPrimaryKey(item.getIdentificador());
        return CoreService.simpleDelete(CoreDAOFactory.getInstance().getDAOItemDuplicataTransporte(), item);
    }

    private NotaFiscalTerceirosFreteCtrc criarNotaTerceirosFreteCtrc(NotaFiscalTerceiros notaCTRC, NotaFiscalTerceiros notaFiscalTerceiros, double calc) {
        NotaFiscalTerceirosFreteCtrc n = new NotaFiscalTerceirosFreteCtrc();
        n.setNotaTerceirosCtrc(notaCTRC);
        n.setNotaTerceiros(notaFiscalTerceiros);
        n.setValorFreteCtrc(Double.valueOf(calc));
        return n;
    }
}

