/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.engenhariaprodutos;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstDisponibilidade;
import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeral;
import com.touchcomp.basementor.model.impl.SaldoEstoqueGeralBasico;
import com.touchcomp.basementor.model.impl.VOEngenhariaProdutos;
import com.touchcomp.basementor.model.vo.Empresa;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilEngenhariaProdutos {
    private List<SaldoEstoqueGeral> saldoEstoqueProdutoUnificado = null;
    private List<HashMap> analiseCusto = null;
    private final Date dataConsulta;
    private final Date dataInicial;
    private final Date dataFinal;
    private Double qtdeReferencia;
    private final Integer nivelMax;
    private final Short tipoAnaliseCustoIndireto;
    private final Long idAnaliseCusto;
    private final Short tipoRel;
    private final Long idInicial;
    private final Long idFinal;
    private final Long idMoedaPadrao;
    private final Short carregarSaldosEstCache;
    private final Short carregarTabPrecos;
    private final Short carregarCapacidadeRoteiroApont;
    private final Empresa empresa;
    private final List<VOEngenhariaProdutos> cache;
    private final short TIPO_MAT_SEMI_ACAB_ACABADO = 0;
    private final short TIPO_MAT_MATERIA_PRIMA = 1;
    private final double percEficiencia;

    public UtilEngenhariaProdutos(Date dataConsulta, Date dataInicial, Date dataFinal, Double qtdeReferencia, Integer nivelMax, Short tipoAnaliseCustoIndireto, Long idAnaliseCusto, Short tipoRel, Long idInicial, Long idFinal, Long idMoedaPadrao, Short carregarSaldosEstCache, Short carregarTabPrecos, Short carregarCapacidadeRoteiroApont, Empresa empresa, List<VOEngenhariaProdutos> cache, double percEficiencia) {
        this.dataConsulta = dataConsulta;
        this.dataInicial = dataInicial;
        this.dataFinal = dataFinal;
        this.qtdeReferencia = qtdeReferencia;
        this.nivelMax = nivelMax;
        this.tipoAnaliseCustoIndireto = tipoAnaliseCustoIndireto;
        this.idAnaliseCusto = idAnaliseCusto;
        this.tipoRel = tipoRel;
        this.idInicial = idInicial;
        this.idFinal = idFinal;
        this.idMoedaPadrao = idMoedaPadrao;
        this.carregarSaldosEstCache = carregarSaldosEstCache;
        this.carregarTabPrecos = carregarTabPrecos;
        this.carregarCapacidadeRoteiroApont = carregarCapacidadeRoteiroApont;
        this.empresa = empresa;
        this.cache = cache;
        this.percEficiencia = percEficiencia;
    }

    public List<VOEngenhariaProdutos> processData() throws ExceptionService {
        try {
            if (this.qtdeReferencia == null || this.qtdeReferencia <= 0.0) {
                this.qtdeReferencia = 1.0;
            }
            List dados = this.getDados();
            return dados;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionService(ex);
        }
    }

    private List getDados() throws ExceptionService {
        List<VOEngenhariaProdutos> formulacoes = new LinkedList<VOEngenhariaProdutos>();
        if (null != this.tipoRel) {
            switch (this.tipoRel) {
                case 0: {
                    formulacoes = this.getFormulacoesFormulacao();
                    break;
                }
                case 1: {
                    formulacoes = this.getFormulacoes();
                    break;
                }
                default: {
                    formulacoes = this.getFormulacoesProdutos();
                }
            }
        }
        this.putQtdBaseRefParaCalculo(formulacoes);
        this.getItens(formulacoes, 1);
        this.calcularQuantidade(formulacoes, this.qtdeReferencia);
        this.calcularPrecoMedio(formulacoes);
        this.calcularUltCusto(formulacoes);
        this.calcularTempoRoteiro(formulacoes);
        this.calcularValoresCustoPrincipal(formulacoes);
        return formulacoes;
    }

    private void calcularValoresCustoPrincipal(List<VOEngenhariaProdutos> itens) throws ExceptionService {
        for (VOEngenhariaProdutos item : itens) {
            this.calcularValoresCusto(item, item.getItens());
        }
    }

    private void calcularValoresCusto(VOEngenhariaProdutos pai, List<VOEngenhariaProdutos> itens) throws ExceptionService {
        for (VOEngenhariaProdutos item : itens) {
            this.calcularValoresCusto(item, item.getItens());
            this.calcularValoresCustoFilho(item);
        }
        this.calcularTotalPai(pai);
    }

    private void calcularTotalPai(VOEngenhariaProdutos pai) throws ExceptionService {
        if (pai == null) {
            return;
        }
        if (pai.getTipoMat() == 1) {
            return;
        }
        if (pai.getTipoMat() == 0) {
            for (VOEngenhariaProdutos filho : pai.getItens()) {
                pai.setTotalGeralUltPrecoCusto(Double.valueOf(pai.getTotalGeralUltPrecoCusto() + filho.getTotalGeralUltPrecoCusto()));
                pai.setTotalGeralUltPrecoMedio(Double.valueOf(pai.getTotalGeralUltPrecoMedio() + filho.getTotalGeralUltPrecoMedio()));
                pai.setTotalUltPrecoCusto(Double.valueOf(pai.getTotalUltPrecoCusto() + filho.getTotalUltPrecoCusto()));
                pai.setTotalUltPrecoMedio(Double.valueOf(pai.getTotalUltPrecoMedio() + filho.getTotalGeralUltPrecoMedio()));
            }
        }
        this.calcularValoresCustoRoteiro(pai);
        pai.setTotalGeralUltPrecoCusto(Double.valueOf(pai.getTotalGeralUltPrecoCusto() + pai.getCustoRoteiroCalc()));
        pai.setTotalGeralUltPrecoMedio(Double.valueOf(pai.getTotalGeralUltPrecoMedio() + pai.getCustoRoteiroCalc()));
    }

    private void calcularValoresCustoRoteiro(VOEngenhariaProdutos aux) throws ExceptionService {
        if (aux.getTipoMat() == 0) {
            double custoUnitarioRoteiro = 0.0;
            double valorTotalCelula = 0.0;
            double capacidadeTotal = 0.0;
            double capRoteiroTotal = 0.0;
            List itensRoteiro = aux.getItensRoteiro();
            for (VOEngenhariaProdutos.VOEngenhariaProdutosRoteiro item : itensRoteiro) {
                Double capProdutiva = item.getCapacidadeProdutiva();
                if (this.carregarCapacidadeRoteiroApont == null || this.carregarCapacidadeRoteiroApont == 0) {
                    capProdutiva = capProdutiva * (this.percEficiencia > 0.0 ? this.percEficiencia / 100.0 : 1.0);
                }
                if (!(capProdutiva > 0.0)) continue;
                double valorCelula = this.getValorHora(item.getIdCelulaProdutiva());
                custoUnitarioRoteiro += valorCelula / capProdutiva;
                capacidadeTotal += capProdutiva.doubleValue();
                capRoteiroTotal += item.getCapacidadeRoteiro().doubleValue();
                valorTotalCelula += valorCelula;
            }
            aux.setCustoRoteiroCalc(Double.valueOf(custoUnitarioRoteiro * aux.getQuantidadeCalculada()));
            aux.setCustoCelula(Double.valueOf(valorTotalCelula));
            aux.setCapacidadeRoteiro(Double.valueOf(capRoteiroTotal));
            aux.setCapacidadeUtilizada(Double.valueOf(capacidadeTotal));
            aux.setCustoRoteiro(Double.valueOf(custoUnitarioRoteiro));
        }
    }

    private void calcularValoresCustoFilho(VOEngenhariaProdutos aux) throws ExceptionService {
        if (aux.getTipoMat() == 1) {
            aux.setCustoPrMedioMateriais(Double.valueOf(aux.getQuantidadeCalculada() * aux.getPrecoMedio()));
            aux.setCustoUltCustoMateriais(Double.valueOf(aux.getQuantidadeCalculada() * aux.getUltPrecoCusto()));
            aux.setTotalGeralUltPrecoCusto(aux.getCustoUltCustoMateriais());
            aux.setTotalGeralUltPrecoMedio(aux.getCustoPrMedioMateriais());
            aux.setTotalUltPrecoCusto(aux.getUltPrecoCusto());
            aux.setTotalUltPrecoMedio(aux.getTotalUltPrecoMedio());
            System.out.println("teste");
        }
    }

    private void calcularPrecoMedio(List<VOEngenhariaProdutos> itens) throws ExceptionService {
        for (VOEngenhariaProdutos item : itens) {
            if (item.getTipoMat() == 1) {
                VOEngenhariaProdutos found = this.getFromCachePrMedio(item.getIdGradeCor());
                if (found != null) {
                    item.setPrecoMedio(found.getPrecoMedio());
                } else {
                    Double valorPR = 0.0;
                    if (this.carregarTabPrecos == 1) {
                        valorPR = this.carregarPrecosTabPrecos(item.getIdProduto());
                    }
                    if (valorPR == null || valorPR <= 0.0) {
                        valorPR = this.getPrecoMedioGradeCor(item.getIdGradeCor(), item.getIdProduto());
                    }
                    item.setPrecoMedio(valorPR);
                }
                item.setPrecoMedioCarregado(Short.valueOf((short)1));
            }
            this.calcularPrecoMedio(item.getItens());
        }
    }

    private void calcularUltCusto(List<VOEngenhariaProdutos> itens) throws ExceptionService {
        for (VOEngenhariaProdutos item : itens) {
            if (item.getTipoMat() == 1) {
                VOEngenhariaProdutos found = this.getFromCacheUltCusto(item.getIdGradeCor());
                if (found != null) {
                    item.setUltPrecoCusto(found.getUltPrecoCusto());
                    item.setDataUltCusto(found.getDataUltCusto());
                    item.setNrDocUltCusto(found.getNrDocUltCusto());
                } else {
                    HashMap ret;
                    Double valorPR = null;
                    if (this.carregarTabPrecos == 1) {
                        valorPR = this.carregarPrecosTabPrecos(item.getIdProduto());
                        item.setUltPrecoCusto(valorPR);
                    }
                    if ((valorPR == null || valorPR <= 0.0) && (ret = this.getUltPrecoCusto(item.getIdProduto())) != null) {
                        Double valorCusto = (Double)ret.get("ULT_VALOR_CUSTO");
                        Date data = (Date)ret.get("DATA_ULT_CUSTO");
                        Number numeroNota = (Number)ret.get("NUMERO_NOTA");
                        item.setUltPrecoCusto(valorCusto);
                        item.setDataUltCusto(data);
                        item.setNrDocUltCusto(numeroNota);
                    }
                }
            }
            this.calcularUltCusto(item.getItens());
        }
    }

    private void calcularQuantidade(List<VOEngenhariaProdutos> itens, Double qtdeReferencia) {
        for (VOEngenhariaProdutos item : itens) {
            Double quantidadeCalculada = qtdeReferencia * item.getQuantidade();
            item.setQuantidadeCalculada(quantidadeCalculada);
            this.calcularQuantidade(item.getItens(), quantidadeCalculada);
        }
    }

    private void getItens(List<VOEngenhariaProdutos> itens, int nivel) throws ExceptionService {
        if (nivel > this.nivelMax) {
            return;
        }
        for (VOEngenhariaProdutos item : itens) {
            List<VOEngenhariaProdutos> ret = this.getItensFormulacao(item.getIdGradeCor());
            if (ret.isEmpty()) {
                item.setTipoMat((short)1);
            } else {
                item.setTipoMat((short)0);
                this.getItens(ret, nivel + 1);
                item.setItens(ret);
            }
            item.setNivel(nivel);
        }
    }

    private void calcularTempoRoteiro(List<VOEngenhariaProdutos> itens) throws ExceptionService {
        for (VOEngenhariaProdutos item : itens) {
            if (item.getTipoMat() == 0) {
                List<Map> itensRoteiro = this.getRoteiroProduto(item);
                if (itensRoteiro.isEmpty()) {
                    throw new ExceptionService("Produto " + item.getProduto() + "/" + item.getGradeProduto() + " sem roteiro de produ\u00e7\u00e3o.");
                }
                for (Map map : itensRoteiro) {
                    VOEngenhariaProdutos.VOEngenhariaProdutosRoteiro v = new VOEngenhariaProdutos.VOEngenhariaProdutosRoteiro(item);
                    v.setCapacidadeProdutiva((Double)map.get("CAPACIDADE_PRODUTIVA"));
                    v.setCapacidadeRoteiro((Double)map.get("CAPACIDADE_PRODUTIVA_ROTEIRO"));
                    v.setCelulaProdutiva((String)map.get("CELULA"));
                    v.setIdCelulaProdutiva((Long)map.get("ID_CELULA_PRODUTIVA"));
                    v.setIdRoteiroProducao((Long)map.get("ID_ROTEIRO_PRODUCAO"));
                    v.setTempo((Double)map.get("TEMPO"));
                    item.getItensRoteiro().add(v);
                }
            }
            this.calcularTempoRoteiro(item.getItens());
        }
    }

    private List<Map> getRoteiroProduto(VOEngenhariaProdutos item) throws ExceptionService {
        if (this.carregarCapacidadeRoteiroApont == null || this.carregarCapacidadeRoteiroApont == 0) {
            return this.getCapacidadeRoteiro(item);
        }
        return this.getCapacidadeApontada(item);
    }

    private List<Map> getCapacidadeApontada(VOEngenhariaProdutos item) throws ExceptionService {
        Long idGrade = item.getIdGradeCor();
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select cel.identificador as ID_CELULA_PRODUTIVA ,sum(g.quantidade) as QUANTIDADE ,sum(e.horaEvento) as TEMPO ,cel.descricao as CELULA ,f.qtdePorHora as QTD_HORA_ROTEIRO ,r.identificador as ID_ROTEIRO_PRODUCAO ,f.descricaoAuxiliar as FASE_PRODUTIVA from EventoOsProducaoLinhaProd e inner join e.faseProdutiva f inner join f.roteiroProducao r inner join f.celulaProdutiva cel inner join e.comunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g inner join g.gradeCor gc where gc.identificador=:idGrade and e.dataFechamento between :dataInicial and :dataFinal group by cel.identificador, cel.descricao,f.qtdePorHora,r.identificador,f.descricaoAuxiliar ");
        q.setLong("idGrade", idGrade.longValue());
        q.setDate("dataInicial", this.dataInicial);
        q.setDate("dataFinal", this.dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        for (Map map : r) {
            Double quantidade = (Double)map.get("QUANTIDADE");
            Double qtdHoraRoteiro = (Double)map.get("QTD_HORA_ROTEIRO");
            Double tempo = (Double)map.get("TEMPO");
            if (tempo == null || tempo <= 0.0) {
                throw new ExceptionService("Existem apontamentos com quantidade produzida apontada, mas sem tempo de producao. Verifique: " + item.getProduto());
            }
            if (tempo > 0.0) {
                map.put("CAPACIDADE_PRODUTIVA", quantidade / tempo);
            }
            map.put("CAPACIDADE_PRODUTIVA_ROTEIRO", qtdHoraRoteiro);
        }
        return r;
    }

    private List<Map> getCapacidadeRoteiro(VOEngenhariaProdutos item) throws ExceptionService {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select r.identificador from RoteiroProducao r  inner join r.roteiroProducaoGrCor rp inner join rp.gradeCor gc where gc.identificador=:grade and r.ativo = :ativo");
        q.setLong("grade", item.getIdGradeCor().longValue());
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        Long idRoteiro = (Long)q.uniqueResult();
        if (idRoteiro == null) {
            throw new RuntimeException("Roteiro de producao nao encontrado para produto, porem existe formulacao: " + item.getIdProduto() + " - " + item.getProduto());
        }
        q = s.createQuery("select r.identificador as ID_ROTEIRO_PRODUCAO ,c.identificador as ID_CELULA_PRODUTIVA ,f.qtdePorHora as CAPACIDADE_PRODUTIVA ,f.qtdePorHora as CAPACIDADE_PRODUTIVA_ROTEIRO ,f.descricaoAuxiliar as FASE_PRODUTIVA ,f.qtdePorHora  as FASE_PRODUTIVA ,c.descricao as CELULA from RoteiroProducao r  inner join r.roteiroProducaoGrCor rp inner join rp.gradeCor gc inner join r.fasesProdutivas f inner join f.celulaProdutiva c where r.identificador=:roteiro");
        q.setLong("roteiro", idRoteiro.longValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List r = q.list();
        return r;
    }

    private Double getPrecoMedioGradeCor(Long idGradeCor, Long idProduto) throws ExceptionService {
        if (this.carregarSaldosEstCache == 1) {
            return this.findSaldoCache(idGradeCor);
        }
        return this.findSaldoDireto(idProduto);
    }

    private Double findSaldoDireto(Long idProduto) {
        SaldoEstoqueGeralBasico sal = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProdutoUnicoBasico(idProduto, this.dataConsulta, this.empresa.getIdentificador(), 1, 1, 1, EnumConstCentroEstDisponibilidade.DISPON_TIPO_CENTRO_EST_TODOS.getValue(), EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        if (sal == null || sal.getValorMedio() == null) {
            return 0.0;
        }
        return sal.getValorMedio();
    }

    private Double findSaldoCache(Long idGradeCor) {
        if (this.saldoEstoqueProdutoUnificado == null) {
            this.loadCacheSaldos(this.empresa, this.dataConsulta);
        }
        for (SaldoEstoqueGeral h : this.saldoEstoqueProdutoUnificado) {
            Long idGradeAux = h.getGradeCor().getIdentificador();
            if (idGradeCor.longValue() != ((Number)idGradeAux).longValue()) continue;
            Double precoMedio = h.getValorMedio();
            return precoMedio != null ? precoMedio : 0.0;
        }
        return 0.0;
    }

    private HashMap getUltPrecoCusto(Long idProduto) {
        HashMap found = CoreDAOFactory.getInstance().getDAONotaFiscalTerceiros().findUltPrecoCustoData(idProduto, this.empresa.getIdentificador());
        return found;
    }

    private List<VOEngenhariaProdutos> getFormulacoes() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct g.identificador as ID_FORMULACAO ,p.identificador as ID_PRODUTO ,c.nome as NOME_FORMULACAO ,p.nome as PRODUTO ,p.codigoAuxiliar as COD_AUX_PRODUTO ,un.sigla as UN_PRODUTO ,e.nome as ESPECIE_PRODUTO ,g.descricao as NOME_FORMULACAO ,gc.identificador as ID_GRADE_COR ,s.nome as SUB_ESPECIE_PRODUTO from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.unidadeMedida un inner join p.grupoProdutos gr left join p.especie e left join p.subEspecie s where gr.identificador between :grupoInicial and :grupoFinal and g.ativo=:sim");
        q.setLong("grupoInicial", this.idInicial.longValue());
        q.setLong("grupoFinal", this.idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        return this.transformDataBI(ret);
    }

    private List<VOEngenhariaProdutos> getFormulacoesFormulacao() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct g.identificador as ID_FORMULACAO ,p.identificador as ID_PRODUTO ,c.nome as GRADE_PRODUTO ,p.nome as PRODUTO ,p.codigoAuxiliar as COD_AUX_PRODUTO ,un.sigla as UN_PRODUTO ,e.nome as ESPECIE_PRODUTO ,g.descricao as NOME_FORMULACAO ,gc.identificador as ID_GRADE_COR ,s.nome as SUB_ESPECIE_PRODUTO from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.unidadeMedida un left join p.especie e left join p.subEspecie s where g.identificador between :formIn and :formFim  and g.ativo = :sim");
        q.setLong("formIn", this.idInicial.longValue());
        q.setLong("formFim", this.idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        return this.transformDataBI(ret);
    }

    private List<VOEngenhariaProdutos> getFormulacoesProdutos() {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select distinct g.identificador as ID_FORMULACAO, p.identificador as ID_PRODUTO, c.nome as GRADE_PRODUTO, p.nome as PRODUTO, p.codigoAuxiliar as COD_AUX_PRODUTO, un.sigla as UN_PRODUTO, e.nome as ESPECIE_PRODUTO, g.descricao as NOME_FORMULACAO, gc.identificador as ID_GRADE_COR, s.nome as SUB_ESPECIE_PRODUTO from GradeFormulaProduto g inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p left join p.unidadeMedida un left join p.especie e left join p.subEspecie s where p.identificador between :prodInicial and :prodFinal and g.ativo = :sim");
        q.setLong("prodInicial", this.idInicial.longValue());
        q.setLong("prodFinal", this.idFinal.longValue());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List ret = q.list();
        return this.transformDataBI(ret);
    }

    private List<VOEngenhariaProdutos> getItensFormulacao(Long idGradeCor) {
        Session s = CoreBdUtil.getInstance().getSession();
        Query q = s.createQuery("select g.identificador from GradeFormulaProduto g inner join g.gradeCor gc where gc.identificador =:idGrade and g.ativo=:sim");
        q.setLong("idGrade", idGradeCor.longValue());
        q.setShort("sim", (short)1);
        q.setMaxResults(1);
        Long idForm = (Long)q.uniqueResult();
        if (idForm == null) {
            return new ArrayList<VOEngenhariaProdutos>();
        }
        q = s.createQuery("select p.identificador as ID_PRODUTO ,p.nome as PRODUTO ,p.codigoAuxiliar as COD_AUX_PRODUTO ,c.nome as GRADE_PRODUTO ,un.sigla as UN_PRODUTO ,e.nome as ESPECIE_PRODUTO ,s.nome as SUB_ESPECIE_PRODUTO ,g.quantidade as QUANTIDADE ,gc.identificador aS ID_GRADE_COR ,gg.identificador aS ID_FORMULACAO ,gg.descricao aS NOME_FORMULACAO from ItemGradeFormulaProduto g inner join g.gradeFormulaProduto gg inner join g.gradeCor gc inner join gc.cor c inner join gc.produtoGrade pg inner join pg.produto p inner join p.especie e inner join p.subEspecie s inner join p.unidadeMedida un where gg.identificador =:idForm and gg.ativo=:sim");
        q.setLong("idForm", idForm.longValue());
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List<VOEngenhariaProdutos> ret = this.transformDataBI(q.list());
        return ret;
    }

    private List<VOEngenhariaProdutos> transformDataBI(List<HashMap> list) {
        LinkedList<VOEngenhariaProdutos> ret = new LinkedList<VOEngenhariaProdutos>();
        for (HashMap h : list) {
            Long idFormulacao = (Long)h.get("ID_FORMULACAO");
            Long idProduto = (Long)h.get("ID_PRODUTO");
            String gradeProdutoFormulacao = (String)h.get("GRADE_PRODUTO");
            String produtoFormulacao = (String)h.get("PRODUTO");
            String codAuxProdutoFormulacao = (String)h.get("COD_AUX_PRODUTO");
            String unidadeMedidaFormulacao = (String)h.get("UN_PRODUTO");
            String especieFormulacao = (String)h.get("ESPECIE_PRODUTO");
            String descFormulacao = (String)h.get("NOME_FORMULACAO");
            Long idGradeCor = (Long)h.get("ID_GRADE_COR");
            Double quantidade = (Double)h.get("QUANTIDADE");
            VOEngenhariaProdutos b = new VOEngenhariaProdutos();
            b.setCodAuxProduto(codAuxProdutoFormulacao);
            b.setFormulacao(descFormulacao);
            b.setIdFormulacao(idFormulacao);
            b.setGradeProduto(gradeProdutoFormulacao);
            b.setIdGradeCor(idGradeCor);
            b.setIdProduto(idProduto);
            b.setNivel(0);
            b.setProduto(produtoFormulacao);
            b.setQuantidade(quantidade);
            b.setTipoMat((short)0);
            b.setUnProduto(unidadeMedidaFormulacao);
            b.setEspecieProduto(especieFormulacao);
            ret.add(b);
            this.cache.add(b);
        }
        return ret;
    }

    private void loadCacheSaldos(Empresa emp, Date dataConsulta) {
        this.saldoEstoqueProdutoUnificado = CoreDAOFactory.getInstance().getDAOSaldoEstProprio().findSaldoProduto(null, null, dataConsulta, emp.getIdentificador(), emp.getIdentificador(), 1, 1, 1, null, EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue(), null);
        System.out.println("Saldos carregados: " + this.saldoEstoqueProdutoUnificado.size());
    }

    private List<HashMap> getAnaliseCustoCelula() {
        if (this.analiseCusto == null) {
            Query q;
            Session s = CoreBdUtil.getInstance().getSession();
            if (this.tipoAnaliseCustoIndireto == 0) {
                q = s.createQuery("select a.identificador as ID_CELULA_PRODUTIVA,  a.valorCustoHora as VALOR_HORA from CelulaProdutiva a");
                q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                this.analiseCusto = q.list();
            }
            if (this.tipoAnaliseCustoIndireto == 1 && this.idAnaliseCusto != null) {
                q = s.createQuery("select c.identificador as ID_CELULA_PRODUTIVA, acc.custoHora as VALOR_HORA from AnaliseCustoProd a inner join a.analiseCustoCelProd acc inner join acc.celulaProdutiva c where a.identificador =:idanalise");
                q.setLong("idanalise", this.idAnaliseCusto.longValue());
                q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
                this.analiseCusto = q.list();
            }
        }
        return this.analiseCusto;
    }

    private Double getValorHora(Long idCelula) {
        for (HashMap hashMap : this.getAnaliseCustoCelula()) {
            Long idCel = (Long)hashMap.get("ID_CELULA_PRODUTIVA");
            Double valorCel = (Double)hashMap.get("VALOR_HORA");
            if (!idCel.equals(idCelula)) continue;
            return valorCel;
        }
        return 0.0;
    }

    private void putQtdBaseRefParaCalculo(List<VOEngenhariaProdutos> formulacoes) {
        for (VOEngenhariaProdutos r : formulacoes) {
            r.setQuantidade(this.qtdeReferencia);
        }
    }

    private Double carregarPrecosTabPrecos(Long idProduto) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery(" select tp.valorVenda as VALOR_VENDA,m.identificador as ID_MOEDA from TabelaPrecoBase t inner join t.produtos tp inner join tp.produto p inner join t.moeda m where p.identificador =:idProduto and :dataConsulta between t.dataInicial and t.dataFinal and tp.ativo=:sim");
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataConsulta", this.dataConsulta);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(1);
        Map re = (Map)q.uniqueResult();
        if (re == null) {
            return 0.0;
        }
        Double valorVenda = (Double)re.get("VALOR_VENDA");
        Long idMoeda = (Long)re.get("ID_MOEDA");
        Double cotacaoMoeda = 1.0;
        if (this.idMoedaPadrao != null && idMoeda != null && this.idMoedaPadrao.longValue() != idMoeda.longValue()) {
            cotacaoMoeda = this.getUltimaCotacaoMoeda(idMoeda);
        }
        if (cotacaoMoeda == null) {
            cotacaoMoeda = 1.0;
        }
        return valorVenda * cotacaoMoeda;
    }

    private Double getUltimaCotacaoMoeda(Long idMoeda) {
        Query q = CoreBdUtil.getInstance().getSession().createQuery(" select c.valor from CotacaoMoeda c inner join c.moeda m where m.identificador =:idMoeda order by c.dataCotacao desc");
        q.setLong("idMoeda", idMoeda.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    private VOEngenhariaProdutos getFromCachePrMedio(Long idGradeCor) {
        Optional<VOEngenhariaProdutos> found = this.cache.stream().filter(i -> i.getPrecoMedioCarregado() == 1 && i.getIdGradeCor().equals(idGradeCor)).findFirst();
        return found.isPresent() ? found.get() : null;
    }

    private VOEngenhariaProdutos getFromCacheUltCusto(Long idGradeCor) {
        Optional<VOEngenhariaProdutos> found = this.cache.stream().filter(i -> i.getUltimoCustoCarregado() == 1 && i.getIdGradeCor().equals(idGradeCor)).findFirst();
        return found.isPresent() ? found.get() : null;
    }
}

