/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocCodigoRecolhimento;
import com.touchcomp.basementor.model.vo.EsocEstabelecimentos5011;
import com.touchcomp.basementor.model.vo.EsocEvento;
import com.touchcomp.basementor.model.vo.EsocLotacaoTributaria5011;
import com.touchcomp.basementor.model.vo.EsocLoteEventos;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.EsocValores5011;
import com.touchcomp.basementor.model.vo.EsocValoresContSociaisDevidas;
import com.touchcomp.basementor.model.vo.EsocValoresOutrasEntidades;
import com.touchcomp.basementor.model.vo.Evento;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.HorarioTrabalho;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.RegistroAdmissaoPreLiminar;
import com.touchcomp.basementor.model.vo.TabelaProcessosEsoc;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.colaborador.admissaopreliminar.UtilityGeracaoS2190;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1000;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1005;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1010;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1020;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1030;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1050;
import mentorcore.service.impl.esocial.tabelasiniciais.UtilityGeracaoS1070;

public class ServiceESocialAux
extends CoreService {
    public static final String CRIAR_OBJETO_E_SOCIAL = "criarObjetoESoc";
    public static final String EXCLUIR_BASE_TESTE_E_SOCIAL = "excluirBaseTesteESocial";
    public static final String EXCLUSAO_EVENTOS_ESOCIL = "exclusaoEventosEsocial";
    public static final String BUSCAR_VALORES_INSS_ESOCIAL = "buscarValoresInssEsocial";
    public static final String BUSCAR_VALORES_FGTS_ESOCIAL = "buscarValoresFgtsEsocial";
    public static final String BUSCAR_VALORES_EVENTO_5011 = "buscarValoresEvento5011";
    public static final String BUSCAR_VALORES_IRRF_ESOCIAL = "buscarValoresIrrfEsocial";
    public static final String RETIFICAR_EVENTO_1200 = "retificarEvento1200";
    public static final String RETIFICAR_EVENTO_1210 = "retificarEvento1210";
    public static final String FIND_1210_DESLISGAMENTO = "find1210Desligamento";
    public static final String FIND_BUSCAR_MOV_TRABALHISTAS = "findBuscarMovTrabalhistas";
    public static final String EXCLUIR_ESTABELECIMENTO_NAO_ENVIADO = "excluirEstabelecimentoNaoEnviado";
    public static final String EXCLUIR_LOTACAO_NAO_ENVIADO = "excluirLotacaoNaoEnviado";
    public static final String EXCLUIR_RUBRICA_NAO_ENVIADO = "excluirEventoNaoEnviado";
    public static final String EXCLUIR_PRE_EVENTO = "excluirPreEvento";
    public static final String DESVINCULAR_EVENTOS_ESOCIAL = "desvincularEventosEsocial";
    public static final String RETIFICAR_EVENTO_1210_RECISAO = "retificarEvento1210Recisao";

    public Object criarObjetoESoc(CoreRequestContext request) throws ExceptionDatabase, ExceptionEsocial, ExceptionReflection, ExceptionService {
        Object objeto = request.getAttribute("vo");
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        if (objeto instanceof OpcoesESocial) {
            OpcoesESocial vo = (OpcoesESocial)objeto;
            return new UtilityGeracaoS1000().geracaoEventoS1000(vo, usuario);
        }
        if (objeto instanceof Evento) {
            Evento evento = (Evento)objeto;
            if (((TipoCalculoEvento)evento.getTipoCalculoEvento().get(0)).getAtivo().equals((short)1)) {
                new UtilityGeracaoS1010().geracaoEventoS1010((TipoCalculoEvento)evento.getTipoCalculoEvento().get(0), usuario, empresa);
            } else {
                new UtilityGeracaoS1010().inativarEventos((TipoCalculoEvento)evento.getTipoCalculoEvento().get(0));
            }
            return evento;
        }
        if (objeto instanceof EsocCadastroEstabelcimento) {
            EsocCadastroEstabelcimento vo = (EsocCadastroEstabelcimento)objeto;
            return new UtilityGeracaoS1005().geracaoEventoS1000(vo, usuario);
        }
        if (objeto instanceof EsocCadastroLotacaoTributaria) {
            EsocCadastroLotacaoTributaria vo = (EsocCadastroLotacaoTributaria)objeto;
            return new UtilityGeracaoS1020().geracaoEventoS1020(vo, usuario);
        }
        if (objeto instanceof Funcao) {
            Funcao vo = (Funcao)objeto;
            if (vo.getAtivo().equals((short)1)) {
                return new UtilityGeracaoS1030().geracaoEventoS1030(vo, usuario, empresa);
            }
            new UtilityGeracaoS1030().inativarEventosFuncoes(vo);
            return vo;
        }
        if (objeto instanceof HorarioTrabalho) {
            HorarioTrabalho horario = (HorarioTrabalho)objeto;
            if (horario.getEsocCadastroHorario().getAtivo().equals((short)1)) {
                new UtilityGeracaoS1050().gerarDadosEsocialS1050(horario, usuario, empresa);
            } else {
                new UtilityGeracaoS1050().inativarHorario(horario);
            }
            return horario;
        }
        if (objeto instanceof TabelaProcessosEsoc) {
            TabelaProcessosEsoc vo = (TabelaProcessosEsoc)objeto;
            return new UtilityGeracaoS1070().geracaoEventoS1070(vo, usuario, empresa);
        }
        if (objeto instanceof RegistroAdmissaoPreLiminar) {
            RegistroAdmissaoPreLiminar vo = (RegistroAdmissaoPreLiminar)objeto;
            return new UtilityGeracaoS2190().geracaoEventoS2190(vo, usuario, empresa);
        }
        return null;
    }

    public void excluirBaseTesteESocial(CoreRequestContext request) {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        this.desvincularEsocEvento(empresa);
        this.deletarEsocEvento();
    }

    private void desvincularEsocEvento(Empresa empresa) {
        String hql = " update EsocPreEvento e  set e.esocEvento = null  where  e.empresa = :empresa  and  e.eventoProdRestritaProducao = :restrita";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresa).setShort("restrita", EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue()).executeUpdate();
    }

    private void deletarEsocEvento() {
        String hql = "  delete from EsocEvento e   where   not exists (from EsocPreEvento ee where ee.esocEvento = e )";
        CoreBdUtil.getInstance().getSession().createQuery(hql).executeUpdate();
    }

    public void exclusaoEventosEsocial(CoreRequestContext r) throws ExceptionDatabase {
    }

    public List buscarValoresInssEsocial(CoreRequestContext r) {
        Date periodoInicial = (Date)r.getAttribute("periodoInicial");
        Date periodoFinal = (Date)r.getAttribute("periodoFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        Short tipo = (Short)r.getAttribute("tipo");
        return this.getValoresInss(periodoInicial, periodoFinal, grupoEmpresa, tipo);
    }

    public List buscarValoresFgtsEsocial(CoreRequestContext r) {
        Date periodoInicial = (Date)r.getAttribute("periodoInicial");
        Date periodoFinal = (Date)r.getAttribute("periodoFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        Short tipo = (Short)r.getAttribute("tipo");
        return this.getValoresFgts(periodoInicial, periodoFinal, grupoEmpresa, tipo);
    }

    public EsocValores5011 buscarValoresEvento5011(CoreRequestContext r) throws ExceptionDatabase, ExceptionService {
        Date periodoInicial = (Date)r.getAttribute("periodoInicial");
        Date periodoFinal = (Date)r.getAttribute("periodoFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        Short tipo = (Short)r.getAttribute("tipo");
        return this.getValores5011(periodoInicial, periodoFinal, grupoEmpresa, tipo);
    }

    public List buscarValoresIrrfEsocial(CoreRequestContext r) {
        Date periodoInicial = (Date)r.getAttribute("periodoInicial");
        Date periodoFinal = (Date)r.getAttribute("periodoFinal");
        GrupoEmpresa grupoEmpresa = (GrupoEmpresa)r.getAttribute("grupoEmpresa");
        Short tipo = (Short)r.getAttribute("tipo");
        return this.getValoresIrrf(periodoInicial, periodoFinal, grupoEmpresa, tipo);
    }

    private List getValoresInss(Date periodoInicial, Date periodoFinal, GrupoEmpresa grupoEmpresa, Short tipo) {
        String hql = " from EsocValoresInssColaborador e     where     e.periodoApuracao between :periodoInicial and :periodoFinal     and     e.esocEvento.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa     and      ( e.esocEvento.preEvento.tipoEventoEsocial.identificador = :folha or e.esocEvento.preEvento.tipoEventoEsocial.identificador = :desligamento  )      and     e.esocEvento.preEvento.eventoProdRestritaProducao = :tipo     and     ( e.esocEvento.preEvento.eventoPosterior is null    or         not exists (from EsocEvento es             where             es.preEvento.eventoRetificacao = 1             and             es.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa             and             ( es.preEvento.tipoEventoEsocial.identificador = :folha or es.preEvento.tipoEventoEsocial.identificador = :desligamento )            and             es.preEvento.tipoEventoEsocial = e.esocEvento.preEvento.tipoEventoEsocial             and             es.preEvento.eventoProdRestritaProducao = : tipo            and             es.preEvento.numeroReciboRetificado = e.esocEvento.nrRecibo) )    order by   e.totalInssEsocial desc";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("tipo", tipo.shortValue()).setParameter("folha", (Object)ConstantsESocial.REGISTRO_1200).setParameter("desligamento", (Object)ConstantsESocial.REGISTRO_2299).setEntity("grupoEmpresa", (Object)grupoEmpresa).list();
    }

    private List getValoresIrrf(Date periodoInicial, Date periodoFinal, GrupoEmpresa grupoEmpresa, Short tipo) {
        String hql = " from EsocValoresIrrfColaborador e where  e.periodoApuracao between :periodoInicial and :periodoFinal  and  e.esocEvento.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  e.esocEvento.preEvento.eventoProdRestritaProducao = :tipo  and     not exists (from EsocEvento es             where             es.preEvento.eventoRetificacao = 1             and             es.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa            and             es.preEvento.tipoEventoEsocial = e.esocEvento.preEvento.tipoEventoEsocial             and             es.preEvento.eventoProdRestritaProducao = : tipo            and             es.preEvento.numeroReciboRetificado = e.esocEvento.nrRecibo)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("tipo", tipo.shortValue()).setEntity("grupoEmpresa", (Object)grupoEmpresa).list();
    }

    public EsocS1010 retificarEvento1200(CoreRequestContext r) {
        MovimentoFolha m = (MovimentoFolha)r.getAttribute("mov");
        return this.getEvento1200Folha(m);
    }

    private EsocS1010 getEvento1200Folha(MovimentoFolha m) {
        String hql = " select distinct s.s1010  from EsocItemS1010 s  where  s.movimentoFolha = :m ";
        return (EsocS1010)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("m", (Object)m).uniqueResult();
    }

    public ESocS1020 retificarEvento1210(CoreRequestContext r) {
        MovimentoFolha m = (MovimentoFolha)r.getAttribute("mov");
        return this.getEvento1210Folha(m);
    }

    public ESocS1020 find1210Desligamento(CoreRequestContext r) {
        Recisao vo = (Recisao)r.getAttribute("vo");
        String hql = " select distinct s.esocS1020  from EsocItemS1020 s  where  s.rescisao = :vo ";
        return (ESocS1020)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("vo", (Object)vo).uniqueResult();
    }

    private ESocS1020 getEvento1210Folha(MovimentoFolha m) {
        String hql = " select distinct s.esocS1020  from EsocItemS1020 s  where  s.movimentoFolha = :m ";
        return (ESocS1020)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("m", (Object)m).uniqueResult();
    }

    public List findBuscarMovTrabalhistas(CoreRequestContext r) {
        Colaborador colaborador = (Colaborador)r.getAttribute("colaborador");
        return this.getMovimentacaoTrabalhista(colaborador);
    }

    private List getMovimentacaoTrabalhista(Colaborador colaborador) {
        String hql = " select e  from EsocPreEvento e  left join e.afastamentoColaborador afastamentoColaborador  left join e.recisao recisao  left join e.emissaoAviso emissaoAviso  left join e.feriasColaborador feriasColaborador  left join feriasColaborador.periodoAqFeriasColab periodoAqFeriasColab left join periodoAqFeriasColab.colaborador col  left join e.transferenciaColaborador transferenciaColaborador  left join e.convocacao convocacao  left join e.colaborador colaborador  where  e.eventoProdRestritaProducao = :producao  and  e.esocEvento is not null  and  (e.esocEvento.status = :sucesso or e.esocEvento.status = :sucessoAdvertencia) and  (col = :colaborador  or  afastamentoColaborador.colaborador = :colaborador  or  recisao.colaborador = :colaborador  or  emissaoAviso.colaborador = :colaborador  or  colaborador = :colaborador   or  transferenciaColaborador.colaborador = :colaborador  or  convocacao.colaborador = :colaborador )";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setShort("producao", EnumConstEventoProducao.EVENTO_PRODUCAO.getValue()).setShort("sucessoAdvertencia", (short)202).setShort("sucesso", (short)201).list();
    }

    private List getValoresFgts(Date periodoInicial, Date periodoFinal, GrupoEmpresa grupoEmpresa, Short tipo) {
        String hql = " from EsocValoresFgtsColaborador e     where     e.periodoApuracao between :periodoInicial and :periodoFinal     and     e.esocEvento.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa     and     e.esocEvento.preEvento.eventoProdRestritaProducao = :tipo     and     not exists (from EsocEvento es             where             es.preEvento.eventoRetificacao = 1             and             es.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa            and             es.preEvento.tipoEventoEsocial = e.esocEvento.preEvento.tipoEventoEsocial             and             es.preEvento.eventoProdRestritaProducao = : tipo            and             es.preEvento.numeroReciboRetificado = e.esocEvento.nrRecibo)";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("tipo", tipo.shortValue()).setEntity("grupoEmpresa", (Object)grupoEmpresa).list();
    }

    private EsocValores5011 getValores5011(Date periodoInicial, Date periodoFinal, GrupoEmpresa grupoEmpresa, Short tipo) throws ExceptionDatabase, ExceptionService {
        String hql = " from EsocValores5011 e     where     e.periodoApuracao between :periodoInicial and :periodoFinal     and     e.esocEvento.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa     and     e.esocEvento.preEvento.tipoEventoEsocial.identificador = 29     and     e.esocEvento.preEvento.eventoProdRestritaProducao = :tipo     and     not exists (from EsocEvento es             where             es.preEvento.eventoRetificacao = 1             and             es.preEvento.empresa.empresaDados.grupoEmpresa = :grupoEmpresa             and             es.preEvento.tipoEventoEsocial.identificador = 29              and             es.preEvento.tipoEventoEsocial = e.esocEvento.preEvento.tipoEventoEsocial             and             es.preEvento.eventoProdRestritaProducao = : tipo            and             es.preEvento.numeroReciboRetificado = e.esocEvento.nrRecibo)";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("tipo", tipo.shortValue()).setEntity("grupoEmpresa", (Object)grupoEmpresa).list();
        if (retorno == null || retorno.isEmpty()) {
            return null;
        }
        EsocValores5011 esoc = (EsocValores5011)retorno.get(retorno.size() - 1);
        for (EsocValoresOutrasEntidades esocValoresOutrasEntidade : esoc.getEsocValoresOutrasEntidades()) {
            if (esocValoresOutrasEntidade.getEsocCodigoRecolhimento() != null) continue;
            esocValoresOutrasEntidade.setEsocCodigoRecolhimento(this.getCodigoRecolhimento(esocValoresOutrasEntidade.getCodigoReceita()));
            CoreDAOFactory.getInstance().getDAOEsocValoresOutrasEntidades().saveOrUpdate(esocValoresOutrasEntidade);
        }
        for (EsocEstabelecimentos5011 e : esoc.getEstabelecimentos()) {
            for (EsocValoresContSociaisDevidas valoresDevido : e.getValoresDevidos()) {
                if (valoresDevido.getEsocCodigoRecolhimento() != null) continue;
                valoresDevido.setEsocCodigoRecolhimento(this.getCodigoRecolhimento(valoresDevido.getCodigoReceita()));
                CoreDAOFactory.getInstance().getDAOEsocValoresContSociaisDevidas().saveOrUpdate(valoresDevido);
            }
            String cnpj = e.getNumeroCnpj();
            if (e.getEstabelecimento() == null) {
                e.setEstabelecimento(this.getEstabelecimento(cnpj));
                CoreDAOFactory.getInstance().getDAOEsocEstabelecimentos5011().saveOrUpdate(e);
            }
            for (EsocLotacaoTributaria5011 l : e.getLotacoes()) {
                if (l.getLotacaoTributaria() != null) continue;
                String codigoLotacao = l.getCodigo();
                l.setLotacaoTributaria(this.getLotacaoTributaria(codigoLotacao));
                CoreDAOFactory.getInstance().getDAOEsocLotacaoTributaria5011().saveOrUpdate(l);
            }
        }
        return esoc;
    }

    private EsocCadastroEstabelcimento getEstabelecimento(String cnpj) {
        String hql = " select distinct e from EsocCadastroEstabelcimento e  where  e.empresa.pessoa.complemento.cnpj = :cnpj ";
        return (EsocCadastroEstabelcimento)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("cnpj", (Object)cnpj).setMaxResults(1).uniqueResult();
    }

    private EsocCadastroLotacaoTributaria getLotacaoTributaria(String codigoLotacao) {
        String hql = " select distinct l  from EsocCadastroLotacaoTributaria l  where  l.codigo = :codigoLotacao ";
        return (EsocCadastroLotacaoTributaria)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("codigoLotacao", (Object)codigoLotacao).uniqueResult();
    }

    private EsocCodigoRecolhimento getCodigoRecolhimento(String codigoReceita) throws ExceptionService {
        EsocCodigoRecolhimento r = (EsocCodigoRecolhimento)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEsocCodigoRecolhimento(), "codigo", codigoReceita, 0);
        return r;
    }

    public void excluirEstabelecimentoNaoEnviado(CoreRequestContext r) throws ExceptionDatabase {
        EsocCadastroEstabelcimento vo = (EsocCadastroEstabelcimento)r.getAttribute("vo");
        if (!vo.getPreEventosEsocial().isEmpty()) {
            List eventos = vo.getPreEventosEsocial();
            vo.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setEstabelecimento(null);
                CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
            }
        }
        CoreDAOFactory.getInstance().getDAOEsocCadastroEstabelecimento().delete(vo);
    }

    public void excluirLotacaoNaoEnviado(CoreRequestContext r) throws ExceptionDatabase {
        EsocCadastroLotacaoTributaria vo = (EsocCadastroLotacaoTributaria)r.getAttribute("vo");
        if (!vo.getPreEventosEsocial().isEmpty()) {
            List eventos = vo.getPreEventosEsocial();
            vo.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setLotacaoTrbutaria(null);
                CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
            }
        }
        CoreDAOFactory.getInstance().getDAOEsocCadastroTipoLotacao().delete(vo);
    }

    public void excluirEventoNaoEnviado(CoreRequestContext r) throws ExceptionDatabase {
        Evento evt = (Evento)r.getAttribute("vo");
        for (TipoCalculoEvento vo : evt.getTipoCalculoEvento()) {
            if (vo.getPreEventosEsocial().isEmpty()) continue;
            List eventos = vo.getPreEventosEsocial();
            vo.setPreEventosEsocial(new ArrayList());
            for (EsocPreEvento e : eventos) {
                e.setTipoCalculo(null);
                CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
            }
        }
        CoreDAOFactory.getInstance().getDAOEvento().delete(evt);
    }

    public void excluirPreEvento(CoreRequestContext r) throws ExceptionDatabase {
        EsocPreEvento e = (EsocPreEvento)r.getAttribute("esocPreEvento");
        this.atualizarEventoPosterior(e);
        e.setMovimentoFolhaRecisao(null);
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().delete(e);
    }

    public Object desvincularEventosEsocial(CoreRequestContext r) throws ExceptionDatabase {
        EsocLoteEventos vo = (EsocLoteEventos)r.getAttribute("vo");
        ArrayList<EsocEvento> eventos = new ArrayList<EsocEvento>();
        for (EsocEvento evento : vo.getEventos()) {
            if (evento.getStatus() == 0L) {
                evento.setEsocLoteEventos(null);
                evento.setNrSeqEvtLote(null);
                CoreDAOFactory.getInstance().getDAOEsocEvento().saveOrUpdate(evento);
                System.out.println(evento);
                continue;
            }
            eventos.add(evento);
        }
        vo.setEventos(eventos);
        vo = (EsocLoteEventos)CoreDAOFactory.getInstance().getDAOEsocLoteEventos().saveOrUpdate(vo);
        return vo;
    }

    private void atualizarEventoPosterior(EsocPreEvento e) {
        String hql = " update EsocPreEvento e set e.eventoPosterior = null where e.eventoPosterior = :e ";
        CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("e", (Object)e).executeUpdate();
    }

    public ESocS1020 retificarEvento1210Recisao(CoreRequestContext r) {
        Recisao rec = (Recisao)r.getAttribute("recisao");
        return this.getEvento1210Recisao(rec);
    }

    private ESocS1020 getEvento1210Recisao(Recisao rec) {
        String hql = " select distinct s.esocS1020  from EsocItemS1020 s  where  s.rescisao = :rec ";
        return (ESocS1020)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("rec", (Object)rec).uniqueResult();
    }
}

