/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConvocacaoContratoIntermitente;
import com.touchcomp.basementor.model.vo.ESocS1020;
import com.touchcomp.basementor.model.vo.EmissaoAvisoTrabalhado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocAquisicaoProducaoRural;
import com.touchcomp.basementor.model.vo.EsocComunicadoAcidTrab;
import com.touchcomp.basementor.model.vo.EsocCondicoesAmbientaisTrabalho;
import com.touchcomp.basementor.model.vo.EsocFechamentoFolha;
import com.touchcomp.basementor.model.vo.EsocMonitoramentoSaude;
import com.touchcomp.basementor.model.vo.EsocS1010;
import com.touchcomp.basementor.model.vo.EsocSolicitacaoPagamentoContigencia;
import com.touchcomp.basementor.model.vo.ExclusaoEventosEsocial;
import com.touchcomp.basementor.model.vo.FeriasColaborador;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.LancamentoAtestado;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.SaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.TerminoTrabalhadorSemVinculo;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.aquisicaoprodutorural.UtilityGeracao1250;
import mentorcore.service.impl.esocial.colaborador.admissao.UtilityGeracao2200;
import mentorcore.service.impl.esocial.colaborador.afastamentos.UtilityGeracao2230;
import mentorcore.service.impl.esocial.colaborador.afastamentos.UtilityGeracao2230Atestado;
import mentorcore.service.impl.esocial.colaborador.afastamentos.UtilityGeracao2230Ferias;
import mentorcore.service.impl.esocial.colaborador.alteracaocadastral.UtilityGeracao2205;
import mentorcore.service.impl.esocial.colaborador.alteracaocontratual.UtilityGeracao2206;
import mentorcore.service.impl.esocial.colaborador.alteracaotsv.UtilityGeracao2306;
import mentorcore.service.impl.esocial.colaborador.avisoprevio.UtilityGeracao2250;
import mentorcore.service.impl.esocial.colaborador.desligamento.UtilityGeracaoS2299;
import mentorcore.service.impl.esocial.colaborador.iniciotsv.UtilityGeracao2300;
import mentorcore.service.impl.esocial.colaborador.terminotsv.UtilityGeracao2399;
import mentorcore.service.impl.esocial.colaborador.transferenciacolaborador.Utility2200Transferencia;
import mentorcore.service.impl.esocial.colaborador.transferenciacolaborador.Utility2299Transferencia;
import mentorcore.service.impl.esocial.contratointermitente.UtilityGeracaoEvento2260;
import mentorcore.service.impl.esocial.exclusaoeventos.UtilityGeracao3000;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityGeracao1200;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityGeracao1210;
import mentorcore.service.impl.esocial.fechamentofolha.UtilityGeracao1280;
import mentorcore.service.impl.esocial.solicitacaopagcontigencia.UtilityPagamentoContigencia1295;
import mentorcore.service.impl.esocial.sst.ambiente.UtilityGeracao2240;
import mentorcore.service.impl.esocial.sst.cat.UtilityGeracao2210;
import mentorcore.service.impl.esocial.sst.monitoramentosaude.UtilityGeracao2220;

public class ServiceSaneamentoColaboradorEsocial
extends CoreService {
    public static final String SALVAR_SANEAMENTO_DADOS_COLABORADOR = "salvarSaneamentoDadosColaborador";
    public static final String GERAR_EVENTO_RETIFICACAO = "gerarEventoRetificacao";
    public static final String GERAR_EVENTO_ALTERACAO_CADASTRAL_2205 = "gerarEventoAlteracaoCadastral2205";
    public static final String GERAR_EVENTO_ALTERACAO_CONTRATO_2206 = "gerarEventoAlteracaoContrato2206";
    public static final String GERAR_EVENTO_ALTERACAO_CONTRATO_2306 = "gerarEventoAlteracaoContrato2306";
    public static final String GERAR_EVENTO_ATESTADO = "gerarEventoAtestado";
    public static final String GERAR_EVENTO_AFASTAMENTO = "gerarEventoAfastamento";
    public static final String GERAR_EVENTO_AVISO_PREVIO = "gerarAvisoPrevio";
    public static final String GERAR_EVENTO_AFASTAMENTO_FERIAS = "gerarEventoAfastamentoFerias";
    public static final String GERAR_EVENTO_EXCLUSAO = "gerarEventoExclusao";
    public static final String GERAR_EVENTO_CAT = "gerarEventoCat";
    public static final String GERAR_EVENTO_MONITORAMENTO = "gerarEventoMonitoramento";
    public static final String GERAR_EVENTO_CONDICOES = "gerarEventoCondicoes";
    public static final String GERAR_EVENTO_TRANSFERENCIA = "gerarEventoTransferencia";
    public static final String GERAR_EVENTO_PAG_CONTIGENCIA = "esocEventoPagContigencia";

    public Object salvarSaneamentoDadosColaborador(CoreRequestContext request) throws ExceptionDatabase, ExceptionEsocial, ExceptionReflection, ExceptionService {
        SaneamentoDadosColaborador vo = (SaneamentoDadosColaborador)request.getAttribute("vo");
        Usuario usuario = (Usuario)request.getAttribute("usuario");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        EmpresaRh empresarh = (EmpresaRh)request.getAttribute("empresaRh");
        for (ItemSaneamentoDadosColaborador item : vo.getItemSaneamento()) {
            if (!vo.getTipoEvento().getIdentificador().equals(ConstantsESocial.REGISTRO_2299) && !vo.getTipoEvento().getIdentificador().equals(ConstantsESocial.REGISTRO_2399)) {
                Colaborador colaborador = item.getColaborador();
                if (this.get2200(colaborador) && item.getLiberado().equals((short)1)) {
                    new UtilityGeracao2200().geracaoEventoS2200(colaborador, usuario, empresa);
                    continue;
                }
                if (!this.get2300(colaborador) || !item.getLiberado().equals((short)1)) continue;
                new UtilityGeracao2300().geracaoEventoS2300(colaborador, usuario, empresa);
                continue;
            }
            if (vo.getTipoEvento().getIdentificador().equals(ConstantsESocial.REGISTRO_2299)) {
                Recisao recisao = item.getRecisao();
                new UtilityGeracaoS2299().geracaoEventoS2299(recisao, usuario, empresa, empresarh);
                continue;
            }
            if (!vo.getTipoEvento().getIdentificador().equals(ConstantsESocial.REGISTRO_2399)) continue;
            TerminoTrabalhadorSemVinculo t = item.getTermino();
            new UtilityGeracao2399().geracaoEventoS2299(t, usuario, empresa);
        }
        vo = (SaneamentoDadosColaborador)CoreDAOFactory.getInstance().getDAOSaneamentoDadosEsocial().saveOrUpdate(vo);
        return vo;
    }

    public void gerarEventoRetificacao(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        InterfaceVOEsocial i = (InterfaceVOEsocial)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Short tipoEvento = (Short)r.getAttribute("tipoEvento");
        Long tipoRet = (Long)r.getAttribute("tipoRet");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("empresaRh");
        if (i instanceof Colaborador) {
            Colaborador vo = (Colaborador)i;
            if (tipoRet.equals(ConstantsESocial.REGISTRO_2200) || tipoRet.equals(ConstantsESocial.REGISTRO_2300)) {
                if (vo.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.EMPREGADO.getValue()) || vo.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())) {
                    new UtilityGeracao2200().geracaoEventoRetificacaoS2200(vo, usuario, empresa, tipoEvento);
                } else if (vo.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO.getValue()) || vo.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()) || vo.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()) || vo.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.ESTAGIARIO.getValue())) {
                    new UtilityGeracao2300().geracaoEventoRetificacaoS2300(vo, usuario, empresa, tipoEvento);
                }
            } else if (tipoRet.equals(ConstantsESocial.REGISTRO_2205)) {
                new UtilityGeracao2205().geracaoEventoRetificacaoS2200(vo, usuario, empresa, tipoEvento);
            } else if (tipoRet.equals(ConstantsESocial.REGISTRO_2206)) {
                new UtilityGeracao2206().geracaoEventoRetificacaoS2206(vo, usuario, empresa, tipoEvento);
            } else if (tipoRet.equals(ConstantsESocial.REGISTRO_2306)) {
                new UtilityGeracao2306().geracaoEventoRetificacaoS2306(vo, usuario, empresa, tipoEvento, null);
            }
        } else if (i instanceof EmissaoAvisoTrabalhado) {
            EmissaoAvisoTrabalhado vo = (EmissaoAvisoTrabalhado)i;
            new UtilityGeracao2250().geracaoEventoRetificacaoS2250(vo, usuario, empresa, tipoEvento);
        } else if (i instanceof FeriasColaborador) {
            if (tipoRet.equals(ConstantsESocial.REGISTRO_2230)) {
                FeriasColaborador vo = (FeriasColaborador)i;
                new UtilityGeracao2230Ferias().geracaoEventoRetificacaoS2230(vo, usuario, empresa, tipoEvento);
            }
        } else if (i instanceof AfastamentoColaborador) {
            AfastamentoColaborador vo = (AfastamentoColaborador)i;
            if (tipoRet.equals(ConstantsESocial.RETIFICAR_AFASTAMENTO_SAIDA)) {
                new UtilityGeracao2230().geracaoEventoRetificacaoS2230Saida(vo, usuario, empresa, tipoEvento);
            } else {
                new UtilityGeracao2230().geracaoEventoRetificacaoS2230Retorno(vo, usuario, empresa, tipoEvento);
            }
        } else if (i instanceof LancamentoAtestado) {
            LancamentoAtestado vo = (LancamentoAtestado)i;
            new UtilityGeracao2230Atestado().geracaoEventoRetificacaoS2230(vo, usuario, empresa, tipoEvento);
        } else if (i instanceof TransferenciaColaborador) {
            TransferenciaColaborador vo = (TransferenciaColaborador)i;
            new Utility2299Transferencia().geracaoEventoRetificacaoS2299(vo, usuario, empresa, tipoEvento);
        } else if (i instanceof Recisao) {
            Recisao vo = (Recisao)i;
            new UtilityGeracaoS2299().geracaoEventoRetificacaoS2299(vo, usuario, empresa, tipoEvento, empresaRh);
        } else if (i instanceof EsocAquisicaoProducaoRural) {
            EsocAquisicaoProducaoRural vo = (EsocAquisicaoProducaoRural)i;
            new UtilityGeracao1250().geracaoEventoRetificacaoS1250(vo, usuario, empresa, tipoEvento);
        } else if (i instanceof EsocS1010) {
            EsocS1010 vo = (EsocS1010)i;
            new UtilityGeracao1200().geracaoEventoRetificacaoS1200(vo, usuario, empresa, tipoEvento, empresaRh);
        } else if (i instanceof ESocS1020) {
            ESocS1020 vo = (ESocS1020)i;
            new UtilityGeracao1210().geracaoEventoRetificacaoS1210(vo, usuario, empresa, tipoEvento, empresaRh);
        } else if (i instanceof EsocFechamentoFolha && tipoRet.equals(ConstantsESocial.REGISTRO_1200)) {
            EsocFechamentoFolha esoc = (EsocFechamentoFolha)i;
            for (EsocS1010 e : esoc.getEsocS1010()) {
                new UtilityGeracao1200().geracaoEventoRetificacaoS1200(e, usuario, empresa, tipoEvento, empresaRh);
            }
        } else if (i instanceof EsocFechamentoFolha && tipoRet.equals(ConstantsESocial.REGISTRO_1210)) {
            EsocFechamentoFolha esoc = (EsocFechamentoFolha)i;
            for (ESocS1020 e : esoc.getEsocS1020()) {
                new UtilityGeracao1210().geracaoEventoRetificacaoS1210(e, usuario, empresa, tipoEvento, empresaRh);
            }
        } else if (i instanceof ConvocacaoContratoIntermitente) {
            ConvocacaoContratoIntermitente vo = (ConvocacaoContratoIntermitente)i;
            new UtilityGeracaoEvento2260().geracaoEventoRetificacaoS2260(vo, usuario, empresa, tipoEvento);
        } else if (i instanceof EsocFechamentoFolha && tipoRet.equals(ConstantsESocial.REGISTRO_1280)) {
            EsocFechamentoFolha esoc = (EsocFechamentoFolha)i;
            new UtilityGeracao1280().geracaoEventoRetificacaoS1280(esoc, usuario, empresa, tipoEvento, empresaRh);
        } else if (tipoRet.equals(ConstantsESocial.REGISTRO_2220)) {
            EsocMonitoramentoSaude vo = (EsocMonitoramentoSaude)i;
            new UtilityGeracao2220().geracaoEventoRetificacaoS2220(vo, usuario, empresa, tipoEvento);
        } else {
            throw new ExceptionEsocial("Evento ainda n\u00e3o implementado para retifica\u00e7\u00e3o. Entre em contato com o Suporte");
        }
    }

    public void gerarEventoAlteracaoCadastral2205(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        Colaborador vo = (Colaborador)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Date dataAlteracao = (Date)r.getAttribute("dataAlteracao");
        new UtilityGeracao2205().geracaoEventoS2205(vo, usuario, empresa, dataAlteracao);
    }

    public void gerarEventoAlteracaoContrato2206(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        Colaborador vo = (Colaborador)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        String obs = (String)r.getAttribute("obs");
        Date dataAlteracao = (Date)r.getAttribute("dataAlteracao");
        new UtilityGeracao2206().geracaoEventoS2206(vo, usuario, empresa, dataAlteracao, obs);
    }

    public void gerarEventoAlteracaoContrato2306(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        Colaborador vo = (Colaborador)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Date dataAlteracao = (Date)r.getAttribute("dataAlteracao");
        new UtilityGeracao2306().geracaoEventoS2306(vo, usuario, empresa, dataAlteracao);
    }

    private boolean get2200(Colaborador colaborador) {
        return colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.EMPREGADO.getValue()) || colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.MENOR_APRENDIZ.getValue());
    }

    private boolean get2300(Colaborador colaborador) {
        return colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()) || colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.ESTAGIARIO.getValue()) || colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO.getValue()) || colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.AUTONOMO_FRETE.getValue());
    }

    public void gerarEventoAtestado(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionDatabase, ExceptionReflection {
        LancamentoAtestado vo = (LancamentoAtestado)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Short tipo = (Short)r.getAttribute("tipo");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2230Atestado().geracaoEventoS2230(vo, usuario, empresa);
    }

    public void gerarEventoAfastamento(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionDatabase, ExceptionReflection {
        AfastamentoColaborador vo = (AfastamentoColaborador)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Short tipo = (Short)r.getAttribute("tipo");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2230().geracaoEventoS2230(vo, usuario, empresa, tipo);
    }

    public void gerarAvisoPrevio(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionReflection, ExceptionDatabase {
        EmissaoAvisoTrabalhado vo = (EmissaoAvisoTrabalhado)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2250().geracaoEventoS2250(vo, usuario, empresa);
    }

    public void gerarEventoAfastamentoFerias(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionReflection, ExceptionDatabase {
        FeriasColaborador vo = (FeriasColaborador)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2230Ferias().geracaoEventoS2230(vo, usuario, empresa);
    }

    public void gerarEventoExclusao(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionReflection, ExceptionDatabase {
        ExclusaoEventosEsocial vo = (ExclusaoEventosEsocial)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao3000().geracaoEventoS3000(vo, usuario, empresa);
    }

    public void gerarEventoCat(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionReflection, ExceptionDatabase {
        EsocComunicadoAcidTrab vo = (EsocComunicadoAcidTrab)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2210().geracaoEventoS2210(vo, usuario, empresa);
    }

    public void gerarEventoMonitoramento(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionReflection, ExceptionDatabase {
        EsocMonitoramentoSaude vo = (EsocMonitoramentoSaude)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2220().geracaoEventoS2220(vo, usuario, empresa);
    }

    public void gerarEventoCondicoes(CoreRequestContext r) throws ExceptionEsocial, ExceptionService, ExceptionReflection, ExceptionDatabase {
        EsocCondicoesAmbientaisTrabalho vo = (EsocCondicoesAmbientaisTrabalho)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityGeracao2240().geracaoEventoS2240(vo, usuario, empresa);
    }

    public void gerarEventoTransferencia(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        TransferenciaColaborador vo = (TransferenciaColaborador)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        new Utility2299Transferencia().geracaoEventoS2299(vo, usuario, vo.getEmpresa());
        new Utility2200Transferencia().geracaoEventoS2200(vo, usuario, vo.getEmpresaNova());
    }

    public void esocEventoPagContigencia(CoreRequestContext r) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        EsocSolicitacaoPagamentoContigencia vo = (EsocSolicitacaoPagamentoContigencia)r.getAttribute("vo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        new UtilityPagamentoContigencia1295().geracaoEventoS1295(vo, usuario, empresa);
    }
}

