/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import java.util.Date;
import java.util.List;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.UtilitySaneamentoDados;

public class ServiceSaneamentoEsocial
extends CoreService {
    public static final String RASTREAR_DADOS_RUBRICAS = "rastrearDadosRubrica";
    public static final String RASTREAR_FUNCAO = "rastrearFuncao";
    public static final String RASTREAR_HORARIO_TRABALHO = "rastrearHorarioTrabalho";
    public static final String RASTREAR_COLABORADOR = "rastrearColaborador";
    public static final String RASTREAR_TRABALHADOR_SEM_VINCULO = "rastrearTrabalhadorSV";
    public static final String BUSCAR_EVENTOS_NAO_ENVIADOS = "buscarEventosNaoEnviados";
    public static final String BUSCAR_COLABORADORES_NAO_ENVIADOS = "buscarColaboradoresNaoEnviados";
    public static final String BUSCAR_RECISOES_NAO_ENVIADAS = "buscarRecisoesNaoEnviadas";
    public static final String FIND_EVENTOS_POR_PERIODO = "eventosEnviadosPorPeriodo";

    public List rastrearDadosRubrica(CoreRequestContext request) {
        Short filtrarPeriodo = (Short)request.getAttribute("filtrarPeriodo");
        Date periodoInicial = (Date)request.getAttribute("periodoInicial");
        Date periodoFinal = (Date)request.getAttribute("periodoFinal");
        String tipoBusca = (String)request.getAttribute("tipoBusca");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short tipo = (Short)request.getAttribute("tipo");
        return new UtilitySaneamentoDados().saneamentoDadosRubricas(filtrarPeriodo, periodoInicial, periodoFinal, tipoBusca, empresa, tipo);
    }

    public List rastrearFuncao(CoreRequestContext request) {
        Short filtrarFuncao = (Short)request.getAttribute("chcfiltrarFuncoes");
        String tipoBusca = (String)request.getAttribute("tipoBusca");
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short tipo = (Short)request.getAttribute("tipo");
        return new UtilitySaneamentoDados().rastrearFuncoes(filtrarFuncao, tipoBusca, empresa, tipo);
    }

    public List rastrearHorarioTrabalho(CoreRequestContext request) {
        String tipoBusca = (String)request.getAttribute("tipoBusca");
        Short filtrarHorario = (Short)request.getAttribute("filtrarHorario");
        return new UtilitySaneamentoDados().rastrearHorario(tipoBusca, filtrarHorario);
    }

    public List rastrearColaborador(CoreRequestContext request) {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        Short tipo = (Short)request.getAttribute("tipo");
        String tipoBusca = (String)request.getAttribute("tipoBusca");
        return new UtilitySaneamentoDados().rastrearColaborador(empresa, tipoBusca, tipo);
    }

    public List rastrearTrabalhadorSV(CoreRequestContext request) {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        String tipoBusca = (String)request.getAttribute("tipoBusca");
        return new UtilitySaneamentoDados().rastrearTrabalhadorTSV(empresa, tipoBusca);
    }

    public List buscarEventosNaoEnviados(CoreRequestContext request) {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        return new UtilitySaneamentoDados().eventosNaoEnviados(empresa);
    }

    public List buscarColaboradoresNaoEnviados(CoreRequestContext request) throws ExceptionService {
        Empresa empresa = (Empresa)request.getAttribute("empresa");
        OpcoesESocial opcoes = (OpcoesESocial)request.getAttribute("opcoes");
        return new UtilitySaneamentoDados().buscarColaboradoresSemEventos(empresa, opcoes);
    }

    public List buscarRecisoesNaoEnviadas(CoreRequestContext r) throws ExceptionService {
        OpcoesESocial opcoes = (OpcoesESocial)r.getAttribute("opcoes");
        return new UtilitySaneamentoDados().buscarRecisaoSemEventos(opcoes);
    }

    public List eventosEnviadosPorPeriodo(CoreRequestContext r) {
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        Date dataInicio = (Date)r.getAttribute("dataInicio");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        return new UtilitySaneamentoDados().findEventosEnviados(dataInicio, dataFinal, empresa);
    }
}

