/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstESocialStatus;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionService;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilitySaneamentoDados {
    private String TODOS = "1";
    private String NAO_REVISADOS = "2";
    private String REVISADOS = "3";
    private String ENVIADOS = "4";

    public List saneamentoDadosRubricas(Short filtrarPeriodo, Date periodoInicial, Date periodoFinal, String tipoBusca, Empresa empresa, Short tipo) {
        if (tipoBusca.equals(this.TODOS)) {
            String hql = " select distinct tp  from TipoCalculoEvento tp  where  :filtrarPeriodo = 0  or  exists (select item.identificador         from ItemMovimentoFolha item          where          item.eventoColaborador.tipoCalculoEvento = tp          and         item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal ) order by tp.evento.codigo";
            List list = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarPeriodo", filtrarPeriodo.shortValue()).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).list();
            return list;
        }
        if (tipoBusca.equals(this.NAO_REVISADOS)) {
            String hql = " select distinct tp  from TipoCalculoEvento tp  left join tp.preEventosEsocial pre  where  pre = null  and  :filtrarPeriodo = 0  or  exists (select item.identificador         from ItemMovimentoFolha item          where          item.eventoColaborador.tipoCalculoEvento = tp          and         item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal ) order by tp.evento.codigo";
            List list = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarPeriodo", filtrarPeriodo.shortValue()).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).list();
            return list;
        }
        if (tipoBusca.equals(this.REVISADOS)) {
            String hql = " select distinct tp  from TipoCalculoEvento tp  inner join tp.preEventosEsocial pre  left join pre.esocEvento e  where  pre.eventoPosterior is null  and  pre.eventoProdRestritaProducao = :tipo  and  pre.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  (e = null or e.nrRecibo = null ) and  (:filtrarPeriodo = 0  or  exists (select item.identificador         from ItemMovimentoFolha item          where          item.eventoColaborador.tipoCalculoEvento = tp          and         item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal )) order by tp.evento.codigo";
            List list = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarPeriodo", filtrarPeriodo.shortValue()).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("tipo", tipo.shortValue()).setEntity("grupoEmpresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).list();
            return list;
        }
        if (tipoBusca.equals(this.ENVIADOS)) {
            String hql = " select distinct tp  from TipoCalculoEvento tp  inner join tp.preEventosEsocial pre  where  pre.eventoPosterior is null  and  pre.eventoProdRestritaProducao = :tipo  and  (pre.esocEvento != null and pre.esocEvento.nrRecibo != null ) and  :filtrarPeriodo = 0  or  exists (select item.identificador         from ItemMovimentoFolha item          where          item.eventoColaborador.tipoCalculoEvento = tp          and         item.movimentoFolha.aberturaPeriodo.dataInicio between :periodoInicial and :periodoFinal ) order by tp.evento.codigo";
            List list = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarPeriodo", filtrarPeriodo.shortValue()).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).setShort("tipo", tipo.shortValue()).list();
            return list;
        }
        return null;
    }

    public List rastrearFuncoes(Short filtrarFuncao, String tipoBusca, Empresa empresa, Short tipo) {
        if (tipoBusca.equals(this.TODOS)) {
            String hql = " select distinct funcao  from Funcao funcao  where  :filtrarFuncao = 0   or  exists (select c          from Colaborador c          where          c.funcao = funcao )";
            return CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarFuncao", filtrarFuncao.shortValue()).list();
        }
        if (tipoBusca.equals(this.REVISADOS)) {
            String hql = " select distinct funcao  from Funcao funcao  inner join funcao.preEventosEsocial pre  left join pre.esocEvento e  where  pre.eventoPosterior is null  and  pre.eventoProdRestritaProducao = :tipo  and  pre.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  (e = null or e.nrRecibo = null )";
            return CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("tipo", tipo.shortValue()).setEntity("grupoEmpresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).list();
        }
        if (tipoBusca.equals(this.NAO_REVISADOS)) {
            String hql = " select distinct funcao  from Funcao funcao  left join funcao.preEventosEsocial pre  where  pre = null  and  (:filtrarFuncao = 0   or  exists (select c          from Colaborador c          where          c.funcao = funcao ))";
            return CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarFuncao", filtrarFuncao.shortValue()).list();
        }
        if (tipoBusca.equals(this.ENVIADOS)) {
            String hql = " select distinct funcao  from Funcao funcao  inner join funcao.preEventosEsocial pre  where  pre.eventoPosterior is null  and  pre.eventoProdRestritaProducao = :tipo  and  pre.empresa.empresaDados.grupoEmpresa = :grupoEmpresa  and  (pre.esocEvento != null and pre.esocEvento.nrRecibo != null ) and  (:filtrarFuncao = 0   or  exists (select c          from Colaborador c          where          c.funcao = funcao ))";
            return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("grupoEmpresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).setShort("tipo", tipo.shortValue()).setShort("filtrarFuncao", filtrarFuncao.shortValue()).list();
        }
        return null;
    }

    public List rastrearHorario(String tipoBusca, Short filtrarHorario) {
        String hql = " select horario  from HorarioTrabalho horario  where  (:filtrarHorario = 0  or  exists (select c from Colaborador c where c.horarioTrabalho = horario))";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("filtrarHorario", filtrarHorario.shortValue()).list();
    }

    public List rastrearColaborador(Empresa empresa, String tipoBusca, Short tipo) {
        String hql = " from Colaborador c  where  c.empresa.empresaDados.grupoEmpresa = :empresa  and  (c.tipoColaborador.identificador = :empregado or c.tipoColaborador.identificador = :menorApredinz)  and  c.ativo = 1 and c.dataDemissao is null ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("empresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).setParameter("empregado", (Object)EnumConstTipoColaborador.EMPREGADO.getValue()).setParameter("menorApredinz", (Object)EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        if (tipoBusca.equals(this.TODOS)) {
            return retorno;
        }
        ArrayList<Colaborador> aux = new ArrayList<Colaborador>();
        for (Object object : retorno) {
            Colaborador colaborador = (Colaborador)object;
            if (tipoBusca.equals(this.ENVIADOS) && this.getColaboradorEnviado2200(colaborador, tipo)) {
                aux.add(colaborador);
                continue;
            }
            if (tipoBusca.equals(this.NAO_REVISADOS) && colaborador.getPreEventosEsocial().isEmpty()) {
                aux.add(colaborador);
                continue;
            }
            if (!tipoBusca.equals(this.REVISADOS) || !this.getColaboradorNaoEnviado2200(colaborador)) continue;
            aux.add(colaborador);
        }
        return aux;
    }

    private boolean getColaboradorEnviado2200(Colaborador colaborador, Short tipo) {
        System.out.println(colaborador.toString());
        if (colaborador.getPreEventosEsocial().isEmpty()) {
            return false;
        }
        for (EsocPreEvento preEvento : colaborador.getPreEventosEsocial()) {
            if (!preEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2200) || preEvento.getEsocEvento() == null || !preEvento.getEventoProdRestritaProducao().equals(tipo) || !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean getColaboradorNaoEnviado2200(Colaborador colaborador) {
        if (colaborador.getPreEventosEsocial().isEmpty()) {
            return false;
        }
        for (EsocPreEvento preEvento : colaborador.getPreEventosEsocial()) {
            if (!preEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2200) || preEvento.getEsocEvento() == null || !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean getColaboradorEnviado2300(Colaborador colaborador) {
        if (colaborador.getPreEventosEsocial().isEmpty()) {
            return false;
        }
        for (EsocPreEvento preEvento : colaborador.getPreEventosEsocial()) {
            if (!preEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2300) || preEvento.getEsocEvento() == null || !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO.getValue()) && !preEvento.getEsocEvento().getStatus().equals(EnumConstESocialStatus.STATUS_SUCESSO_ADVERTENCIA.getValue())) continue;
            return true;
        }
        return false;
    }

    public List rastrearTrabalhadorTSV(Empresa empresa, String tipoBusca) {
        String hql = " from Colaborador c  where  c.empresa.empresaDados.grupoEmpresa = :empresa  and  (c.tipoColaborador.identificador = :socio or c.tipoColaborador.identificador = :estagiario or c.tipoColaborador.identificador = :autonomo or c.tipoColaborador.identificador = :autonomoFrete)  and  c.ativo = 1 and c.dataDemissao is null ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("empresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).setParameter("estagiario", (Object)EnumConstTipoColaborador.ESTAGIARIO.getValue()).setParameter("autonomo", (Object)EnumConstTipoColaborador.AUTONOMO.getValue()).setParameter("autonomoFrete", (Object)EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()).setParameter("socio", (Object)EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        if (tipoBusca.equals(this.TODOS)) {
            return retorno;
        }
        ArrayList<Colaborador> aux = new ArrayList<Colaborador>();
        for (Object object : retorno) {
            Colaborador colaborador = (Colaborador)object;
            if (tipoBusca.equals(this.ENVIADOS) && this.getColaboradorEnviado2300(colaborador)) {
                aux.add(colaborador);
                continue;
            }
            if (tipoBusca.equals(this.NAO_REVISADOS) && colaborador.getPreEventosEsocial().isEmpty()) {
                aux.add(colaborador);
                continue;
            }
            if (!tipoBusca.equals(this.REVISADOS) || this.getColaboradorEnviado2300(colaborador)) continue;
            aux.add(colaborador);
        }
        return aux;
    }

    public List eventosNaoEnviados(Empresa empresa) {
        String hql = "  select e from EsocPreEvento e  left join e.esocEvento ee  where  (ee = null  or  (ee.status != 201 and ee.status != 202) ) and  e.empresa.empresaDados.grupoEmpresa = :empresa";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresa.getEmpresaDados().getGrupoEmpresa()).list();
    }

    public List buscarRecisaoSemEventos(OpcoesESocial opcoesEsocial) throws ExceptionService {
        if (opcoesEsocial.getDataInicio() == null) {
            throw new ExceptionService("Informe a Data de Inicio em opcoes eSocial");
        }
        String hql = " from Recisao r  where  r.recisaoComplementar = 0  and  r.dataAfastamento >= :inicioObrigatoriedade  and  r.empresa.empresaDados.grupoEmpresa.identificador = :grupoEmpresa   and   not exists(select item.identificador              from ItemSaneamentoDadosColaborador item              where item.recisao.identificador = r.identificador              and item.liberado = :sim ) ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("inicioObrigatoriedade", (Object)opcoesEsocial.getDataInicio()).setParameter("sim", (Object)1).setParameter("grupoEmpresa", (Object)opcoesEsocial.getEmpresaRh().getEmpresa().getEmpresaDados().getGrupoEmpresa().getIdentificador()).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        return retorno;
    }

    public List buscarColaboradoresSemEventos(Empresa empresa, OpcoesESocial opcoes) throws ExceptionService {
        if (opcoes.getDataInicio() == null) {
            throw new ExceptionService("Informe a Data de Inicio em opcoes eSocial");
        }
        String hql = "from Colaborador c  where c.dataDemissao is null  and (c.tipoColaborador.identificador = :empregado or c.tipoColaborador.identificador = :menor) and c.ativo = :sim  and c.dataAdmissao > :inicioObrigatoriedade and not exists(select item.identificador                  from ItemSaneamentoDadosColaborador item                  where item.colaborador.identificador = c.identificador                  and item.liberado = :sim )  and c.empresa.empresaDados.grupoEmpresa.identificador = :grupoEmpresa";
        Query q = CoreBdUtil.getInstance().getSession().createQuery(hql);
        q.setShort("sim", (short)1);
        q.setLong("empregado", EnumConstTipoColaborador.EMPREGADO.getValue());
        q.setLong("menor", EnumConstTipoColaborador.MENOR_APRENDIZ.getValue());
        q.setLong("grupoEmpresa", empresa.getEmpresaDados().getGrupoEmpresa().getIdentificador().longValue());
        q.setDate("inicioObrigatoriedade", opcoes.getDataInicio());
        return q.list();
    }

    private Date getInicioObrigatoriedadeProducao() {
        GregorianCalendar g = new GregorianCalendar();
        g.set(5, 9);
        g.set(2, 9);
        g.set(1, 2018);
        return g.getTime();
    }

    public List findEventosEnviados(Date dataInicio, Date dataFinal, Empresa empresa) {
        String hql = "";
        hql = "select p.tipoEventoEsocial.codigo as CODIGO ,p.tipoEventoEsocial.descricao as DESCRICAO, \tcount(e.identificador) as QUANTIDADE from EsocEvento e inner join e.preEvento p left join p.esocS1200 inss left join inss.esocFechamentoFolha periodo  left join p.esocS1210 irrf  left join irrf.esocFechamento periodoF left join p.reaberturaEventos reabertura left join p.fechamentoEventos fec left join p.admissaoPreLiminar preLiminar left join p.colaborador colaborador left join p.emissaoAviso emissaoAviso left join p.convocacao convocacao left join p.recisao recisao left join p.exclusaoEventos exclusao where e.preEvento.empresa = :empresa and e.status = 201 and p.eventoProdRestritaProducao = 1 and p.eventoPosterior is null and ((p.empresaRH is not null and p.dataInicioVal between :dataInicio and :dataFinal) or (p.estabelecimento is not null and p.dataInicioVal between :dataInicio and :dataFinal)  or (p.tipoCalculo is not null and  p.dataInicioVal between :dataInicio and :dataFinal ) or (p.lotacaoTrbutaria is not null and p.dataInicioVal between :dataInicio and :dataFinal) or (p.funcao is not null and p.dataInicioVal between :dataInicio and :dataFinal) or (p.infoHorario is not null and p.dataInicioVal between :dataInicio and :dataFinal) or (inss is not null and periodo.periodoApuracao between :dataInicio and :dataFinal) or (irrf is not null and periodoF.periodoApuracao between :dataInicio and :dataFinal) or (reabertura is not null and reabertura.periodo between :dataInicio and :dataFinal ) or (fec is not null and fec.periodoReferencia between :dataInicio and :dataFinal ) or (preLiminar is not null and preLiminar.dataAdmissao between :dataInicio and :dataFinal  ) or (colaborador is not null and p.tipoEventoEsocial.identificador = 14 and colaborador.dataAdmissao between  :dataInicio and :dataFinal) or (colaborador is not null and p.tipoEventoEsocial.identificador = 16 and p.dataInicioVal between  :dataInicio and :dataFinal) or (colaborador is not null and p.tipoEventoEsocial.identificador = 19 and p.dataInicioVal between  :dataInicio and :dataFinal) or (p.tipoEventoEsocial.identificador = 17 and p.dataInicioVal between  :dataInicio and :dataFinal )or (emissaoAviso is not null and emissaoAviso.dataEmissaoAviso between :dataInicio and :dataFinal) or (convocacao is not null and convocacao.dataInicio between :dataInicio and :dataFinal) or (recisao is not null and recisao.dataAfastamento between  :dataInicio and :dataFinal) or (colaborador is not null and p.tipoEventoEsocial.identificador = 15 and colaborador.dataAdmissao between  :dataInicio and :dataFinal) or (exclusao is not null and p.dataInicioVal between  :dataInicio and :dataFinal ) ) group by p.tipoEventoEsocial.identificador, p.tipoEventoEsocial.codigo,p.tipoEventoEsocial.descricao order by p.tipoEventoEsocial.codigo";
        return CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("empresa", (Object)empresa).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }
}

