/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.aquisicaoprodutorural;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EsocClienteProducaoRural;
import com.touchcomp.basementor.model.vo.EsocFornecedorProducaoRural;
import com.touchcomp.basementor.model.vo.NotaAquisicaoProdRural;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.NotaPropriaAquisicaoProdRural;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mentorcore.database.mentor.CoreBdUtil;

public class UtilityEsocAquisicaoProducaoRural {
    public List findNotasProdRural(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        String hql = " from NotaFiscalTerceiros nt  where  (nt.valoresNfTerceiros.valorInss > 0  or  nt.valoresNfTerceiros.valorRat > 0  or  nt.valoresNfTerceiros.valorSenar > 0 or  nt.valoresNfTerceiros.valorFunrural > 0) and  nt.dataEntrada between :periodoInicial and :periodoFinal  and  nt.empresa = :empresa  and  exists (             from ItemNotaTerceiros i             inner join i.itemNotaLivroFiscal il            inner join il.cfop cf             where cf.cfopNotaProdutorRural=:sim             and             i.modeloFiscal.compoeAquisicaoRural = :sim             and i.notaFiscalTerceiros = nt )  and  not exists (from NotaAquisicaoProdRural nn where nn.notaTerceiros = nt )";
        List retornoNotas = CoreBdUtil.getInstance().getSession().createQuery(hql).setDate("periodoInicial", periodoInicial).setShort("sim", (short)1).setDate("periodoFinal", periodoFinal).setEntity("empresa", (Object)empresa).list();
        if (retornoNotas == null || retornoNotas.isEmpty()) {
            return new ArrayList();
        }
        return this.processarNotas(retornoNotas);
    }

    private List processarNotas(List retornoNotas) {
        ArrayList<EsocFornecedorProducaoRural> fornecedores = new ArrayList<EsocFornecedorProducaoRural>();
        for (Object obj : retornoNotas) {
            NotaFiscalTerceiros nota = (NotaFiscalTerceiros)obj;
            boolean achou = false;
            if (nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj().isEmpty() || nota.getUnidadeFatFornecedor().getFornecedor().getPessoa().getComplemento().getCnpj().length() != 11) continue;
            for (EsocFornecedorProducaoRural esocF : fornecedores) {
                if (!esocF.getFornecedor().equals((Object)nota.getUnidadeFatFornecedor().getFornecedor())) continue;
                esocF.getNotasAqProdRural().add(new NotaAquisicaoProdRural(nota, esocF));
                achou = true;
                break;
            }
            if (achou) continue;
            EsocFornecedorProducaoRural newF = new EsocFornecedorProducaoRural(nota.getUnidadeFatFornecedor().getFornecedor());
            newF.getNotasAqProdRural().add(new NotaAquisicaoProdRural(nota, newF));
            fornecedores.add(newF);
        }
        return fornecedores;
    }

    public List findNotasPropriasAquisicaoRural(Date periodoInicial, Date periodoFinal, Empresa empresa) {
        String hql = " select distinct np  from NotaFiscalPropria np  where  np.dataEntradaSaida between :periodoInicial and :periodoFinal  and  np.empresa = :empresa  and np.situacaoDocumento.codigo <> 02  and np.situacaoDocumento.codigo <> 03  and np.situacaoDocumento.codigo <> 04  and  exists (             from ItemNotaFiscalPropria i             inner join i.itemNotaLivroFiscal il            inner join il.cfop cf            where cf.cfopNotaProdutorRural=:sim             and i.modeloFiscal.compoeAquisicaoRural = :sim             and i.notaFiscalPropria = np )  and  not exists (from NotaPropriaAquisicaoProdRural nn where nn.notaPropria = np )";
        List notas = CoreBdUtil.getInstance().getSession().createQuery(hql).setShort("sim", (short)1).setEntity("empresa", (Object)empresa).setDate("periodoInicial", periodoInicial).setDate("periodoFinal", periodoFinal).list();
        if (notas == null || notas.isEmpty()) {
            return new ArrayList();
        }
        return this.processarNotasProprias(notas);
    }

    private List processarNotasProprias(List notas) {
        ArrayList<EsocClienteProducaoRural> clientes = new ArrayList<EsocClienteProducaoRural>();
        for (Object obj : notas) {
            NotaFiscalPropria nota = (NotaFiscalPropria)obj;
            boolean achou = false;
            if (nota.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj().isEmpty() || nota.getUnidadeFatCliente().getCliente().getPessoa().getComplemento().getCnpj().length() != 11) continue;
            for (EsocClienteProducaoRural esocC : clientes) {
                if (!esocC.getCliente().equals((Object)nota.getUnidadeFatCliente().getCliente())) continue;
                esocC.getNotas().add(new NotaPropriaAquisicaoProdRural(nota, esocC));
                achou = true;
                break;
            }
            if (achou) continue;
            EsocClienteProducaoRural newC = new EsocClienteProducaoRural(nota.getUnidadeFatCliente().getCliente());
            newC.getNotas().add(new NotaPropriaAquisicaoProdRural(nota, newC));
            clientes.add(newC);
        }
        return clientes;
    }
}

