/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.colaborador.alteracaocadastral;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.Date;
import java.util.GregorianCalendar;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;

public class UtilityGeracao2205 {
    public void geracaoEventoS2205(Colaborador vo, Usuario usuario, Empresa empresa, Date dataAlteracao) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2205) || !esocPreEvento.getEventoProdRestritaProducao().equals(EnumConstEventoProducao.EVENTO_PRODUCAO.getValue()) || esocPreEvento.getEsocEvento() != null && esocPreEvento.getEsocEvento().getNrRecibo() != null && !esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) continue;
            throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
        }
        EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue(), (short)0, dataAlteracao);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
        preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0, dataAlteracao);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoColaborador(Colaborador vo, Usuario usuario, Empresa empresa, Short prodEvento, Short eventoRetificacao, Date dataAlteracao) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        if (dataAlteracao != null) {
            pre.setDataCadastro(dataAlteracao);
        } else {
            pre.setDataCadastro(new Date());
        }
        pre.setDataFimVal(null);
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("Colaborador");
        pre.setIdentificacaoEntidade(vo.getIdentificador().toString());
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial(this.getTipoEventoESocial(16L));
        pre.setEventoRetificacao(eventoRetificacao);
        if (pre.getEventoRetificacao().equals((short)1)) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo, prodEvento));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (vo instanceof EmpresaRh) {
            preEvento.setEmpresaRH((EmpresaRh)vo);
        } else if (vo instanceof TipoCalculoEvento) {
            preEvento.setTipoCalculo((TipoCalculoEvento)vo);
        } else if (vo instanceof EsocCadastroEstabelcimento) {
            preEvento.setEstabelecimento((EsocCadastroEstabelcimento)vo);
        } else if (vo instanceof EsocCadastroLotacaoTributaria) {
            preEvento.setLotacaoTrbutaria((EsocCadastroLotacaoTributaria)vo);
        } else if (vo instanceof Funcao) {
            preEvento.setFuncao((Funcao)vo);
        } else if (vo instanceof InfoHorarioTrabalho) {
            preEvento.setInfoHorario((InfoHorarioTrabalho)vo);
        } else if (vo instanceof Colaborador) {
            preEvento.setColaborador((Colaborador)vo);
        } else {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
    }

    private Date getInicioObrigatoriedade() {
        GregorianCalendar g = new GregorianCalendar();
        g.set(7, 1);
        g.set(2, 9);
        g.set(1, 2018);
        return g.getTime();
    }

    private String getReciboRetificacao(Colaborador vo, Short prodEvento) {
        for (EsocPreEvento e : vo.getPreEventosEsocial()) {
            if (!e.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2205) || e.getEventoPosterior() != null || !e.getEventoProdRestritaProducao().equals(prodEvento)) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return "ERRO";
    }

    public void geracaoEventoRetificacaoS2200(Colaborador vo, Usuario usuario, Empresa empresa, Short tipoEvento) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2205) || !esocPreEvento.getEventoProdRestritaProducao().equals(tipoEvento)) continue;
            if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
            }
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, tipoEvento, (short)1, null);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
        }
    }
}

