/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.colaborador.desligamento;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmissaoAvisoTrabalhado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EsocCadastroEstabelcimento;
import com.touchcomp.basementor.model.vo.EsocCadastroLotacaoTributaria;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.InfoHorarioTrabalho;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.PagamentoFolhaCompColaborador;
import com.touchcomp.basementor.model.vo.Recisao;
import com.touchcomp.basementor.model.vo.Rubricas1200;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementortools.tools.date.ToolDate;
import contatocore.util.ContatoFormatUtil;
import java.util.ArrayList;
import java.util.Date;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;

public class UtilityGeracaoS2299 {
    public void geracaoEventoS2299Desligamento(Recisao vo, Usuario usuario, Empresa empresa, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0, empresaRh);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        vo.getPreEventosEsocial().add(preEvento);
    }

    public void geracaoEventoS2299(Recisao vo, Usuario usuario, Empresa empresa, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0, empresaRh);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoColaborador(Recisao vo, Usuario usuario, Empresa empresa, Short prodEvento, Short eventoRetificacao, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(vo.getDataAfastamento());
        pre.setDataFimVal(null);
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("Desligamento");
        pre.setIdentificacaoEntidade(vo.getIdentificador() != null ? vo.getIdentificador().toString() : "1");
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        if (vo.getRecisaoComplementarAc() == null) {
            pre.setTipoEventoEsocial(this.getTipoEventoESocial(ConstantsESocial.REGISTRO_2299));
        } else {
            pre.setTipoEventoEsocial(this.getTipoEventoESocial(ConstantsESocial.REGISTRO_1200));
        }
        pre.setEventoRetificacao(eventoRetificacao);
        if (pre.getEventoRetificacao().equals((short)1)) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo, prodEvento));
        }
        pre.setFolhaComplementar(this.getFolhaComplementar(vo.getColaborador(), vo.getDataAfastamento()));
        pre.setMovimentoFolhaRecisao(this.getMovimentoFolhaAdd(vo.getColaborador(), vo.getDataAfastamento(), empresaRh));
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (vo instanceof EmpresaRh) {
            preEvento.setEmpresaRH((EmpresaRh)vo);
        } else if (vo instanceof TipoCalculoEvento) {
            preEvento.setTipoCalculo((TipoCalculoEvento)vo);
        } else if (vo instanceof EsocCadastroEstabelcimento) {
            preEvento.setEstabelecimento((EsocCadastroEstabelcimento)vo);
        } else if (vo instanceof EsocCadastroLotacaoTributaria) {
            preEvento.setLotacaoTrbutaria((EsocCadastroLotacaoTributaria)vo);
        } else if (vo instanceof Funcao) {
            preEvento.setFuncao((Funcao)vo);
        } else if (vo instanceof InfoHorarioTrabalho) {
            preEvento.setInfoHorario((InfoHorarioTrabalho)vo);
        } else if (vo instanceof Colaborador) {
            preEvento.setColaborador((Colaborador)vo);
        } else if (vo instanceof EmissaoAvisoTrabalhado) {
            preEvento.setEmissaoAviso((EmissaoAvisoTrabalhado)vo);
        } else if (vo instanceof Recisao) {
            preEvento.setRecisao((Recisao)vo);
        } else {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
    }

    private String getReciboRetificacao(Recisao vo, Short prodEvento) {
        for (EsocPreEvento e : vo.getPreEventosEsocial()) {
            if (!e.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2299) || !e.getEventoProdRestritaProducao().equals(prodEvento) || e.getEventoPosterior() != null) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return "ERRO";
    }

    public void geracaoEventoRetificacaoS2299(Recisao vo, Usuario usuario, Empresa empresa, Short tipoEvento, EmpresaRh empresaRh) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2299) && !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_1200) || !esocPreEvento.getEventoProdRestritaProducao().equals(tipoEvento)) continue;
            if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
            }
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, tipoEvento, (short)1, empresaRh);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
        }
    }

    private PagamentoFolhaCompColaborador getFolhaComplementar(Colaborador colaborador, Date dataAfastamento) {
        String hql = " from PagamentoFolhaCompColaborador f  where  f.colaborador = :colaborador  and  f.calculoComplementoSalario.dataPagamento between :dataInicio and :dataFinal and  not exists (from MovimentoFolha m where m.pagamentoFolhaComplementar = f) ";
        PagamentoFolhaCompColaborador f = (PagamentoFolhaCompColaborador)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicio", ToolDate.getDateFirstMonthDay((Date)dataAfastamento)).setDate("dataFinal", ToolDate.getDateLastMonthDay((Date)dataAfastamento)).setMaxResults(1).uniqueResult();
        return f;
    }

    private MovimentoFolha getMovimentoFolhaAdd(Colaborador colaborador, Date dataAfastamento, EmpresaRh empresaRh) {
        String hql = " from MovimentoFolha m  where  m.colaborador = :colaborador  and  m.aberturaPeriodo.dataInicio between :dataInicio and :dataFinal and  m.aberturaPeriodo.tipoCalculo.tipoFolha = :adiantamentoSalario ";
        MovimentoFolha m = (MovimentoFolha)CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicio", ToolDate.getDateFirstMonthDay((Date)dataAfastamento)).setDate("dataFinal", ToolDate.getDateLastMonthDay((Date)dataAfastamento)).setShort("adiantamentoSalario", EnumConstTipoCalculoEvento.CALCULO_ADIANTAMENTO_SALARIO.getValue().shortValue()).setMaxResults(1).uniqueResult();
        if (m != null) {
            m.getRubricas1200().clear();
            this.criarRubricas1200(m, empresaRh);
        }
        return m;
    }

    private void criarRubricas1200(MovimentoFolha mov, EmpresaRh empresaRh) {
        ArrayList<Rubricas1200> rubricas = new ArrayList<Rubricas1200>();
        Double baseInss = 0.0;
        Double baseInssDec = 0.0;
        Double baseFgts = 0.0;
        Double baseFgtsDec = 0.0;
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            TipoCalculoEvento tp = item.getEventoColaborador().getTipoCalculoEvento();
            if (!tp.getDescartarRubricaEsocial().equals((short)0)) continue;
            if (item.getValor() > 0.0 && tp.getEsocRubricasFolhaPagamento() != null) {
                System.err.println(tp.getEvento().getCodigo());
                rubricas.add(new Rubricas1200(tp, item.getReferencia(), item.getValor(), mov));
            }
            if ((item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11") || item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("15") || item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("21")) && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInss = baseInss + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInss = ContatoFormatUtil.arrredondarNumero((Double)baseInss, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("11")) {
                baseInss = baseInss - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInss = ContatoFormatUtil.arrredondarNumero((Double)baseInss, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("12") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseInssDec = baseInssDec + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInssDec = ContatoFormatUtil.arrredondarNumero((Double)baseInssDec, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaPrevidencia().getCodigo().equals("12")) {
                baseInssDec = baseInssDec - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseInssDec = ContatoFormatUtil.arrredondarNumero((Double)baseInssDec, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseFgts = baseFgts + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgts = ContatoFormatUtil.arrredondarNumero((Double)baseFgts, (int)2);
            } else if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("11")) {
                baseFgts = baseFgts - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgts = ContatoFormatUtil.arrredondarNumero((Double)baseFgts, (int)2);
            }
            if (item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("12") && item.getEventoColaborador().getTipoCalculoEvento().getEsocTipoRubrica().getCodigo().equals("1")) {
                baseFgtsDec = baseFgtsDec + ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
                baseFgtsDec = ContatoFormatUtil.arrredondarNumero((Double)baseFgtsDec, (int)2);
                continue;
            }
            if (!item.getEventoColaborador().getTipoCalculoEvento().getEsocRubricaFgts().getCodigo().equals("12")) continue;
            baseFgtsDec = baseFgtsDec - ContatoFormatUtil.arrredondarNumero((Double)item.getValor(), (int)2);
            baseFgtsDec = ContatoFormatUtil.arrredondarNumero((Double)baseFgtsDec, (int)2);
        }
        if (mov.getVrInssSalario() + mov.getVrInssFerias() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInss(), mov.getAliqInssSalario(), Double.valueOf(mov.getVrInssSalario() + mov.getVrInssFerias()), mov));
        }
        if (mov.getVrInss13Sal() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpInssDec(), mov.getAliqInss13Sal(), mov.getVrInss13Sal(), mov));
        }
        if (mov.getVrInssFerias() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoDevolucaoInssFerias(), mov.getAliqInssFerias(), mov.getVrInssFerias(), mov));
        }
        if (baseInss > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInss(), Double.valueOf(0.0), baseInss, mov));
        }
        if (baseInssDec > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseInssDec(), Double.valueOf(0.0), baseInssDec, mov));
        }
        if (baseFgts > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgts(), Double.valueOf(0.0), baseFgts, mov));
        }
        if (baseFgtsDec > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getEventoBaseFgtsDecimoTerceiro(), Double.valueOf(0.0), baseFgtsDec, mov));
        }
        if (mov.getVrIrrfSalario() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpIrrf(), Double.valueOf(0.0), mov.getVrIrrfSalario(), mov));
        }
        if (mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario() > 0.0) {
            rubricas.add(new Rubricas1200(empresaRh.getTpFgts(), Double.valueOf(0.0), Double.valueOf(mov.getVrFgts13Sal() + mov.getVrFgtsFerias() + mov.getVrFgtsSalario()), mov));
        }
        for (Rubricas1200 rubrica : rubricas) {
            rubrica.setMovimentoFolha(mov);
        }
        mov.getRubricas1200().addAll(rubricas);
    }
}

