/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.colaborador.transferenciacolaborador;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.TransferenciaColaborador;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;

public class Utility2299Transferencia {
    public void geracaoEventoS2299(TransferenciaColaborador vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue(), (short)0);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
        preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoColaborador(TransferenciaColaborador vo, Usuario usuario, Empresa empresa, Short prodEvento, Short eventoRetificacao) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(vo.getDataTransferencia());
        pre.setDataFimVal(null);
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("Transferencia Colaborador");
        pre.setIdentificacaoEntidade(vo.getIdentificador().toString());
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial(this.getTipoEventoESocial(21L));
        pre.setEventoRetificacao(eventoRetificacao);
        if (pre.getEventoRetificacao().equals((short)1)) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo, prodEvento));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (!(vo instanceof TransferenciaColaborador)) {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
        preEvento.setTransferenciaColaborador((TransferenciaColaborador)vo);
    }

    private String getReciboRetificacao(TransferenciaColaborador vo, Short prodEvento) {
        for (EsocPreEvento e : vo.getPreEventosEsocial()) {
            if (!e.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2299) || !e.getEventoProdRestritaProducao().equals(prodEvento) || e.getEventoPosterior() != null) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return "ERRO";
    }

    public void geracaoEventoRetificacaoS2299(TransferenciaColaborador vo, Usuario usuario, Empresa empresa, Short tipoEvento) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2299) || !esocPreEvento.getEventoProdRestritaProducao().equals(tipoEvento)) continue;
            if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
            }
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, tipoEvento, (short)1);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
        }
    }
}

