/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.contratointermitente;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumEsocialFormaGerEvento;
import com.touchcomp.basementor.constants.enums.EnumEsocialTipoEvento;
import com.touchcomp.basementor.constants.enums.esocial.EnumConstEventoProducao;
import com.touchcomp.basementor.model.interfaces.InterfaceVOEsocial;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ConvocacaoContratoIntermitente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaDados;
import com.touchcomp.basementor.model.vo.EsocPreEvento;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.EnumEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.esocial.ExceptionEsocial;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.exceptions.ExceptionService;
import mentorcore.service.CoreService;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class UtilityGeracaoEvento2260 {
    public void geracaoEventoS2260(ConvocacaoContratoIntermitente vo, Usuario usuario, Empresa empresa) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO_TESTE.getValue(), (short)0);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
        preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, EnumConstEventoProducao.EVENTO_PRODUCAO.getValue(), (short)0);
        preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_INCLUSAO.value));
        CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(preEvento);
    }

    private Empresa verificarEmpresaMatriz(Empresa emp) throws ExceptionService {
        if (emp.getEmpresaDados().getMatriz().equals((short)1)) {
            return emp;
        }
        for (EmpresaDados empDados : emp.getEmpresaDados().getGrupoEmpresa().getEmpresas()) {
            if (!empDados.getMatriz().equals((short)1)) continue;
            return (Empresa)CoreService.simpleFindByCriteriaUniqueResult(CoreDAOFactory.getInstance().getDAOEmpresa(), "empresaDados", empDados, 0);
        }
        return emp;
    }

    private EsocPreEvento createNewPreEventoColaborador(ConvocacaoContratoIntermitente vo, Usuario usuario, Empresa empresa, Short prodEvento, Short eventoRetificacao) throws ExceptionEsocial, ExceptionReflection, ExceptionService {
        EsocPreEvento pre = new EsocPreEvento();
        pre.setDataCadastro(new Date());
        pre.setDataFimVal(null);
        pre.setEventoProdRestritaProducao(prodEvento);
        pre.setDataInicioVal(pre.getDataCadastro());
        pre.setDesativarEnvio(Short.valueOf((short)0));
        pre.setEmpresa(this.verificarEmpresaMatriz(empresa));
        pre.setFormaGeracao(Short.valueOf(EnumEsocialFormaGerEvento.TIPO_EVENTO_AUTOMATICO.value));
        pre.setUsuario(usuario);
        pre.setDescricaoEntidade("Colaborador");
        pre.setIdentificacaoEntidade(vo.getIdentificador().toString());
        pre.setClasseEntidade(vo.getClass().getCanonicalName());
        pre.setTipoEventoEsocial(this.getTipoEventoESocial(23L));
        pre.setEventoRetificacao(eventoRetificacao);
        if (pre.getEventoRetificacao().equals((short)1)) {
            pre.setNumeroReciboRetificado(this.getReciboRetificacao(vo, prodEvento));
        }
        this.setOrigem(pre, (InterfaceVOEsocial)vo);
        return pre;
    }

    private TipoEventoEsocial getTipoEventoESocial(Long id) throws ExceptionService {
        return (TipoEventoEsocial)CoreService.simpleFindByPrimaryKey(CoreDAOFactory.getInstance().getDAOTipoEventoEsocial(), id);
    }

    private void setOrigem(EsocPreEvento preEvento, InterfaceVOEsocial vo) throws ExceptionEsocial {
        if (!(vo instanceof ConvocacaoContratoIntermitente)) {
            throw new ExceptionEsocial(EnumEsocial.ENTIDADE_NAO_MAPEADA_GERAR_PRE_EVENTO_ESOCIAL, new Object[]{vo});
        }
        preEvento.setConvocacao((ConvocacaoContratoIntermitente)vo);
    }

    private Date getInicioObrigatoriedade() {
        GregorianCalendar g = new GregorianCalendar();
        g.set(5, 10);
        g.set(2, 9);
        g.set(1, 2018);
        return g.getTime();
    }

    private String getReciboRetificacao(ConvocacaoContratoIntermitente vo, Short prodEvento) {
        for (EsocPreEvento e : vo.getPreEventosEsocial()) {
            if (!e.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2260) || e.getEventoPosterior() != null || !e.getEventoProdRestritaProducao().equals(prodEvento)) continue;
            return e.getEsocEvento().getNrRecibo();
        }
        return "ERRO";
    }

    public void geracaoEventoRetificacaoS2260(ConvocacaoContratoIntermitente vo, Usuario usuario, Empresa empresa, Short tipoEvento) throws ExceptionEsocial, ExceptionReflection, ExceptionService, ExceptionDatabase {
        for (EsocPreEvento esocPreEvento : vo.getPreEventosEsocial()) {
            if (!esocPreEvento.getEmpresa().getEmpresaDados().getGrupoEmpresa().equals((Object)empresa.getEmpresaDados().getGrupoEmpresa()) || esocPreEvento.getEventoPosterior() != null || !esocPreEvento.getTipoEventoEsocial().getIdentificador().equals(ConstantsESocial.REGISTRO_2260) || !esocPreEvento.getEventoProdRestritaProducao().equals(tipoEvento)) continue;
            if (esocPreEvento.getEsocEvento() == null || esocPreEvento.getEsocEvento().getNrRecibo() == null || esocPreEvento.getEsocEvento().getNrRecibo().isEmpty()) {
                throw new ExceptionService("Ultimo Evento ainda n\u00e3o autorizado");
            }
            EsocPreEvento preEvento = this.createNewPreEventoColaborador(vo, usuario, empresa, tipoEvento, (short)1);
            preEvento.setTipoEvento(Short.valueOf(EnumEsocialTipoEvento.TIPO_EVENTO_ALTERACAO.value));
            preEvento.setEventoAnterior(esocPreEvento);
            esocPreEvento.setEventoPosterior(preEvento);
            CoreDAOFactory.getInstance().getDAOEsocPreEvento().saveOrUpdate(esocPreEvento);
        }
    }

    public List getConvocacaoContratoInterminente(MovimentoFolha mov) {
        String hql = " select  coalesce ((i.valor),0) as VALOR ,  i.eventoColaborador.tipoCalculoEvento as ID_EVENTO, i.convocacao as CONVOCACAO  from ItemConvocacaoContIntermitente i  where  i.convocacao.colaborador = :colaborador  and  i.convocacao.dataPagamento between :dataInicio and :dataFinal  and  i.convocacao.pagamentoAposConvocacao  = :sim  ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)mov.getColaborador()).setDate("dataInicio", mov.getAberturaPeriodo().getDataInicio()).setDate("dataFinal", mov.getAberturaPeriodo().getDataFinal()).setParameter("sim", (Object)1).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (Object object : retorno) {
            HashMap h = (HashMap)object;
            boolean achou = false;
            for (Object e : aux) {
                HashMap h1 = (HashMap)e;
                if (!h1.get("ID_EVENTO").equals(h.get("ID_EVENTO"))) continue;
                Double valor = (Double)h.get("VALOR");
                valor = valor + (Double)h1.get("VALOR");
                h1.put("VALOR", valor);
                achou = true;
                break;
            }
            if (achou) continue;
            aux.add(h);
        }
        return aux;
    }

    public List getConvocacaoContratoInterminenteRescisao(Colaborador colaborador, Date dataInicio, Date dataFinal) {
        String hql = " select  coalesce ((i.valor),0) as VALOR ,  i.eventoColaborador.tipoCalculoEvento as ID_EVENTO, i.convocacao as CONVOCACAO  from ItemConvocacaoContIntermitente i  where  i.convocacao.colaborador = :colaborador  and  i.convocacao.dataPagamento between :dataInicio and :dataFinal  and  i.convocacao.pagamentoAposConvocacao  = :sim  ";
        List retorno = CoreBdUtil.getInstance().getSession().createQuery(hql).setEntity("colaborador", (Object)colaborador).setDate("dataInicio", dataInicio).setDate("dataFinal", dataFinal).setParameter("sim", (Object)1).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
        if (retorno == null || retorno.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<HashMap> aux = new ArrayList<HashMap>();
        for (Object object : retorno) {
            HashMap h = (HashMap)object;
            boolean achou = false;
            for (Object e : aux) {
                HashMap h1 = (HashMap)e;
                if (!h1.get("ID_EVENTO").equals(h.get("ID_EVENTO"))) continue;
                Double valor = (Double)h.get("VALOR");
                valor = valor + (Double)h1.get("VALOR");
                h1.put("VALOR", valor);
                achou = true;
                break;
            }
            if (achou) continue;
            aux.add(h);
        }
        return aux;
    }
}

