/*
 * Decompiled with CFR 0.152.
 */
package mentorcore.service.impl.esocial.controlebancohoras;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorBancoHoras;
import com.touchcomp.basementor.model.vo.ControleBancoHorasFolha;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.EventoColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.ModeloEmail;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ServidorEmail;
import com.touchcomp.basementor.model.vo.TipoCalculoEvento;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.email.Email;
import com.touchcomp.basementortools.tools.email.ToolSendEmail;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import mentorcore.dao.CoreDAOFactory;
import mentorcore.database.mentor.CoreBdUtil;
import mentorcore.exceptions.ExceptionDatabase;
import mentorcore.service.CoreRequestContext;
import mentorcore.service.CoreService;
import mentorcore.service.impl.esocial.controlebancohoras.UtilityControleBancoHoras;

public class ServiceControleBancoHoras
extends CoreService {
    public static final String FIND_APURACAO_HORAS_COLABORADOR = "findApuracaoHorasColaborador";
    public static final String INTEGRAR_BANCO_HORAS_FOLHA = "integrarBancoHorasFolha";
    public static final String ENVIAR_BANCO_POR_EMAIL = "enviarBancoPorEmail";

    public List findApuracaoHorasColaborador(CoreRequestContext r) {
        Date dataInicial = (Date)r.getAttribute("dataInicial");
        Date dataFinal = (Date)r.getAttribute("dataFinal");
        Empresa empresa = (Empresa)r.getAttribute("empresa");
        List lista = (List)r.getAttribute("lista");
        return new UtilityControleBancoHoras().findApuracaoColaborador(dataInicial, dataFinal, empresa, lista);
    }

    public void integrarBancoHorasFolha(CoreRequestContext r) throws ExceptionDatabase {
        ControleBancoHorasFolha vo = (ControleBancoHorasFolha)r.getAttribute("vo");
        EmpresaRh empresaRh = (EmpresaRh)r.getAttribute("empresaRh");
        TipoCalculoEvento tpHorasNegativas = empresaRh.getEventoBHNegativo();
        TipoCalculoEvento tpHorasPositivas = empresaRh.getEventoBHPositivo();
        for (ColaboradorBancoHoras col : vo.getColaboradores()) {
            EventoColaborador evt;
            TipoCalculoEvento tipo;
            ItemMovimentoFolha item2;
            if (!(col.getHorasNegativas() > 0.0) && !(col.getHorasPositivas() > 0.0)) continue;
            MovimentoFolha mov = this.getFolhaPagamento(col.getColaborador(), vo.getPeriodoApuracao());
            boolean achou = false;
            if (mov == null) continue;
            Double referencia = 0.0;
            TipoCalculoEvento tp = null;
            if (col.getHorasPositivas() > 0.0) {
                referencia = col.getHorasPositivas();
                tp = tpHorasPositivas;
                for (ItemMovimentoFolha item2 : mov.getItensMovimentoFolha()) {
                    tipo = item2.getEventoColaborador().getTipoCalculoEvento();
                    if (!item2.getEventoColaborador().getTipoCalculoEvento().equals((Object)tp)) continue;
                    achou = true;
                    item2.setInformarValor(Short.valueOf((short)1));
                    item2.setValor(referencia);
                    break;
                }
                if (!achou) {
                    evt = this.createEventoColaborador(tp, mov);
                    item2 = this.createItemMovimentoFolha(mov, evt, referencia);
                    mov.getItensMovimentoFolha().add(item2);
                }
            }
            if (col.getHorasNegativas() > 0.0) {
                referencia = col.getHorasNegativas();
                tp = tpHorasNegativas;
                achou = false;
                for (ItemMovimentoFolha item2 : mov.getItensMovimentoFolha()) {
                    tipo = item2.getEventoColaborador().getTipoCalculoEvento();
                    if (!item2.getEventoColaborador().getTipoCalculoEvento().equals((Object)tp)) continue;
                    achou = true;
                    item2.setInformarValor(Short.valueOf((short)1));
                    item2.setValor(referencia);
                    break;
                }
                if (!achou) {
                    evt = this.createEventoColaborador(tp, mov);
                    item2 = this.createItemMovimentoFolha(mov, evt, referencia);
                    mov.getItensMovimentoFolha().add(item2);
                }
            }
            CoreDAOFactory.getInstance().getDAOMovimentoFolha().saveOrUpdate(mov);
        }
    }

    private ItemMovimentoFolha createItemMovimentoFolha(MovimentoFolha vo, EventoColaborador ev, Double valorReferencia) {
        ItemMovimentoFolha i = new ItemMovimentoFolha();
        i.setMovimentoFolha(vo);
        i.setValor(Double.valueOf(0.0));
        i.setReferencia(Double.valueOf(0.0));
        i.setEventoColaborador(ev);
        i.setGeraFeriDecRec(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue());
        i.setInformarValor(Short.valueOf((short)1));
        i.setValor(valorReferencia);
        return i;
    }

    private EventoColaborador createEventoColaborador(TipoCalculoEvento tipoCalculoEvento, MovimentoFolha mov) {
        EventoColaborador evento = new EventoColaborador();
        evento.setTipoCalculoEvento(tipoCalculoEvento);
        evento.setColaborador(mov.getColaborador());
        evento.setDataInicial(mov.getAberturaPeriodo().getDataInicio());
        evento.setDataFinal(mov.getAberturaPeriodo().getDataFinal());
        evento.setTipoOcorrencia(Short.valueOf((short)2));
        evento.setEventoFixo(Short.valueOf((short)0));
        evento.setValor(Double.valueOf(0.0));
        return evento;
    }

    private MovimentoFolha getFolhaPagamento(Colaborador colaborador, Date periodoApuracao) {
        String hql = " from MovimentoFolha mov  where mov.aberturaPeriodo.tipoCalculo.tipoFolha = :folhaPagamento  and  mov.colaborador = :c  and  mov.aberturaPeriodo.dataFinal = :dataFinal ";
        return (MovimentoFolha)CoreBdUtil.getInstance().getSession().createQuery(hql).setParameter("c", (Object)colaborador).setParameter("dataFinal", (Object)periodoApuracao).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).uniqueResult();
    }

    public void enviarBancoPorEmail(CoreRequestContext r) throws Exception {
        ControleBancoHorasFolha vo = (ControleBancoHorasFolha)r.getAttribute("vo");
        ServidorEmail servidor = (ServidorEmail)r.getAttribute("servidor");
        ModeloEmail modelo = (ModeloEmail)r.getAttribute("modelo");
        Usuario usuario = (Usuario)r.getAttribute("usuario");
        for (ColaboradorBancoHoras col : vo.getColaboradores()) {
            if (col.getColaborador().getPessoa().getComplemento().getEmailPrincipal() == null || col.getColaborador().getPessoa().getComplemento().getEmailPrincipal().length() <= 1) continue;
            Email email = this.criarEmail(col, servidor);
            ToolSendEmail.sendEmailWithException((Email)email);
            System.err.println(col.getColaborador().toString() + "---" + col.getColaborador().getPessoa().getComplemento().getEmailPrincipal());
        }
    }

    private Email criarEmail(ColaboradorBancoHoras col, ServidorEmail servidor) {
        Email email = new Email(true);
        email.setRemetente(servidor.getEmail());
        email.setDestinatariosStr(ServiceControleBancoHoras.getDestinatarios(col.getColaborador().getPessoa()));
        email.setAssunto("INFORMACOES BANCO DE HORAS " + ToolDate.dateToStr((Date)col.getControleBdHoras().getPeriodoApuracao()));
        email.setCorpoMensagem(this.getTexto(col));
        email.setServidor(new Email.ServidorEmail(servidor.getServidor(), servidor.getServidorImap(), servidor.getServidorPop(), servidor.getEmail(), servidor.getSenha(), servidor.getPortaEmail(), servidor.getNaoAutenticarEmail(), servidor.getLogin(), servidor.getServerProperties(), servidor.getGerarArquivoExtensaoEml(), servidor.getDebugServer()));
        email.setZiparAnexos(false);
        return email;
    }

    private static HashSet<String> getDestinatarios(Pessoa pessoa) {
        HashSet<String> emails = new HashSet<String>();
        emails.add(pessoa.getComplemento().getEmailPrincipal());
        return emails;
    }

    private String getTexto(ColaboradorBancoHoras col) {
        String texto = " Sr. " + col.getColaborador().getPessoa().getNome().toUpperCase() + "\n\n";
        texto = texto + " Informa\u00e7\u00f5es do seu banco de Horas referente a competencia: " + ToolDate.dateToStr((Date)col.getControleBdHoras().getPeriodoApuracao());
        texto = texto + "\n\n";
        texto = texto + "Saldo Anterior: " + col.getSaldoAnterior() + "\n";
        texto = texto + "Horas Pagas: " + col.getHorasPagas() + "\n";
        texto = texto + "Horas Positivas: " + col.getHorasPositivas() + "\n";
        texto = texto + "Horas Negativas: " + col.getHorasNegativas() + "\n";
        texto = texto + "Saldo Final: " + col.getSaldoBanco();
        return texto;
    }
}

